/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.Fix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.BalloonDescription;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.BalloonSeverity;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J7\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u00052\b\b\u0001\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\f\u001a\u00020\u00052\b\b\u0001\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J#\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00120\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ShowDetailsHtmlContentCreator;", "", "<init>", "()V", "create", "", "balloonDescription", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/BalloonDescription;", "buildHtmlForPopup", "Lcom/intellij/openapi/util/NlsContexts$PopupContent;", "severity", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/BalloonSeverity;", "detailsHeader", "detailsBody", "actions", "", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/Fix;", "detailsChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "statusChunk", "actionsChunk", "kotlin.jvm.PlatformType", "(Ljava/util/List;)Lcom/intellij/openapi/util/text/HtmlChunk;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nShowDetailsHtmlContentCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowDetailsHtmlContentCreator.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ShowDetailsHtmlContentCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1863#2,2:80\n1872#2,3:82\n*S KotlinDebug\n*F\n+ 1 ShowDetailsHtmlContentCreator.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ShowDetailsHtmlContentCreator\n*L\n45#1:80,2\n74#1:82,3\n*E\n"})
public final class ShowDetailsHtmlContentCreator {
    @NotNull
    public static final ShowDetailsHtmlContentCreator INSTANCE = new ShowDetailsHtmlContentCreator();

    private ShowDetailsHtmlContentCreator() {
    }

    @NlsSafe
    @NotNull
    public final String create(@NotNull BalloonDescription balloonDescription) {
        Intrinsics.checkNotNullParameter((Object)balloonDescription, (String)"balloonDescription");
        return this.buildHtmlForPopup(balloonDescription.getSeverity(), balloonDescription.getDetailsHeader(), balloonDescription.getDetailsBody(), balloonDescription.getActions());
    }

    private final String buildHtmlForPopup(BalloonSeverity severity, @Nls String detailsHeader, @Nls String detailsBody, List<? extends Fix> actions) {
        String string = HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.statusChunk(severity).wrapWith("td"))).child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.detailsChunk(detailsHeader, detailsBody).wrapWith("td").attr("colspan", "2"))).child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.actionsChunk(actions).wrapWith("td").attr("colspan", "2"))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final HtmlChunk detailsChunk(@Nls String detailsHeader, @Nls String detailsBody) {
        HtmlBuilder builder = new HtmlBuilder();
        char[] cArray = new char[]{'\n'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)detailsHeader, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.append(it);
            builder.br();
        }
        builder.clearAndAppend((HtmlChunk)builder.wrapWith("div").style("color: " + ColorUtil.toHtmlColor((Color)((Color)JBColor.gray))));
        builder.br();
        builder.append(StringUtil.notNullize((String)detailsBody));
        HtmlChunk htmlChunk = builder.toFragment();
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"toFragment(...)");
        return htmlChunk;
    }

    private final HtmlChunk statusChunk(BalloonSeverity severity) {
        String text = switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1 -> RiderDatabaseBundle.message("balloon.failure", new Object[0]);
            case 2 -> RiderDatabaseBundle.message("balloon.warning", new Object[0]);
            case 3 -> RiderDatabaseBundle.message("balloon.success", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        Color color = switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1 -> (Color)JBColor.RED;
            case 2 -> JBColor.ORANGE.getDarkVariant();
            case 3 -> JBColor.GREEN.getDarkVariant();
            default -> throw new NoWhenBranchMatchedException();
        };
        HtmlChunk.Element element = HtmlChunk.text((String)text).bold().style("color: " + ColorUtil.toHtmlColor((Color)color));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"style(...)");
        return (HtmlChunk)element;
    }

    /*
     * WARNING - void declaration
     */
    private final HtmlChunk actionsChunk(List<? extends Fix> actions) {
        HtmlBuilder htmlBuilder;
        HtmlBuilder $this$actionsChunk_u24lambda_u242 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = actions;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void action;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Fix fix = (Fix)item$iv;
            int index = n;
            boolean bl2 = false;
            $this$actionsChunk_u24lambda_u242.appendLink("fix_" + index, action.getActionText());
            $this$actionsChunk_u24lambda_u242.appendRaw("&emsp;");
        }
        return htmlBuilder.toFragment();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BalloonSeverity.values().length];
            try {
                nArray[BalloonSeverity.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BalloonSeverity.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BalloonSeverity.Success.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

