/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection;

import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.BalloonCreator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection.TestConnectionExecutionResult;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.BalloonDescription;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.ConfigurationStatusComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/connection/TestConnectionResultDisplay;", "", "component", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ConfigurationStatusComponent;", "session", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;", "balloonCreator", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/BalloonCreator;", "<init>", "(Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ConfigurationStatusComponent;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/BalloonCreator;)V", "showConnectionResult", "", "testConnectionResult", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/connection/TestConnectionExecutionResult;", "intellij.rider.plugins.appender"})
public final class TestConnectionResultDisplay {
    @NotNull
    private final ConfigurationStatusComponent component;
    @NotNull
    private final SelectedDriverSession session;
    @NotNull
    private final BalloonCreator balloonCreator;

    public TestConnectionResultDisplay(@NotNull ConfigurationStatusComponent component2, @NotNull SelectedDriverSession session, @NotNull BalloonCreator balloonCreator) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)balloonCreator, (String)"balloonCreator");
        this.component = component2;
        this.session = session;
        this.balloonCreator = balloonCreator;
    }

    public final void showConnectionResult(@Nullable TestConnectionExecutionResult testConnectionResult) {
        TestConnectionExecutionResult testConnectionExecutionResult = testConnectionResult;
        if (testConnectionExecutionResult instanceof TestConnectionExecutionResult.Success) {
            ConfigurationStatusComponent.showSuccess$default(this.component, RiderDatabaseBundle.message("connected.successfully", new Object[0]), null, 2, null);
        } else if (testConnectionExecutionResult instanceof TestConnectionExecutionResult.Failure) {
            BalloonDescription balloon = this.balloonCreator.createBalloon(testConnectionResult, false);
            Object[] objectArray = new Object[]{this.session.getDataSourceIdentifier()};
            this.component.showError(RiderDatabaseBundle.message("can.t.connect.to.0", objectArray), balloon);
        } else {
            this.component.hide();
        }
    }
}

