/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog;

import com.intellij.concurrency.ThreadContext;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JBCardLayout;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.PotentialConnectionString;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.DatabaseConnectionDialog;
import com.jetbrains.rider.plugins.appender.database.dialog.DatabaseConnectionDialogManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.manual.ManualConnectionManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.InitialPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.DefaultDriverSelector;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Driver;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.DriverDownloadingManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.DriverFilter;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.DriverProvider;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Drivers;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.FixesStorage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.Navigator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.validation.DatabaseConnectionDialogValidationManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.url.UrlConnectionManager;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b3\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b*\u0001#\u0018\u00002\u00020\u00012\u00020\u0002:\u0001GB/\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0014J\b\u0010+\u001a\u00020&H\u0014J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0014\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u000201H\u0014J\u0012\u00102\u001a\u00020(2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020(H\u0014J\b\u00106\u001a\u00020(H\u0014J\u0010\u00107\u001a\u00020(2\u0006\u00108\u001a\u000209H\u0016J\u0016\u0010:\u001a\u00020(2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0016J\u0012\u0010>\u001a\u00020(2\b\b\u0001\u0010?\u001a\u000201H\u0016J\b\u0010@\u001a\u00020(H\u0016J\b\u0010A\u001a\u00020(H\u0016J\b\u0010B\u001a\u00020(H\u0016J\b\u0010C\u001a\u00020(H\u0016J\b\u0010D\u001a\u00020&H\u0016J\b\u0010E\u001a\u00020&H\u0016J\b\u0010F\u001a\u00020(H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$\u00a8\u0006H"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialogManager;", "project", "Lcom/intellij/openapi/project/Project;", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "drivers", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;", "connectionStrings", "", "Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/PotentialConnectionString;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;Ljava/util/Collection;)V", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "jbCardLayout", "Lcom/intellij/ui/JBCardLayout;", "panel", "Ljavax/swing/JPanel;", "navigator", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;", "fixesStorage", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/FixesStorage;", "driverDownloadingManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverDownloadingManager;", "validationManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/validation/DatabaseConnectionDialogValidationManager;", "initialPage", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/InitialPage;", "manualManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/manual/ManualConnectionManager;", "urlManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/url/UrlConnectionManager;", "closeAction", "com/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog$closeAction$1", "Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog$closeAction$1;", "createCenterPanel", "Ljavax/swing/JComponent;", "beforeShowCallback", "", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createSouthPanel", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "getHelpId", "", "doCancelAction", "source", "Ljava/awt/AWTEvent;", "doOKAction", "dispose", "resetValidation", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "displayValidation", "validationInfo", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "setNextButtonText", "text", "disableNextButton", "enableNextButton", "enableBackButton", "disableBackButton", "getNextButton", "getPreviousButton", "close", "Builder", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDatabaseConnectionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseConnectionDialog.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class DatabaseConnectionDialog
extends DialogWrapper
implements DatabaseConnectionDialogManager {
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final JBCardLayout jbCardLayout;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final FixesStorage fixesStorage;
    @NotNull
    private final DriverDownloadingManager driverDownloadingManager;
    @NotNull
    private final DatabaseConnectionDialogValidationManager validationManager;
    @NotNull
    private final InitialPage initialPage;
    @NotNull
    private final ManualConnectionManager manualManager;
    @NotNull
    private final UrlConnectionManager urlManager;
    @NotNull
    private final closeAction.1 closeAction;

    private DatabaseConnectionDialog(Project project, ConnectionType connectionType, Drivers drivers, Collection<PotentialConnectionString> connectionStrings) {
        super(project);
        this.lifetimeDefinition = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)project));
        this.jbCardLayout = new JBCardLayout();
        this.panel = new JPanel((LayoutManager)this.jbCardLayout);
        this.navigator = new Navigator((Lifetime)this.lifetimeDefinition, connectionType, this.panel, this.jbCardLayout);
        this.fixesStorage = new FixesStorage();
        this.driverDownloadingManager = new DriverDownloadingManager((Lifetime)this.lifetimeDefinition, drivers);
        this.validationManager = new DatabaseConnectionDialogValidationManager();
        this.initialPage = new InitialPage(this.lifetimeDefinition.getLifetime(), this.navigator);
        this.manualManager = new ManualConnectionManager((Lifetime)this.lifetimeDefinition, project, this.initialPage, this.navigator, this.fixesStorage, this, this.driverDownloadingManager, drivers);
        this.urlManager = new UrlConnectionManager((Lifetime)this.lifetimeDefinition, project, this.initialPage, this.navigator, this.fixesStorage, this, this.driverDownloadingManager, drivers, connectionStrings);
        String string = RiderDatabaseBundle.message("cancel", new Object[0]);
        this.closeAction = new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ DatabaseConnectionDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                this.this$0.close(0);
            }
        };
        this.setTitle(RiderDatabaseBundle.message("dialog.title.connect.to.database", new Object[0]));
        this.setSize(570, 355);
        this.setCancelButtonText(RiderDatabaseBundle.message("back", new Object[0]));
        this.setModal(false);
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel;
        this.navigator.addPage(this.initialPage);
        this.manualManager.initializePageAndSteps();
        this.urlManager.initializePageAndSteps();
        JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = this.panel;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setBorder(DialogWrapper.createDefaultBorder());
        return jPanel;
    }

    public void beforeShowCallback() {
        this.navigator.moveToBeginning();
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent jComponent;
        JComponent $this$createSouthPanel_u24lambda_u241 = jComponent = super.createSouthPanel();
        boolean bl = false;
        Border border = JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLineTop(...)");
        Border borderWithLine = border;
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)8, (int)12);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        JBEmptyBorder borderWithInsets = jBEmptyBorder;
        $this$createSouthPanel_u24lambda_u241.setBorder(new CompoundBorder(borderWithLine, (Border)borderWithInsets));
        JComponent jComponent2 = jComponent;
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"apply(...)");
        return jComponent2;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        if (SystemInfoRt.isMac) {
            Action[] actionArray2 = new Action[]{this.closeAction, this.getCancelAction(), this.getOKAction(), this.getHelpAction()};
            actionArray = actionArray2;
        } else {
            Action[] actionArray3 = new Action[]{this.getCancelAction(), this.getOKAction(), this.closeAction, this.getHelpAction()};
            actionArray = actionArray3;
        }
        return actionArray;
    }

    @NotNull
    protected String getHelpId() {
        return "rider.database.connection.dialog";
    }

    public void doCancelAction(@Nullable AWTEvent source) {
        AWTEvent aWTEvent = source;
        boolean bl = aWTEvent != null ? aWTEvent.getID() == 201 : false;
        if (bl) {
            this.close(0);
        } else {
            this.navigator.getCurrentStep().previousButtonPressed();
        }
    }

    protected void doOKAction() {
        this.navigator.getCurrentStep().nextButtonPressed();
    }

    protected void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
        super.dispose();
    }

    @Override
    public void resetValidation(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.validationManager.reset(lifetime);
    }

    @Override
    public void displayValidation(@NotNull List<ValidationInfo> validationInfo) {
        Intrinsics.checkNotNullParameter(validationInfo, (String)"validationInfo");
        this.validationManager.displayValidation(validationInfo);
    }

    @Override
    public void setNextButtonText(@NlsContexts.Button @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setOKButtonText(text);
    }

    @Override
    public void disableNextButton() {
        this.setOKActionEnabled(false);
    }

    @Override
    public void enableNextButton() {
        this.setOKActionEnabled(true);
    }

    @Override
    public void enableBackButton() {
        this.myCancelAction.setEnabled(true);
    }

    @Override
    public void disableBackButton() {
        this.myCancelAction.setEnabled(false);
    }

    @Override
    @NotNull
    public JComponent getNextButton() {
        Object v = this.getButtonMap().get(this.myOKAction);
        Intrinsics.checkNotNull(v);
        return (JComponent)v;
    }

    @Override
    @NotNull
    public JComponent getPreviousButton() {
        Object v = this.getButtonMap().get(this.myCancelAction);
        Intrinsics.checkNotNull(v);
        return (JComponent)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AutoCloseable autoCloseable = (AutoCloseable)ThreadContext.resetThreadContext();
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            this.close(0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public /* synthetic */ DatabaseConnectionDialog(Project project, ConnectionType connectionType, Drivers drivers, Collection connectionStrings, DefaultConstructorMarker $constructor_marker) {
        this(project, connectionType, drivers, connectionStrings);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u001f\u0010\u0013\u001a\u00020\u00112\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0016J\u0014\u0010\u001b\u001a\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog$Builder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "filters", "", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverFilter;", "connectionStrings", "", "Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/PotentialConnectionString;", "defaultDriverSelector", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DefaultDriverSelector;", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "useConnectionType", "", "filter", "filterByDbms", "dbms", "", "Lcom/intellij/database/Dbms;", "([Lcom/intellij/database/Dbms;)V", "useDefaultDriverSelector", "selector", "selectDefaultDriverFor", "useConnectionStrings", "build", "Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nDatabaseConnectionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseConnectionDialog.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog$Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n295#2,2:214\n1755#2,3:216\n*S KotlinDebug\n*F\n+ 1 DatabaseConnectionDialog.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog$Builder\n*L\n185#1:214,2\n194#1:216,3\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Project project;
        @NotNull
        private final List<DriverFilter> filters;
        @NotNull
        private Collection<PotentialConnectionString> connectionStrings;
        @Nullable
        private DefaultDriverSelector defaultDriverSelector;
        @Nullable
        private ConnectionType connectionType;

        public Builder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.filters = new ArrayList();
            this.connectionStrings = CollectionsKt.emptyList();
        }

        public final void useConnectionType(@NotNull ConnectionType connectionType) {
            Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
            this.connectionType = connectionType;
        }

        public final void filter(@NotNull DriverFilter filter) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            this.filters.add(filter);
        }

        public final void filterByDbms(Dbms ... dbms) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            this.filter(arg_0 -> Builder.filterByDbms$lambda$0(dbms, arg_0));
        }

        public final void useDefaultDriverSelector(@NotNull DefaultDriverSelector selector) {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            this.defaultDriverSelector = selector;
        }

        public final void selectDefaultDriverFor(@NotNull Dbms dbms) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            this.useDefaultDriverSelector(arg_0 -> Builder.selectDefaultDriverFor$lambda$2(dbms, arg_0));
        }

        public final void useConnectionStrings(@NotNull Collection<PotentialConnectionString> connectionStrings) {
            Intrinsics.checkNotNullParameter(connectionStrings, (String)"connectionStrings");
            this.connectionStrings = connectionStrings;
        }

        @NotNull
        public final DatabaseConnectionDialog build() {
            DriverFilter filter = arg_0 -> Builder.build$lambda$4(this, arg_0);
            Collection<Driver> createdDrivers = DriverProvider.INSTANCE.getDrivers(this.project, filter);
            if (createdDrivers.isEmpty()) {
                throw new IllegalStateException("All drivers were filtered out, readjust your filter");
            }
            Object object = this.defaultDriverSelector;
            if (object == null || (object = object.selectDefaultDriver(createdDrivers)) == null) {
                object = (Driver)CollectionsKt.first((Iterable)createdDrivers);
            }
            Object defaultDriver = object;
            Drivers drivers = new Drivers(createdDrivers, (Driver)defaultDriver);
            DatabaseArtifactManager.getInstance().checkForUpdates();
            ConnectionType connectionType = this.connectionType;
            if (connectionType == null) {
                connectionType = ConnectionType.Url;
            }
            return new DatabaseConnectionDialog(this.project, connectionType, drivers, this.connectionStrings, null);
        }

        private static final boolean filterByDbms$lambda$0(Dbms[] $dbms, DatabaseDriver it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Dbms dbms = DbImplUtilCore.getDbms((DatabaseDriver)it);
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms driverDbms = dbms;
            return ArraysKt.contains((Object[])$dbms, (Object)driverDbms);
        }

        private static final Driver selectDefaultDriverFor$lambda$2(Dbms $dbms, Collection drivers) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)drivers, (String)"drivers");
                Iterable $this$firstOrNull$iv = drivers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Driver it = (Driver)element$iv;
                    boolean bl = false;
                    if (!DbImplUtilCore.getDbms((DatabaseDriver)it.getDatabaseDriver()).eq($dbms)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private static final boolean build$lambda$4(Builder this$0, DatabaseDriver driver) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                Iterable $this$any$iv = this$0.filters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DriverFilter it = (DriverFilter)element$iv;
                        boolean bl2 = false;
                        if (!(!it.isIncluded(driver))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return !bl;
        }
    }
}

