/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.common;

import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlResolveExtension;
import com.jetbrains.rider.plugins.appender.database.FakeDasSymbol;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\u0007*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0007*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/common/ClrLanguageSqlDapperParameterResolveExtension;", "Lcom/intellij/sql/psi/impl/SqlResolveExtension;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "process", "", "reference", "Lcom/intellij/sql/psi/SqlReference;", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "isBinaryExpression", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "isFunctionCallArgument", "intellij.rider.plugins.appender"})
public abstract class ClrLanguageSqlDapperParameterResolveExtension
implements SqlResolveExtension {
    @NotNull
    private final Language language;

    public ClrLanguageSqlDapperParameterResolveExtension(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.language = language;
    }

    public boolean process(@NotNull SqlReference reference, @NotNull SqlScopeProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        if (!processor.isResultEmpty()) {
            return true;
        }
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement element = psiElement;
        SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)element.getContainingFile().getUserData(FileContextUtil.INJECTED_IN_ELEMENT);
        if (smartPsiElementPointer == null || (smartPsiElementPointer = smartPsiElementPointer.getContainingFile()) == null) {
            return true;
        }
        SmartPsiElementPointer containingFile = smartPsiElementPointer;
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)SqlCompositeElementTypes.SQL_VARIABLE_REFERENCE)) {
            return true;
        }
        if (!(this.isBinaryExpression(element) | this.isFunctionCallArgument(element))) {
            return true;
        }
        if (!containingFile.getLanguage().is(this.language)) {
            return true;
        }
        DasType dasType = null;
        PsiElement psiElement2 = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        processor.executeTarget((DasSymbol)new FakeDasSymbol(psiElement2), dasType, null, ResolveState.initial());
        return true;
    }

    private final boolean isBinaryExpression(PsiElement $this$isBinaryExpression) {
        return $this$isBinaryExpression.getParent() instanceof SqlBinaryExpression;
    }

    private final boolean isFunctionCallArgument(PsiElement $this$isFunctionCallArgument) {
        return $this$isFunctionCallArgument.getParent() instanceof SqlExpressionList && $this$isFunctionCallArgument.getParent().getParent() instanceof SqlFunctionCallExpression;
    }
}

