/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.completion.stats.cSharp;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.ModelUtilKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/appender/completion/stats/cSharp/CSharpContextFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ContextFeatureProvider;", "<init>", "()V", "getName", "", "calculateFeatures", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "environment", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "intellij.rider.plugins.appender"})
public final class CSharpContextFeatureProvider
implements ContextFeatureProvider {
    @NotNull
    public String getName() {
        return "C#";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull CompletionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        CompletionParameters completionParameters = environment.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)completionParameters, (String)"getParameters(...)");
        CompletionParameters params = completionParameters;
        Editor editor2 = params.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Project project = editor3.getProject();
        if (project == null) {
            return MapsKt.emptyMap();
        }
        Project project2 = project;
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.tryGetInstance(project2);
        if (frontendCompletionHost == null) {
            return MapsKt.emptyMap();
        }
        FrontendCompletionHost completionHost = frontendCompletionHost;
        PsiFile psiFile = params.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        int prefixOffset = params.getOffset();
        if (EditorUtilKt.hasMultipleEditPoints((Editor)editor3) || editor3.getSelectionModel().hasSelection()) {
            prefixOffset = PlatformTextControlUtilsKt.getStartOffset((Editor)editor3);
        }
        boolean mayTrustLookup = params.getInvocationCount() == 0;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int sessionOffset = ModelUtilKt.getCurrentOffsetSafe((TextControlModel)DocumentExKt.getTextControlModel((Editor)editor3));
        String prefix = completionHost.getCompletionPrefix(prefixOffset, document2, psiFile2, sessionOffset, editor3, mayTrustLookup);
        boolean allSmallLetters = true;
        boolean onlyFirstLetterIsCapital = false;
        boolean hasSmallLetters = false;
        boolean casingIsDescendant = false;
        int n = prefix.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            char c = prefix.charAt(i);
            if (Character.isUpperCase(c)) {
                allSmallLetters = false;
                boolean bl = onlyFirstLetterIsCapital = i2 == 0;
                if (i2 == 0) {
                    casingIsDescendant = true;
                    continue;
                }
                if (!hasSmallLetters) continue;
                casingIsDescendant = false;
                continue;
            }
            hasSmallLetters = true;
        }
        casingIsDescendant = casingIsDescendant && hasSmallLetters;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"casing_is_descendant", (Object)MLFeatureValue.Companion.binary(casingIsDescendant)), TuplesKt.to((Object)"only_first_letter_is_capital", (Object)MLFeatureValue.Companion.binary(onlyFirstLetterIsCapital)), TuplesKt.to((Object)"all_small_letters", (Object)MLFeatureValue.Companion.binary(allSmallLetters)), TuplesKt.to((Object)"prefix_is_empty", (Object)MLFeatureValue.Companion.binary(((CharSequence)prefix).length() == 0))};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

