/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Arrays;
import java.util.Locale;

public enum ITSIssueType {
    Terminology,
    Mistranslation,
    Omission,
    Untranslated,
    Addition,
    Duplication,
    Inconsistency,
    Grammar,
    Legal,
    Register,
    LocaleSpecificContent("locale-specific-content"),
    LocaleViolation("locale-violation"),
    Style,
    Characters,
    Misspelling,
    Typographical,
    Formatting,
    InconsistentEntities("inconsistent-entities"),
    Numbers,
    Markup,
    PatternProblem("pattern-problem"),
    Whitespace,
    Internationalization,
    Length,
    NonConformance("non-conformance"),
    Uncategorized,
    Other;

    private final String name;

    public static ITSIssueType getIssueType(String name) {
        for (ITSIssueType issueType : ITSIssueType.values()) {
            if (!issueType.toString().equals(name)) continue;
            return issueType;
        }
        throw new IllegalArgumentException("No IssueType found for name '" + name + "'. Valid values: " + Arrays.toString((Object[])ITSIssueType.values()));
    }

    private ITSIssueType() {
        this.name = this.name();
    }

    private ITSIssueType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name.toLowerCase(Locale.ENGLISH);
    }
}

