/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLongAssociativeContainer;
import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.comparators.ObjectLongComparator;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.ObjectLongPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.procedures.ObjectLongProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationObjectLongHashMap<KType>
implements ObjectLongMap<KType> {
    public final ObjectLongHashMap<KType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectLongHashMap(ObjectLongHashMap<KType> delegate2, Comparator<KType> comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectLongHashMap(ObjectLongHashMap<KType> delegate2, ObjectLongComparator<KType> comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectLongComparator<KType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final long[] values;
            {
                this.keys = SortedIterationObjectLongHashMap.this.delegate.keys;
                this.values = SortedIterationObjectLongHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectLongCursor<KType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectLongPredicate<? super KType> predicate) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectLongProcedure<? super KType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectLongPredicate<? super KType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public LongContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public long get(KType key2) {
        return this.delegate.get(key2);
    }

    @Override
    public long getOrDefault(KType key2, long defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public long put(KType key2, long value) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectLongAssociativeContainer<? extends KType> container) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectLongCursor<? extends KType>> iterable) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public long putOrAdd(KType key2, long putValue, long incrementValue) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public long addTo(KType key2, long additionValue) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public long remove(KType key2) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public long indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public long indexReplace(int index, long newValue) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key2, long value) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public long indexRemove(int index) {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectLongHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectLongCursor<KType>> {
        private final ObjectLongCursor<KType> cursor = new ObjectLongCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectLongCursor<KType> fetch() {
            if (this.index < SortedIterationObjectLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectLongHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectLongHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectLongCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectLongHashMap<KType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectLongHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectLongHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final SortedIterationObjectLongHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectLongHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            for (ObjectLongCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationObjectLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationObjectLongHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectLongHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationObjectLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectLongHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

