/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.shared.utils.registryUtils.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.shared.utils.registryUtils.IRegistryKey;
import com.jetbrains.rider.shared.utils.registryUtils.impl.RegistryRoot;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.List;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u0013H\u0016J&\u0010\u0015\u001a \u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u0016H\u0016JG\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001b\"\u00020\u00032\u001c\u0010\u001c\u001a\u0018\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002H\u00190\u001dj\b\u0012\u0004\u0012\u0002H\u0019`\u001fH\u0002\u00a2\u0006\u0002\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/shared/utils/registryUtils/impl/RegistryKey;", "Lcom/jetbrains/rider/shared/utils/registryUtils/IRegistryKey;", "key", "", "registryRoot", "Lcom/jetbrains/rider/shared/utils/registryUtils/impl/RegistryRoot;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/shared/utils/registryUtils/impl/RegistryRoot;)V", "getKey", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "withSuffix", "suffix", "inChild", "child", "getStringValue", "value", "getKeys", "", "kotlin.jvm.PlatformType", "getValues", "Ljava/util/TreeMap;", "", "tryExecuteWithHKEY", "T", "args", "", "action", "Lkotlin/Function1;", "Lcom/sun/jna/platform/win32/WinReg$HKEY;", "Lcom/jetbrains/rider/shared/utils/registryUtils/impl/WinRegAction;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.rider.shared"})
@SourceDebugExtension(value={"SMAP\nRegistryRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryRoot.kt\ncom/jetbrains/rider/shared/utils/registryUtils/impl/RegistryKey\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n15#2:68\n*S KotlinDebug\n*F\n+ 1 RegistryRoot.kt\ncom/jetbrains/rider/shared/utils/registryUtils/impl/RegistryKey\n*L\n15#1:68\n*E\n"})
public final class RegistryKey
implements IRegistryKey {
    @NotNull
    private final String key;
    @NotNull
    private final RegistryRoot registryRoot;
    @NotNull
    private final Logger logger;

    public RegistryKey(@NotNull String key, @NotNull RegistryRoot registryRoot) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)registryRoot, (String)"registryRoot");
        this.key = key;
        this.registryRoot = registryRoot;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RegistryKey.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public IRegistryKey withSuffix(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return new RegistryKey(this.key + suffix, this.registryRoot);
    }

    @Override
    @NotNull
    public IRegistryKey inChild(@NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return new RegistryKey(this.key + "\\" + child, this.registryRoot);
    }

    @Override
    @Nullable
    public String getStringValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String[] stringArray = new String[]{this.key, value};
        return (String)this.tryExecuteWithHKEY(stringArray, arg_0 -> RegistryKey.getStringValue$lambda$0(this, value, arg_0));
    }

    @Override
    @Nullable
    public List<String> getKeys() {
        String[] stringArray = new String[]{this.key};
        Object[] objectArray = (String[])this.tryExecuteWithHKEY(stringArray, arg_0 -> RegistryKey.getKeys$lambda$1(this, arg_0));
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    @Nullable
    public TreeMap<String, Object> getValues() {
        String[] stringArray = new String[]{this.key};
        return (TreeMap)this.tryExecuteWithHKEY(stringArray, arg_0 -> RegistryKey.getValues$lambda$2(this, arg_0));
    }

    private final <T> T tryExecuteWithHKEY(String[] args, Function1<? super WinReg.HKEY, ? extends T> action) {
        return this.registryRoot.executeWithHKEY(arg_0 -> RegistryKey.tryExecuteWithHKEY$lambda$3(action, this, args, arg_0));
    }

    private static final String getStringValue$lambda$0(RegistryKey this$0, String $value, WinReg.HKEY it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Advapi32Util.registryKeyExists((WinReg.HKEY)it, (String)this$0.key)) {
            return null;
        }
        return Advapi32Util.registryGetStringValue((WinReg.HKEY)it, (String)this$0.key, (String)$value);
    }

    private static final String[] getKeys$lambda$1(RegistryKey this$0, WinReg.HKEY it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Advapi32Util.registryGetKeys((WinReg.HKEY)it, (String)this$0.key);
    }

    private static final TreeMap getValues$lambda$2(RegistryKey this$0, WinReg.HKEY it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Advapi32Util.registryGetValues((WinReg.HKEY)it, (String)this$0.key);
    }

    private static final Object tryExecuteWithHKEY$lambda$3(Function1 $action, RegistryKey this$0, String[] $args, WinReg.HKEY it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            return $action.invoke((Object)it);
        }
        catch (Win32Exception t) {
            this$0.logger.info("registry arguments: " + ArraysKt.joinToString$default((Object[])$args, null, null, null, (int)0, null, null, (int)63, null));
            this$0.logger.warn("Failed to work with registry", (Throwable)t);
            return null;
        }
    }
}

