/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.frameworks.ReactLikeProjectGenerator;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.PathUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditorKt;
import com.jetbrains.plugins.reactnative.ReactNativeDebuggerBundle;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationType;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ReactNativeProjectGenerator
extends NpmPackageProjectGenerator
implements ReactLikeProjectGenerator {
    public static final String REACT_NATIVE_CLI = "@react-native-community/cli";
    private static final Logger LOG = Logger.getInstance(ReactNativeProjectGenerator.class);

    public String getId() {
        return "ReactNative";
    }

    @Nls
    @NotNull
    public String getName() {
        String string = ReactNativeDebuggerBundle.message("react.native.config.name", new Object[0]);
        if (string == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getDescription() {
        return ReactNativeDebuggerBundle.message("react.native.project.generator.description", new Object[0]);
    }

    protected Filter @NotNull [] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(2);
        }
        if (Filter.EMPTY_ARRAY == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(3);
        }
        return Filter.EMPTY_ARRAY;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        if (pkg == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(4);
        }
        String string = pkg.getSystemDependentPath() + File.separator + "index.js";
        if (string == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(6);
        }
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(7);
        }
        String[] stringArray = new String[]{"init", baseDir.getName(), "--skip-install"};
        if (stringArray == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(9);
        }
        if (entry != null) {
            entry.addExcludeFolder(baseDir.getUrl() + "/android");
            entry.addExcludeFolder(baseDir.getUrl() + "/ios");
            Project project = entry.getRootModel().getModule().getProject();
            ReactNativeProjectGenerator.setLanguageLevel(project);
        }
    }

    protected boolean getShouldInstallDependencies() {
        return true;
    }

    protected boolean generateInTemp() {
        return true;
    }

    private static void createRunConfigurations(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(10);
        }
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(11);
        }
        ReactNativeRunConfigurationType configurationType = ReactNativeRunConfigurationType.getInstance();
        if (!project.isDisposed()) {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings rc = ReactNativeProjectGenerator.createRunConfiguration(project, runManager, (ConfigurationType)configurationType, ReactNativePlatform.ANDROID, baseDir);
            if (SystemInfo.isMac) {
                rc = ReactNativeProjectGenerator.createRunConfiguration(project, runManager, (ConfigurationType)configurationType, ReactNativePlatform.IOS, baseDir);
            }
            RunManager.getInstance((Project)project).setSelectedConfiguration(rc);
        }
    }

    @NotNull
    private static RunnerAndConfigurationSettings createRunConfiguration(Project project, RunManager runManager, ConfigurationType configurationType, ReactNativePlatform platform, VirtualFile baseDir) {
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(platform.getReadableName(), configurationType.getConfigurationFactories()[0]);
        ReactNativeRunConfiguration rc = (ReactNativeRunConfiguration)settings.getConfiguration();
        rc.setPlatform(platform);
        NodePackage pack = (NodePackage)ReadAction.compute(() -> {
            NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreterRef.createProjectRef().resolve(project);
            return ReactNativeConfigurationEditorKt.findReactNativePackage(project, nodeJsInterpreter);
        });
        if (pack != null) {
            rc.setReactNativePackage(pack);
        }
        rc.setWorkingDirectory(baseDir.getPath());
        runManager.addConfiguration(settings);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
        if (runnerAndConfigurationSettings == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(12);
        }
        return runnerAndConfigurationSettings;
    }

    private static void setLanguageLevel(Project project) {
        JSRootConfiguration.getInstance((Project)project).storeLanguageLevelAndUpdateCaches(JSLanguageLevel.FLOW);
    }

    @NotNull
    protected String packageName() {
        return REACT_NATIVE_CLI;
    }

    @NotNull
    protected String presentablePackageName() {
        String string = ReactNativeDebuggerBundle.message("react.native.project.generator.package.name", new Object[0]);
        if (string == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list = Collections.singletonList(new NpxPackageDescriptor.NpxCommand(REACT_NATIVE_CLI, "rnc-cli"));
        if (list == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(14);
        }
        return list;
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }

    protected void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(15);
        }
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(16);
        }
        ReactNativeProjectGenerator.createRunConfigurations(project, baseDir);
    }

    protected void onProcessHandlerCreated(@NotNull ProcessHandler processHandler) {
        OutputStream processInput;
        if (processHandler == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(17);
        }
        if ((processInput = processHandler.getProcessInput()) != null) {
            try {
                processInput.write("yes\n".getBytes(StandardCharsets.UTF_8));
                processInput.flush();
                if (!TerminalExecutionConsole.isAcceptable((ProcessHandler)processHandler)) {
                    processInput.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Cannot write input to " + String.valueOf(processHandler.getClass()), (Throwable)e);
            }
        } else {
            LOG.warn("Null process input");
        }
        LOG.info("Answered 'yes' to prompt");
    }

    protected String validateProjectPath(@NotNull String path) {
        String fileName;
        if (path == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(18);
        }
        if (!(fileName = PathUtil.getFileName((String)path)).matches("[$a-zA-Z_][0-9a-zA-Z_$]*")) {
            return XmlStringUtil.wrapInHtml((CharSequence)ReactNativeDebuggerBundle.message("react.native.project.generator.validation", fileName));
        }
        return super.validateProjectPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 6, 7, 9, 10, 11, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "presentablePackageName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfigurations";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onProcessHandlerCreated";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 6, 7, 9, 10, 11, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }
}

