/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxmlpatterns_python.h"

// main header
#include "qxmlnodemodelindex_wrapper.h"

// inner classes

// Extra includes
#include <QtXmlPatterns/qabstractxmlnodemodel.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlNodeModelIndex_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlNodeModelIndex >()))
        return -1;

    ::QXmlNodeModelIndex *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlNodeModelIndex.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QXmlNodeModelIndex", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlNodeModelIndex::QXmlNodeModelIndex()
    // 1: QXmlNodeModelIndex::QXmlNodeModelIndex(QXmlNodeModelIndex)
    if (numArgs == 0) {
        overloadId = 0; // QXmlNodeModelIndex()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QXmlNodeModelIndex(QXmlNodeModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlNodeModelIndex_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlNodeModelIndex()
        {

            if (!PyErr_Occurred()) {
                // QXmlNodeModelIndex()
                cptr = new ::QXmlNodeModelIndex();
            }
            break;
        }
        case 1: // QXmlNodeModelIndex(const QXmlNodeModelIndex & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlNodeModelIndex cppArg0_local;
            ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlNodeModelIndex(QXmlNodeModelIndex)
                cptr = new ::QXmlNodeModelIndex(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlNodeModelIndex >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlNodeModelIndex_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlNodeModelIndex_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlNodeModelIndexFunc_additionalData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlNodeModelIndex.additionalData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // additionalData()const
            qint64 cppResult = const_cast<const ::QXmlNodeModelIndex *>(cppSelf)->additionalData();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlNodeModelIndexFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlNodeModelIndex.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            qint64 cppResult = const_cast<const ::QXmlNodeModelIndex *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlNodeModelIndexFunc_internalPointer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlNodeModelIndex.internalPointer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // internalPointer()const
            void * cppResult = const_cast<const ::QXmlNodeModelIndex *>(cppSelf)->internalPointer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlNodeModelIndexFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlNodeModelIndex.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QXmlNodeModelIndex *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlNodeModelIndexFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlNodeModelIndex.model";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // model()const
            const QAbstractXmlNodeModel * cppResult = const_cast<const ::QXmlNodeModelIndex *>(cppSelf)->model();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlNodeModelIndex___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlNodeModelIndex_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlNodeModelIndex_methods[] = {
    {"additionalData", reinterpret_cast<PyCFunction>(Sbk_QXmlNodeModelIndexFunc_additionalData), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QXmlNodeModelIndexFunc_data), METH_NOARGS},
    {"internalPointer", reinterpret_cast<PyCFunction>(Sbk_QXmlNodeModelIndexFunc_internalPointer), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QXmlNodeModelIndexFunc_isNull), METH_NOARGS},
    {"model", reinterpret_cast<PyCFunction>(Sbk_QXmlNodeModelIndexFunc_model), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QXmlNodeModelIndex___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QXmlNodeModelIndex___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QXmlNodeModelIndex_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
                // operator!=(const QXmlNodeModelIndex & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QXmlNodeModelIndex cppArg0_local;
                ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
                // operator==(const QXmlNodeModelIndex & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QXmlNodeModelIndex cppArg0_local;
                ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QXmlNodeModelIndex_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QXmlNodeModelIndex_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QXmlNodeModelIndex_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlNodeModelIndex_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlNodeModelIndex_Type = nullptr;
static SbkObjectType *Sbk_QXmlNodeModelIndex_TypeF(void)
{
    return _Sbk_QXmlNodeModelIndex_Type;
}

static PyType_Slot Sbk_QXmlNodeModelIndex_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlNodeModelIndex_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlNodeModelIndex_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QXmlNodeModelIndex_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlNodeModelIndex_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlNodeModelIndex_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QXmlNodeModelIndex___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QXmlNodeModelIndex___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlNodeModelIndex_spec = {
    "2:PySide2.QtXmlPatterns.QXmlNodeModelIndex",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlNodeModelIndex_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QXmlNodeModelIndex_NodeKind_PythonToCpp_QXmlNodeModelIndex_NodeKind(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlNodeModelIndex::NodeKind *>(cppOut) =
        static_cast<::QXmlNodeModelIndex::NodeKind>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QXmlNodeModelIndex_NodeKind_PythonToCpp_QXmlNodeModelIndex_NodeKind_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX]))
        return QXmlNodeModelIndex_NodeKind_PythonToCpp_QXmlNodeModelIndex_NodeKind;
    return {};
}
static PyObject *QXmlNodeModelIndex_NodeKind_CppToPython_QXmlNodeModelIndex_NodeKind(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QXmlNodeModelIndex::NodeKind *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX], castCppIn);

}

static void QXmlNodeModelIndex_DocumentOrder_PythonToCpp_QXmlNodeModelIndex_DocumentOrder(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlNodeModelIndex::DocumentOrder *>(cppOut) =
        static_cast<::QXmlNodeModelIndex::DocumentOrder>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QXmlNodeModelIndex_DocumentOrder_PythonToCpp_QXmlNodeModelIndex_DocumentOrder_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX]))
        return QXmlNodeModelIndex_DocumentOrder_PythonToCpp_QXmlNodeModelIndex_DocumentOrder;
    return {};
}
static PyObject *QXmlNodeModelIndex_DocumentOrder_CppToPython_QXmlNodeModelIndex_DocumentOrder(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QXmlNodeModelIndex::DocumentOrder *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlNodeModelIndex_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlNodeModelIndex_TypeF())))
        return QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlNodeModelIndex_PTR_CppToPython_QXmlNodeModelIndex(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlNodeModelIndex *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlNodeModelIndex_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QXmlNodeModelIndex_COPY_CppToPython_QXmlNodeModelIndex(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QXmlNodeModelIndex_TypeF(), new ::QXmlNodeModelIndex(*reinterpret_cast<const ::QXmlNodeModelIndex *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlNodeModelIndex *>(cppOut) = *reinterpret_cast< ::QXmlNodeModelIndex *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlNodeModelIndex_TypeF())))
        return QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlNodeModelIndex_SignatureStrings[] = {
    "1:PySide2.QtXmlPatterns.QXmlNodeModelIndex(self)",
    "0:PySide2.QtXmlPatterns.QXmlNodeModelIndex(self,other:PySide2.QtXmlPatterns.QXmlNodeModelIndex)",
    "PySide2.QtXmlPatterns.QXmlNodeModelIndex.additionalData(self)->qint64",
    "PySide2.QtXmlPatterns.QXmlNodeModelIndex.data(self)->qint64",
    "PySide2.QtXmlPatterns.QXmlNodeModelIndex.internalPointer(self)->void",
    "PySide2.QtXmlPatterns.QXmlNodeModelIndex.isNull(self)->bool",
    "PySide2.QtXmlPatterns.QXmlNodeModelIndex.model(self)->PySide2.QtXmlPatterns.QAbstractXmlNodeModel",
    "PySide2.QtXmlPatterns.QXmlNodeModelIndex.__copy__()",
    nullptr}; // Sentinel

void init_QXmlNodeModelIndex(PyObject *module)
{
    _Sbk_QXmlNodeModelIndex_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlNodeModelIndex",
        "QXmlNodeModelIndex",
        &Sbk_QXmlNodeModelIndex_spec,
        &Shiboken::callCppDestructor< ::QXmlNodeModelIndex >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlNodeModelIndex_Type);
    InitSignatureStrings(pyType, QXmlNodeModelIndex_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlNodeModelIndex_Type), Sbk_QXmlNodeModelIndex_PropertyStrings);
    SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlNodeModelIndex_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlNodeModelIndex_TypeF(),
        QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_PTR,
        is_QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_PTR_Convertible,
        QXmlNodeModelIndex_PTR_CppToPython_QXmlNodeModelIndex,
        QXmlNodeModelIndex_COPY_CppToPython_QXmlNodeModelIndex);

    Shiboken::Conversions::registerConverterName(converter, "QXmlNodeModelIndex");
    Shiboken::Conversions::registerConverterName(converter, "QXmlNodeModelIndex*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlNodeModelIndex&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlNodeModelIndex).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_COPY,
        is_QXmlNodeModelIndex_PythonToCpp_QXmlNodeModelIndex_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'NodeKind'.
    SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QXmlNodeModelIndex_TypeF(),
        "NodeKind",
        "2:PySide2.QtXmlPatterns.QXmlNodeModelIndex.NodeKind",
        "QXmlNodeModelIndex::NodeKind");
    if (!SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Attribute", (long) QXmlNodeModelIndex::NodeKind::Attribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Comment", (long) QXmlNodeModelIndex::NodeKind::Comment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Document", (long) QXmlNodeModelIndex::NodeKind::Document))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Element", (long) QXmlNodeModelIndex::NodeKind::Element))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Namespace", (long) QXmlNodeModelIndex::NodeKind::Namespace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "ProcessingInstruction", (long) QXmlNodeModelIndex::NodeKind::ProcessingInstruction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Text", (long) QXmlNodeModelIndex::NodeKind::Text))
        return;
    // Register converter for enum 'QXmlNodeModelIndex::NodeKind'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX],
            QXmlNodeModelIndex_NodeKind_CppToPython_QXmlNodeModelIndex_NodeKind);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QXmlNodeModelIndex_NodeKind_PythonToCpp_QXmlNodeModelIndex_NodeKind,
            is_QXmlNodeModelIndex_NodeKind_PythonToCpp_QXmlNodeModelIndex_NodeKind_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QXmlNodeModelIndex::NodeKind");
        Shiboken::Conversions::registerConverterName(converter, "NodeKind");
    }
    // End of 'NodeKind' enum.

    // Initialization of enum 'DocumentOrder'.
    SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QXmlNodeModelIndex_TypeF(),
        "DocumentOrder",
        "2:PySide2.QtXmlPatterns.QXmlNodeModelIndex.DocumentOrder",
        "QXmlNodeModelIndex::DocumentOrder");
    if (!SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Precedes", (long) QXmlNodeModelIndex::DocumentOrder::Precedes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Is", (long) QXmlNodeModelIndex::DocumentOrder::Is))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX],
        Sbk_QXmlNodeModelIndex_TypeF(), "Follows", (long) QXmlNodeModelIndex::DocumentOrder::Follows))
        return;
    // Register converter for enum 'QXmlNodeModelIndex::DocumentOrder'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX],
            QXmlNodeModelIndex_DocumentOrder_CppToPython_QXmlNodeModelIndex_DocumentOrder);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QXmlNodeModelIndex_DocumentOrder_PythonToCpp_QXmlNodeModelIndex_DocumentOrder,
            is_QXmlNodeModelIndex_DocumentOrder_PythonToCpp_QXmlNodeModelIndex_DocumentOrder_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QXmlNodeModelIndex::DocumentOrder");
        Shiboken::Conversions::registerConverterName(converter, "DocumentOrder");
    }
    // End of 'DocumentOrder' enum.

    qRegisterMetaType< ::QXmlNodeModelIndex >("QXmlNodeModelIndex");
    qRegisterMetaType< ::QXmlNodeModelIndex::NodeKind >("QXmlNodeModelIndex::NodeKind");
    qRegisterMetaType< ::QXmlNodeModelIndex::DocumentOrder >("QXmlNodeModelIndex::DocumentOrder");
}
