/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QABSTRACTXMLNODEMODELWRAPPER_H
#define SBK_QABSTRACTXMLNODEMODELWRAPPER_H

#define protected public

#include <QtXmlPatterns/qabstractxmlnodemodel.h>


// Extra includes
#include <qurl.h>
#include <QtXmlPatterns/qabstractxmlnodemodel.h>
#include <QtXmlPatterns/qxmlname.h>
#include <QtXmlPatterns/qabstractxmlreceiver.h>
#include <QVector>
#include <QtXmlPatterns/qsourcelocation.h>
class QAbstractXmlNodeModelWrapper : public QAbstractXmlNodeModel
{
public:
    QAbstractXmlNodeModelWrapper();
    ::QVector<QXmlNodeModelIndex > attributes(const ::QXmlNodeModelIndex & element) const override;
    ::QUrl baseUri(const ::QXmlNodeModelIndex & ni) const override;
    ::QXmlNodeModelIndex::DocumentOrder compareOrder(const ::QXmlNodeModelIndex & ni1, const ::QXmlNodeModelIndex & ni2) const override;
    ::QUrl documentUri(const ::QXmlNodeModelIndex & ni) const override;
    ::QXmlNodeModelIndex elementById(const ::QXmlName & NCName) const override;
    bool isDeepEqual(const ::QXmlNodeModelIndex & ni1, const ::QXmlNodeModelIndex & ni2) const override;
    ::QXmlNodeModelIndex::NodeKind kind(const ::QXmlNodeModelIndex & ni) const override;
    ::QXmlName name(const ::QXmlNodeModelIndex & ni) const override;
    ::QVector<QXmlName > namespaceBindings(const ::QXmlNodeModelIndex & n) const override;
    ::QXmlName::NamespaceCode namespaceForPrefix(const ::QXmlNodeModelIndex & ni, const ::QXmlName::PrefixCode prefix) const override;
    ::QXmlNodeModelIndex nextFromSimpleAxis(::QAbstractXmlNodeModel::SimpleAxis axis, const ::QXmlNodeModelIndex & origin) const override;
    ::QVector<QXmlNodeModelIndex > nodesByIdref(const ::QXmlName & NCName) const override;
    ::QXmlNodeModelIndex root(const ::QXmlNodeModelIndex & n) const override;
    void sendNamespaces(const ::QXmlNodeModelIndex & n, ::QAbstractXmlReceiver *const receiver) const override;
    ::QString stringValue(const ::QXmlNodeModelIndex & n) const override;
    ::QVariant typedValue(const ::QXmlNodeModelIndex & n) const override;
    ~QAbstractXmlNodeModelWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[16];
};

#endif // SBK_QABSTRACTXMLNODEMODELWRAPPER_H

