/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxmlpatterns_python.h"

// main header
#include "qabstractxmlnodemodel_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractXmlNodeModelWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractXmlNodeModelWrapper::QAbstractXmlNodeModelWrapper() : QAbstractXmlNodeModel()
{
    resetPyMethodCache();
    // ... middle
}

::QVector<QXmlNodeModelIndex > QAbstractXmlNodeModelWrapper::attributes(const ::QXmlNodeModelIndex & element) const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.attributes()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "attributes";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.attributes()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &element)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtXmlPatternsTypeConverters[SBK_QTXMLPATTERNS_QVECTOR_QXMLNODEMODELINDEX_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.attributes", "vector", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QVector<QXmlNodeModelIndex > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QUrl QAbstractXmlNodeModelWrapper::baseUri(const ::QXmlNodeModelIndex & ni) const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.baseUri()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "baseUri";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.baseUri()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.baseUri", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QUrl >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QUrl cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QXmlNodeModelIndex::DocumentOrder QAbstractXmlNodeModelWrapper::compareOrder(const ::QXmlNodeModelIndex & ni1, const ::QXmlNodeModelIndex & ni2) const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.compareOrder()' not implemented.");
        return QXmlNodeModelIndex::Is;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QXmlNodeModelIndex::Is;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "compareOrder";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.compareOrder()' not implemented.");
        return QXmlNodeModelIndex::Is;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni1),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QXmlNodeModelIndex::Is;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.compareOrder", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QXmlNodeModelIndex::DocumentOrder >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QXmlNodeModelIndex::Is;
    }
    ::QXmlNodeModelIndex::DocumentOrder cppResult{QXmlNodeModelIndex::Is};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QUrl QAbstractXmlNodeModelWrapper::documentUri(const ::QXmlNodeModelIndex & ni) const
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.documentUri()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "documentUri";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.documentUri()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.documentUri", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QUrl >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QUrl cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QXmlNodeModelIndex QAbstractXmlNodeModelWrapper::elementById(const ::QXmlName & NCName) const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.elementById()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "elementById";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.elementById()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), &NCName)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.elementById", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QXmlNodeModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QXmlNodeModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractXmlNodeModelWrapper::isDeepEqual(const ::QXmlNodeModelIndex & ni1, const ::QXmlNodeModelIndex & ni2) const
{
    if (m_PyMethodCache[5])
        return this->::QAbstractXmlNodeModel::isDeepEqual(ni1, ni2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isDeepEqual";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QAbstractXmlNodeModel::isDeepEqual(ni1, ni2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni1),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.isDeepEqual", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QXmlNodeModelIndex::NodeKind QAbstractXmlNodeModelWrapper::kind(const ::QXmlNodeModelIndex & ni) const
{
    if (m_PyMethodCache[6]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.kind()' not implemented.");
        return static_cast< ::QXmlNodeModelIndex::NodeKind>(0);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return static_cast< ::QXmlNodeModelIndex::NodeKind>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "kind";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.kind()' not implemented.");
        return static_cast< ::QXmlNodeModelIndex::NodeKind>(0);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return static_cast< ::QXmlNodeModelIndex::NodeKind>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.kind", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QXmlNodeModelIndex::NodeKind >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return static_cast< ::QXmlNodeModelIndex::NodeKind>(0);
    }
    ::QXmlNodeModelIndex::NodeKind cppResult = static_cast< ::QXmlNodeModelIndex::NodeKind>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QXmlName QAbstractXmlNodeModelWrapper::name(const ::QXmlNodeModelIndex & ni) const
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.name()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "name";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.name()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.name", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QXmlName >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QXmlName cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVector<QXmlName > QAbstractXmlNodeModelWrapper::namespaceBindings(const ::QXmlNodeModelIndex & n) const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.namespaceBindings()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "namespaceBindings";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.namespaceBindings()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &n)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtXmlPatternsTypeConverters[SBK_QTXMLPATTERNS_QVECTOR_QXMLNAME_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.namespaceBindings", "vector", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QVector<QXmlName > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QXmlName::NamespaceCode QAbstractXmlNodeModelWrapper::namespaceForPrefix(const ::QXmlNodeModelIndex & ni, const ::QXmlName::PrefixCode prefix) const
{
    if (m_PyMethodCache[9])
        return this->::QAbstractXmlNodeModel::namespaceForPrefix(ni, prefix);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QXmlName::NamespaceCode();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "namespaceForPrefix";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QAbstractXmlNodeModel::namespaceForPrefix(ni, prefix);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &ni),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<QXmlName::PrefixCode>(), &prefix)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QXmlName::NamespaceCode();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<QXmlName::NamespaceCode>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.namespaceForPrefix", "NamespaceCode", Py_TYPE(pyResult)->tp_name);
        return ::QXmlName::NamespaceCode();
    }
    ::QXmlName::NamespaceCode cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QXmlNodeModelIndex QAbstractXmlNodeModelWrapper::nextFromSimpleAxis(::QAbstractXmlNodeModel::SimpleAxis axis, const ::QXmlNodeModelIndex & origin) const
{
    if (m_PyMethodCache[10]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nextFromSimpleAxis()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nextFromSimpleAxis";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nextFromSimpleAxis()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX])->converter, &axis),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &origin)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.nextFromSimpleAxis", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QXmlNodeModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QXmlNodeModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVector<QXmlNodeModelIndex > QAbstractXmlNodeModelWrapper::nodesByIdref(const ::QXmlName & NCName) const
{
    if (m_PyMethodCache[11]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nodesByIdref()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nodesByIdref";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nodesByIdref()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), &NCName)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtXmlPatternsTypeConverters[SBK_QTXMLPATTERNS_QVECTOR_QXMLNODEMODELINDEX_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.nodesByIdref", "vector", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QVector<QXmlNodeModelIndex > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QXmlNodeModelIndex QAbstractXmlNodeModelWrapper::root(const ::QXmlNodeModelIndex & n) const
{
    if (m_PyMethodCache[12]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.root()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "root";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.root()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &n)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.root", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QXmlNodeModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QXmlNodeModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractXmlNodeModelWrapper::sendNamespaces(const ::QXmlNodeModelIndex & n, ::QAbstractXmlReceiver *const receiver) const
{
    if (m_PyMethodCache[13]) {
        return this->::QAbstractXmlNodeModel::sendNamespaces(n, receiver);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sendNamespaces";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QAbstractXmlNodeModel::sendNamespaces(n, receiver);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &n),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX]), receiver)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QString QAbstractXmlNodeModelWrapper::stringValue(const ::QXmlNodeModelIndex & n) const
{
    if (m_PyMethodCache[14]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.stringValue()' not implemented.");
        return ::QString();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stringValue";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.stringValue()' not implemented.");
        return ::QString();
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &n)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.stringValue", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QAbstractXmlNodeModelWrapper::typedValue(const ::QXmlNodeModelIndex & n) const
{
    if (m_PyMethodCache[15]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.typedValue()' not implemented.");
        return ::QVariant();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "typedValue";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.typedValue()' not implemented.");
        return ::QVariant();
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &n)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.typedValue", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QAbstractXmlNodeModelWrapper::~QAbstractXmlNodeModelWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractXmlNodeModel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractXmlNodeModel' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractXmlNodeModel >()))
        return -1;

    ::QAbstractXmlNodeModelWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QAbstractXmlNodeModel()
            cptr = new ::QAbstractXmlNodeModelWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractXmlNodeModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_attributes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.attributes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::attributes(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // attributes(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_attributes_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // attributes(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.attributes()' not implemented.");
                return {};
            }
            QVector<QXmlNodeModelIndex > cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->attributes(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtXmlPatternsTypeConverters[SBK_QTXMLPATTERNS_QVECTOR_QXMLNODEMODELINDEX_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_attributes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_baseUri(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.baseUri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::baseUri(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // baseUri(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_baseUri_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // baseUri(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.baseUri()' not implemented.");
                return {};
            }
            QUrl cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->baseUri(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_baseUri_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_compareOrder(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.compareOrder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "compareOrder", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::compareOrder(QXmlNodeModelIndex,QXmlNodeModelIndex)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[1])))) {
        overloadId = 0; // compareOrder(QXmlNodeModelIndex,QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_compareOrder_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QXmlNodeModelIndex cppArg1_local;
        ::QXmlNodeModelIndex *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // compareOrder(QXmlNodeModelIndex,QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.compareOrder()' not implemented.");
                return {};
            }
            QXmlNodeModelIndex::DocumentOrder cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->compareOrder(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_compareOrder_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_createIndex(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.createIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:createIndex", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::createIndex(qint64)const
    // 1: QAbstractXmlNodeModel::createIndex(qint64,qint64)const
    // 2: QAbstractXmlNodeModel::createIndex(void*,qint64)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // createIndex(void*,qint64)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
            overloadId = 2; // createIndex(void*,qint64)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createIndex(qint64)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
            overloadId = 1; // createIndex(qint64,qint64)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createIndex(qint64 data) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError;
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // createIndex(qint64)const
                QXmlNodeModelIndex cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->createIndex(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &cppResult);
            }
            break;
        }
        case 1: // createIndex(qint64 data, qint64 additionalData) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError;
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qint64 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createIndex(qint64,qint64)const
                QXmlNodeModelIndex cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->createIndex(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &cppResult);
            }
            break;
        }
        case 2: // createIndex(void * pointer, qint64 additionalData) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_additionalData = Shiboken::String::createStaticString("additionalData");
                if (PyDict_Contains(kwds, key_additionalData)) {
                    value = PyDict_GetItem(kwds, key_additionalData);
                    if (value && pyArgs[1]) {
                        errInfo = key_additionalData;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1]))))
                            goto Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_additionalData);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError;
                }
            }
            void* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qint64 cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createIndex(void*,qint64)const
                QXmlNodeModelIndex cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->createIndex(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_createIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_documentUri(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.documentUri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::documentUri(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // documentUri(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_documentUri_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // documentUri(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.documentUri()' not implemented.");
                return {};
            }
            QUrl cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->documentUri(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_documentUri_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_elementById(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.elementById";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::elementById(QXmlName)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), (pyArg)))) {
        overloadId = 0; // elementById(QXmlName)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_elementById_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlName cppArg0_local;
        ::QXmlName *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // elementById(QXmlName)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.elementById()' not implemented.");
                return {};
            }
            QXmlNodeModelIndex cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->elementById(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_elementById_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_isDeepEqual(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.isDeepEqual";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isDeepEqual", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::isDeepEqual(QXmlNodeModelIndex,QXmlNodeModelIndex)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[1])))) {
        overloadId = 0; // isDeepEqual(QXmlNodeModelIndex,QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_isDeepEqual_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QXmlNodeModelIndex cppArg1_local;
        ::QXmlNodeModelIndex *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // isDeepEqual(QXmlNodeModelIndex,QXmlNodeModelIndex)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->::QAbstractXmlNodeModel::isDeepEqual(*cppArg0, *cppArg1)
                : const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->isDeepEqual(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_isDeepEqual_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_kind(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.kind";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::kind(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // kind(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_kind_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // kind(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.kind()' not implemented.");
                return {};
            }
            QXmlNodeModelIndex::NodeKind cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->kind(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_kind_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_name(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.name";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::name(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // name(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_name_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // name(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.name()' not implemented.");
                return {};
            }
            QXmlName cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->name(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_name_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_namespaceBindings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.namespaceBindings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::namespaceBindings(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // namespaceBindings(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_namespaceBindings_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // namespaceBindings(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.namespaceBindings()' not implemented.");
                return {};
            }
            QVector<QXmlName > cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->namespaceBindings(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtXmlPatternsTypeConverters[SBK_QTXMLPATTERNS_QVECTOR_QXMLNAME_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_namespaceBindings_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_namespaceForPrefix(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.namespaceForPrefix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "namespaceForPrefix", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::namespaceForPrefix(QXmlNodeModelIndex,QXmlName::PrefixCode)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<QXmlName::PrefixCode>(), (pyArgs[1])))) {
        overloadId = 0; // namespaceForPrefix(QXmlNodeModelIndex,QXmlName::PrefixCode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_namespaceForPrefix_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QXmlName::PrefixCode cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // namespaceForPrefix(QXmlNodeModelIndex,QXmlName::PrefixCode)const
            QXmlName::NamespaceCode cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->::QAbstractXmlNodeModel::namespaceForPrefix(*cppArg0, cppArg1)
                : const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->namespaceForPrefix(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<QXmlName::NamespaceCode>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_namespaceForPrefix_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_nextFromSimpleAxis(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.nextFromSimpleAxis";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "nextFromSimpleAxis", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::nextFromSimpleAxis(QAbstractXmlNodeModel::SimpleAxis,QXmlNodeModelIndex)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[1])))) {
        overloadId = 0; // nextFromSimpleAxis(QAbstractXmlNodeModel::SimpleAxis,QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_nextFromSimpleAxis_TypeError;

    // Call function/method
    {
        ::QAbstractXmlNodeModel::SimpleAxis cppArg0{QAbstractXmlNodeModel::Parent};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QXmlNodeModelIndex cppArg1_local;
        ::QXmlNodeModelIndex *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // nextFromSimpleAxis(QAbstractXmlNodeModel::SimpleAxis,QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nextFromSimpleAxis()' not implemented.");
                return {};
            }
            QXmlNodeModelIndex cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->nextFromSimpleAxis(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_nextFromSimpleAxis_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_nodesByIdref(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.nodesByIdref";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::nodesByIdref(QXmlName)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), (pyArg)))) {
        overloadId = 0; // nodesByIdref(QXmlName)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_nodesByIdref_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlName cppArg0_local;
        ::QXmlName *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // nodesByIdref(QXmlName)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nodesByIdref()' not implemented.");
                return {};
            }
            QVector<QXmlNodeModelIndex > cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->nodesByIdref(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtXmlPatternsTypeConverters[SBK_QTXMLPATTERNS_QVECTOR_QXMLNODEMODELINDEX_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_nodesByIdref_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_root(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.root";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::root(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // root(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_root_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // root(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.root()' not implemented.");
                return {};
            }
            QXmlNodeModelIndex cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->root(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_root_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_sendNamespaces(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.sendNamespaces";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sendNamespaces", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::sendNamespaces(QXmlNodeModelIndex,QAbstractXmlReceiver*const)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX]), (pyArgs[1])))) {
        overloadId = 0; // sendNamespaces(QXmlNodeModelIndex,QAbstractXmlReceiver*const)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_sendNamespaces_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAbstractXmlReceiver *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // sendNamespaces(QXmlNodeModelIndex,QAbstractXmlReceiver*const)const
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->::QAbstractXmlNodeModel::sendNamespaces(*cppArg0, cppArg1)
                : const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->sendNamespaces(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractXmlNodeModelFunc_sendNamespaces_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_sourceLocation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.sourceLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::sourceLocation(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // sourceLocation(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_sourceLocation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // sourceLocation(QXmlNodeModelIndex)const
            QSourceLocation cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->sourceLocation(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QSOURCELOCATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_sourceLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_stringValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.stringValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::stringValue(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // stringValue(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_stringValue_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // stringValue(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.stringValue()' not implemented.");
                return {};
            }
            QString cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->stringValue(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_stringValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractXmlNodeModelFunc_typedValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.typedValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractXmlNodeModel::typedValue(QXmlNodeModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // typedValue(QXmlNodeModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractXmlNodeModelFunc_typedValue_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlNodeModelIndex cppArg0_local;
        ::QXmlNodeModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // typedValue(QXmlNodeModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.typedValue()' not implemented.");
                return {};
            }
            QVariant cppResult = const_cast<const ::QAbstractXmlNodeModel *>(cppSelf)->typedValue(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractXmlNodeModelFunc_typedValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAbstractXmlNodeModel_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractXmlNodeModel_methods[] = {
    {"attributes", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_attributes), METH_O},
    {"baseUri", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_baseUri), METH_O},
    {"compareOrder", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_compareOrder), METH_VARARGS},
    {"createIndex", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_createIndex), METH_VARARGS|METH_KEYWORDS},
    {"documentUri", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_documentUri), METH_O},
    {"elementById", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_elementById), METH_O},
    {"isDeepEqual", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_isDeepEqual), METH_VARARGS},
    {"kind", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_kind), METH_O},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_name), METH_O},
    {"namespaceBindings", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_namespaceBindings), METH_O},
    {"namespaceForPrefix", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_namespaceForPrefix), METH_VARARGS},
    {"nextFromSimpleAxis", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_nextFromSimpleAxis), METH_VARARGS},
    {"nodesByIdref", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_nodesByIdref), METH_O},
    {"root", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_root), METH_O},
    {"sendNamespaces", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_sendNamespaces), METH_VARARGS},
    {"sourceLocation", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_sourceLocation), METH_O},
    {"stringValue", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_stringValue), METH_O},
    {"typedValue", reinterpret_cast<PyCFunction>(Sbk_QAbstractXmlNodeModelFunc_typedValue), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractXmlNodeModel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractXmlNodeModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractXmlNodeModelWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractXmlNodeModel_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractXmlNodeModel_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractXmlNodeModel_Type = nullptr;
static SbkObjectType *Sbk_QAbstractXmlNodeModel_TypeF(void)
{
    return _Sbk_QAbstractXmlNodeModel_Type;
}

static PyType_Slot Sbk_QAbstractXmlNodeModel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractXmlNodeModel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractXmlNodeModel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractXmlNodeModel_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractXmlNodeModel_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractXmlNodeModel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractXmlNodeModel_spec = {
    "2:PySide2.QtXmlPatterns.QAbstractXmlNodeModel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractXmlNodeModel_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QAbstractXmlNodeModel_SimpleAxis_PythonToCpp_QAbstractXmlNodeModel_SimpleAxis(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractXmlNodeModel::SimpleAxis *>(cppOut) =
        static_cast<::QAbstractXmlNodeModel::SimpleAxis>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractXmlNodeModel_SimpleAxis_PythonToCpp_QAbstractXmlNodeModel_SimpleAxis_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX]))
        return QAbstractXmlNodeModel_SimpleAxis_PythonToCpp_QAbstractXmlNodeModel_SimpleAxis;
    return {};
}
static PyObject *QAbstractXmlNodeModel_SimpleAxis_CppToPython_QAbstractXmlNodeModel_SimpleAxis(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractXmlNodeModel::SimpleAxis *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX], castCppIn);

}

static void QAbstractXmlNodeModel_NodeCopySetting_PythonToCpp_QAbstractXmlNodeModel_NodeCopySetting(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractXmlNodeModel::NodeCopySetting *>(cppOut) =
        static_cast<::QAbstractXmlNodeModel::NodeCopySetting>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractXmlNodeModel_NodeCopySetting_PythonToCpp_QAbstractXmlNodeModel_NodeCopySetting_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX]))
        return QAbstractXmlNodeModel_NodeCopySetting_PythonToCpp_QAbstractXmlNodeModel_NodeCopySetting;
    return {};
}
static PyObject *QAbstractXmlNodeModel_NodeCopySetting_CppToPython_QAbstractXmlNodeModel_NodeCopySetting(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractXmlNodeModel::NodeCopySetting *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractXmlNodeModel_PythonToCpp_QAbstractXmlNodeModel_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractXmlNodeModel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractXmlNodeModel_PythonToCpp_QAbstractXmlNodeModel_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractXmlNodeModel_TypeF())))
        return QAbstractXmlNodeModel_PythonToCpp_QAbstractXmlNodeModel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractXmlNodeModel_PTR_CppToPython_QAbstractXmlNodeModel(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAbstractXmlNodeModel *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAbstractXmlNodeModel_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractXmlNodeModel_SignatureStrings[] = {
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel(self)",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.attributes(self,element:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->QVector[PySide2.QtXmlPatterns.QXmlNodeModelIndex]",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.baseUri(self,ni:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->PySide2.QtCore.QUrl",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.compareOrder(self,ni1:PySide2.QtXmlPatterns.QXmlNodeModelIndex,ni2:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->PySide2.QtXmlPatterns.QXmlNodeModelIndex.DocumentOrder",
    "2:PySide2.QtXmlPatterns.QAbstractXmlNodeModel.createIndex(self,data:qint64)->PySide2.QtXmlPatterns.QXmlNodeModelIndex",
    "1:PySide2.QtXmlPatterns.QAbstractXmlNodeModel.createIndex(self,data:qint64,additionalData:qint64)->PySide2.QtXmlPatterns.QXmlNodeModelIndex",
    "0:PySide2.QtXmlPatterns.QAbstractXmlNodeModel.createIndex(self,pointer:void,additionalData:qint64=0)->PySide2.QtXmlPatterns.QXmlNodeModelIndex",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.documentUri(self,ni:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->PySide2.QtCore.QUrl",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.elementById(self,NCName:PySide2.QtXmlPatterns.QXmlName)->PySide2.QtXmlPatterns.QXmlNodeModelIndex",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.isDeepEqual(self,ni1:PySide2.QtXmlPatterns.QXmlNodeModelIndex,ni2:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->bool",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.kind(self,ni:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->PySide2.QtXmlPatterns.QXmlNodeModelIndex.NodeKind",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.name(self,ni:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->PySide2.QtXmlPatterns.QXmlName",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.namespaceBindings(self,n:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->QVector[PySide2.QtXmlPatterns.QXmlName]",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.namespaceForPrefix(self,ni:PySide2.QtXmlPatterns.QXmlNodeModelIndex,prefix:QXmlName.PrefixCode)->QXmlName.NamespaceCode",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.nextFromSimpleAxis(self,axis:PySide2.QtXmlPatterns.QAbstractXmlNodeModel.SimpleAxis,origin:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->PySide2.QtXmlPatterns.QXmlNodeModelIndex",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.nodesByIdref(self,NCName:PySide2.QtXmlPatterns.QXmlName)->QVector[PySide2.QtXmlPatterns.QXmlNodeModelIndex]",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.root(self,n:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->PySide2.QtXmlPatterns.QXmlNodeModelIndex",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.sendNamespaces(self,n:PySide2.QtXmlPatterns.QXmlNodeModelIndex,receiver:PySide2.QtXmlPatterns.QAbstractXmlReceiver)",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.sourceLocation(self,index:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->PySide2.QtXmlPatterns.QSourceLocation",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.stringValue(self,n:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->QString",
    "PySide2.QtXmlPatterns.QAbstractXmlNodeModel.typedValue(self,n:PySide2.QtXmlPatterns.QXmlNodeModelIndex)->QVariant",
    nullptr}; // Sentinel

void init_QAbstractXmlNodeModel(PyObject *module)
{
    _Sbk_QAbstractXmlNodeModel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractXmlNodeModel",
        "QAbstractXmlNodeModel*",
        &Sbk_QAbstractXmlNodeModel_spec,
        &Shiboken::callCppDestructor< ::QAbstractXmlNodeModel >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractXmlNodeModel_Type);
    InitSignatureStrings(pyType, QAbstractXmlNodeModel_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractXmlNodeModel_Type), Sbk_QAbstractXmlNodeModel_PropertyStrings);
    SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractXmlNodeModel_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractXmlNodeModel_TypeF(),
        QAbstractXmlNodeModel_PythonToCpp_QAbstractXmlNodeModel_PTR,
        is_QAbstractXmlNodeModel_PythonToCpp_QAbstractXmlNodeModel_PTR_Convertible,
        QAbstractXmlNodeModel_PTR_CppToPython_QAbstractXmlNodeModel);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractXmlNodeModel");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractXmlNodeModel*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractXmlNodeModel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractXmlNodeModel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractXmlNodeModelWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'SimpleAxis'.
    SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractXmlNodeModel_TypeF(),
        "SimpleAxis",
        "2:PySide2.QtXmlPatterns.QAbstractXmlNodeModel.SimpleAxis",
        "QAbstractXmlNodeModel::SimpleAxis");
    if (!SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX],
        Sbk_QAbstractXmlNodeModel_TypeF(), "Parent", (long) QAbstractXmlNodeModel::SimpleAxis::Parent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX],
        Sbk_QAbstractXmlNodeModel_TypeF(), "FirstChild", (long) QAbstractXmlNodeModel::SimpleAxis::FirstChild))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX],
        Sbk_QAbstractXmlNodeModel_TypeF(), "PreviousSibling", (long) QAbstractXmlNodeModel::SimpleAxis::PreviousSibling))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX],
        Sbk_QAbstractXmlNodeModel_TypeF(), "NextSibling", (long) QAbstractXmlNodeModel::SimpleAxis::NextSibling))
        return;
    // Register converter for enum 'QAbstractXmlNodeModel::SimpleAxis'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX],
            QAbstractXmlNodeModel_SimpleAxis_CppToPython_QAbstractXmlNodeModel_SimpleAxis);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractXmlNodeModel_SimpleAxis_PythonToCpp_QAbstractXmlNodeModel_SimpleAxis,
            is_QAbstractXmlNodeModel_SimpleAxis_PythonToCpp_QAbstractXmlNodeModel_SimpleAxis_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractXmlNodeModel::SimpleAxis");
        Shiboken::Conversions::registerConverterName(converter, "SimpleAxis");
    }
    // End of 'SimpleAxis' enum.

    // Initialization of enum 'NodeCopySetting'.
    SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractXmlNodeModel_TypeF(),
        "NodeCopySetting",
        "2:PySide2.QtXmlPatterns.QAbstractXmlNodeModel.NodeCopySetting",
        "QAbstractXmlNodeModel::NodeCopySetting");
    if (!SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX],
        Sbk_QAbstractXmlNodeModel_TypeF(), "InheritNamespaces", (long) QAbstractXmlNodeModel::NodeCopySetting::InheritNamespaces))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX],
        Sbk_QAbstractXmlNodeModel_TypeF(), "PreserveNamespaces", (long) QAbstractXmlNodeModel::NodeCopySetting::PreserveNamespaces))
        return;
    // Register converter for enum 'QAbstractXmlNodeModel::NodeCopySetting'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX],
            QAbstractXmlNodeModel_NodeCopySetting_CppToPython_QAbstractXmlNodeModel_NodeCopySetting);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractXmlNodeModel_NodeCopySetting_PythonToCpp_QAbstractXmlNodeModel_NodeCopySetting,
            is_QAbstractXmlNodeModel_NodeCopySetting_PythonToCpp_QAbstractXmlNodeModel_NodeCopySetting_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractXmlNodeModel::NodeCopySetting");
        Shiboken::Conversions::registerConverterName(converter, "NodeCopySetting");
    }
    // End of 'NodeCopySetting' enum.

    qRegisterMetaType< ::QAbstractXmlNodeModel::SimpleAxis >("QAbstractXmlNodeModel::SimpleAxis");
    qRegisterMetaType< ::QAbstractXmlNodeModel::NodeCopySetting >("QAbstractXmlNodeModel::NodeCopySetting");
}
