/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxml_python.h"

// main header
#include "qdomtext_wrapper.h"

// inner classes

// Extra includes
#include <QtXml/qdom.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDomText_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDomText >()))
        return -1;

    ::QDomText *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomText.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDomText", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDomText::QDomText()
    // 1: QDomText::QDomText(QDomText)
    if (numArgs == 0) {
        overloadId = 0; // QDomText()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDomText(QDomText)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomText_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDomText()
        {

            if (!PyErr_Occurred()) {
                // QDomText()
                cptr = new ::QDomText();
            }
            break;
        }
        case 1: // QDomText(const QDomText & x)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDomText cppArg0_local;
            ::QDomText *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDomText(QDomText)
                cptr = new ::QDomText(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDomText >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDomText_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDomText_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDomTextFunc_nodeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomText.nodeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nodeType()const
            QDomNode::NodeType cppResult = const_cast<const ::QDomText *>(cppSelf)->nodeType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomTextFunc_splitText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomText.splitText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomText::splitText(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // splitText(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomTextFunc_splitText_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // splitText(int)
            QDomText cppResult = cppSelf->splitText(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomTextFunc_splitText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomText___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDomText_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDomText_methods[] = {
    {"nodeType", reinterpret_cast<PyCFunction>(Sbk_QDomTextFunc_nodeType), METH_NOARGS},
    {"splitText", reinterpret_cast<PyCFunction>(Sbk_QDomTextFunc_splitText), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDomText___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QDomText_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDomText_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDomText_Type = nullptr;
static SbkObjectType *Sbk_QDomText_TypeF(void)
{
    return _Sbk_QDomText_Type;
}

static PyType_Slot Sbk_QDomText_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDomText_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDomText_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDomText_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDomText_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QDomText_spec = {
    "2:PySide2.QtXml.QDomText",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDomText_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDomText_PythonToCpp_QDomText_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDomText_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDomText_PythonToCpp_QDomText_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomText_TypeF())))
        return QDomText_PythonToCpp_QDomText_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDomText_PTR_CppToPython_QDomText(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDomText *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDomText_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDomText_COPY_CppToPython_QDomText(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDomText_TypeF(), new ::QDomText(*reinterpret_cast<const ::QDomText *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDomText_PythonToCpp_QDomText_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomText *>(cppOut) = *reinterpret_cast< ::QDomText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDomText_PythonToCpp_QDomText_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomText_TypeF())))
        return QDomText_PythonToCpp_QDomText_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDomText_SignatureStrings[] = {
    "1:PySide2.QtXml.QDomText(self)",
    "0:PySide2.QtXml.QDomText(self,x:PySide2.QtXml.QDomText)",
    "PySide2.QtXml.QDomText.nodeType(self)->PySide2.QtXml.QDomNode.NodeType",
    "PySide2.QtXml.QDomText.splitText(self,offset:int)->PySide2.QtXml.QDomText",
    "PySide2.QtXml.QDomText.__copy__()",
    nullptr}; // Sentinel

void init_QDomText(PyObject *module)
{
    _Sbk_QDomText_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDomText",
        "QDomText",
        &Sbk_QDomText_spec,
        &Shiboken::callCppDestructor< ::QDomText >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMCHARACTERDATA_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDomText_Type);
    InitSignatureStrings(pyType, QDomText_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDomText_Type), Sbk_QDomText_PropertyStrings);
    SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDomText_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDomText_TypeF(),
        QDomText_PythonToCpp_QDomText_PTR,
        is_QDomText_PythonToCpp_QDomText_PTR_Convertible,
        QDomText_PTR_CppToPython_QDomText,
        QDomText_COPY_CppToPython_QDomText);

    Shiboken::Conversions::registerConverterName(converter, "QDomText");
    Shiboken::Conversions::registerConverterName(converter, "QDomText*");
    Shiboken::Conversions::registerConverterName(converter, "QDomText&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDomText).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDomText_PythonToCpp_QDomText_COPY,
        is_QDomText_PythonToCpp_QDomText_COPY_Convertible);

    qRegisterMetaType< ::QDomText >("QDomText");
}
