/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxml_python.h"

// main header
#include "qdomprocessinginstruction_wrapper.h"

// inner classes

// Extra includes
#include <QtXml/qdom.h>
#include <qtextstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDomProcessingInstruction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDomProcessingInstruction >()))
        return -1;

    ::QDomProcessingInstruction *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomProcessingInstruction.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDomProcessingInstruction", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDomProcessingInstruction::QDomProcessingInstruction()
    // 1: QDomProcessingInstruction::QDomProcessingInstruction(QDomProcessingInstruction)
    if (numArgs == 0) {
        overloadId = 0; // QDomProcessingInstruction()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDomProcessingInstruction(QDomProcessingInstruction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomProcessingInstruction_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDomProcessingInstruction()
        {

            if (!PyErr_Occurred()) {
                // QDomProcessingInstruction()
                cptr = new ::QDomProcessingInstruction();
            }
            break;
        }
        case 1: // QDomProcessingInstruction(const QDomProcessingInstruction & x)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDomProcessingInstruction cppArg0_local;
            ::QDomProcessingInstruction *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDomProcessingInstruction(QDomProcessingInstruction)
                cptr = new ::QDomProcessingInstruction(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDomProcessingInstruction >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDomProcessingInstruction_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDomProcessingInstruction_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDomProcessingInstructionFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomProcessingInstruction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomProcessingInstruction.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            QString cppResult = const_cast<const ::QDomProcessingInstruction *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomProcessingInstructionFunc_nodeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomProcessingInstruction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomProcessingInstruction.nodeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nodeType()const
            QDomNode::NodeType cppResult = const_cast<const ::QDomProcessingInstruction *>(cppSelf)->nodeType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomProcessingInstructionFunc_setData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomProcessingInstruction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomProcessingInstruction.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomProcessingInstruction::setData(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setData(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomProcessingInstructionFunc_setData_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setData(QString)
            cppSelf->setData(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDomProcessingInstructionFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomProcessingInstructionFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomProcessingInstruction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomProcessingInstruction.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            QString cppResult = const_cast<const ::QDomProcessingInstruction *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomProcessingInstruction___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomProcessingInstruction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDomProcessingInstruction_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDomProcessingInstruction_methods[] = {
    {"data", reinterpret_cast<PyCFunction>(Sbk_QDomProcessingInstructionFunc_data), METH_NOARGS},
    {"nodeType", reinterpret_cast<PyCFunction>(Sbk_QDomProcessingInstructionFunc_nodeType), METH_NOARGS},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_QDomProcessingInstructionFunc_setData), METH_O},
    {"target", reinterpret_cast<PyCFunction>(Sbk_QDomProcessingInstructionFunc_target), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDomProcessingInstruction___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QDomProcessingInstruction___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QDomProcessingInstruction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QDomProcessingInstruction_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDomProcessingInstruction_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDomProcessingInstruction_Type = nullptr;
static SbkObjectType *Sbk_QDomProcessingInstruction_TypeF(void)
{
    return _Sbk_QDomProcessingInstruction_Type;
}

static PyType_Slot Sbk_QDomProcessingInstruction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDomProcessingInstruction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDomProcessingInstruction_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDomProcessingInstruction_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDomProcessingInstruction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QDomProcessingInstruction___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QDomProcessingInstruction___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QDomProcessingInstruction_spec = {
    "2:PySide2.QtXml.QDomProcessingInstruction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDomProcessingInstruction_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDomProcessingInstruction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomProcessingInstruction_TypeF())))
        return QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDomProcessingInstruction_PTR_CppToPython_QDomProcessingInstruction(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDomProcessingInstruction *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDomProcessingInstruction_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDomProcessingInstruction_COPY_CppToPython_QDomProcessingInstruction(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDomProcessingInstruction_TypeF(), new ::QDomProcessingInstruction(*reinterpret_cast<const ::QDomProcessingInstruction *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomProcessingInstruction *>(cppOut) = *reinterpret_cast< ::QDomProcessingInstruction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomProcessingInstruction_TypeF())))
        return QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDomProcessingInstruction_SignatureStrings[] = {
    "1:PySide2.QtXml.QDomProcessingInstruction(self)",
    "0:PySide2.QtXml.QDomProcessingInstruction(self,x:PySide2.QtXml.QDomProcessingInstruction)",
    "PySide2.QtXml.QDomProcessingInstruction.data(self)->QString",
    "PySide2.QtXml.QDomProcessingInstruction.nodeType(self)->PySide2.QtXml.QDomNode.NodeType",
    "PySide2.QtXml.QDomProcessingInstruction.setData(self,d:QString)",
    "PySide2.QtXml.QDomProcessingInstruction.target(self)->QString",
    "PySide2.QtXml.QDomProcessingInstruction.__copy__()",
    nullptr}; // Sentinel

void init_QDomProcessingInstruction(PyObject *module)
{
    _Sbk_QDomProcessingInstruction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDomProcessingInstruction",
        "QDomProcessingInstruction",
        &Sbk_QDomProcessingInstruction_spec,
        &Shiboken::callCppDestructor< ::QDomProcessingInstruction >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDomProcessingInstruction_Type);
    InitSignatureStrings(pyType, QDomProcessingInstruction_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDomProcessingInstruction_Type), Sbk_QDomProcessingInstruction_PropertyStrings);
    SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDomProcessingInstruction_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDomProcessingInstruction_TypeF(),
        QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_PTR,
        is_QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_PTR_Convertible,
        QDomProcessingInstruction_PTR_CppToPython_QDomProcessingInstruction,
        QDomProcessingInstruction_COPY_CppToPython_QDomProcessingInstruction);

    Shiboken::Conversions::registerConverterName(converter, "QDomProcessingInstruction");
    Shiboken::Conversions::registerConverterName(converter, "QDomProcessingInstruction*");
    Shiboken::Conversions::registerConverterName(converter, "QDomProcessingInstruction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDomProcessingInstruction).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_COPY,
        is_QDomProcessingInstruction_PythonToCpp_QDomProcessingInstruction_COPY_Convertible);

    qRegisterMetaType< ::QDomProcessingInstruction >("QDomProcessingInstruction");
}
