/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxml_python.h"

// main header
#include "qdomnode_wrapper.h"

// inner classes

// Extra includes
#include <QtXml/qdom.h>
#include <qtextstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDomNode_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDomNode >()))
        return -1;

    ::QDomNode *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDomNode", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDomNode::QDomNode()
    // 1: QDomNode::QDomNode(QDomNode)
    if (numArgs == 0) {
        overloadId = 0; // QDomNode()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDomNode(QDomNode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNode_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDomNode()
        {

            if (!PyErr_Occurred()) {
                // QDomNode()
                cptr = new ::QDomNode();
            }
            break;
        }
        case 1: // QDomNode(const QDomNode & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDomNode cppArg0_local;
            ::QDomNode *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDomNode(QDomNode)
                cptr = new ::QDomNode(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDomNode >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDomNode_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDomNode_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDomNodeFunc_appendChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.appendChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNode::appendChild(QDomNode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArg)))) {
        overloadId = 0; // appendChild(QDomNode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_appendChild_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDomNode cppArg0_local;
        ::QDomNode *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // appendChild(QDomNode)
            QDomNode cppResult = cppSelf->appendChild(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_appendChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_attributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.attributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attributes()const
            QDomNamedNodeMap cppResult = const_cast<const ::QDomNode *>(cppSelf)->attributes();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_childNodes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.childNodes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childNodes()const
            QDomNodeList cppResult = const_cast<const ::QDomNode *>(cppSelf)->childNodes();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODELIST_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDomNodeFunc_cloneNode(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.cloneNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomNodeFunc_cloneNode_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:cloneNode", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::cloneNode(bool)const
    if (numArgs == 0) {
        overloadId = 0; // cloneNode(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // cloneNode(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_cloneNode_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_deep = Shiboken::String::createStaticString("deep");
            if (PyDict_Contains(kwds, key_deep)) {
                value = PyDict_GetItem(kwds, key_deep);
                if (value && pyArgs[0]) {
                    errInfo = key_deep;
                    Py_INCREF(errInfo);
                    goto Sbk_QDomNodeFunc_cloneNode_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QDomNodeFunc_cloneNode_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_deep);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDomNodeFunc_cloneNode_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // cloneNode(bool)const
            QDomNode cppResult = const_cast<const ::QDomNode *>(cppSelf)->cloneNode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_cloneNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_columnNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.columnNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnNumber()const
            int cppResult = const_cast<const ::QDomNode *>(cppSelf)->columnNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_firstChild(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.firstChild";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstChild()const
            QDomNode cppResult = const_cast<const ::QDomNode *>(cppSelf)->firstChild();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_firstChildElement(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.firstChildElement";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomNodeFunc_firstChildElement_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:firstChildElement", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::firstChildElement(QString)const
    if (numArgs == 0) {
        overloadId = 0; // firstChildElement(QString)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // firstChildElement(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_firstChildElement_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_tagName = Shiboken::String::createStaticString("tagName");
            if (PyDict_Contains(kwds, key_tagName)) {
                value = PyDict_GetItem(kwds, key_tagName);
                if (value && pyArgs[0]) {
                    errInfo = key_tagName;
                    Py_INCREF(errInfo);
                    goto Sbk_QDomNodeFunc_firstChildElement_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QDomNodeFunc_firstChildElement_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_tagName);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDomNodeFunc_firstChildElement_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // firstChildElement(QString)const
            QDomElement cppResult = const_cast<const ::QDomNode *>(cppSelf)->firstChildElement(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_firstChildElement_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_hasAttributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.hasAttributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasAttributes()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->hasAttributes();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_hasChildNodes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.hasChildNodes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasChildNodes()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->hasChildNodes();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_insertAfter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.insertAfter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertAfter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::insertAfter(QDomNode,QDomNode)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertAfter(QDomNode,QDomNode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_insertAfter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDomNode cppArg0_local;
        ::QDomNode *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDomNode cppArg1_local;
        ::QDomNode *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // insertAfter(QDomNode,QDomNode)
            QDomNode cppResult = cppSelf->insertAfter(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_insertAfter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_insertBefore(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.insertBefore";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertBefore", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::insertBefore(QDomNode,QDomNode)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertBefore(QDomNode,QDomNode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_insertBefore_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDomNode cppArg0_local;
        ::QDomNode *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDomNode cppArg1_local;
        ::QDomNode *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // insertBefore(QDomNode,QDomNode)
            QDomNode cppResult = cppSelf->insertBefore(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_insertBefore_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_isAttr(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isAttr";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAttr()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isAttr();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isCDATASection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isCDATASection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCDATASection()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isCDATASection();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isCharacterData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isCharacterData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCharacterData()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isCharacterData();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isComment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isComment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isComment()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isComment();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isDocument(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isDocument";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDocument()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isDocument();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isDocumentFragment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isDocumentFragment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDocumentFragment()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isDocumentFragment();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isDocumentType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isDocumentType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDocumentType()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isDocumentType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isElement";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isElement()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isElement();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isEntity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isEntity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEntity()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isEntity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isEntityReference(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isEntityReference";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEntityReference()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isEntityReference();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isNotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isNotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNotation()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isNotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isProcessingInstruction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isProcessingInstruction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isProcessingInstruction()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isProcessingInstruction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_isSupported(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isSupported", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::isSupported(QString,QString)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // isSupported(QString,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_isSupported_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isSupported(QString,QString)const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isSupported(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_isSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_isText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.isText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isText()const
            bool cppResult = const_cast<const ::QDomNode *>(cppSelf)->isText();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_lastChild(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.lastChild";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastChild()const
            QDomNode cppResult = const_cast<const ::QDomNode *>(cppSelf)->lastChild();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_lastChildElement(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.lastChildElement";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomNodeFunc_lastChildElement_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:lastChildElement", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::lastChildElement(QString)const
    if (numArgs == 0) {
        overloadId = 0; // lastChildElement(QString)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // lastChildElement(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_lastChildElement_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_tagName = Shiboken::String::createStaticString("tagName");
            if (PyDict_Contains(kwds, key_tagName)) {
                value = PyDict_GetItem(kwds, key_tagName);
                if (value && pyArgs[0]) {
                    errInfo = key_tagName;
                    Py_INCREF(errInfo);
                    goto Sbk_QDomNodeFunc_lastChildElement_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QDomNodeFunc_lastChildElement_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_tagName);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDomNodeFunc_lastChildElement_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // lastChildElement(QString)const
            QDomElement cppResult = const_cast<const ::QDomNode *>(cppSelf)->lastChildElement(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_lastChildElement_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_lineNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.lineNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineNumber()const
            int cppResult = const_cast<const ::QDomNode *>(cppSelf)->lineNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_localName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.localName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localName()const
            QString cppResult = const_cast<const ::QDomNode *>(cppSelf)->localName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_namedItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.namedItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNode::namedItem(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // namedItem(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_namedItem_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // namedItem(QString)const
            QDomNode cppResult = const_cast<const ::QDomNode *>(cppSelf)->namedItem(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_namedItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_namespaceURI(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.namespaceURI";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namespaceURI()const
            QString cppResult = const_cast<const ::QDomNode *>(cppSelf)->namespaceURI();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_nextSibling(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.nextSibling";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextSibling()const
            QDomNode cppResult = const_cast<const ::QDomNode *>(cppSelf)->nextSibling();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_nextSiblingElement(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.nextSiblingElement";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomNodeFunc_nextSiblingElement_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:nextSiblingElement", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::nextSiblingElement(QString)const
    if (numArgs == 0) {
        overloadId = 0; // nextSiblingElement(QString)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // nextSiblingElement(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_nextSiblingElement_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_taName = Shiboken::String::createStaticString("taName");
            if (PyDict_Contains(kwds, key_taName)) {
                value = PyDict_GetItem(kwds, key_taName);
                if (value && pyArgs[0]) {
                    errInfo = key_taName;
                    Py_INCREF(errInfo);
                    goto Sbk_QDomNodeFunc_nextSiblingElement_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QDomNodeFunc_nextSiblingElement_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_taName);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDomNodeFunc_nextSiblingElement_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // nextSiblingElement(QString)const
            QDomElement cppResult = const_cast<const ::QDomNode *>(cppSelf)->nextSiblingElement(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_nextSiblingElement_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_nodeName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.nodeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nodeName()const
            QString cppResult = const_cast<const ::QDomNode *>(cppSelf)->nodeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_nodeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.nodeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nodeType()const
            QDomNode::NodeType cppResult = const_cast<const ::QDomNode *>(cppSelf)->nodeType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_nodeValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.nodeValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nodeValue()const
            QString cppResult = const_cast<const ::QDomNode *>(cppSelf)->nodeValue();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_normalize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.normalize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // normalize()
            cppSelf->normalize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDomNodeFunc_ownerDocument(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.ownerDocument";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownerDocument()const
            QDomDocument cppResult = const_cast<const ::QDomNode *>(cppSelf)->ownerDocument();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_parentNode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.parentNode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentNode()const
            QDomNode cppResult = const_cast<const ::QDomNode *>(cppSelf)->parentNode();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_prefix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.prefix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // prefix()const
            QString cppResult = const_cast<const ::QDomNode *>(cppSelf)->prefix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_previousSibling(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.previousSibling";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // previousSibling()const
            QDomNode cppResult = const_cast<const ::QDomNode *>(cppSelf)->previousSibling();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_previousSiblingElement(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.previousSiblingElement";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomNodeFunc_previousSiblingElement_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:previousSiblingElement", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::previousSiblingElement(QString)const
    if (numArgs == 0) {
        overloadId = 0; // previousSiblingElement(QString)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // previousSiblingElement(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_previousSiblingElement_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_tagName = Shiboken::String::createStaticString("tagName");
            if (PyDict_Contains(kwds, key_tagName)) {
                value = PyDict_GetItem(kwds, key_tagName);
                if (value && pyArgs[0]) {
                    errInfo = key_tagName;
                    Py_INCREF(errInfo);
                    goto Sbk_QDomNodeFunc_previousSiblingElement_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QDomNodeFunc_previousSiblingElement_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_tagName);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDomNodeFunc_previousSiblingElement_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // previousSiblingElement(QString)const
            QDomElement cppResult = const_cast<const ::QDomNode *>(cppSelf)->previousSiblingElement(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_previousSiblingElement_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_removeChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.removeChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNode::removeChild(QDomNode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArg)))) {
        overloadId = 0; // removeChild(QDomNode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_removeChild_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDomNode cppArg0_local;
        ::QDomNode *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeChild(QDomNode)
            QDomNode cppResult = cppSelf->removeChild(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_removeChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_replaceChild(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.replaceChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replaceChild", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::replaceChild(QDomNode,QDomNode)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // replaceChild(QDomNode,QDomNode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_replaceChild_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDomNode cppArg0_local;
        ::QDomNode *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDomNode cppArg1_local;
        ::QDomNode *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // replaceChild(QDomNode,QDomNode)
            QDomNode cppResult = cppSelf->replaceChild(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc_replaceChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_save(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.save";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDomNodeFunc_save_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDomNodeFunc_save_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:save", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDomNode::save(QTextStream&,int,QDomNode::EncodingPolicy)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // save(QTextStream&,int,QDomNode::EncodingPolicy)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // save(QTextStream&,int,QDomNode::EncodingPolicy)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_save_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__3 = Shiboken::String::createStaticString("arg__3");
            if (PyDict_Contains(kwds, key_arg__3)) {
                value = PyDict_GetItem(kwds, key_arg__3);
                if (value && pyArgs[2]) {
                    errInfo = key_arg__3;
                    Py_INCREF(errInfo);
                    goto Sbk_QDomNodeFunc_save_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QDomNodeFunc_save_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__3);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDomNodeFunc_save_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTextStream *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QDomNode::EncodingPolicy cppArg2 = QDomNode::EncodingFromDocument;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // save(QTextStream&,int,QDomNode::EncodingPolicy)const
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            const_cast<const ::QDomNode *>(cppSelf)->save(*cppArg0, cppArg1, cppArg2);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDomNodeFunc_save_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_setNodeValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.setNodeValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNode::setNodeValue(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setNodeValue(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_setNodeValue_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNodeValue(QString)
            cppSelf->setNodeValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDomNodeFunc_setNodeValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_setPrefix(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.setPrefix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNode::setPrefix(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPrefix(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNodeFunc_setPrefix_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPrefix(QString)
            cppSelf->setPrefix(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDomNodeFunc_setPrefix_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNodeFunc_toAttr(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toAttr";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toAttr()const
            QDomAttr cppResult = const_cast<const ::QDomNode *>(cppSelf)->toAttr();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMATTR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toCDATASection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toCDATASection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toCDATASection()const
            QDomCDATASection cppResult = const_cast<const ::QDomNode *>(cppSelf)->toCDATASection();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMCDATASECTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toCharacterData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toCharacterData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toCharacterData()const
            QDomCharacterData cppResult = const_cast<const ::QDomNode *>(cppSelf)->toCharacterData();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMCHARACTERDATA_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toComment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toComment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toComment()const
            QDomComment cppResult = const_cast<const ::QDomNode *>(cppSelf)->toComment();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMCOMMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toDocument(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toDocument";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toDocument()const
            QDomDocument cppResult = const_cast<const ::QDomNode *>(cppSelf)->toDocument();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toDocumentFragment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toDocumentFragment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toDocumentFragment()const
            QDomDocumentFragment cppResult = const_cast<const ::QDomNode *>(cppSelf)->toDocumentFragment();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTFRAGMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toDocumentType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toDocumentType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toDocumentType()const
            QDomDocumentType cppResult = const_cast<const ::QDomNode *>(cppSelf)->toDocumentType();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toElement";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toElement()const
            QDomElement cppResult = const_cast<const ::QDomNode *>(cppSelf)->toElement();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMELEMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toEntity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toEntity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toEntity()const
            QDomEntity cppResult = const_cast<const ::QDomNode *>(cppSelf)->toEntity();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMENTITY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toEntityReference(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toEntityReference";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toEntityReference()const
            QDomEntityReference cppResult = const_cast<const ::QDomNode *>(cppSelf)->toEntityReference();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toNotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toNotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toNotation()const
            QDomNotation cppResult = const_cast<const ::QDomNode *>(cppSelf)->toNotation();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNOTATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toProcessingInstruction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toProcessingInstruction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toProcessingInstruction()const
            QDomProcessingInstruction cppResult = const_cast<const ::QDomNode *>(cppSelf)->toProcessingInstruction();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNodeFunc_toText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.toText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toText()const
            QDomText cppResult = const_cast<const ::QDomNode *>(cppSelf)->toText();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMTEXT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNode___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDomNode_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDomNode_methods[] = {
    {"appendChild", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_appendChild), METH_O},
    {"attributes", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_attributes), METH_NOARGS},
    {"childNodes", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_childNodes), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_clear), METH_NOARGS},
    {"cloneNode", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_cloneNode), METH_VARARGS|METH_KEYWORDS},
    {"columnNumber", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_columnNumber), METH_NOARGS},
    {"firstChild", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_firstChild), METH_NOARGS},
    {"firstChildElement", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_firstChildElement), METH_VARARGS|METH_KEYWORDS},
    {"hasAttributes", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_hasAttributes), METH_NOARGS},
    {"hasChildNodes", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_hasChildNodes), METH_NOARGS},
    {"insertAfter", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_insertAfter), METH_VARARGS},
    {"insertBefore", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_insertBefore), METH_VARARGS},
    {"isAttr", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isAttr), METH_NOARGS},
    {"isCDATASection", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isCDATASection), METH_NOARGS},
    {"isCharacterData", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isCharacterData), METH_NOARGS},
    {"isComment", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isComment), METH_NOARGS},
    {"isDocument", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isDocument), METH_NOARGS},
    {"isDocumentFragment", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isDocumentFragment), METH_NOARGS},
    {"isDocumentType", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isDocumentType), METH_NOARGS},
    {"isElement", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isElement), METH_NOARGS},
    {"isEntity", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isEntity), METH_NOARGS},
    {"isEntityReference", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isEntityReference), METH_NOARGS},
    {"isNotation", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isNotation), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isNull), METH_NOARGS},
    {"isProcessingInstruction", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isProcessingInstruction), METH_NOARGS},
    {"isSupported", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isSupported), METH_VARARGS},
    {"isText", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_isText), METH_NOARGS},
    {"lastChild", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_lastChild), METH_NOARGS},
    {"lastChildElement", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_lastChildElement), METH_VARARGS|METH_KEYWORDS},
    {"lineNumber", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_lineNumber), METH_NOARGS},
    {"localName", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_localName), METH_NOARGS},
    {"namedItem", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_namedItem), METH_O},
    {"namespaceURI", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_namespaceURI), METH_NOARGS},
    {"nextSibling", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_nextSibling), METH_NOARGS},
    {"nextSiblingElement", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_nextSiblingElement), METH_VARARGS|METH_KEYWORDS},
    {"nodeName", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_nodeName), METH_NOARGS},
    {"nodeType", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_nodeType), METH_NOARGS},
    {"nodeValue", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_nodeValue), METH_NOARGS},
    {"normalize", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_normalize), METH_NOARGS},
    {"ownerDocument", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_ownerDocument), METH_NOARGS},
    {"parentNode", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_parentNode), METH_NOARGS},
    {"prefix", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_prefix), METH_NOARGS},
    {"previousSibling", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_previousSibling), METH_NOARGS},
    {"previousSiblingElement", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_previousSiblingElement), METH_VARARGS|METH_KEYWORDS},
    {"removeChild", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_removeChild), METH_O},
    {"replaceChild", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_replaceChild), METH_VARARGS},
    {"save", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_save), METH_VARARGS|METH_KEYWORDS},
    {"setNodeValue", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_setNodeValue), METH_O},
    {"setPrefix", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_setPrefix), METH_O},
    {"toAttr", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toAttr), METH_NOARGS},
    {"toCDATASection", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toCDATASection), METH_NOARGS},
    {"toCharacterData", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toCharacterData), METH_NOARGS},
    {"toComment", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toComment), METH_NOARGS},
    {"toDocument", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toDocument), METH_NOARGS},
    {"toDocumentFragment", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toDocumentFragment), METH_NOARGS},
    {"toDocumentType", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toDocumentType), METH_NOARGS},
    {"toElement", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toElement), METH_NOARGS},
    {"toEntity", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toEntity), METH_NOARGS},
    {"toEntityReference", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toEntityReference), METH_NOARGS},
    {"toNotation", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toNotation), METH_NOARGS},
    {"toProcessingInstruction", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toProcessingInstruction), METH_NOARGS},
    {"toText", reinterpret_cast<PyCFunction>(Sbk_QDomNodeFunc_toText), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDomNode___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QDomNode___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QDomNodeFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNode.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QDomNode::operator<<(QTextStream&,QDomNode)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QTextStream&,QDomNode)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QDomNodeFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QTextStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QTextStream&,QDomNode) [reverse operator]
                QTextStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTEXTSTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNodeFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QDomNode_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArg)))) {
                // operator!=(const QDomNode & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDomNode cppArg0_local;
                ::QDomNode *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArg)))) {
                // operator==(const QDomNode & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDomNode cppArg0_local;
                ::QDomNode *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QDomNode_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QDomNode_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QDomNode_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDomNode_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDomNode_Type = nullptr;
static SbkObjectType *Sbk_QDomNode_TypeF(void)
{
    return _Sbk_QDomNode_Type;
}

static PyType_Slot Sbk_QDomNode_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDomNode_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDomNode_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QDomNode_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDomNode_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDomNode_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QDomNode___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QDomNode___nb_bool},
#endif
    {Py_nb_lshift, (void *)Sbk_QDomNodeFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QDomNode_spec = {
    "2:PySide2.QtXml.QDomNode",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDomNode_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QDomNode_NodeType_PythonToCpp_QDomNode_NodeType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomNode::NodeType *>(cppOut) =
        static_cast<::QDomNode::NodeType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDomNode_NodeType_PythonToCpp_QDomNode_NodeType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX]))
        return QDomNode_NodeType_PythonToCpp_QDomNode_NodeType;
    return {};
}
static PyObject *QDomNode_NodeType_CppToPython_QDomNode_NodeType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDomNode::NodeType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX], castCppIn);

}

static void QDomNode_EncodingPolicy_PythonToCpp_QDomNode_EncodingPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomNode::EncodingPolicy *>(cppOut) =
        static_cast<::QDomNode::EncodingPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDomNode_EncodingPolicy_PythonToCpp_QDomNode_EncodingPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX]))
        return QDomNode_EncodingPolicy_PythonToCpp_QDomNode_EncodingPolicy;
    return {};
}
static PyObject *QDomNode_EncodingPolicy_CppToPython_QDomNode_EncodingPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDomNode::EncodingPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDomNode_PythonToCpp_QDomNode_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDomNode_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDomNode_PythonToCpp_QDomNode_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomNode_TypeF())))
        return QDomNode_PythonToCpp_QDomNode_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDomNode_PTR_CppToPython_QDomNode(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDomNode *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDomNode_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDomNode_COPY_CppToPython_QDomNode(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDomNode_TypeF(), new ::QDomNode(*reinterpret_cast<const ::QDomNode *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDomNode_PythonToCpp_QDomNode_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomNode *>(cppOut) = *reinterpret_cast< ::QDomNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDomNode_PythonToCpp_QDomNode_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomNode_TypeF())))
        return QDomNode_PythonToCpp_QDomNode_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDomNode_SignatureStrings[] = {
    "1:PySide2.QtXml.QDomNode(self)",
    "0:PySide2.QtXml.QDomNode(self,arg__1:PySide2.QtXml.QDomNode)",
    "PySide2.QtXml.QDomNode.appendChild(self,newChild:PySide2.QtXml.QDomNode)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.attributes(self)->PySide2.QtXml.QDomNamedNodeMap",
    "PySide2.QtXml.QDomNode.childNodes(self)->PySide2.QtXml.QDomNodeList",
    "PySide2.QtXml.QDomNode.clear(self)",
    "PySide2.QtXml.QDomNode.cloneNode(self,deep:bool=true)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.columnNumber(self)->int",
    "PySide2.QtXml.QDomNode.firstChild(self)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.firstChildElement(self,tagName:QString=QString())->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomNode.hasAttributes(self)->bool",
    "PySide2.QtXml.QDomNode.hasChildNodes(self)->bool",
    "PySide2.QtXml.QDomNode.insertAfter(self,newChild:PySide2.QtXml.QDomNode,refChild:PySide2.QtXml.QDomNode)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.insertBefore(self,newChild:PySide2.QtXml.QDomNode,refChild:PySide2.QtXml.QDomNode)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.isAttr(self)->bool",
    "PySide2.QtXml.QDomNode.isCDATASection(self)->bool",
    "PySide2.QtXml.QDomNode.isCharacterData(self)->bool",
    "PySide2.QtXml.QDomNode.isComment(self)->bool",
    "PySide2.QtXml.QDomNode.isDocument(self)->bool",
    "PySide2.QtXml.QDomNode.isDocumentFragment(self)->bool",
    "PySide2.QtXml.QDomNode.isDocumentType(self)->bool",
    "PySide2.QtXml.QDomNode.isElement(self)->bool",
    "PySide2.QtXml.QDomNode.isEntity(self)->bool",
    "PySide2.QtXml.QDomNode.isEntityReference(self)->bool",
    "PySide2.QtXml.QDomNode.isNotation(self)->bool",
    "PySide2.QtXml.QDomNode.isNull(self)->bool",
    "PySide2.QtXml.QDomNode.isProcessingInstruction(self)->bool",
    "PySide2.QtXml.QDomNode.isSupported(self,feature:QString,version:QString)->bool",
    "PySide2.QtXml.QDomNode.isText(self)->bool",
    "PySide2.QtXml.QDomNode.lastChild(self)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.lastChildElement(self,tagName:QString=QString())->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomNode.lineNumber(self)->int",
    "PySide2.QtXml.QDomNode.localName(self)->QString",
    "PySide2.QtXml.QDomNode.namedItem(self,name:QString)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.namespaceURI(self)->QString",
    "PySide2.QtXml.QDomNode.nextSibling(self)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.nextSiblingElement(self,taName:QString=QString())->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomNode.nodeName(self)->QString",
    "PySide2.QtXml.QDomNode.nodeType(self)->PySide2.QtXml.QDomNode.NodeType",
    "PySide2.QtXml.QDomNode.nodeValue(self)->QString",
    "PySide2.QtXml.QDomNode.normalize(self)",
    "PySide2.QtXml.QDomNode.ownerDocument(self)->PySide2.QtXml.QDomDocument",
    "PySide2.QtXml.QDomNode.parentNode(self)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.prefix(self)->QString",
    "PySide2.QtXml.QDomNode.previousSibling(self)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.previousSiblingElement(self,tagName:QString=QString())->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomNode.removeChild(self,oldChild:PySide2.QtXml.QDomNode)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.replaceChild(self,newChild:PySide2.QtXml.QDomNode,oldChild:PySide2.QtXml.QDomNode)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNode.save(self,arg__1:PySide2.QtCore.QTextStream,arg__2:int,arg__3:PySide2.QtXml.QDomNode.EncodingPolicy=QDomNode.EncodingFromDocument)",
    "PySide2.QtXml.QDomNode.setNodeValue(self,arg__1:QString)",
    "PySide2.QtXml.QDomNode.setPrefix(self,pre:QString)",
    "PySide2.QtXml.QDomNode.toAttr(self)->PySide2.QtXml.QDomAttr",
    "PySide2.QtXml.QDomNode.toCDATASection(self)->PySide2.QtXml.QDomCDATASection",
    "PySide2.QtXml.QDomNode.toCharacterData(self)->PySide2.QtXml.QDomCharacterData",
    "PySide2.QtXml.QDomNode.toComment(self)->PySide2.QtXml.QDomComment",
    "PySide2.QtXml.QDomNode.toDocument(self)->PySide2.QtXml.QDomDocument",
    "PySide2.QtXml.QDomNode.toDocumentFragment(self)->PySide2.QtXml.QDomDocumentFragment",
    "PySide2.QtXml.QDomNode.toDocumentType(self)->PySide2.QtXml.QDomDocumentType",
    "PySide2.QtXml.QDomNode.toElement(self)->PySide2.QtXml.QDomElement",
    "PySide2.QtXml.QDomNode.toEntity(self)->PySide2.QtXml.QDomEntity",
    "PySide2.QtXml.QDomNode.toEntityReference(self)->PySide2.QtXml.QDomEntityReference",
    "PySide2.QtXml.QDomNode.toNotation(self)->PySide2.QtXml.QDomNotation",
    "PySide2.QtXml.QDomNode.toProcessingInstruction(self)->PySide2.QtXml.QDomProcessingInstruction",
    "PySide2.QtXml.QDomNode.toText(self)->PySide2.QtXml.QDomText",
    "PySide2.QtXml.QDomNode.__copy__()",
    "PySide2.QtXml.QDomNode.__lshift__(self,arg__1:PySide2.QtCore.QTextStream)->PySide2.QtCore.QTextStream",
    nullptr}; // Sentinel

void init_QDomNode(PyObject *module)
{
    _Sbk_QDomNode_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDomNode",
        "QDomNode",
        &Sbk_QDomNode_spec,
        &Shiboken::callCppDestructor< ::QDomNode >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDomNode_Type);
    InitSignatureStrings(pyType, QDomNode_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDomNode_Type), Sbk_QDomNode_PropertyStrings);
    SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDomNode_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDomNode_TypeF(),
        QDomNode_PythonToCpp_QDomNode_PTR,
        is_QDomNode_PythonToCpp_QDomNode_PTR_Convertible,
        QDomNode_PTR_CppToPython_QDomNode,
        QDomNode_COPY_CppToPython_QDomNode);

    Shiboken::Conversions::registerConverterName(converter, "QDomNode");
    Shiboken::Conversions::registerConverterName(converter, "QDomNode*");
    Shiboken::Conversions::registerConverterName(converter, "QDomNode&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDomNode).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDomNode_PythonToCpp_QDomNode_COPY,
        is_QDomNode_PythonToCpp_QDomNode_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'NodeType'.
    SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDomNode_TypeF(),
        "NodeType",
        "2:PySide2.QtXml.QDomNode.NodeType",
        "QDomNode::NodeType");
    if (!SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "ElementNode", (long) QDomNode::NodeType::ElementNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "AttributeNode", (long) QDomNode::NodeType::AttributeNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "TextNode", (long) QDomNode::NodeType::TextNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "CDATASectionNode", (long) QDomNode::NodeType::CDATASectionNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "EntityReferenceNode", (long) QDomNode::NodeType::EntityReferenceNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "EntityNode", (long) QDomNode::NodeType::EntityNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "ProcessingInstructionNode", (long) QDomNode::NodeType::ProcessingInstructionNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "CommentNode", (long) QDomNode::NodeType::CommentNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "DocumentNode", (long) QDomNode::NodeType::DocumentNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "DocumentTypeNode", (long) QDomNode::NodeType::DocumentTypeNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "DocumentFragmentNode", (long) QDomNode::NodeType::DocumentFragmentNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "NotationNode", (long) QDomNode::NodeType::NotationNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "BaseNode", (long) QDomNode::NodeType::BaseNode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
        Sbk_QDomNode_TypeF(), "CharacterDataNode", (long) QDomNode::NodeType::CharacterDataNode))
        return;
    // Register converter for enum 'QDomNode::NodeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX],
            QDomNode_NodeType_CppToPython_QDomNode_NodeType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDomNode_NodeType_PythonToCpp_QDomNode_NodeType,
            is_QDomNode_NodeType_PythonToCpp_QDomNode_NodeType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDomNode::NodeType");
        Shiboken::Conversions::registerConverterName(converter, "NodeType");
    }
    // End of 'NodeType' enum.

    // Initialization of enum 'EncodingPolicy'.
    SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDomNode_TypeF(),
        "EncodingPolicy",
        "2:PySide2.QtXml.QDomNode.EncodingPolicy",
        "QDomNode::EncodingPolicy");
    if (!SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX],
        Sbk_QDomNode_TypeF(), "EncodingFromDocument", (long) QDomNode::EncodingPolicy::EncodingFromDocument))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX],
        Sbk_QDomNode_TypeF(), "EncodingFromTextStream", (long) QDomNode::EncodingPolicy::EncodingFromTextStream))
        return;
    // Register converter for enum 'QDomNode::EncodingPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX],
            QDomNode_EncodingPolicy_CppToPython_QDomNode_EncodingPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDomNode_EncodingPolicy_PythonToCpp_QDomNode_EncodingPolicy,
            is_QDomNode_EncodingPolicy_PythonToCpp_QDomNode_EncodingPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDomNode::EncodingPolicy");
        Shiboken::Conversions::registerConverterName(converter, "EncodingPolicy");
    }
    // End of 'EncodingPolicy' enum.

    qRegisterMetaType< ::QDomNode >("QDomNode");
    qRegisterMetaType< ::QDomNode::NodeType >("QDomNode::NodeType");
    qRegisterMetaType< ::QDomNode::EncodingPolicy >("QDomNode::EncodingPolicy");
}
