/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxml_python.h"

// main header
#include "qdomnamednodemap_wrapper.h"

// inner classes

// Extra includes
#include <QtXml/qdom.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDomNamedNodeMap_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDomNamedNodeMap >()))
        return -1;

    ::QDomNamedNodeMap *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDomNamedNodeMap", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDomNamedNodeMap::QDomNamedNodeMap()
    // 1: QDomNamedNodeMap::QDomNamedNodeMap(QDomNamedNodeMap)
    if (numArgs == 0) {
        overloadId = 0; // QDomNamedNodeMap()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDomNamedNodeMap(QDomNamedNodeMap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMap_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDomNamedNodeMap()
        {

            if (!PyErr_Occurred()) {
                // QDomNamedNodeMap()
                cptr = new ::QDomNamedNodeMap();
            }
            break;
        }
        case 1: // QDomNamedNodeMap(const QDomNamedNodeMap & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDomNamedNodeMap cppArg0_local;
            ::QDomNamedNodeMap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDomNamedNodeMap(QDomNamedNodeMap)
                cptr = new ::QDomNamedNodeMap(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDomNamedNodeMap >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDomNamedNodeMap_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDomNamedNodeMap_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDomNamedNodeMapFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNamedNodeMap::contains(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // contains(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMapFunc_contains_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // contains(QString)const
            bool cppResult = const_cast<const ::QDomNamedNodeMap *>(cppSelf)->contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNamedNodeMapFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNamedNodeMapFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QDomNamedNodeMap *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNamedNodeMapFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QDomNamedNodeMap *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNamedNodeMapFunc_item(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.item";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNamedNodeMap::item(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // item(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMapFunc_item_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // item(int)const
            QDomNode cppResult = const_cast<const ::QDomNamedNodeMap *>(cppSelf)->item(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNamedNodeMapFunc_item_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNamedNodeMapFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            int cppResult = const_cast<const ::QDomNamedNodeMap *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNamedNodeMapFunc_namedItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.namedItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNamedNodeMap::namedItem(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // namedItem(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMapFunc_namedItem_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // namedItem(QString)const
            QDomNode cppResult = const_cast<const ::QDomNamedNodeMap *>(cppSelf)->namedItem(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNamedNodeMapFunc_namedItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNamedNodeMapFunc_namedItemNS(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.namedItemNS";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "namedItemNS", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomNamedNodeMap::namedItemNS(QString,QString)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // namedItemNS(QString,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMapFunc_namedItemNS_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // namedItemNS(QString,QString)const
            QDomNode cppResult = const_cast<const ::QDomNamedNodeMap *>(cppSelf)->namedItemNS(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNamedNodeMapFunc_namedItemNS_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNamedNodeMapFunc_removeNamedItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.removeNamedItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNamedNodeMap::removeNamedItem(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeNamedItem(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMapFunc_removeNamedItem_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeNamedItem(QString)
            QDomNode cppResult = cppSelf->removeNamedItem(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNamedNodeMapFunc_removeNamedItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNamedNodeMapFunc_removeNamedItemNS(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.removeNamedItemNS";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeNamedItemNS", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDomNamedNodeMap::removeNamedItemNS(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // removeNamedItemNS(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMapFunc_removeNamedItemNS_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // removeNamedItemNS(QString,QString)
            QDomNode cppResult = cppSelf->removeNamedItemNS(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNamedNodeMapFunc_removeNamedItemNS_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNamedNodeMapFunc_setNamedItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.setNamedItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNamedNodeMap::setNamedItem(QDomNode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArg)))) {
        overloadId = 0; // setNamedItem(QDomNode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMapFunc_setNamedItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDomNode cppArg0_local;
        ::QDomNode *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setNamedItem(QDomNode)
            QDomNode cppResult = cppSelf->setNamedItem(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNamedNodeMapFunc_setNamedItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNamedNodeMapFunc_setNamedItemNS(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.setNamedItemNS";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDomNamedNodeMap::setNamedItemNS(QDomNode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), (pyArg)))) {
        overloadId = 0; // setNamedItemNS(QDomNode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomNamedNodeMapFunc_setNamedItemNS_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDomNode cppArg0_local;
        ::QDomNode *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setNamedItemNS(QDomNode)
            QDomNode cppResult = cppSelf->setNamedItemNS(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDomNamedNodeMapFunc_setNamedItemNS_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDomNamedNodeMapFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomNamedNodeMap.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QDomNamedNodeMap *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomNamedNodeMap___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDomNamedNodeMap_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDomNamedNodeMap_methods[] = {
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_contains), METH_O},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_count), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_isEmpty), METH_NOARGS},
    {"item", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_item), METH_O},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_length), METH_NOARGS},
    {"namedItem", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_namedItem), METH_O},
    {"namedItemNS", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_namedItemNS), METH_VARARGS},
    {"removeNamedItem", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_removeNamedItem), METH_O},
    {"removeNamedItemNS", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_removeNamedItemNS), METH_VARARGS},
    {"setNamedItem", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_setNamedItem), METH_O},
    {"setNamedItemNS", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_setNamedItemNS), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMapFunc_size), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDomNamedNodeMap___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QDomNamedNodeMap_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]), (pyArg)))) {
                // operator!=(const QDomNamedNodeMap & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDomNamedNodeMap cppArg0_local;
                ::QDomNamedNodeMap *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]), (pyArg)))) {
                // operator==(const QDomNamedNodeMap & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDomNamedNodeMap cppArg0_local;
                ::QDomNamedNodeMap *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QDomNamedNodeMap_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QDomNamedNodeMap_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QDomNamedNodeMap_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDomNamedNodeMap_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDomNamedNodeMap_Type = nullptr;
static SbkObjectType *Sbk_QDomNamedNodeMap_TypeF(void)
{
    return _Sbk_QDomNamedNodeMap_Type;
}

static PyType_Slot Sbk_QDomNamedNodeMap_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDomNamedNodeMap_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDomNamedNodeMap_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QDomNamedNodeMap_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDomNamedNodeMap_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDomNamedNodeMap_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QDomNamedNodeMap_spec = {
    "2:PySide2.QtXml.QDomNamedNodeMap",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDomNamedNodeMap_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDomNamedNodeMap_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomNamedNodeMap_TypeF())))
        return QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDomNamedNodeMap_PTR_CppToPython_QDomNamedNodeMap(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDomNamedNodeMap *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDomNamedNodeMap_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDomNamedNodeMap_COPY_CppToPython_QDomNamedNodeMap(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDomNamedNodeMap_TypeF(), new ::QDomNamedNodeMap(*reinterpret_cast<const ::QDomNamedNodeMap *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomNamedNodeMap *>(cppOut) = *reinterpret_cast< ::QDomNamedNodeMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomNamedNodeMap_TypeF())))
        return QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDomNamedNodeMap_SignatureStrings[] = {
    "1:PySide2.QtXml.QDomNamedNodeMap(self)",
    "0:PySide2.QtXml.QDomNamedNodeMap(self,arg__1:PySide2.QtXml.QDomNamedNodeMap)",
    "PySide2.QtXml.QDomNamedNodeMap.contains(self,name:QString)->bool",
    "PySide2.QtXml.QDomNamedNodeMap.count(self)->int",
    "PySide2.QtXml.QDomNamedNodeMap.isEmpty(self)->bool",
    "PySide2.QtXml.QDomNamedNodeMap.item(self,index:int)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNamedNodeMap.length(self)->int",
    "PySide2.QtXml.QDomNamedNodeMap.namedItem(self,name:QString)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNamedNodeMap.namedItemNS(self,nsURI:QString,localName:QString)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNamedNodeMap.removeNamedItem(self,name:QString)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNamedNodeMap.removeNamedItemNS(self,nsURI:QString,localName:QString)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNamedNodeMap.setNamedItem(self,newNode:PySide2.QtXml.QDomNode)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNamedNodeMap.setNamedItemNS(self,newNode:PySide2.QtXml.QDomNode)->PySide2.QtXml.QDomNode",
    "PySide2.QtXml.QDomNamedNodeMap.size(self)->int",
    "PySide2.QtXml.QDomNamedNodeMap.__copy__()",
    nullptr}; // Sentinel

void init_QDomNamedNodeMap(PyObject *module)
{
    _Sbk_QDomNamedNodeMap_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDomNamedNodeMap",
        "QDomNamedNodeMap",
        &Sbk_QDomNamedNodeMap_spec,
        &Shiboken::callCppDestructor< ::QDomNamedNodeMap >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDomNamedNodeMap_Type);
    InitSignatureStrings(pyType, QDomNamedNodeMap_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDomNamedNodeMap_Type), Sbk_QDomNamedNodeMap_PropertyStrings);
    SbkPySide2_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDomNamedNodeMap_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDomNamedNodeMap_TypeF(),
        QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_PTR,
        is_QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_PTR_Convertible,
        QDomNamedNodeMap_PTR_CppToPython_QDomNamedNodeMap,
        QDomNamedNodeMap_COPY_CppToPython_QDomNamedNodeMap);

    Shiboken::Conversions::registerConverterName(converter, "QDomNamedNodeMap");
    Shiboken::Conversions::registerConverterName(converter, "QDomNamedNodeMap*");
    Shiboken::Conversions::registerConverterName(converter, "QDomNamedNodeMap&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDomNamedNodeMap).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_COPY,
        is_QDomNamedNodeMap_PythonToCpp_QDomNamedNodeMap_COPY_Convertible);

    qRegisterMetaType< ::QDomNamedNodeMap >("QDomNamedNodeMap");
}
