/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtx11extras_python.h"

// main header
#include "qx11info_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QX11InfoFunc_appDpiX(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.appDpiX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QX11InfoFunc_appDpiX_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:appDpiX", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QX11Info::appDpiX(int)
    if (numArgs == 0) {
        overloadId = 0; // appDpiX(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // appDpiX(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QX11InfoFunc_appDpiX_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_screen = Shiboken::String::createStaticString("screen");
            if (PyDict_Contains(kwds, key_screen)) {
                value = PyDict_GetItem(kwds, key_screen);
                if (value && pyArgs[0]) {
                    errInfo = key_screen;
                    Py_INCREF(errInfo);
                    goto Sbk_QX11InfoFunc_appDpiX_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QX11InfoFunc_appDpiX_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_screen);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QX11InfoFunc_appDpiX_TypeError;
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // appDpiX(int)
            int cppResult = ::QX11Info::appDpiX(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QX11InfoFunc_appDpiX_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QX11InfoFunc_appDpiY(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.appDpiY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QX11InfoFunc_appDpiY_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:appDpiY", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QX11Info::appDpiY(int)
    if (numArgs == 0) {
        overloadId = 0; // appDpiY(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // appDpiY(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QX11InfoFunc_appDpiY_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_screen = Shiboken::String::createStaticString("screen");
            if (PyDict_Contains(kwds, key_screen)) {
                value = PyDict_GetItem(kwds, key_screen);
                if (value && pyArgs[0]) {
                    errInfo = key_screen;
                    Py_INCREF(errInfo);
                    goto Sbk_QX11InfoFunc_appDpiY_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QX11InfoFunc_appDpiY_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_screen);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QX11InfoFunc_appDpiY_TypeError;
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // appDpiY(int)
            int cppResult = ::QX11Info::appDpiY(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QX11InfoFunc_appDpiY_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QX11InfoFunc_appRootWindow(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.appRootWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QX11InfoFunc_appRootWindow_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:appRootWindow", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QX11Info::appRootWindow(int)
    if (numArgs == 0) {
        overloadId = 0; // appRootWindow(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // appRootWindow(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QX11InfoFunc_appRootWindow_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_screen = Shiboken::String::createStaticString("screen");
            if (PyDict_Contains(kwds, key_screen)) {
                value = PyDict_GetItem(kwds, key_screen);
                if (value && pyArgs[0]) {
                    errInfo = key_screen;
                    Py_INCREF(errInfo);
                    goto Sbk_QX11InfoFunc_appRootWindow_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QX11InfoFunc_appRootWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_screen);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QX11InfoFunc_appRootWindow_TypeError;
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // appRootWindow(int)
            unsigned long cppResult = ::QX11Info::appRootWindow(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QX11InfoFunc_appRootWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QX11InfoFunc_appScreen(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.appScreen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // appScreen()
            int cppResult = ::QX11Info::appScreen();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QX11InfoFunc_appTime(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.appTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // appTime()
            unsigned long cppResult = ::QX11Info::appTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QX11InfoFunc_appUserTime(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.appUserTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // appUserTime()
            unsigned long cppResult = ::QX11Info::appUserTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QX11InfoFunc_generatePeekerId(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.generatePeekerId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // generatePeekerId()
            qint32 cppResult = ::QX11Info::generatePeekerId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QX11InfoFunc_getTimestamp(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.getTimestamp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getTimestamp()
            unsigned long cppResult = ::QX11Info::getTimestamp();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QX11InfoFunc_isCompositingManagerRunning(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.isCompositingManagerRunning";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QX11InfoFunc_isCompositingManagerRunning_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:isCompositingManagerRunning", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QX11Info::isCompositingManagerRunning(int)
    if (numArgs == 0) {
        overloadId = 0; // isCompositingManagerRunning(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // isCompositingManagerRunning(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QX11InfoFunc_isCompositingManagerRunning_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_screen = Shiboken::String::createStaticString("screen");
            if (PyDict_Contains(kwds, key_screen)) {
                value = PyDict_GetItem(kwds, key_screen);
                if (value && pyArgs[0]) {
                    errInfo = key_screen;
                    Py_INCREF(errInfo);
                    goto Sbk_QX11InfoFunc_isCompositingManagerRunning_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QX11InfoFunc_isCompositingManagerRunning_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_screen);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QX11InfoFunc_isCompositingManagerRunning_TypeError;
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // isCompositingManagerRunning(int)
            bool cppResult = ::QX11Info::isCompositingManagerRunning(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QX11InfoFunc_isCompositingManagerRunning_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QX11InfoFunc_isPlatformX11(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.isPlatformX11";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPlatformX11()
            bool cppResult = ::QX11Info::isPlatformX11();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QX11InfoFunc_nextStartupId(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.nextStartupId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextStartupId()
            QByteArray cppResult = ::QX11Info::nextStartupId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QX11InfoFunc_removePeekerId(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.removePeekerId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QX11Info::removePeekerId(qint32)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), (pyArg)))) {
        overloadId = 0; // removePeekerId(qint32)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QX11InfoFunc_removePeekerId_TypeError;

    // Call function/method
    {
        qint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removePeekerId(qint32)
            bool cppResult = ::QX11Info::removePeekerId(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QX11InfoFunc_removePeekerId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QX11InfoFunc_setAppTime(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.setAppTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QX11Info::setAppTime(ulong)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
        overloadId = 0; // setAppTime(ulong)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QX11InfoFunc_setAppTime_TypeError;

    // Call function/method
    {
        unsigned long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAppTime(ulong)
            ::QX11Info::setAppTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QX11InfoFunc_setAppTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QX11InfoFunc_setAppUserTime(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.setAppUserTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QX11Info::setAppUserTime(ulong)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArg)))) {
        overloadId = 0; // setAppUserTime(ulong)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QX11InfoFunc_setAppUserTime_TypeError;

    // Call function/method
    {
        unsigned long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAppUserTime(ulong)
            ::QX11Info::setAppUserTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QX11InfoFunc_setAppUserTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QX11InfoFunc_setNextStartupId(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtX11Extras.QX11Info.setNextStartupId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QX11Info::setNextStartupId(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setNextStartupId(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QX11InfoFunc_setNextStartupId_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setNextStartupId(QByteArray)
            ::QX11Info::setNextStartupId(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QX11InfoFunc_setNextStartupId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QX11Info_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QX11Info_methods[] = {
    {"appDpiX", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_appDpiX), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"appDpiY", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_appDpiY), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"appRootWindow", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_appRootWindow), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"appScreen", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_appScreen), METH_NOARGS|METH_STATIC},
    {"appTime", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_appTime), METH_NOARGS|METH_STATIC},
    {"appUserTime", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_appUserTime), METH_NOARGS|METH_STATIC},
    {"generatePeekerId", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_generatePeekerId), METH_NOARGS|METH_STATIC},
    {"getTimestamp", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_getTimestamp), METH_NOARGS|METH_STATIC},
    {"isCompositingManagerRunning", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_isCompositingManagerRunning), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isPlatformX11", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_isPlatformX11), METH_NOARGS|METH_STATIC},
    {"nextStartupId", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_nextStartupId), METH_NOARGS|METH_STATIC},
    {"removePeekerId", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_removePeekerId), METH_O|METH_STATIC},
    {"setAppTime", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_setAppTime), METH_O|METH_STATIC},
    {"setAppUserTime", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_setAppUserTime), METH_O|METH_STATIC},
    {"setNextStartupId", reinterpret_cast<PyCFunction>(Sbk_QX11InfoFunc_setNextStartupId), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QX11Info_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QX11Info_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QX11Info_Type = nullptr;
static SbkObjectType *Sbk_QX11Info_TypeF(void)
{
    return _Sbk_QX11Info_Type;
}

static PyType_Slot Sbk_QX11Info_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QX11Info_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QX11Info_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QX11Info_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QX11Info_spec = {
    "2:PySide2.QtX11Extras.QX11Info",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QX11Info_slots
};

} //extern "C"

PyObject *SbkPySide2_QtX11Extras_QX11Info_PeekOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QX11Info::PeekOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QX11Info::PeekOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QX11Info::PeekOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QX11Info::PeekOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QX11Info::PeekOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtX11Extras_QX11Info_PeekOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QX11Info::PeekOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QX11Info::PeekOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QX11Info::PeekOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QX11Info::PeekOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QX11Info::PeekOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtX11Extras_QX11Info_PeekOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QX11Info::PeekOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QX11Info::PeekOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QX11Info::PeekOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QX11Info::PeekOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QX11Info::PeekOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtX11Extras_QX11Info_PeekOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QX11Info::PeekOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX])->converter, self, &cppSelf);
    ::QX11Info::PeekOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtX11Extras_QX11Info_PeekOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtX11Extras_QX11Info_PeekOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtX11Extras_QX11Info_PeekOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtX11Extras_QX11Info_PeekOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QX11Info_PeekOption_PythonToCpp_QX11Info_PeekOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QX11Info::PeekOption *>(cppOut) =
        static_cast<::QX11Info::PeekOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QX11Info_PeekOption_PythonToCpp_QX11Info_PeekOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX]))
        return QX11Info_PeekOption_PythonToCpp_QX11Info_PeekOption;
    return {};
}
static PyObject *QX11Info_PeekOption_CppToPython_QX11Info_PeekOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QX11Info::PeekOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX], castCppIn);

}

static void QFlags_QX11Info_PeekOption__PythonToCpp_QFlags_QX11Info_PeekOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QX11Info::PeekOption> *>(cppOut) =
        ::QFlags<QX11Info::PeekOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QX11Info_PeekOption__PythonToCpp_QFlags_QX11Info_PeekOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX]))
        return QFlags_QX11Info_PeekOption__PythonToCpp_QFlags_QX11Info_PeekOption_;
    return {};
}
static PyObject *QFlags_QX11Info_PeekOption__CppToPython_QFlags_QX11Info_PeekOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QX11Info::PeekOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX]));

}

static void QX11Info_PeekOption_PythonToCpp_QFlags_QX11Info_PeekOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QX11Info::PeekOption> *>(cppOut) =
        ::QFlags<QX11Info::PeekOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QX11Info_PeekOption_PythonToCpp_QFlags_QX11Info_PeekOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX]))
        return QX11Info_PeekOption_PythonToCpp_QFlags_QX11Info_PeekOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QX11Info_PeekOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QX11Info::PeekOption> *>(cppOut) =
        ::QFlags<QX11Info::PeekOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QX11Info_PeekOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX]))
        return number_PythonToCpp_QFlags_QX11Info_PeekOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QX11Info_PythonToCpp_QX11Info_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QX11Info_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QX11Info_PythonToCpp_QX11Info_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QX11Info_TypeF())))
        return QX11Info_PythonToCpp_QX11Info_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QX11Info_PTR_CppToPython_QX11Info(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QX11Info *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QX11Info_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QX11Info_SignatureStrings[] = {
    "PySide2.QtX11Extras.QX11Info.appDpiX(screen:int=-1)->int",
    "PySide2.QtX11Extras.QX11Info.appDpiY(screen:int=-1)->int",
    "PySide2.QtX11Extras.QX11Info.appRootWindow(screen:int=-1)->unsigned long",
    "PySide2.QtX11Extras.QX11Info.appScreen()->int",
    "PySide2.QtX11Extras.QX11Info.appTime()->unsigned long",
    "PySide2.QtX11Extras.QX11Info.appUserTime()->unsigned long",
    "PySide2.QtX11Extras.QX11Info.generatePeekerId()->qint32",
    "PySide2.QtX11Extras.QX11Info.getTimestamp()->unsigned long",
    "PySide2.QtX11Extras.QX11Info.isCompositingManagerRunning(screen:int=-1)->bool",
    "PySide2.QtX11Extras.QX11Info.isPlatformX11()->bool",
    "PySide2.QtX11Extras.QX11Info.nextStartupId()->PySide2.QtCore.QByteArray",
    "PySide2.QtX11Extras.QX11Info.removePeekerId(peekerId:qint32)->bool",
    "PySide2.QtX11Extras.QX11Info.setAppTime(time:unsigned long)",
    "PySide2.QtX11Extras.QX11Info.setAppUserTime(time:unsigned long)",
    "PySide2.QtX11Extras.QX11Info.setNextStartupId(id:PySide2.QtCore.QByteArray)",
    nullptr}; // Sentinel

void init_QX11Info(PyObject *module)
{
    _Sbk_QX11Info_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QX11Info",
        "QX11Info*",
        &Sbk_QX11Info_spec,
        &Shiboken::callCppDestructor< ::QX11Info >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QX11Info_Type);
    InitSignatureStrings(pyType, QX11Info_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QX11Info_Type), Sbk_QX11Info_PropertyStrings);
    SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QX11Info_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QX11Info_TypeF(),
        QX11Info_PythonToCpp_QX11Info_PTR,
        is_QX11Info_PythonToCpp_QX11Info_PTR_Convertible,
        QX11Info_PTR_CppToPython_QX11Info);

    Shiboken::Conversions::registerConverterName(converter, "QX11Info");
    Shiboken::Conversions::registerConverterName(converter, "QX11Info*");
    Shiboken::Conversions::registerConverterName(converter, "QX11Info&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QX11Info).name());


    // Initialization of enums.

    // Initialization of enum 'PeekOption'.
    SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtX11Extras.QX11Info.PeekOptions", SbkPySide2_QtX11Extras_QX11Info_PeekOption_number_slots);
    SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QX11Info_TypeF(),
        "PeekOption",
        "2:PySide2.QtX11Extras.QX11Info.PeekOption",
        "QX11Info::PeekOption",
        SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX]);
    if (!SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX],
        Sbk_QX11Info_TypeF(), "PeekDefault", (long) QX11Info::PeekOption::PeekDefault))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX],
        Sbk_QX11Info_TypeF(), "PeekFromCachedIndex", (long) QX11Info::PeekOption::PeekFromCachedIndex))
        return;
    // Register converter for enum 'QX11Info::PeekOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX],
            QX11Info_PeekOption_CppToPython_QX11Info_PeekOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QX11Info_PeekOption_PythonToCpp_QX11Info_PeekOption,
            is_QX11Info_PeekOption_PythonToCpp_QX11Info_PeekOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtX11ExtrasTypes[SBK_QX11INFO_PEEKOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QX11Info::PeekOption");
        Shiboken::Conversions::registerConverterName(converter, "PeekOption");
    }
    // Register converter for flag 'QFlags<QX11Info::PeekOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX],
            QFlags_QX11Info_PeekOption__CppToPython_QFlags_QX11Info_PeekOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QX11Info_PeekOption_PythonToCpp_QFlags_QX11Info_PeekOption_,
            is_QX11Info_PeekOption_PythonToCpp_QFlags_QX11Info_PeekOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QX11Info_PeekOption__PythonToCpp_QFlags_QX11Info_PeekOption_,
            is_QFlags_QX11Info_PeekOption__PythonToCpp_QFlags_QX11Info_PeekOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QX11Info_PeekOption_,
            is_number_PythonToCpp_QFlags_QX11Info_PeekOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtX11ExtrasTypes[SBK_QFLAGS_QX11INFO_PEEKOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QX11Info::PeekOptions");
        Shiboken::Conversions::registerConverterName(converter, "PeekOptions");
    }
    // End of 'PeekOption' enum/flags.

    qRegisterMetaType< ::QX11Info::PeekOption >("QX11Info::PeekOption");
    qRegisterMetaType< ::QX11Info::PeekOptions >("QX11Info::PeekOptions");
}
