/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QTREEWIDGETITEMWRAPPER_H
#define SBK_QTREEWIDGETITEMWRAPPER_H

#define protected public

#include <QtWidgets/qtreewidget.h>


// Extra includes
#include <QtWidgets/qtreewidget.h>
#include <QtGui/qicon.h>
#include <QtGui/qfont.h>
#include <QtGui/qcolor.h>
#include <QtGui/qbrush.h>
#include <qsize.h>
#include <qdatastream.h>
#include <QList>
class QTreeWidgetItemWrapper : public QTreeWidgetItem
{
public:
    QTreeWidgetItemWrapper(::QTreeWidget * treeview, ::QTreeWidgetItem * after, int type = Type);
    QTreeWidgetItemWrapper(::QTreeWidget * treeview, const ::QStringList & strings, int type = Type);
    QTreeWidgetItemWrapper(::QTreeWidget * treeview, int type = Type);
    QTreeWidgetItemWrapper(::QTreeWidgetItem * parent, ::QTreeWidgetItem * after, int type = Type);
    QTreeWidgetItemWrapper(::QTreeWidgetItem * parent, const ::QStringList & strings, int type = Type);
    QTreeWidgetItemWrapper(::QTreeWidgetItem * parent, int type = Type);
    QTreeWidgetItemWrapper(const ::QStringList & strings, int type = Type);
    QTreeWidgetItemWrapper(const QTreeWidgetItem& self) : QTreeWidgetItem(self)
    {
    }

    QTreeWidgetItemWrapper(int type = Type);
    ::QTreeWidgetItem * clone() const override;
    ::QVariant data(int column, int role) const override;
    bool operator<(const ::QTreeWidgetItem & other) const override;
    void read(::QDataStream & in) override;
    void setData(int column, int role, const ::QVariant & value) override;
    void write(::QDataStream & out) const override;
    ~QTreeWidgetItemWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[6];
};

#endif // SBK_QTREEWIDGETITEMWRAPPER_H

