/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QTEXTBROWSERWRAPPER_H
#define SBK_QTEXTBROWSERWRAPPER_H

#define protected public

#include <QtWidgets/qtextbrowser.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qwidget.h>
#include <qurl.h>
#include <qcoreevent.h>
#include <QtGui/qevent.h>
#include <qmimedata.h>
#include <QtGui/qcolor.h>
#include <qbytearray.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpainter.h>
#include <qregularexpression.h>
#include <QtGui/qtextformat.h>
#include <QtWidgets/qmenu.h>
#include <qpoint.h>
#include <QList>
#include <QTextEdit>
#include <QtGui/qfont.h>
#include <QtGui/qtextcursor.h>
#include <qmetaobject.h>
#include <qregexp.h>
#include <QtGui/qpagedpaintdevice.h>
#include <qsize.h>
#include <QtGui/qtextdocument.h>
#include <QtGui/qpaintdevice.h>
#include <qrect.h>
#include <qobjectdefs.h>
namespace PySide { class DynamicQMetaObject; }

class QTextBrowserWrapper : public QTextBrowser
{
public:
    QTextBrowserWrapper(::QWidget * parent = nullptr);
    void actionEvent(::QActionEvent * event) override;
    void backward() override;
    bool canInsertFromMimeData(const ::QMimeData * source) const override;
    void changeEvent(::QEvent * e) override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * e) override;
    ::QMimeData * createMimeDataFromSelection() const override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void doSetTextCursor(const ::QTextCursor & cursor) override;
    void dragEnterEvent(::QDragEnterEvent * e) override;
    void dragLeaveEvent(::QDragLeaveEvent * e) override;
    void dragMoveEvent(::QDragMoveEvent * e) override;
    void dropEvent(::QDropEvent * e) override;
    void enterEvent(::QEvent * event) override;
    bool event(::QEvent * e) override;
    bool eventFilter(::QObject * arg__1, ::QEvent * arg__2) override;
    void focusInEvent(::QFocusEvent * e) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * ev) override;
    void forward() override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * event) override;
    void home() override;
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent(::QInputMethodEvent * arg__1) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery property) const override;
    void insertFromMimeData(const ::QMimeData * source) override;
    void keyPressEvent(::QKeyEvent * ev) override;
    void keyReleaseEvent(::QKeyEvent * e) override;
    void leaveEvent(::QEvent * event) override;
    ::QVariant loadResource(int type, const ::QUrl & name) override;
    const ::QMetaObject * metaObject() const override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * e) override;
    void mouseMoveEvent(::QMouseEvent * ev) override;
    void mousePressEvent(::QMouseEvent * ev) override;
    void mouseReleaseEvent(::QMouseEvent * ev) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, long * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * e) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void reload() override;
    void resizeEvent(::QResizeEvent * e) override;
    void scrollContentsBy(int dx, int dy) override;
    void setSource(const ::QUrl & name) override;
    void setVisible(bool visible) override;
    void setupViewport(::QWidget * viewport) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * arg__1) override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * e) override;
    bool viewportEvent(::QEvent * arg__1) override;
    ::QSize viewportSizeHint() const override;
    void wheelEvent(::QWheelEvent * e) override;
    ~QTextBrowserWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    // Inherited overloads, because the using keyword sux
    inline void setSource(const ::QUrl & name, ::QTextDocument::ResourceType type) { QTextBrowser::setSource(name, QTextDocument::ResourceType(type)); }
    inline ::QVariant inputMethodQuery(::Qt::InputMethodQuery query, ::QVariant argument) const { return QTextBrowser::inputMethodQuery(Qt::InputMethodQuery(query), argument); }
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[62];
};

#endif // SBK_QTEXTBROWSERWRAPPER_H

