/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qtablewidgetselectionrange_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qtablewidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTableWidgetSelectionRange_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTableWidgetSelectionRange >()))
        return -1;

    ::QTableWidgetSelectionRange *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTableWidgetSelectionRange.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QTableWidgetSelectionRange_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QTableWidgetSelectionRange", 0, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QTableWidgetSelectionRange::QTableWidgetSelectionRange()
    // 1: QTableWidgetSelectionRange::QTableWidgetSelectionRange(QTableWidgetSelectionRange)
    // 2: QTableWidgetSelectionRange::QTableWidgetSelectionRange(int,int,int,int)
    if (numArgs == 0) {
        overloadId = 0; // QTableWidgetSelectionRange()
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 2; // QTableWidgetSelectionRange(int,int,int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTableWidgetSelectionRange(QTableWidgetSelectionRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTableWidgetSelectionRange_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTableWidgetSelectionRange()
        {

            if (!PyErr_Occurred()) {
                // QTableWidgetSelectionRange()
                cptr = new ::QTableWidgetSelectionRange();
            }
            break;
        }
        case 1: // QTableWidgetSelectionRange(const QTableWidgetSelectionRange & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTableWidgetSelectionRange cppArg0_local;
            ::QTableWidgetSelectionRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTableWidgetSelectionRange(QTableWidgetSelectionRange)
                cptr = new ::QTableWidgetSelectionRange(*cppArg0);
            }
            break;
        }
        case 2: // QTableWidgetSelectionRange(int top, int left, int bottom, int right)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QTableWidgetSelectionRange(int,int,int,int)
                cptr = new ::QTableWidgetSelectionRange(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTableWidgetSelectionRange >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTableWidgetSelectionRange_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTableWidgetSelectionRange_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTableWidgetSelectionRangeFunc_bottomRow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTableWidgetSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTableWidgetSelectionRange.bottomRow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottomRow()const
            int cppResult = const_cast<const ::QTableWidgetSelectionRange *>(cppSelf)->bottomRow();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTableWidgetSelectionRangeFunc_columnCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTableWidgetSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTableWidgetSelectionRange.columnCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnCount()const
            int cppResult = const_cast<const ::QTableWidgetSelectionRange *>(cppSelf)->columnCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTableWidgetSelectionRangeFunc_leftColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTableWidgetSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTableWidgetSelectionRange.leftColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leftColumn()const
            int cppResult = const_cast<const ::QTableWidgetSelectionRange *>(cppSelf)->leftColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTableWidgetSelectionRangeFunc_rightColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTableWidgetSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTableWidgetSelectionRange.rightColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rightColumn()const
            int cppResult = const_cast<const ::QTableWidgetSelectionRange *>(cppSelf)->rightColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTableWidgetSelectionRangeFunc_rowCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTableWidgetSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTableWidgetSelectionRange.rowCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rowCount()const
            int cppResult = const_cast<const ::QTableWidgetSelectionRange *>(cppSelf)->rowCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTableWidgetSelectionRangeFunc_topRow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTableWidgetSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTableWidgetSelectionRange.topRow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topRow()const
            int cppResult = const_cast<const ::QTableWidgetSelectionRange *>(cppSelf)->topRow();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTableWidgetSelectionRange___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTableWidgetSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTableWidgetSelectionRange_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTableWidgetSelectionRange_methods[] = {
    {"bottomRow", reinterpret_cast<PyCFunction>(Sbk_QTableWidgetSelectionRangeFunc_bottomRow), METH_NOARGS},
    {"columnCount", reinterpret_cast<PyCFunction>(Sbk_QTableWidgetSelectionRangeFunc_columnCount), METH_NOARGS},
    {"leftColumn", reinterpret_cast<PyCFunction>(Sbk_QTableWidgetSelectionRangeFunc_leftColumn), METH_NOARGS},
    {"rightColumn", reinterpret_cast<PyCFunction>(Sbk_QTableWidgetSelectionRangeFunc_rightColumn), METH_NOARGS},
    {"rowCount", reinterpret_cast<PyCFunction>(Sbk_QTableWidgetSelectionRangeFunc_rowCount), METH_NOARGS},
    {"topRow", reinterpret_cast<PyCFunction>(Sbk_QTableWidgetSelectionRangeFunc_topRow), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTableWidgetSelectionRange___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTableWidgetSelectionRange_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTableWidgetSelectionRange_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTableWidgetSelectionRange_Type = nullptr;
static SbkObjectType *Sbk_QTableWidgetSelectionRange_TypeF(void)
{
    return _Sbk_QTableWidgetSelectionRange_Type;
}

static PyType_Slot Sbk_QTableWidgetSelectionRange_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTableWidgetSelectionRange_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTableWidgetSelectionRange_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTableWidgetSelectionRange_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTableWidgetSelectionRange_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTableWidgetSelectionRange_spec = {
    "2:PySide2.QtWidgets.QTableWidgetSelectionRange",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTableWidgetSelectionRange_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTableWidgetSelectionRange_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTableWidgetSelectionRange_TypeF())))
        return QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTableWidgetSelectionRange_PTR_CppToPython_QTableWidgetSelectionRange(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTableWidgetSelectionRange *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTableWidgetSelectionRange_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTableWidgetSelectionRange_COPY_CppToPython_QTableWidgetSelectionRange(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTableWidgetSelectionRange_TypeF(), new ::QTableWidgetSelectionRange(*reinterpret_cast<const ::QTableWidgetSelectionRange *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTableWidgetSelectionRange *>(cppOut) = *reinterpret_cast< ::QTableWidgetSelectionRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTableWidgetSelectionRange_TypeF())))
        return QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTableWidgetSelectionRange_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QTableWidgetSelectionRange(self)",
    "1:PySide2.QtWidgets.QTableWidgetSelectionRange(self,other:PySide2.QtWidgets.QTableWidgetSelectionRange)",
    "0:PySide2.QtWidgets.QTableWidgetSelectionRange(self,top:int,left:int,bottom:int,right:int)",
    "PySide2.QtWidgets.QTableWidgetSelectionRange.bottomRow(self)->int",
    "PySide2.QtWidgets.QTableWidgetSelectionRange.columnCount(self)->int",
    "PySide2.QtWidgets.QTableWidgetSelectionRange.leftColumn(self)->int",
    "PySide2.QtWidgets.QTableWidgetSelectionRange.rightColumn(self)->int",
    "PySide2.QtWidgets.QTableWidgetSelectionRange.rowCount(self)->int",
    "PySide2.QtWidgets.QTableWidgetSelectionRange.topRow(self)->int",
    "PySide2.QtWidgets.QTableWidgetSelectionRange.__copy__()",
    nullptr}; // Sentinel

void init_QTableWidgetSelectionRange(PyObject *module)
{
    _Sbk_QTableWidgetSelectionRange_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTableWidgetSelectionRange",
        "QTableWidgetSelectionRange",
        &Sbk_QTableWidgetSelectionRange_spec,
        &Shiboken::callCppDestructor< ::QTableWidgetSelectionRange >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTableWidgetSelectionRange_Type);
    InitSignatureStrings(pyType, QTableWidgetSelectionRange_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTableWidgetSelectionRange_Type), Sbk_QTableWidgetSelectionRange_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTableWidgetSelectionRange_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTableWidgetSelectionRange_TypeF(),
        QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_PTR,
        is_QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_PTR_Convertible,
        QTableWidgetSelectionRange_PTR_CppToPython_QTableWidgetSelectionRange,
        QTableWidgetSelectionRange_COPY_CppToPython_QTableWidgetSelectionRange);

    Shiboken::Conversions::registerConverterName(converter, "QTableWidgetSelectionRange");
    Shiboken::Conversions::registerConverterName(converter, "QTableWidgetSelectionRange*");
    Shiboken::Conversions::registerConverterName(converter, "QTableWidgetSelectionRange&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTableWidgetSelectionRange).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_COPY,
        is_QTableWidgetSelectionRange_PythonToCpp_QTableWidgetSelectionRange_COPY_Convertible);

    qRegisterMetaType< ::QTableWidgetSelectionRange >("QTableWidgetSelectionRange");
}
