/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptionsizegrip_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionSizeGrip_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionSizeGrip >()))
        return -1;

    ::QStyleOptionSizeGrip *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionSizeGrip.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionSizeGrip", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionSizeGrip::QStyleOptionSizeGrip()
    // 1: QStyleOptionSizeGrip::QStyleOptionSizeGrip(QStyleOptionSizeGrip)
    // 2: QStyleOptionSizeGrip::QStyleOptionSizeGrip(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionSizeGrip()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionSizeGrip(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionSizeGrip(QStyleOptionSizeGrip)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionSizeGrip_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionSizeGrip()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionSizeGrip()
                cptr = new ::QStyleOptionSizeGrip();
            }
            break;
        }
        case 1: // QStyleOptionSizeGrip(const QStyleOptionSizeGrip & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionSizeGrip *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionSizeGrip(QStyleOptionSizeGrip)
                cptr = new ::QStyleOptionSizeGrip(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionSizeGrip(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionSizeGrip(int)
                cptr = new ::QStyleOptionSizeGrip(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionSizeGrip >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionSizeGrip_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionSizeGrip_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionSizeGrip_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionSizeGrip_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionSizeGrip_get_corner(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionSizeGrip *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::Corner cppOut_local = cppSelf->corner;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionSizeGrip_set_corner(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionSizeGrip *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'corner' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CORNER_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'corner', 'Corner' or convertible type expected");
        return -1;
    }

    ::Qt::Corner cppOut_local = cppSelf->corner;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->corner = cppOut_local;

    return 0;
}

// Getters and Setters for QStyleOptionSizeGrip
static PyGetSetDef Sbk_QStyleOptionSizeGrip_getsetlist[] = {
    {const_cast<char *>("corner"), Sbk_QStyleOptionSizeGrip_get_corner, Sbk_QStyleOptionSizeGrip_set_corner},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionSizeGrip_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionSizeGrip_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionSizeGrip_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionSizeGrip_TypeF(void)
{
    return _Sbk_QStyleOptionSizeGrip_Type;
}

static PyType_Slot Sbk_QStyleOptionSizeGrip_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionSizeGrip_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionSizeGrip_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionSizeGrip_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionSizeGrip_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionSizeGrip_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionSizeGrip_spec = {
    "2:PySide2.QtWidgets.QStyleOptionSizeGrip",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionSizeGrip_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionSizeGrip_StyleOptionType_PythonToCpp_QStyleOptionSizeGrip_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionSizeGrip::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionSizeGrip::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionSizeGrip_StyleOptionType_PythonToCpp_QStyleOptionSizeGrip_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionSizeGrip_StyleOptionType_PythonToCpp_QStyleOptionSizeGrip_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionSizeGrip_StyleOptionType_CppToPython_QStyleOptionSizeGrip_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionSizeGrip::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionSizeGrip_StyleOptionVersion_PythonToCpp_QStyleOptionSizeGrip_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionSizeGrip::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionSizeGrip::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionSizeGrip_StyleOptionVersion_PythonToCpp_QStyleOptionSizeGrip_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionSizeGrip_StyleOptionVersion_PythonToCpp_QStyleOptionSizeGrip_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionSizeGrip_StyleOptionVersion_CppToPython_QStyleOptionSizeGrip_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionSizeGrip::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionSizeGrip_PythonToCpp_QStyleOptionSizeGrip_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionSizeGrip_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionSizeGrip_PythonToCpp_QStyleOptionSizeGrip_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionSizeGrip_TypeF())))
        return QStyleOptionSizeGrip_PythonToCpp_QStyleOptionSizeGrip_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionSizeGrip_PTR_CppToPython_QStyleOptionSizeGrip(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionSizeGrip *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionSizeGrip_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionSizeGrip_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionSizeGrip(self)",
    "1:PySide2.QtWidgets.QStyleOptionSizeGrip(self,other:PySide2.QtWidgets.QStyleOptionSizeGrip)",
    "0:PySide2.QtWidgets.QStyleOptionSizeGrip(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionSizeGrip(PyObject *module)
{
    _Sbk_QStyleOptionSizeGrip_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionSizeGrip",
        "QStyleOptionSizeGrip*",
        &Sbk_QStyleOptionSizeGrip_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionSizeGrip >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionSizeGrip_Type);
    InitSignatureStrings(pyType, QStyleOptionSizeGrip_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionSizeGrip_Type), Sbk_QStyleOptionSizeGrip_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionSizeGrip_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionSizeGrip_TypeF(),
        QStyleOptionSizeGrip_PythonToCpp_QStyleOptionSizeGrip_PTR,
        is_QStyleOptionSizeGrip_PythonToCpp_QStyleOptionSizeGrip_PTR_Convertible,
        QStyleOptionSizeGrip_PTR_CppToPython_QStyleOptionSizeGrip);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSizeGrip");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSizeGrip*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSizeGrip&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionSizeGrip).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionSizeGrip_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionSizeGrip.StyleOptionType",
        "QStyleOptionSizeGrip::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionSizeGrip_TypeF(), "Type", (long) QStyleOptionSizeGrip::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionSizeGrip::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX],
            QStyleOptionSizeGrip_StyleOptionType_CppToPython_QStyleOptionSizeGrip_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionSizeGrip_StyleOptionType_PythonToCpp_QStyleOptionSizeGrip_StyleOptionType,
            is_QStyleOptionSizeGrip_StyleOptionType_PythonToCpp_QStyleOptionSizeGrip_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSizeGrip::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionSizeGrip_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionSizeGrip.StyleOptionVersion",
        "QStyleOptionSizeGrip::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionSizeGrip_TypeF(), "Version", (long) QStyleOptionSizeGrip::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionSizeGrip::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX],
            QStyleOptionSizeGrip_StyleOptionVersion_CppToPython_QStyleOptionSizeGrip_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionSizeGrip_StyleOptionVersion_PythonToCpp_QStyleOptionSizeGrip_StyleOptionVersion,
            is_QStyleOptionSizeGrip_StyleOptionVersion_PythonToCpp_QStyleOptionSizeGrip_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSIZEGRIP_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSizeGrip::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    qRegisterMetaType< ::QStyleOptionSizeGrip::StyleOptionType >("QStyleOptionSizeGrip::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionSizeGrip::StyleOptionVersion >("QStyleOptionSizeGrip::StyleOptionVersion");
}
