/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptionfocusrect_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionFocusRect_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionFocusRect >()))
        return -1;

    ::QStyleOptionFocusRect *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionFocusRect.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionFocusRect", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionFocusRect::QStyleOptionFocusRect()
    // 1: QStyleOptionFocusRect::QStyleOptionFocusRect(QStyleOptionFocusRect)
    // 2: QStyleOptionFocusRect::QStyleOptionFocusRect(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionFocusRect()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionFocusRect(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionFocusRect(QStyleOptionFocusRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionFocusRect_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionFocusRect()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionFocusRect()
                cptr = new ::QStyleOptionFocusRect();
            }
            break;
        }
        case 1: // QStyleOptionFocusRect(const QStyleOptionFocusRect & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionFocusRect *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionFocusRect(QStyleOptionFocusRect)
                cptr = new ::QStyleOptionFocusRect(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionFocusRect(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionFocusRect(int)
                cptr = new ::QStyleOptionFocusRect(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionFocusRect >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionFocusRect_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionFocusRect_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionFocusRect_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionFocusRect_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionFocusRect_get_backgroundColor(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFocusRect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->backgroundColor)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->backgroundColor))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->backgroundColor)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &(cppSelf->backgroundColor), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionFocusRect_set_backgroundColor(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFocusRect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'backgroundColor' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'backgroundColor', 'QColor' or convertible type expected");
        return -1;
    }

    ::QColor& cppOut_ptr = cppSelf->backgroundColor;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QStyleOptionFocusRect
static PyGetSetDef Sbk_QStyleOptionFocusRect_getsetlist[] = {
    {const_cast<char *>("backgroundColor"), Sbk_QStyleOptionFocusRect_get_backgroundColor, Sbk_QStyleOptionFocusRect_set_backgroundColor},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionFocusRect_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionFocusRect_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionFocusRect_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionFocusRect_TypeF(void)
{
    return _Sbk_QStyleOptionFocusRect_Type;
}

static PyType_Slot Sbk_QStyleOptionFocusRect_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionFocusRect_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionFocusRect_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionFocusRect_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionFocusRect_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionFocusRect_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionFocusRect_spec = {
    "2:PySide2.QtWidgets.QStyleOptionFocusRect",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionFocusRect_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionFocusRect_StyleOptionType_PythonToCpp_QStyleOptionFocusRect_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionFocusRect::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionFocusRect::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionFocusRect_StyleOptionType_PythonToCpp_QStyleOptionFocusRect_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionFocusRect_StyleOptionType_PythonToCpp_QStyleOptionFocusRect_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionFocusRect_StyleOptionType_CppToPython_QStyleOptionFocusRect_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionFocusRect::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionFocusRect_StyleOptionVersion_PythonToCpp_QStyleOptionFocusRect_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionFocusRect::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionFocusRect::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionFocusRect_StyleOptionVersion_PythonToCpp_QStyleOptionFocusRect_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionFocusRect_StyleOptionVersion_PythonToCpp_QStyleOptionFocusRect_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionFocusRect_StyleOptionVersion_CppToPython_QStyleOptionFocusRect_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionFocusRect::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionFocusRect_PythonToCpp_QStyleOptionFocusRect_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionFocusRect_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionFocusRect_PythonToCpp_QStyleOptionFocusRect_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionFocusRect_TypeF())))
        return QStyleOptionFocusRect_PythonToCpp_QStyleOptionFocusRect_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionFocusRect_PTR_CppToPython_QStyleOptionFocusRect(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionFocusRect *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionFocusRect_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionFocusRect_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionFocusRect(self)",
    "1:PySide2.QtWidgets.QStyleOptionFocusRect(self,other:PySide2.QtWidgets.QStyleOptionFocusRect)",
    "0:PySide2.QtWidgets.QStyleOptionFocusRect(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionFocusRect(PyObject *module)
{
    _Sbk_QStyleOptionFocusRect_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionFocusRect",
        "QStyleOptionFocusRect*",
        &Sbk_QStyleOptionFocusRect_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionFocusRect >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionFocusRect_Type);
    InitSignatureStrings(pyType, QStyleOptionFocusRect_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionFocusRect_Type), Sbk_QStyleOptionFocusRect_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionFocusRect_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionFocusRect_TypeF(),
        QStyleOptionFocusRect_PythonToCpp_QStyleOptionFocusRect_PTR,
        is_QStyleOptionFocusRect_PythonToCpp_QStyleOptionFocusRect_PTR_Convertible,
        QStyleOptionFocusRect_PTR_CppToPython_QStyleOptionFocusRect);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFocusRect");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFocusRect*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFocusRect&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionFocusRect).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionFocusRect_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionFocusRect.StyleOptionType",
        "QStyleOptionFocusRect::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionFocusRect_TypeF(), "Type", (long) QStyleOptionFocusRect::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionFocusRect::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX],
            QStyleOptionFocusRect_StyleOptionType_CppToPython_QStyleOptionFocusRect_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionFocusRect_StyleOptionType_PythonToCpp_QStyleOptionFocusRect_StyleOptionType,
            is_QStyleOptionFocusRect_StyleOptionType_PythonToCpp_QStyleOptionFocusRect_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFocusRect::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionFocusRect_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionFocusRect.StyleOptionVersion",
        "QStyleOptionFocusRect::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionFocusRect_TypeF(), "Version", (long) QStyleOptionFocusRect::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionFocusRect::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX],
            QStyleOptionFocusRect_StyleOptionVersion_CppToPython_QStyleOptionFocusRect_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionFocusRect_StyleOptionVersion_PythonToCpp_QStyleOptionFocusRect_StyleOptionVersion,
            is_QStyleOptionFocusRect_StyleOptionVersion_PythonToCpp_QStyleOptionFocusRect_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFOCUSRECT_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFocusRect::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    qRegisterMetaType< ::QStyleOptionFocusRect::StyleOptionType >("QStyleOptionFocusRect::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionFocusRect::StyleOptionVersion >("QStyleOptionFocusRect::StyleOptionVersion");
}
