/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstylehintreturnmask_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleHintReturnMask_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleHintReturnMask >()))
        return -1;

    ::QStyleHintReturnMask *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleHintReturnMask.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QStyleHintReturnMask()
            cptr = new ::QStyleHintReturnMask();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleHintReturnMask >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}


static const char *Sbk_QStyleHintReturnMask_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleHintReturnMask_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleHintReturnMask_get_region(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleHintReturnMask *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->region)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->region))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->region)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), &(cppSelf->region), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleHintReturnMask_set_region(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleHintReturnMask *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'region' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'region', 'QRegion' or convertible type expected");
        return -1;
    }

    ::QRegion& cppOut_ptr = cppSelf->region;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QStyleHintReturnMask
static PyGetSetDef Sbk_QStyleHintReturnMask_getsetlist[] = {
    {const_cast<char *>("region"), Sbk_QStyleHintReturnMask_get_region, Sbk_QStyleHintReturnMask_set_region},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleHintReturnMask_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleHintReturnMask_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleHintReturnMask_Type = nullptr;
static SbkObjectType *Sbk_QStyleHintReturnMask_TypeF(void)
{
    return _Sbk_QStyleHintReturnMask_Type;
}

static PyType_Slot Sbk_QStyleHintReturnMask_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleHintReturnMask_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleHintReturnMask_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleHintReturnMask_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleHintReturnMask_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleHintReturnMask_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleHintReturnMask_spec = {
    "2:PySide2.QtWidgets.QStyleHintReturnMask",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleHintReturnMask_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleHintReturnMask_StyleOptionType_PythonToCpp_QStyleHintReturnMask_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleHintReturnMask::StyleOptionType *>(cppOut) =
        static_cast<::QStyleHintReturnMask::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleHintReturnMask_StyleOptionType_PythonToCpp_QStyleHintReturnMask_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX]))
        return QStyleHintReturnMask_StyleOptionType_PythonToCpp_QStyleHintReturnMask_StyleOptionType;
    return {};
}
static PyObject *QStyleHintReturnMask_StyleOptionType_CppToPython_QStyleHintReturnMask_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleHintReturnMask::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleHintReturnMask_StyleOptionVersion_PythonToCpp_QStyleHintReturnMask_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleHintReturnMask::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleHintReturnMask::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleHintReturnMask_StyleOptionVersion_PythonToCpp_QStyleHintReturnMask_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX]))
        return QStyleHintReturnMask_StyleOptionVersion_PythonToCpp_QStyleHintReturnMask_StyleOptionVersion;
    return {};
}
static PyObject *QStyleHintReturnMask_StyleOptionVersion_CppToPython_QStyleHintReturnMask_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleHintReturnMask::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleHintReturnMask_PythonToCpp_QStyleHintReturnMask_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleHintReturnMask_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleHintReturnMask_PythonToCpp_QStyleHintReturnMask_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleHintReturnMask_TypeF())))
        return QStyleHintReturnMask_PythonToCpp_QStyleHintReturnMask_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleHintReturnMask_PTR_CppToPython_QStyleHintReturnMask(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleHintReturnMask *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleHintReturnMask_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleHintReturnMask_SignatureStrings[] = {
    "PySide2.QtWidgets.QStyleHintReturnMask(self)",
    nullptr}; // Sentinel

void init_QStyleHintReturnMask(PyObject *module)
{
    _Sbk_QStyleHintReturnMask_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleHintReturnMask",
        "QStyleHintReturnMask*",
        &Sbk_QStyleHintReturnMask_spec,
        &Shiboken::callCppDestructor< ::QStyleHintReturnMask >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleHintReturnMask_Type);
    InitSignatureStrings(pyType, QStyleHintReturnMask_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleHintReturnMask_Type), Sbk_QStyleHintReturnMask_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleHintReturnMask_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleHintReturnMask_TypeF(),
        QStyleHintReturnMask_PythonToCpp_QStyleHintReturnMask_PTR,
        is_QStyleHintReturnMask_PythonToCpp_QStyleHintReturnMask_PTR_Convertible,
        QStyleHintReturnMask_PTR_CppToPython_QStyleHintReturnMask);

    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnMask");
    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnMask*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnMask&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleHintReturnMask).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleHintReturnMask_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleHintReturnMask.StyleOptionType",
        "QStyleHintReturnMask::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleHintReturnMask_TypeF(), "Type", (long) QStyleHintReturnMask::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleHintReturnMask::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX],
            QStyleHintReturnMask_StyleOptionType_CppToPython_QStyleHintReturnMask_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleHintReturnMask_StyleOptionType_PythonToCpp_QStyleHintReturnMask_StyleOptionType,
            is_QStyleHintReturnMask_StyleOptionType_PythonToCpp_QStyleHintReturnMask_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnMask::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleHintReturnMask_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleHintReturnMask.StyleOptionVersion",
        "QStyleHintReturnMask::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleHintReturnMask_TypeF(), "Version", (long) QStyleHintReturnMask::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleHintReturnMask::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX],
            QStyleHintReturnMask_StyleOptionVersion_CppToPython_QStyleHintReturnMask_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleHintReturnMask_StyleOptionVersion_PythonToCpp_QStyleHintReturnMask_StyleOptionVersion,
            is_QStyleHintReturnMask_StyleOptionVersion_PythonToCpp_QStyleHintReturnMask_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNMASK_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnMask::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    qRegisterMetaType< ::QStyleHintReturnMask::StyleOptionType >("QStyleHintReturnMask::StyleOptionType");
    qRegisterMetaType< ::QStyleHintReturnMask::StyleOptionVersion >("QStyleHintReturnMask::StyleOptionVersion");
}
