/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QSTYLEWRAPPER_H
#define SBK_QSTYLEWRAPPER_H

#define protected public

#include <QtWidgets/qstyle.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qwidget.h>
#include <QtWidgets/qapplication.h>
#include <QtGui/qpalette.h>
#include <qrect.h>
#include <QtGui/qfontmetrics.h>
#include <QtGui/qpixmap.h>
#include <QtGui/qpainter.h>
#include <QtWidgets/qstyleoption.h>
#include <qpoint.h>
#include <qsize.h>
#include <QtGui/qicon.h>
#include <QtWidgets/qstyle.h>
#include <qobjectdefs.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qthread.h>
#include <QList>
#include <qbytearray.h>
namespace PySide { class DynamicQMetaObject; }

class QStyleWrapper : public QStyle
{
public:
    QStyleWrapper();
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void drawComplexControl(::QStyle::ComplexControl cc, const ::QStyleOptionComplex * opt, ::QPainter * p, const ::QWidget * widget = nullptr) const override;
    void drawControl(::QStyle::ControlElement element, const ::QStyleOption * opt, ::QPainter * p, const ::QWidget * widget = nullptr) const override;
    void drawItemPixmap(::QPainter * painter, const ::QRect & rect, int alignment, const ::QPixmap & pixmap) const override;
    void drawItemText(::QPainter * painter, const ::QRect & rect, int flags, const ::QPalette & pal, bool enabled, const ::QString & text, ::QPalette::ColorRole textRole = QPalette::NoRole) const override;
    void drawPrimitive(::QStyle::PrimitiveElement pe, const ::QStyleOption * opt, ::QPainter * p, const ::QWidget * widget = nullptr) const override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QPixmap generatedIconPixmap(::QIcon::Mode iconMode, const ::QPixmap & pixmap, const ::QStyleOption * opt) const override;
    ::QStyle::SubControl hitTestComplexControl(::QStyle::ComplexControl cc, const ::QStyleOptionComplex * opt, const ::QPoint & pt, const ::QWidget * widget = nullptr) const override;
    ::QRect itemPixmapRect(const ::QRect & r, int flags, const ::QPixmap & pixmap) const override;
    ::QRect itemTextRect(const ::QFontMetrics & fm, const ::QRect & r, int flags, bool enabled, const ::QString & text) const override;
    int layoutSpacing(::QSizePolicy::ControlType control1, ::QSizePolicy::ControlType control2, ::Qt::Orientation orientation, const ::QStyleOption * option = nullptr, const ::QWidget * widget = nullptr) const override;
    const ::QMetaObject * metaObject() const override;
    int pixelMetric(::QStyle::PixelMetric metric, const ::QStyleOption * option = nullptr, const ::QWidget * widget = nullptr) const override;
    void polish(::QApplication * application) override;
    void polish(::QPalette & palette) override;
    void polish(::QWidget * widget) override;
    ::QSize sizeFromContents(::QStyle::ContentsType ct, const ::QStyleOption * opt, const ::QSize & contentsSize, const ::QWidget * w = nullptr) const override;
    ::QIcon standardIcon(::QStyle::StandardPixmap standardIcon, const ::QStyleOption * option = nullptr, const ::QWidget * widget = nullptr) const override;
    ::QPalette standardPalette() const override;
    ::QPixmap standardPixmap(::QStyle::StandardPixmap standardPixmap, const ::QStyleOption * opt = nullptr, const ::QWidget * widget = nullptr) const override;
    int styleHint(::QStyle::StyleHint stylehint, const ::QStyleOption * opt = nullptr, const ::QWidget * widget = nullptr, ::QStyleHintReturn * returnData = nullptr) const override;
    ::QRect subControlRect(::QStyle::ComplexControl cc, const ::QStyleOptionComplex * opt, ::QStyle::SubControl sc, const ::QWidget * widget = nullptr) const override;
    ::QRect subElementRect(::QStyle::SubElement subElement, const ::QStyleOption * option, const ::QWidget * widget = nullptr) const override;
    void timerEvent(::QTimerEvent * event) override;
    void unpolish(::QApplication * application) override;
    void unpolish(::QWidget * widget) override;
    ~QStyleWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[31];
};

#endif // SBK_QSTYLEWRAPPER_H

