/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qsizepolicy_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qsizepolicy.h>
#include <qdatastream.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSizePolicy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSizePolicy >()))
        return -1;

    ::QSizePolicy *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSizePolicy_Init_TypeError;
    } else if (numArgs == 1)
        goto Sbk_QSizePolicy_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOO:QSizePolicy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QSizePolicy::QSizePolicy()
    // 1: QSizePolicy::QSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
    if (numArgs == 0) {
        overloadId = 0; // QSizePolicy()
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // QSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArgs[2])))) {
            overloadId = 1; // QSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicy_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSizePolicy()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QSizePolicy_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QSizePolicy()
                cptr = new ::QSizePolicy();
            }
            break;
        }
        case 1: // QSizePolicy(QSizePolicy::Policy horizontal, QSizePolicy::Policy vertical, QSizePolicy::ControlType type)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_type = Shiboken::String::createStaticString("type");
                if (PyDict_Contains(kwds, key_type)) {
                    value = PyDict_GetItem(kwds, key_type);
                    if (value && pyArgs[2]) {
                        errInfo = key_type;
                        Py_INCREF(errInfo);
                        goto Sbk_QSizePolicy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QSizePolicy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_type);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSizePolicy_Init_TypeError;
                }
            }
            ::QSizePolicy::Policy cppArg0{QSizePolicy::Fixed};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSizePolicy::Policy cppArg1{QSizePolicy::Fixed};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QSizePolicy::ControlType cppArg2 = QSizePolicy::ControlType::DefaultType;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
                cptr = new ::QSizePolicy(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSizePolicy >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSizePolicy_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSizePolicy_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSizePolicyFunc_controlType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.controlType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // controlType()const
            QSizePolicy::ControlType cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->controlType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_expandingDirections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.expandingDirections";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // expandingDirections()const
            QFlags<Qt::Orientation> cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->expandingDirections();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_hasHeightForWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.hasHeightForWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasHeightForWidth()const
            bool cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->hasHeightForWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_hasWidthForHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.hasWidthForHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasWidthForHeight()const
            bool cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->hasWidthForHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_horizontalPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.horizontalPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // horizontalPolicy()const
            QSizePolicy::Policy cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->horizontalPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_horizontalStretch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.horizontalStretch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // horizontalStretch()const
            int cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->horizontalStretch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_retainSizeWhenHidden(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.retainSizeWhenHidden";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // retainSizeWhenHidden()const
            bool cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->retainSizeWhenHidden();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_setControlType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.setControlType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSizePolicy::setControlType(QSizePolicy::ControlType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setControlType(QSizePolicy::ControlType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicyFunc_setControlType_TypeError;

    // Call function/method
    {
        ::QSizePolicy::ControlType cppArg0 = static_cast< ::QSizePolicy::ControlType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setControlType(QSizePolicy::ControlType)
            cppSelf->setControlType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSizePolicyFunc_setControlType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc_setHeightForWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.setHeightForWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSizePolicy::setHeightForWidth(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setHeightForWidth(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicyFunc_setHeightForWidth_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHeightForWidth(bool)
            cppSelf->setHeightForWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSizePolicyFunc_setHeightForWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc_setHorizontalPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.setHorizontalPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSizePolicy::setHorizontalPolicy(QSizePolicy::Policy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setHorizontalPolicy(QSizePolicy::Policy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicyFunc_setHorizontalPolicy_TypeError;

    // Call function/method
    {
        ::QSizePolicy::Policy cppArg0{QSizePolicy::Fixed};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHorizontalPolicy(QSizePolicy::Policy)
            cppSelf->setHorizontalPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSizePolicyFunc_setHorizontalPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc_setHorizontalStretch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.setHorizontalStretch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSizePolicy::setHorizontalStretch(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHorizontalStretch(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicyFunc_setHorizontalStretch_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHorizontalStretch(int)
            cppSelf->setHorizontalStretch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSizePolicyFunc_setHorizontalStretch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc_setRetainSizeWhenHidden(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.setRetainSizeWhenHidden";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSizePolicy::setRetainSizeWhenHidden(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRetainSizeWhenHidden(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicyFunc_setRetainSizeWhenHidden_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRetainSizeWhenHidden(bool)
            cppSelf->setRetainSizeWhenHidden(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSizePolicyFunc_setRetainSizeWhenHidden_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc_setVerticalPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.setVerticalPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSizePolicy::setVerticalPolicy(QSizePolicy::Policy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setVerticalPolicy(QSizePolicy::Policy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicyFunc_setVerticalPolicy_TypeError;

    // Call function/method
    {
        ::QSizePolicy::Policy cppArg0{QSizePolicy::Fixed};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVerticalPolicy(QSizePolicy::Policy)
            cppSelf->setVerticalPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSizePolicyFunc_setVerticalPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc_setVerticalStretch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.setVerticalStretch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSizePolicy::setVerticalStretch(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVerticalStretch(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicyFunc_setVerticalStretch_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVerticalStretch(int)
            cppSelf->setVerticalStretch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSizePolicyFunc_setVerticalStretch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc_setWidthForHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.setWidthForHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSizePolicy::setWidthForHeight(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWidthForHeight(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSizePolicyFunc_setWidthForHeight_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidthForHeight(bool)
            cppSelf->setWidthForHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSizePolicyFunc_setWidthForHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc_transpose(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.transpose";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transpose()
            cppSelf->transpose();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSizePolicyFunc_transposed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.transposed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transposed()const
            QSizePolicy cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->transposed();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_verticalPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.verticalPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // verticalPolicy()const
            QSizePolicy::Policy cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->verticalPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicyFunc_verticalStretch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.verticalStretch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // verticalStretch()const
            int cppResult = const_cast<const ::QSizePolicy *>(cppSelf)->verticalStretch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSizePolicy___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSizePolicy_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSizePolicy_methods[] = {
    {"controlType", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_controlType), METH_NOARGS},
    {"expandingDirections", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_expandingDirections), METH_NOARGS},
    {"hasHeightForWidth", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_hasHeightForWidth), METH_NOARGS},
    {"hasWidthForHeight", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_hasWidthForHeight), METH_NOARGS},
    {"horizontalPolicy", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_horizontalPolicy), METH_NOARGS},
    {"horizontalStretch", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_horizontalStretch), METH_NOARGS},
    {"retainSizeWhenHidden", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_retainSizeWhenHidden), METH_NOARGS},
    {"setControlType", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_setControlType), METH_O},
    {"setHeightForWidth", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_setHeightForWidth), METH_O},
    {"setHorizontalPolicy", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_setHorizontalPolicy), METH_O},
    {"setHorizontalStretch", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_setHorizontalStretch), METH_O},
    {"setRetainSizeWhenHidden", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_setRetainSizeWhenHidden), METH_O},
    {"setVerticalPolicy", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_setVerticalPolicy), METH_O},
    {"setVerticalStretch", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_setVerticalStretch), METH_O},
    {"setWidthForHeight", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_setWidthForHeight), METH_O},
    {"transpose", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_transpose), METH_NOARGS},
    {"transposed", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_transposed), METH_NOARGS},
    {"verticalPolicy", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_verticalPolicy), METH_NOARGS},
    {"verticalStretch", reinterpret_cast<PyCFunction>(Sbk_QSizePolicyFunc_verticalStretch), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSizePolicy___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QSizePolicyFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QSizePolicy::operator<<(QDataStream&,QSizePolicy)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QSizePolicy)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QSizePolicyFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QSizePolicy) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSizePolicyFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSizePolicyFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QSizePolicy.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QSizePolicy::operator>>(QDataStream&,QSizePolicy&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QSizePolicy&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QSizePolicyFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QSizePolicy&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSizePolicyFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QSizePolicy_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), (pyArg)))) {
                // operator!=(const QSizePolicy & s) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSizePolicy cppArg0_local;
                ::QSizePolicy *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), (pyArg)))) {
                // operator==(const QSizePolicy & s) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSizePolicy cppArg0_local;
                ::QSizePolicy *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSizePolicy_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSizePolicy_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSizePolicy_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSizePolicy_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSizePolicy__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSizePolicy_Type = nullptr;
static SbkObjectType *Sbk_QSizePolicy_TypeF(void)
{
    return _Sbk_QSizePolicy_Type;
}

static PyType_Slot Sbk_QSizePolicy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSizePolicy__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSizePolicy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSizePolicy_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSizePolicy_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSizePolicy_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSizePolicy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QSizePolicyFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QSizePolicyFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QSizePolicy_spec = {
    "2:PySide2.QtWidgets.QSizePolicy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSizePolicy_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QSizePolicy_ControlType___and__(PyObject *self, PyObject *pyArg)
{
    ::QSizePolicy::ControlTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSizePolicy::ControlTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSizePolicy::ControlTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSizePolicy::ControlTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSizePolicy::ControlTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QSizePolicy_ControlType___or__(PyObject *self, PyObject *pyArg)
{
    ::QSizePolicy::ControlTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSizePolicy::ControlTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSizePolicy::ControlTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSizePolicy::ControlTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSizePolicy::ControlTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QSizePolicy_ControlType___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSizePolicy::ControlTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSizePolicy::ControlTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSizePolicy::ControlTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSizePolicy::ControlTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSizePolicy::ControlTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QSizePolicy_ControlType___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSizePolicy::ControlTypes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, self, &cppSelf);
    ::QSizePolicy::ControlTypes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QSizePolicy_ControlType_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QSizePolicy_ControlType__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QSizePolicy_ControlType_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QSizePolicy_ControlType_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSizePolicy_PolicyFlag_PythonToCpp_QSizePolicy_PolicyFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSizePolicy::PolicyFlag *>(cppOut) =
        static_cast<::QSizePolicy::PolicyFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSizePolicy_PolicyFlag_PythonToCpp_QSizePolicy_PolicyFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX]))
        return QSizePolicy_PolicyFlag_PythonToCpp_QSizePolicy_PolicyFlag;
    return {};
}
static PyObject *QSizePolicy_PolicyFlag_CppToPython_QSizePolicy_PolicyFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSizePolicy::PolicyFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX], castCppIn);

}

static void QSizePolicy_Policy_PythonToCpp_QSizePolicy_Policy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSizePolicy::Policy *>(cppOut) =
        static_cast<::QSizePolicy::Policy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSizePolicy_Policy_PythonToCpp_QSizePolicy_Policy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX]))
        return QSizePolicy_Policy_PythonToCpp_QSizePolicy_Policy;
    return {};
}
static PyObject *QSizePolicy_Policy_CppToPython_QSizePolicy_Policy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSizePolicy::Policy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX], castCppIn);

}

static void QSizePolicy_ControlType_PythonToCpp_QSizePolicy_ControlType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSizePolicy::ControlType *>(cppOut) =
        static_cast<::QSizePolicy::ControlType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSizePolicy_ControlType_PythonToCpp_QSizePolicy_ControlType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX]))
        return QSizePolicy_ControlType_PythonToCpp_QSizePolicy_ControlType;
    return {};
}
static PyObject *QSizePolicy_ControlType_CppToPython_QSizePolicy_ControlType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSizePolicy::ControlType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX], castCppIn);

}

static void QFlags_QSizePolicy_ControlType__PythonToCpp_QFlags_QSizePolicy_ControlType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSizePolicy::ControlType> *>(cppOut) =
        ::QFlags<QSizePolicy::ControlType>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSizePolicy_ControlType__PythonToCpp_QFlags_QSizePolicy_ControlType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX]))
        return QFlags_QSizePolicy_ControlType__PythonToCpp_QFlags_QSizePolicy_ControlType_;
    return {};
}
static PyObject *QFlags_QSizePolicy_ControlType__CppToPython_QFlags_QSizePolicy_ControlType_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSizePolicy::ControlType> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX]));

}

static void QSizePolicy_ControlType_PythonToCpp_QFlags_QSizePolicy_ControlType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSizePolicy::ControlType> *>(cppOut) =
        ::QFlags<QSizePolicy::ControlType>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSizePolicy_ControlType_PythonToCpp_QFlags_QSizePolicy_ControlType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX]))
        return QSizePolicy_ControlType_PythonToCpp_QFlags_QSizePolicy_ControlType_;
    return {};
}
static void number_PythonToCpp_QFlags_QSizePolicy_ControlType_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSizePolicy::ControlType> *>(cppOut) =
        ::QFlags<QSizePolicy::ControlType>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSizePolicy_ControlType__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX]))
        return number_PythonToCpp_QFlags_QSizePolicy_ControlType_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSizePolicy_PythonToCpp_QSizePolicy_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSizePolicy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSizePolicy_PythonToCpp_QSizePolicy_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSizePolicy_TypeF())))
        return QSizePolicy_PythonToCpp_QSizePolicy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSizePolicy_PTR_CppToPython_QSizePolicy(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSizePolicy *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSizePolicy_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSizePolicy_COPY_CppToPython_QSizePolicy(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSizePolicy_TypeF(), new ::QSizePolicy(*reinterpret_cast<const ::QSizePolicy *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSizePolicy_PythonToCpp_QSizePolicy_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSizePolicy *>(cppOut) = *reinterpret_cast< ::QSizePolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSizePolicy_PythonToCpp_QSizePolicy_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSizePolicy_TypeF())))
        return QSizePolicy_PythonToCpp_QSizePolicy_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSizePolicy_SignatureStrings[] = {
    "1:PySide2.QtWidgets.QSizePolicy(self)",
    "0:PySide2.QtWidgets.QSizePolicy(self,horizontal:PySide2.QtWidgets.QSizePolicy.Policy,vertical:PySide2.QtWidgets.QSizePolicy.Policy,type:PySide2.QtWidgets.QSizePolicy.ControlType=DefaultType)",
    "PySide2.QtWidgets.QSizePolicy.controlType(self)->PySide2.QtWidgets.QSizePolicy.ControlType",
    "PySide2.QtWidgets.QSizePolicy.expandingDirections(self)->PySide2.QtCore.Qt.Orientations",
    "PySide2.QtWidgets.QSizePolicy.hasHeightForWidth(self)->bool",
    "PySide2.QtWidgets.QSizePolicy.hasWidthForHeight(self)->bool",
    "PySide2.QtWidgets.QSizePolicy.horizontalPolicy(self)->PySide2.QtWidgets.QSizePolicy.Policy",
    "PySide2.QtWidgets.QSizePolicy.horizontalStretch(self)->int",
    "PySide2.QtWidgets.QSizePolicy.retainSizeWhenHidden(self)->bool",
    "PySide2.QtWidgets.QSizePolicy.setControlType(self,type:PySide2.QtWidgets.QSizePolicy.ControlType)",
    "PySide2.QtWidgets.QSizePolicy.setHeightForWidth(self,b:bool)",
    "PySide2.QtWidgets.QSizePolicy.setHorizontalPolicy(self,d:PySide2.QtWidgets.QSizePolicy.Policy)",
    "PySide2.QtWidgets.QSizePolicy.setHorizontalStretch(self,stretchFactor:int)",
    "PySide2.QtWidgets.QSizePolicy.setRetainSizeWhenHidden(self,retainSize:bool)",
    "PySide2.QtWidgets.QSizePolicy.setVerticalPolicy(self,d:PySide2.QtWidgets.QSizePolicy.Policy)",
    "PySide2.QtWidgets.QSizePolicy.setVerticalStretch(self,stretchFactor:int)",
    "PySide2.QtWidgets.QSizePolicy.setWidthForHeight(self,b:bool)",
    "PySide2.QtWidgets.QSizePolicy.transpose(self)",
    "PySide2.QtWidgets.QSizePolicy.transposed(self)->PySide2.QtWidgets.QSizePolicy",
    "PySide2.QtWidgets.QSizePolicy.verticalPolicy(self)->PySide2.QtWidgets.QSizePolicy.Policy",
    "PySide2.QtWidgets.QSizePolicy.verticalStretch(self)->int",
    "PySide2.QtWidgets.QSizePolicy.__copy__()",
    "PySide2.QtWidgets.QSizePolicy.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtWidgets.QSizePolicy.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QSizePolicy(PyObject *module)
{
    _Sbk_QSizePolicy_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSizePolicy",
        "QSizePolicy",
        &Sbk_QSizePolicy_spec,
        &Shiboken::callCppDestructor< ::QSizePolicy >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSizePolicy_Type);
    InitSignatureStrings(pyType, QSizePolicy_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSizePolicy_Type), Sbk_QSizePolicy_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSizePolicy_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSizePolicy_TypeF(),
        QSizePolicy_PythonToCpp_QSizePolicy_PTR,
        is_QSizePolicy_PythonToCpp_QSizePolicy_PTR_Convertible,
        QSizePolicy_PTR_CppToPython_QSizePolicy,
        QSizePolicy_COPY_CppToPython_QSizePolicy);

    Shiboken::Conversions::registerConverterName(converter, "QSizePolicy");
    Shiboken::Conversions::registerConverterName(converter, "QSizePolicy*");
    Shiboken::Conversions::registerConverterName(converter, "QSizePolicy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSizePolicy).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSizePolicy_PythonToCpp_QSizePolicy_COPY,
        is_QSizePolicy_PythonToCpp_QSizePolicy_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'PolicyFlag'.
    SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSizePolicy_TypeF(),
        "PolicyFlag",
        "2:PySide2.QtWidgets.QSizePolicy.PolicyFlag",
        "QSizePolicy::PolicyFlag");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX],
        Sbk_QSizePolicy_TypeF(), "GrowFlag", (long) QSizePolicy::PolicyFlag::GrowFlag))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX],
        Sbk_QSizePolicy_TypeF(), "ExpandFlag", (long) QSizePolicy::PolicyFlag::ExpandFlag))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX],
        Sbk_QSizePolicy_TypeF(), "ShrinkFlag", (long) QSizePolicy::PolicyFlag::ShrinkFlag))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX],
        Sbk_QSizePolicy_TypeF(), "IgnoreFlag", (long) QSizePolicy::PolicyFlag::IgnoreFlag))
        return;
    // Register converter for enum 'QSizePolicy::PolicyFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX],
            QSizePolicy_PolicyFlag_CppToPython_QSizePolicy_PolicyFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSizePolicy_PolicyFlag_PythonToCpp_QSizePolicy_PolicyFlag,
            is_QSizePolicy_PolicyFlag_PythonToCpp_QSizePolicy_PolicyFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSizePolicy::PolicyFlag");
        Shiboken::Conversions::registerConverterName(converter, "PolicyFlag");
    }
    // End of 'PolicyFlag' enum.

    // Initialization of enum 'Policy'.
    SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSizePolicy_TypeF(),
        "Policy",
        "2:PySide2.QtWidgets.QSizePolicy.Policy",
        "QSizePolicy::Policy");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX],
        Sbk_QSizePolicy_TypeF(), "Fixed", (long) QSizePolicy::Policy::Fixed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX],
        Sbk_QSizePolicy_TypeF(), "Minimum", (long) QSizePolicy::Policy::Minimum))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX],
        Sbk_QSizePolicy_TypeF(), "Maximum", (long) QSizePolicy::Policy::Maximum))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX],
        Sbk_QSizePolicy_TypeF(), "Preferred", (long) QSizePolicy::Policy::Preferred))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX],
        Sbk_QSizePolicy_TypeF(), "MinimumExpanding", (long) QSizePolicy::Policy::MinimumExpanding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX],
        Sbk_QSizePolicy_TypeF(), "Expanding", (long) QSizePolicy::Policy::Expanding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX],
        Sbk_QSizePolicy_TypeF(), "Ignored", (long) QSizePolicy::Policy::Ignored))
        return;
    // Register converter for enum 'QSizePolicy::Policy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX],
            QSizePolicy_Policy_CppToPython_QSizePolicy_Policy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSizePolicy_Policy_PythonToCpp_QSizePolicy_Policy,
            is_QSizePolicy_Policy_PythonToCpp_QSizePolicy_Policy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSizePolicy::Policy");
        Shiboken::Conversions::registerConverterName(converter, "Policy");
    }
    // End of 'Policy' enum.

    // Initialization of enum 'ControlType'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QSizePolicy.ControlTypes", SbkPySide2_QtWidgets_QSizePolicy_ControlType_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSizePolicy_TypeF(),
        "ControlType",
        "2:PySide2.QtWidgets.QSizePolicy.ControlType",
        "QSizePolicy::ControlType",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "DefaultType", (long) QSizePolicy::ControlType::DefaultType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "ButtonBox", (long) QSizePolicy::ControlType::ButtonBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "CheckBox", (long) QSizePolicy::ControlType::CheckBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "ComboBox", (long) QSizePolicy::ControlType::ComboBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "Frame", (long) QSizePolicy::ControlType::Frame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "GroupBox", (long) QSizePolicy::ControlType::GroupBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "Label", (long) QSizePolicy::ControlType::Label))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "Line", (long) QSizePolicy::ControlType::Line))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "LineEdit", (long) QSizePolicy::ControlType::LineEdit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "PushButton", (long) QSizePolicy::ControlType::PushButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "RadioButton", (long) QSizePolicy::ControlType::RadioButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "Slider", (long) QSizePolicy::ControlType::Slider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "SpinBox", (long) QSizePolicy::ControlType::SpinBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "TabWidget", (long) QSizePolicy::ControlType::TabWidget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
        Sbk_QSizePolicy_TypeF(), "ToolButton", (long) QSizePolicy::ControlType::ToolButton))
        return;
    // Register converter for enum 'QSizePolicy::ControlType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX],
            QSizePolicy_ControlType_CppToPython_QSizePolicy_ControlType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSizePolicy_ControlType_PythonToCpp_QSizePolicy_ControlType,
            is_QSizePolicy_ControlType_PythonToCpp_QSizePolicy_ControlType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSizePolicy::ControlType");
        Shiboken::Conversions::registerConverterName(converter, "ControlType");
    }
    // Register converter for flag 'QFlags<QSizePolicy::ControlType>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX],
            QFlags_QSizePolicy_ControlType__CppToPython_QFlags_QSizePolicy_ControlType_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSizePolicy_ControlType_PythonToCpp_QFlags_QSizePolicy_ControlType_,
            is_QSizePolicy_ControlType_PythonToCpp_QFlags_QSizePolicy_ControlType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSizePolicy_ControlType__PythonToCpp_QFlags_QSizePolicy_ControlType_,
            is_QFlags_QSizePolicy_ControlType__PythonToCpp_QFlags_QSizePolicy_ControlType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSizePolicy_ControlType_,
            is_number_PythonToCpp_QFlags_QSizePolicy_ControlType__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSizePolicy::ControlTypes");
        Shiboken::Conversions::registerConverterName(converter, "ControlTypes");
    }
    // End of 'ControlType' enum/flags.

    qRegisterMetaType< ::QSizePolicy >("QSizePolicy");
    qRegisterMetaType< ::QSizePolicy::PolicyFlag >("QSizePolicy::PolicyFlag");
    qRegisterMetaType< ::QSizePolicy::Policy >("QSizePolicy::Policy");
    qRegisterMetaType< ::QSizePolicy::ControlType >("QSizePolicy::ControlType");
    qRegisterMetaType< ::QSizePolicy::ControlTypes >("QSizePolicy::ControlTypes");
}
