/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QMDISUBWINDOWWRAPPER_H
#define SBK_QMDISUBWINDOWWRAPPER_H

#define protected public

#include <QtWidgets/qmdisubwindow.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qwidget.h>
#include <qsize.h>
#include <QtWidgets/qmenu.h>
#include <QtWidgets/qmdiarea.h>
#include <qcoreevent.h>
#include <QtGui/qevent.h>
#include <QtGui/qcursor.h>
#include <QtWidgets/qlayout.h>
#include <QtWidgets/qaction.h>
#include <QtGui/qicon.h>
#include <QtWidgets/qgraphicseffect.h>
#include <QtGui/qwindow.h>
#include <qpoint.h>
#include <qrect.h>
#include <QtGui/qfont.h>
#include <QtGui/qbackingstore.h>
#include <qmetaobject.h>
#include <QtGui/qpaintdevice.h>
#include <QtGui/qregion.h>
#include <QtGui/qfontinfo.h>
#include <qbytearray.h>
#include <QtGui/qpalette.h>
#include <QtWidgets/qstyle.h>
#include <QtGui/qpaintengine.h>
#include <qobjectdefs.h>
#include <QtGui/qpainter.h>
#include <QList>
#include <qmargins.h>
#include <QtGui/qscreen.h>
#include <QtGui/qfontmetrics.h>
#include <QtWidgets/qsizepolicy.h>
#include <QtGui/qbitmap.h>
#include <QtWidgets/qgraphicsproxywidget.h>
#include <QtGui/qpixmap.h>
#include <QtGui/qkeysequence.h>
#include <qlocale.h>
namespace PySide { class DynamicQMetaObject; }

class QMdiSubWindowWrapper : public QMdiSubWindow
{
public:
    QMdiSubWindowWrapper(::QWidget * parent = nullptr, ::QFlags<Qt::WindowType> flags = Qt::WindowFlags());
    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * changeEvent) override;
    void childEvent(::QChildEvent * childEvent) override;
    void closeEvent(::QCloseEvent * closeEvent) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * contextMenuEvent) override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * event) override;
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    void dragMoveEvent(::QDragMoveEvent * event) override;
    void dropEvent(::QDropEvent * event) override;
    void enterEvent(::QEvent * event) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * object, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * focusInEvent) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * focusOutEvent) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * hideEvent) override;
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent(::QKeyEvent * keyEvent) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    void leaveEvent(::QEvent * leaveEvent) override;
    const ::QMetaObject * metaObject() const override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * mouseEvent) override;
    void mouseMoveEvent(::QMouseEvent * mouseEvent) override;
    void mousePressEvent(::QMouseEvent * mouseEvent) override;
    void mouseReleaseEvent(::QMouseEvent * mouseEvent) override;
    void moveEvent(::QMoveEvent * moveEvent) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, long * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * paintEvent) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * resizeEvent) override;
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * showEvent) override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * timerEvent) override;
    void wheelEvent(::QWheelEvent * event) override;
    ~QMdiSubWindowWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[48];
};

#endif // SBK_QMDISUBWINDOWWRAPPER_H

