/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QLISTWIDGETITEMWRAPPER_H
#define SBK_QLISTWIDGETITEMWRAPPER_H

#define protected public

#include <QtWidgets/qlistwidget.h>


// Extra includes
#include <QtWidgets/qlistwidget.h>
#include <QtGui/qicon.h>
#include <QtGui/qfont.h>
#include <QtGui/qcolor.h>
#include <QtGui/qbrush.h>
#include <qsize.h>
#include <qdatastream.h>
class QListWidgetItemWrapper : public QListWidgetItem
{
public:
    QListWidgetItemWrapper(::QListWidget * listview = nullptr, int type = Type);
    QListWidgetItemWrapper(const ::QIcon & icon, const ::QString & text, ::QListWidget * listview = nullptr, int type = Type);
    QListWidgetItemWrapper(const QListWidgetItem& self) : QListWidgetItem(self)
    {
    }

    QListWidgetItemWrapper(const ::QString & text, ::QListWidget * listview = nullptr, int type = Type);
    ::QListWidgetItem * clone() const override;
    ::QVariant data(int role) const override;
    bool operator<(const ::QListWidgetItem & other) const override;
    void read(::QDataStream & in) override;
    void setBackgroundColor(const ::QColor & color) override;
    void setData(int role, const ::QVariant & value) override;
    void write(::QDataStream & out) const override;
    ~QListWidgetItemWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[7];
};

#endif // SBK_QLISTWIDGETITEMWRAPPER_H

