/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qgraphicsscenedragdropevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGraphicsSceneDragDropEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGraphicsSceneDragDropEventWrapper::QGraphicsSceneDragDropEventWrapper(::QEvent::Type type) : QGraphicsSceneDragDropEvent(type)
{
    resetPyMethodCache();
    // ... middle
}

QGraphicsSceneDragDropEventWrapper::~QGraphicsSceneDragDropEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGraphicsSceneDragDropEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGraphicsSceneDragDropEvent >()))
        return -1;

    ::QGraphicsSceneDragDropEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsSceneDragDropEvent_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QGraphicsSceneDragDropEvent", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::QGraphicsSceneDragDropEvent(QEvent::Type)
    if (numArgs == 0) {
        overloadId = 0; // QGraphicsSceneDragDropEvent(QEvent::Type)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QGraphicsSceneDragDropEvent(QEvent::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEvent_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[0]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsSceneDragDropEvent_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QGraphicsSceneDragDropEvent_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsSceneDragDropEvent_Init_TypeError;
            }
        }
        ::QEvent::Type cppArg0 = QEvent::Type::None;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGraphicsSceneDragDropEvent(QEvent::Type)
            cptr = new ::QGraphicsSceneDragDropEventWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGraphicsSceneDragDropEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGraphicsSceneDragDropEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGraphicsSceneDragDropEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_acceptProposedAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.acceptProposedAction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // acceptProposedAction()
            cppSelf->acceptProposedAction();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_buttons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.buttons";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buttons()const
            QFlags<Qt::MouseButton> cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->buttons();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_dropAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.dropAction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dropAction()const
            Qt::DropAction cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->dropAction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_mimeData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.mimeData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mimeData()const
            const QMimeData * cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->mimeData();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_modifiers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.modifiers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // modifiers()const
            QFlags<Qt::KeyboardModifier> cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->modifiers();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            QPointF cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_possibleActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.possibleActions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // possibleActions()const
            QFlags<Qt::DropAction> cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->possibleActions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_proposedAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.proposedAction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // proposedAction()const
            Qt::DropAction cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->proposedAction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_scenePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.scenePos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scenePos()const
            QPointF cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->scenePos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_screenPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.screenPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // screenPos()const
            QPoint cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->screenPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_setButtons(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setButtons";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::setButtons(QFlags<Qt::MouseButton>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setButtons(QFlags<Qt::MouseButton>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEventFunc_setButtons_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::MouseButton> cppArg0 = QFlags<Qt::MouseButton>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setButtons(QFlags<Qt::MouseButton>)
            cppSelf->setButtons(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneDragDropEventFunc_setButtons_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_setDropAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setDropAction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::setDropAction(Qt::DropAction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDropAction(Qt::DropAction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEventFunc_setDropAction_TypeError;

    // Call function/method
    {
        ::Qt::DropAction cppArg0{Qt::IgnoreAction};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDropAction(Qt::DropAction)
            cppSelf->setDropAction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneDragDropEventFunc_setDropAction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_setModifiers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setModifiers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::setModifiers(QFlags<Qt::KeyboardModifier>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setModifiers(QFlags<Qt::KeyboardModifier>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEventFunc_setModifiers_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::KeyboardModifier> cppArg0 = QFlags<Qt::KeyboardModifier>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setModifiers(QFlags<Qt::KeyboardModifier>)
            cppSelf->setModifiers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneDragDropEventFunc_setModifiers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_setPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::setPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEventFunc_setPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPos(QPointF)
            cppSelf->setPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneDragDropEventFunc_setPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_setPossibleActions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setPossibleActions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::setPossibleActions(QFlags<Qt::DropAction>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPossibleActions(QFlags<Qt::DropAction>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEventFunc_setPossibleActions_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::DropAction> cppArg0 = QFlags<Qt::DropAction>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPossibleActions(QFlags<Qt::DropAction>)
            cppSelf->setPossibleActions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneDragDropEventFunc_setPossibleActions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_setProposedAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setProposedAction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::setProposedAction(Qt::DropAction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setProposedAction(Qt::DropAction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEventFunc_setProposedAction_TypeError;

    // Call function/method
    {
        ::Qt::DropAction cppArg0{Qt::IgnoreAction};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProposedAction(Qt::DropAction)
            cppSelf->setProposedAction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneDragDropEventFunc_setProposedAction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_setScenePos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setScenePos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::setScenePos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setScenePos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEventFunc_setScenePos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScenePos(QPointF)
            cppSelf->setScenePos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneDragDropEventFunc_setScenePos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_setScreenPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setScreenPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsSceneDragDropEvent::setScreenPos(QPoint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // setScreenPos(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsSceneDragDropEventFunc_setScreenPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScreenPos(QPoint)
            cppSelf->setScreenPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsSceneDragDropEventFunc_setScreenPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsSceneDragDropEventFunc_source(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.source";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // source()const
            QWidget * cppResult = const_cast<const ::QGraphicsSceneDragDropEvent *>(cppSelf)->source();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGraphicsSceneDragDropEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGraphicsSceneDragDropEvent_methods[] = {
    {"acceptProposedAction", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_acceptProposedAction), METH_NOARGS},
    {"buttons", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_buttons), METH_NOARGS},
    {"dropAction", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_dropAction), METH_NOARGS},
    {"mimeData", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_mimeData), METH_NOARGS},
    {"modifiers", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_modifiers), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_pos), METH_NOARGS},
    {"possibleActions", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_possibleActions), METH_NOARGS},
    {"proposedAction", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_proposedAction), METH_NOARGS},
    {"scenePos", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_scenePos), METH_NOARGS},
    {"screenPos", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_screenPos), METH_NOARGS},
    {"setButtons", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_setButtons), METH_O},
    {"setDropAction", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_setDropAction), METH_O},
    {"setModifiers", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_setModifiers), METH_O},
    {"setPos", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_setPos), METH_O},
    {"setPossibleActions", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_setPossibleActions), METH_O},
    {"setProposedAction", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_setProposedAction), METH_O},
    {"setScenePos", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_setScenePos), METH_O},
    {"setScreenPos", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_setScreenPos), METH_O},
    {"source", reinterpret_cast<PyCFunction>(Sbk_QGraphicsSceneDragDropEventFunc_source), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGraphicsSceneDragDropEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGraphicsSceneDragDropEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGraphicsSceneDragDropEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGraphicsSceneDragDropEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGraphicsSceneDragDropEvent_Type = nullptr;
static SbkObjectType *Sbk_QGraphicsSceneDragDropEvent_TypeF(void)
{
    return _Sbk_QGraphicsSceneDragDropEvent_Type;
}

static PyType_Slot Sbk_QGraphicsSceneDragDropEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGraphicsSceneDragDropEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGraphicsSceneDragDropEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGraphicsSceneDragDropEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGraphicsSceneDragDropEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGraphicsSceneDragDropEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGraphicsSceneDragDropEvent_spec = {
    "2:PySide2.QtWidgets.QGraphicsSceneDragDropEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGraphicsSceneDragDropEvent_slots
};

} //extern "C"

static void *Sbk_QGraphicsSceneDragDropEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(cptr)->type() == QEvent::GraphicsSceneDragEnter ||  reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(cptr)->type() == QEvent::GraphicsSceneDragLeave ||  reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(cptr)->type() == QEvent::GraphicsSceneDragMove ||  reinterpret_cast< ::QGraphicsSceneDragDropEvent *>(cptr)->type() == QEvent::GraphicsSceneDrop)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGraphicsSceneDragDropEvent_PythonToCpp_QGraphicsSceneDragDropEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGraphicsSceneDragDropEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGraphicsSceneDragDropEvent_PythonToCpp_QGraphicsSceneDragDropEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsSceneDragDropEvent_TypeF())))
        return QGraphicsSceneDragDropEvent_PythonToCpp_QGraphicsSceneDragDropEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGraphicsSceneDragDropEvent_PTR_CppToPython_QGraphicsSceneDragDropEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGraphicsSceneDragDropEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGraphicsSceneDragDropEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGraphicsSceneDragDropEvent_SignatureStrings[] = {
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent(self,type:PySide2.QtCore.QEvent.Type=None)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.acceptProposedAction(self)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.buttons(self)->PySide2.QtCore.Qt.MouseButtons",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.dropAction(self)->PySide2.QtCore.Qt.DropAction",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.mimeData(self)->PySide2.QtCore.QMimeData",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.modifiers(self)->PySide2.QtCore.Qt.KeyboardModifiers",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.pos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.possibleActions(self)->PySide2.QtCore.Qt.DropActions",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.proposedAction(self)->PySide2.QtCore.Qt.DropAction",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.scenePos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.screenPos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setButtons(self,buttons:PySide2.QtCore.Qt.MouseButtons)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setDropAction(self,action:PySide2.QtCore.Qt.DropAction)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setModifiers(self,modifiers:PySide2.QtCore.Qt.KeyboardModifiers)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setPos(self,pos:PySide2.QtCore.QPointF)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setPossibleActions(self,actions:PySide2.QtCore.Qt.DropActions)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setProposedAction(self,action:PySide2.QtCore.Qt.DropAction)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setScenePos(self,pos:PySide2.QtCore.QPointF)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.setScreenPos(self,pos:PySide2.QtCore.QPoint)",
    "PySide2.QtWidgets.QGraphicsSceneDragDropEvent.source(self)->PySide2.QtWidgets.QWidget",
    nullptr}; // Sentinel

void init_QGraphicsSceneDragDropEvent(PyObject *module)
{
    _Sbk_QGraphicsSceneDragDropEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGraphicsSceneDragDropEvent",
        "QGraphicsSceneDragDropEvent*",
        &Sbk_QGraphicsSceneDragDropEvent_spec,
        &Shiboken::callCppDestructor< ::QGraphicsSceneDragDropEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsSceneDragDropEvent_Type);
    InitSignatureStrings(pyType, QGraphicsSceneDragDropEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsSceneDragDropEvent_Type), Sbk_QGraphicsSceneDragDropEvent_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSSCENEDRAGDROPEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsSceneDragDropEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGraphicsSceneDragDropEvent_TypeF(),
        QGraphicsSceneDragDropEvent_PythonToCpp_QGraphicsSceneDragDropEvent_PTR,
        is_QGraphicsSceneDragDropEvent_PythonToCpp_QGraphicsSceneDragDropEvent_PTR_Convertible,
        QGraphicsSceneDragDropEvent_PTR_CppToPython_QGraphicsSceneDragDropEvent);

    Shiboken::Conversions::registerConverterName(converter, "QGraphicsSceneDragDropEvent");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsSceneDragDropEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsSceneDragDropEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsSceneDragDropEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsSceneDragDropEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGraphicsSceneDragDropEvent_TypeF(), &Sbk_QGraphicsSceneDragDropEvent_typeDiscovery);

}
