/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qgestureevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGestureEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGestureEventWrapper::QGestureEventWrapper(const ::QList<QGesture* > & gestures) : QGestureEvent(gestures)
{
    resetPyMethodCache();
    // ... middle
}

QGestureEventWrapper::~QGestureEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGestureEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGestureEvent >()))
        return -1;

    ::QGestureEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGestureEvent", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGestureEvent::QGestureEvent(QList<QGesture*>)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGESTUREPTR_IDX], (pyArgs[0])))) {
        overloadId = 0; // QGestureEvent(QList<QGesture*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureEvent_Init_TypeError;

    // Call function/method
    {
        ::QList<QGesture* > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGestureEvent(QList<QGesture*>)
            cptr = new ::QGestureEventWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGestureEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGestureEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGestureEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGestureEventFunc_accept(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.accept";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "accept", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGestureEvent::accept(QGesture*)
    // 1: QEvent::accept()
    // 2: QGestureEvent::accept(Qt::GestureType)
    if (numArgs == 0) {
        overloadId = 1; // accept()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 2; // accept(Qt::GestureType)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // accept(QGesture*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureEventFunc_accept_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // accept(QGesture * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QGesture *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // accept(QGesture*)
                cppSelf->accept(cppArg0);
            }
            break;
        }
        case 1: // accept()
        {

            if (!PyErr_Occurred()) {
                // accept()
                reinterpret_cast<QEvent *>(cppSelf)->accept();
            }
            break;
        }
        case 2: // accept(Qt::GestureType arg__1)
        {
            ::Qt::GestureType cppArg0 = static_cast< ::Qt::GestureType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // accept(Qt::GestureType)
                cppSelf->accept(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGestureEventFunc_accept_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureEventFunc_activeGestures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.activeGestures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeGestures()const
            QList<QGesture* > cppResult = const_cast<const ::QGestureEvent *>(cppSelf)->activeGestures();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGESTUREPTR_IDX], &cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGestureEventFunc_canceledGestures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.canceledGestures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canceledGestures()const
            QList<QGesture* > cppResult = const_cast<const ::QGestureEvent *>(cppSelf)->canceledGestures();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGESTUREPTR_IDX], &cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGestureEventFunc_gesture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.gesture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGestureEvent::gesture(Qt::GestureType)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // gesture(Qt::GestureType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureEventFunc_gesture_TypeError;

    // Call function/method
    {
        ::Qt::GestureType cppArg0 = static_cast< ::Qt::GestureType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // gesture(Qt::GestureType)const
            QGesture * cppResult = const_cast<const ::QGestureEvent *>(cppSelf)->gesture(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGestureEventFunc_gesture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureEventFunc_gestures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.gestures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gestures()const
            QList<QGesture* > cppResult = const_cast<const ::QGestureEvent *>(cppSelf)->gestures();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGESTUREPTR_IDX], &cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGestureEventFunc_ignore(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.ignore";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "ignore", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGestureEvent::ignore(QGesture*)
    // 1: QEvent::ignore()
    // 2: QGestureEvent::ignore(Qt::GestureType)
    if (numArgs == 0) {
        overloadId = 1; // ignore()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 2; // ignore(Qt::GestureType)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // ignore(QGesture*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureEventFunc_ignore_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // ignore(QGesture * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QGesture *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // ignore(QGesture*)
                cppSelf->ignore(cppArg0);
            }
            break;
        }
        case 1: // ignore()
        {

            if (!PyErr_Occurred()) {
                // ignore()
                reinterpret_cast<QEvent *>(cppSelf)->ignore();
            }
            break;
        }
        case 2: // ignore(Qt::GestureType arg__1)
        {
            ::Qt::GestureType cppArg0 = static_cast< ::Qt::GestureType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // ignore(Qt::GestureType)
                cppSelf->ignore(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGestureEventFunc_ignore_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureEventFunc_isAccepted(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.isAccepted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isAccepted", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGestureEvent::isAccepted(QGesture*)const
    // 1: QEvent::isAccepted()const
    // 2: QGestureEvent::isAccepted(Qt::GestureType)const
    if (numArgs == 0) {
        overloadId = 1; // isAccepted()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 2; // isAccepted(Qt::GestureType)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // isAccepted(QGesture*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureEventFunc_isAccepted_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isAccepted(QGesture * arg__1) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QGesture *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // isAccepted(QGesture*)const
                bool cppResult = const_cast<const ::QGestureEvent *>(cppSelf)->isAccepted(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isAccepted() const
        {

            if (!PyErr_Occurred()) {
                // isAccepted()const
                bool cppResult = const_cast<const ::QEvent *>(reinterpret_cast<QEvent *>(cppSelf))->isAccepted();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // isAccepted(Qt::GestureType arg__1) const
        {
            ::Qt::GestureType cppArg0 = static_cast< ::Qt::GestureType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // isAccepted(Qt::GestureType)const
                bool cppResult = const_cast<const ::QGestureEvent *>(cppSelf)->isAccepted(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGestureEventFunc_isAccepted_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureEventFunc_mapToGraphicsScene(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.mapToGraphicsScene";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGestureEvent::mapToGraphicsScene(QPointF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // mapToGraphicsScene(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureEventFunc_mapToGraphicsScene_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapToGraphicsScene(QPointF)const
            QPointF cppResult = const_cast<const ::QGestureEvent *>(cppSelf)->mapToGraphicsScene(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGestureEventFunc_mapToGraphicsScene_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureEventFunc_setAccepted(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.setAccepted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAccepted", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGestureEvent::setAccepted(QGesture*,bool)
    // 1: QEvent::setAccepted(bool)
    // 2: QGestureEvent::setAccepted(Qt::GestureType,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 2; // setAccepted(Qt::GestureType,bool)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 1; // setAccepted(bool)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setAccepted(QGesture*,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureEventFunc_setAccepted_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAccepted(QGesture * arg__1, bool arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QGesture *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setAccepted(QGesture*,bool)
                cppSelf->setAccepted(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setAccepted(bool accepted)
        {
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setAccepted(bool)
                reinterpret_cast<QEvent *>(cppSelf)->setAccepted(cppArg0);
            }
            break;
        }
        case 2: // setAccepted(Qt::GestureType arg__1, bool arg__2)
        {
            ::Qt::GestureType cppArg0 = static_cast< ::Qt::GestureType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setAccepted(Qt::GestureType,bool)
                cppSelf->setAccepted(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGestureEventFunc_setAccepted_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureEventFunc_setWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.setWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGestureEvent::setWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // setWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGestureEventFunc_setWidget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidget(QWidget*)
            cppSelf->setWidget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGestureEventFunc_setWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGestureEventFunc_widget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGestureEvent.widget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // widget()const
            QWidget * cppResult = const_cast<const ::QGestureEvent *>(cppSelf)->widget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGestureEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGestureEvent_methods[] = {
    {"accept", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_accept), METH_VARARGS},
    {"activeGestures", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_activeGestures), METH_NOARGS},
    {"canceledGestures", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_canceledGestures), METH_NOARGS},
    {"gesture", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_gesture), METH_O},
    {"gestures", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_gestures), METH_NOARGS},
    {"ignore", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_ignore), METH_VARARGS},
    {"isAccepted", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_isAccepted), METH_VARARGS},
    {"mapToGraphicsScene", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_mapToGraphicsScene), METH_O},
    {"setAccepted", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_setAccepted), METH_VARARGS},
    {"setWidget", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_setWidget), METH_O},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_QGestureEventFunc_widget), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGestureEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGestureEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGestureEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGestureEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QGestureEvent__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGestureEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGestureEvent_Type = nullptr;
static SbkObjectType *Sbk_QGestureEvent_TypeF(void)
{
    return _Sbk_QGestureEvent_Type;
}

static PyType_Slot Sbk_QGestureEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QGestureEvent__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGestureEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGestureEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGestureEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGestureEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGestureEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGestureEvent_spec = {
    "2:PySide2.QtWidgets.QGestureEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGestureEvent_slots
};

} //extern "C"

static void *Sbk_QGestureEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QGestureEvent *>(cptr)->type() == QEvent::Gesture ||  reinterpret_cast< ::QGestureEvent *>(cptr)->type() == QEvent::GestureOverride)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGestureEvent_PythonToCpp_QGestureEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGestureEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGestureEvent_PythonToCpp_QGestureEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGestureEvent_TypeF())))
        return QGestureEvent_PythonToCpp_QGestureEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGestureEvent_PTR_CppToPython_QGestureEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGestureEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGestureEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGestureEvent_SignatureStrings[] = {
    "PySide2.QtWidgets.QGestureEvent(self,gestures:QList[PySide2.QtWidgets.QGesture])",
    "2:PySide2.QtWidgets.QGestureEvent.accept(self,arg__1:PySide2.QtWidgets.QGesture)",
    "1:PySide2.QtWidgets.QGestureEvent.accept(self)",
    "0:PySide2.QtWidgets.QGestureEvent.accept(self,arg__1:PySide2.QtCore.Qt.GestureType)",
    "PySide2.QtWidgets.QGestureEvent.activeGestures(self)->QList[PySide2.QtWidgets.QGesture]",
    "PySide2.QtWidgets.QGestureEvent.canceledGestures(self)->QList[PySide2.QtWidgets.QGesture]",
    "PySide2.QtWidgets.QGestureEvent.gesture(self,type:PySide2.QtCore.Qt.GestureType)->PySide2.QtWidgets.QGesture",
    "PySide2.QtWidgets.QGestureEvent.gestures(self)->QList[PySide2.QtWidgets.QGesture]",
    "2:PySide2.QtWidgets.QGestureEvent.ignore(self,arg__1:PySide2.QtWidgets.QGesture)",
    "1:PySide2.QtWidgets.QGestureEvent.ignore(self)",
    "0:PySide2.QtWidgets.QGestureEvent.ignore(self,arg__1:PySide2.QtCore.Qt.GestureType)",
    "2:PySide2.QtWidgets.QGestureEvent.isAccepted(self,arg__1:PySide2.QtWidgets.QGesture)->bool",
    "1:PySide2.QtWidgets.QGestureEvent.isAccepted(self)->bool",
    "0:PySide2.QtWidgets.QGestureEvent.isAccepted(self,arg__1:PySide2.QtCore.Qt.GestureType)->bool",
    "PySide2.QtWidgets.QGestureEvent.mapToGraphicsScene(self,gesturePoint:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "2:PySide2.QtWidgets.QGestureEvent.setAccepted(self,arg__1:PySide2.QtWidgets.QGesture,arg__2:bool)",
    "1:PySide2.QtWidgets.QGestureEvent.setAccepted(self,accepted:bool)",
    "0:PySide2.QtWidgets.QGestureEvent.setAccepted(self,arg__1:PySide2.QtCore.Qt.GestureType,arg__2:bool)",
    "PySide2.QtWidgets.QGestureEvent.setWidget(self,widget:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QGestureEvent.widget(self)->PySide2.QtWidgets.QWidget",
    nullptr}; // Sentinel

void init_QGestureEvent(PyObject *module)
{
    _Sbk_QGestureEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGestureEvent",
        "QGestureEvent*",
        &Sbk_QGestureEvent_spec,
        &Shiboken::callCppDestructor< ::QGestureEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGestureEvent_Type);
    InitSignatureStrings(pyType, QGestureEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGestureEvent_Type), Sbk_QGestureEvent_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QGESTUREEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGestureEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGestureEvent_TypeF(),
        QGestureEvent_PythonToCpp_QGestureEvent_PTR,
        is_QGestureEvent_PythonToCpp_QGestureEvent_PTR_Convertible,
        QGestureEvent_PTR_CppToPython_QGestureEvent);

    Shiboken::Conversions::registerConverterName(converter, "QGestureEvent");
    Shiboken::Conversions::registerConverterName(converter, "QGestureEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QGestureEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGestureEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGestureEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGestureEvent_TypeF(), &Sbk_QGestureEvent_typeDiscovery);

}
