/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qcompleter_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QCompleterWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QCompleterWrapper::QCompleterWrapper(::QAbstractItemModel * model, ::QObject * parent) : QCompleter(model, parent)
{
    resetPyMethodCache();
    // ... middle
}

QCompleterWrapper::QCompleterWrapper(::QObject * parent) : QCompleter(parent)
{
    resetPyMethodCache();
    // ... middle
}

QCompleterWrapper::QCompleterWrapper(const ::QStringList & completions, ::QObject * parent) : QCompleter(completions, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QCompleterWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCompleterWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCompleterWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCompleterWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCompleterWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[4])
        return this->::QCompleter::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QCompleter::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCompleter.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCompleterWrapper::eventFilter(::QObject * o, ::QEvent * e)
{
    if (m_PyMethodCache[5])
        return this->::QCompleter::eventFilter(o, e);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QCompleter::eventFilter(o, e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), o),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), e)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCompleter.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QString QCompleterWrapper::pathFromIndex(const ::QModelIndex & index) const
{
    if (m_PyMethodCache[7])
        return this->::QCompleter::pathFromIndex(index);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "pathFromIndex";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QCompleter::pathFromIndex(index);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCompleter.pathFromIndex", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QStringList QCompleterWrapper::splitPath(const ::QString & path) const
{
    if (m_PyMethodCache[8])
        return this->::QCompleter::splitPath(path);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QStringList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "splitPath";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QCompleter::splitPath(path);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &path)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QStringList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCompleter.splitPath", "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QCompleterWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QCompleterWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QCompleter::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCompleterWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QCompleter::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCompleterWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCompleterWrapper *>(this));
        return QCompleter::qt_metacast(_clname);
}

QCompleterWrapper::~QCompleterWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCompleter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCompleter >()))
        return -1;

    ::QCompleterWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QCompleter", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QCompleter::QCompleter(QAbstractItemModel*,QObject*)
    // 1: QCompleter::QCompleter(QObject*)
    // 2: QCompleter::QCompleter(QStringList,QObject*)
    if (numArgs == 0) {
        overloadId = 1; // QCompleter(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QCompleter(QStringList,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QCompleter(QStringList,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QCompleter(QAbstractItemModel*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QCompleter(QAbstractItemModel*,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCompleter(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleter_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCompleter(QAbstractItemModel * model, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QCompleter_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QCompleter_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QCompleter(QAbstractItemModel*,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCompleterWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCompleterWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 1: // QCompleter(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QCompleter_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QCompleter_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCompleter(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCompleterWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCompleterWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 2: // QCompleter(const QStringList & completions, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QCompleter_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QCompleter_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QCompleter(QStringList,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCompleterWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCompleterWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCompleter >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCompleter_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QCompleter_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QCompleter_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCompleterFunc_caseSensitivity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.caseSensitivity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // caseSensitivity()const
            Qt::CaseSensitivity cppResult = const_cast<const ::QCompleter *>(cppSelf)->caseSensitivity();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_complete(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.complete";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCompleterFunc_complete_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:complete", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCompleter::complete(QRect)
    if (numArgs == 0) {
        overloadId = 0; // complete(QRect)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // complete(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_complete_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_rect = Shiboken::String::createStaticString("rect");
            if (PyDict_Contains(kwds, key_rect)) {
                value = PyDict_GetItem(kwds, key_rect);
                if (value && pyArgs[0]) {
                    errInfo = key_rect;
                    Py_INCREF(errInfo);
                    goto Sbk_QCompleterFunc_complete_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QCompleterFunc_complete_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_rect);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCompleterFunc_complete_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRect cppArg0_local = QRect();
        ::QRect *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // complete(QRect)
            cppSelf->complete(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_complete_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_completionColumn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.completionColumn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // completionColumn()const
            int cppResult = const_cast<const ::QCompleter *>(cppSelf)->completionColumn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_completionCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.completionCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // completionCount()const
            int cppResult = const_cast<const ::QCompleter *>(cppSelf)->completionCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_completionMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.completionMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // completionMode()const
            QCompleter::CompletionMode cppResult = const_cast<const ::QCompleter *>(cppSelf)->completionMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_completionModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.completionModel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // completionModel()const
            QAbstractItemModel * cppResult = const_cast<const ::QCompleter *>(cppSelf)->completionModel();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_completionPrefix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.completionPrefix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // completionPrefix()const
            QString cppResult = const_cast<const ::QCompleter *>(cppSelf)->completionPrefix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_completionRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.completionRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // completionRole()const
            int cppResult = const_cast<const ::QCompleter *>(cppSelf)->completionRole();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_currentCompletion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.currentCompletion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentCompletion()const
            QString cppResult = const_cast<const ::QCompleter *>(cppSelf)->currentCompletion();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_currentIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.currentIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentIndex()const
            QModelIndex cppResult = const_cast<const ::QCompleter *>(cppSelf)->currentIndex();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_currentRow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.currentRow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentRow()const
            int cppResult = const_cast<const ::QCompleter *>(cppSelf)->currentRow();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QCompleter::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCompleterFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.eventFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_eventFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QCompleter::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCompleterFunc_eventFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_filterMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.filterMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filterMode()const
            QFlags<Qt::MatchFlag> cppResult = const_cast<const ::QCompleter *>(cppSelf)->filterMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_maxVisibleItems(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.maxVisibleItems";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxVisibleItems()const
            int cppResult = const_cast<const ::QCompleter *>(cppSelf)->maxVisibleItems();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.model";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // model()const
            QAbstractItemModel * cppResult = const_cast<const ::QCompleter *>(cppSelf)->model();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_modelSorting(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.modelSorting";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // modelSorting()const
            QCompleter::ModelSorting cppResult = const_cast<const ::QCompleter *>(cppSelf)->modelSorting();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_pathFromIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.pathFromIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::pathFromIndex(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // pathFromIndex(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_pathFromIndex_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // pathFromIndex(QModelIndex)const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QCompleter *>(cppSelf)->::QCompleter::pathFromIndex(*cppArg0)
                : const_cast<const ::QCompleter *>(cppSelf)->pathFromIndex(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCompleterFunc_pathFromIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_popup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.popup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // popup()const
            QAbstractItemView * cppResult = const_cast<const ::QCompleter *>(cppSelf)->popup();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_setCaseSensitivity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setCaseSensitivity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setCaseSensitivity(Qt::CaseSensitivity)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCaseSensitivity(Qt::CaseSensitivity)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setCaseSensitivity_TypeError;

    // Call function/method
    {
        ::Qt::CaseSensitivity cppArg0{Qt::CaseInsensitive};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCaseSensitivity(Qt::CaseSensitivity)
            cppSelf->setCaseSensitivity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setCaseSensitivity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setCompletionColumn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setCompletionColumn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setCompletionColumn(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCompletionColumn(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setCompletionColumn_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCompletionColumn(int)
            cppSelf->setCompletionColumn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setCompletionColumn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setCompletionMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setCompletionMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setCompletionMode(QCompleter::CompletionMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCompletionMode(QCompleter::CompletionMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setCompletionMode_TypeError;

    // Call function/method
    {
        ::QCompleter::CompletionMode cppArg0{QCompleter::PopupCompletion};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCompletionMode(QCompleter::CompletionMode)
            cppSelf->setCompletionMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setCompletionMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setCompletionPrefix(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setCompletionPrefix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setCompletionPrefix(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCompletionPrefix(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setCompletionPrefix_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCompletionPrefix(QString)
            cppSelf->setCompletionPrefix(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setCompletionPrefix_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setCompletionRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setCompletionRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setCompletionRole(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCompletionRole(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setCompletionRole_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCompletionRole(int)
            cppSelf->setCompletionRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setCompletionRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setCurrentRow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setCurrentRow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setCurrentRow(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentRow(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setCurrentRow_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentRow(int)
            bool cppResult = cppSelf->setCurrentRow(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCompleterFunc_setCurrentRow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setFilterMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setFilterMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setFilterMode(QFlags<Qt::MatchFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFilterMode(QFlags<Qt::MatchFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setFilterMode_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::MatchFlag> cppArg0 = QFlags<Qt::MatchFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFilterMode(QFlags<Qt::MatchFlag>)
            cppSelf->setFilterMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setFilterMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setMaxVisibleItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setMaxVisibleItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setMaxVisibleItems(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaxVisibleItems(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setMaxVisibleItems_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaxVisibleItems(int)
            cppSelf->setMaxVisibleItems(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setMaxVisibleItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setModel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setModel(QAbstractItemModel*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArg)))) {
        overloadId = 0; // setModel(QAbstractItemModel*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setModel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setModel(QAbstractItemModel*)
            cppSelf->setModel(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "setModel(QAbstractItemModel*)1", pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setModel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setModelSorting(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setModelSorting";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setModelSorting(QCompleter::ModelSorting)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setModelSorting(QCompleter::ModelSorting)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setModelSorting_TypeError;

    // Call function/method
    {
        ::QCompleter::ModelSorting cppArg0{QCompleter::UnsortedModel};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setModelSorting(QCompleter::ModelSorting)
            cppSelf->setModelSorting(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setModelSorting_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setPopup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setPopup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setPopup(QAbstractItemView*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMVIEW_IDX]), (pyArg)))) {
        overloadId = 0; // setPopup(QAbstractItemView*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setPopup_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPopup(QAbstractItemView*)
            cppSelf->setPopup(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setPopup_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // setWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setWidget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidget(QWidget*)
            cppSelf->setWidget(cppArg0);
            Shiboken::Object::setParent(pyArg, self);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_setWrapAround(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.setWrapAround";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::setWrapAround(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWrapAround(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_setWrapAround_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapAround(bool)
            cppSelf->setWrapAround(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompleterFunc_setWrapAround_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_splitPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.splitPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompleter::splitPath(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // splitPath(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompleterFunc_splitPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // splitPath(QString)const
            QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QCompleter *>(cppSelf)->::QCompleter::splitPath(cppArg0)
                : const_cast<const ::QCompleter *>(cppSelf)->splitPath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCompleterFunc_splitPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompleterFunc_widget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.widget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // widget()const
            QWidget * cppResult = const_cast<const ::QCompleter *>(cppSelf)->widget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompleterFunc_wrapAround(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QCompleter.wrapAround";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapAround()const
            bool cppResult = const_cast<const ::QCompleter *>(cppSelf)->wrapAround();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCompleter_PropertyStrings[] = {
    "caseSensitivity::",
    "completionColumn::",
    "completionMode::",
    "completionPrefix::",
    "completionRole::",
    "filterMode::",
    "maxVisibleItems::",
    "modelSorting::",
    "wrapAround::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCompleter_methods[] = {
    {"caseSensitivity", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_caseSensitivity), METH_NOARGS},
    {"complete", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_complete), METH_VARARGS|METH_KEYWORDS},
    {"completionColumn", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_completionColumn), METH_NOARGS},
    {"completionCount", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_completionCount), METH_NOARGS},
    {"completionMode", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_completionMode), METH_NOARGS},
    {"completionModel", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_completionModel), METH_NOARGS},
    {"completionPrefix", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_completionPrefix), METH_NOARGS},
    {"completionRole", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_completionRole), METH_NOARGS},
    {"currentCompletion", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_currentCompletion), METH_NOARGS},
    {"currentIndex", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_currentIndex), METH_NOARGS},
    {"currentRow", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_currentRow), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_event), METH_O},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_eventFilter), METH_VARARGS},
    {"filterMode", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_filterMode), METH_NOARGS},
    {"maxVisibleItems", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_maxVisibleItems), METH_NOARGS},
    {"model", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_model), METH_NOARGS},
    {"modelSorting", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_modelSorting), METH_NOARGS},
    {"pathFromIndex", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_pathFromIndex), METH_O},
    {"popup", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_popup), METH_NOARGS},
    {"setCaseSensitivity", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setCaseSensitivity), METH_O},
    {"setCompletionColumn", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setCompletionColumn), METH_O},
    {"setCompletionMode", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setCompletionMode), METH_O},
    {"setCompletionPrefix", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setCompletionPrefix), METH_O},
    {"setCompletionRole", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setCompletionRole), METH_O},
    {"setCurrentRow", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setCurrentRow), METH_O},
    {"setFilterMode", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setFilterMode), METH_O},
    {"setMaxVisibleItems", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setMaxVisibleItems), METH_O},
    {"setModel", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setModel), METH_O},
    {"setModelSorting", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setModelSorting), METH_O},
    {"setPopup", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setPopup), METH_O},
    {"setWidget", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setWidget), METH_O},
    {"setWrapAround", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_setWrapAround), METH_O},
    {"splitPath", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_splitPath), METH_O},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_widget), METH_NOARGS},
    {"wrapAround", reinterpret_cast<PyCFunction>(Sbk_QCompleterFunc_wrapAround), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCompleter_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QCompleter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCompleterWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QCompleter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCompleter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCompleter_Type = nullptr;
static SbkObjectType *Sbk_QCompleter_TypeF(void)
{
    return _Sbk_QCompleter_Type;
}

static PyType_Slot Sbk_QCompleter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QCompleter_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCompleter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCompleter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCompleter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCompleter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCompleter_spec = {
    "2:PySide2.QtWidgets.QCompleter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCompleter_slots
};

} //extern "C"

static void *Sbk_QCompleter_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QCompleter *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QCompleter_CompletionMode_PythonToCpp_QCompleter_CompletionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCompleter::CompletionMode *>(cppOut) =
        static_cast<::QCompleter::CompletionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCompleter_CompletionMode_PythonToCpp_QCompleter_CompletionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX]))
        return QCompleter_CompletionMode_PythonToCpp_QCompleter_CompletionMode;
    return {};
}
static PyObject *QCompleter_CompletionMode_CppToPython_QCompleter_CompletionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCompleter::CompletionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX], castCppIn);

}

static void QCompleter_ModelSorting_PythonToCpp_QCompleter_ModelSorting(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCompleter::ModelSorting *>(cppOut) =
        static_cast<::QCompleter::ModelSorting>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCompleter_ModelSorting_PythonToCpp_QCompleter_ModelSorting_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX]))
        return QCompleter_ModelSorting_PythonToCpp_QCompleter_ModelSorting;
    return {};
}
static PyObject *QCompleter_ModelSorting_CppToPython_QCompleter_ModelSorting(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCompleter::ModelSorting *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCompleter_PythonToCpp_QCompleter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCompleter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCompleter_PythonToCpp_QCompleter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCompleter_TypeF())))
        return QCompleter_PythonToCpp_QCompleter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCompleter_PTR_CppToPython_QCompleter(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QCompleter *>(const_cast<void *>(cppIn)), Sbk_QCompleter_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCompleter_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QCompleter(self,model:PySide2.QtCore.QAbstractItemModel,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtWidgets.QCompleter(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtWidgets.QCompleter(self,completions:QStringList,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtWidgets.QCompleter.caseSensitivity(self)->PySide2.QtCore.Qt.CaseSensitivity",
    "PySide2.QtWidgets.QCompleter.complete(self,rect:PySide2.QtCore.QRect=QRect())",
    "PySide2.QtWidgets.QCompleter.completionColumn(self)->int",
    "PySide2.QtWidgets.QCompleter.completionCount(self)->int",
    "PySide2.QtWidgets.QCompleter.completionMode(self)->PySide2.QtWidgets.QCompleter.CompletionMode",
    "PySide2.QtWidgets.QCompleter.completionModel(self)->PySide2.QtCore.QAbstractItemModel",
    "PySide2.QtWidgets.QCompleter.completionPrefix(self)->QString",
    "PySide2.QtWidgets.QCompleter.completionRole(self)->int",
    "PySide2.QtWidgets.QCompleter.currentCompletion(self)->QString",
    "PySide2.QtWidgets.QCompleter.currentIndex(self)->PySide2.QtCore.QModelIndex",
    "PySide2.QtWidgets.QCompleter.currentRow(self)->int",
    "PySide2.QtWidgets.QCompleter.event(self,arg__1:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QCompleter.eventFilter(self,o:PySide2.QtCore.QObject,e:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QCompleter.filterMode(self)->PySide2.QtCore.Qt.MatchFlags",
    "PySide2.QtWidgets.QCompleter.maxVisibleItems(self)->int",
    "PySide2.QtWidgets.QCompleter.model(self)->PySide2.QtCore.QAbstractItemModel",
    "PySide2.QtWidgets.QCompleter.modelSorting(self)->PySide2.QtWidgets.QCompleter.ModelSorting",
    "PySide2.QtWidgets.QCompleter.pathFromIndex(self,index:PySide2.QtCore.QModelIndex)->QString",
    "PySide2.QtWidgets.QCompleter.popup(self)->PySide2.QtWidgets.QAbstractItemView",
    "PySide2.QtWidgets.QCompleter.setCaseSensitivity(self,caseSensitivity:PySide2.QtCore.Qt.CaseSensitivity)",
    "PySide2.QtWidgets.QCompleter.setCompletionColumn(self,column:int)",
    "PySide2.QtWidgets.QCompleter.setCompletionMode(self,mode:PySide2.QtWidgets.QCompleter.CompletionMode)",
    "PySide2.QtWidgets.QCompleter.setCompletionPrefix(self,prefix:QString)",
    "PySide2.QtWidgets.QCompleter.setCompletionRole(self,role:int)",
    "PySide2.QtWidgets.QCompleter.setCurrentRow(self,row:int)->bool",
    "PySide2.QtWidgets.QCompleter.setFilterMode(self,filterMode:PySide2.QtCore.Qt.MatchFlags)",
    "PySide2.QtWidgets.QCompleter.setMaxVisibleItems(self,maxItems:int)",
    "PySide2.QtWidgets.QCompleter.setModel(self,c:PySide2.QtCore.QAbstractItemModel)",
    "PySide2.QtWidgets.QCompleter.setModelSorting(self,sorting:PySide2.QtWidgets.QCompleter.ModelSorting)",
    "PySide2.QtWidgets.QCompleter.setPopup(self,popup:PySide2.QtWidgets.QAbstractItemView)",
    "PySide2.QtWidgets.QCompleter.setWidget(self,widget:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QCompleter.setWrapAround(self,wrap:bool)",
    "PySide2.QtWidgets.QCompleter.splitPath(self,path:QString)->QStringList",
    "PySide2.QtWidgets.QCompleter.widget(self)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QCompleter.wrapAround(self)->bool",
    nullptr}; // Sentinel

void init_QCompleter(PyObject *module)
{
    _Sbk_QCompleter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCompleter",
        "QCompleter*",
        &Sbk_QCompleter_spec,
        &Shiboken::callCppDestructor< ::QCompleter >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCompleter_Type);
    InitSignatureStrings(pyType, QCompleter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCompleter_Type), Sbk_QCompleter_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCompleter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCompleter_TypeF(),
        QCompleter_PythonToCpp_QCompleter_PTR,
        is_QCompleter_PythonToCpp_QCompleter_PTR_Convertible,
        QCompleter_PTR_CppToPython_QCompleter);

    Shiboken::Conversions::registerConverterName(converter, "QCompleter");
    Shiboken::Conversions::registerConverterName(converter, "QCompleter*");
    Shiboken::Conversions::registerConverterName(converter, "QCompleter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCompleter).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCompleterWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QCompleter_TypeF(), &Sbk_QCompleter_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'CompletionMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCompleter_TypeF(),
        "CompletionMode",
        "2:PySide2.QtWidgets.QCompleter.CompletionMode",
        "QCompleter::CompletionMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX],
        Sbk_QCompleter_TypeF(), "PopupCompletion", (long) QCompleter::CompletionMode::PopupCompletion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX],
        Sbk_QCompleter_TypeF(), "UnfilteredPopupCompletion", (long) QCompleter::CompletionMode::UnfilteredPopupCompletion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX],
        Sbk_QCompleter_TypeF(), "InlineCompletion", (long) QCompleter::CompletionMode::InlineCompletion))
        return;
    // Register converter for enum 'QCompleter::CompletionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX],
            QCompleter_CompletionMode_CppToPython_QCompleter_CompletionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCompleter_CompletionMode_PythonToCpp_QCompleter_CompletionMode,
            is_QCompleter_CompletionMode_PythonToCpp_QCompleter_CompletionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCompleter::CompletionMode");
        Shiboken::Conversions::registerConverterName(converter, "CompletionMode");
    }
    // End of 'CompletionMode' enum.

    // Initialization of enum 'ModelSorting'.
    SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCompleter_TypeF(),
        "ModelSorting",
        "2:PySide2.QtWidgets.QCompleter.ModelSorting",
        "QCompleter::ModelSorting");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX],
        Sbk_QCompleter_TypeF(), "UnsortedModel", (long) QCompleter::ModelSorting::UnsortedModel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX],
        Sbk_QCompleter_TypeF(), "CaseSensitivelySortedModel", (long) QCompleter::ModelSorting::CaseSensitivelySortedModel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX],
        Sbk_QCompleter_TypeF(), "CaseInsensitivelySortedModel", (long) QCompleter::ModelSorting::CaseInsensitivelySortedModel))
        return;
    // Register converter for enum 'QCompleter::ModelSorting'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX],
            QCompleter_ModelSorting_CppToPython_QCompleter_ModelSorting);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCompleter_ModelSorting_PythonToCpp_QCompleter_ModelSorting,
            is_QCompleter_ModelSorting_PythonToCpp_QCompleter_ModelSorting_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QCOMPLETER_MODELSORTING_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCompleter::ModelSorting");
        Shiboken::Conversions::registerConverterName(converter, "ModelSorting");
    }
    // End of 'ModelSorting' enum.

    PySide::Signal::registerSignals(Sbk_QCompleter_TypeF(), &::QCompleter::staticMetaObject);
    qRegisterMetaType< ::QCompleter::CompletionMode >("QCompleter::CompletionMode");
    qRegisterMetaType< ::QCompleter::ModelSorting >("QCompleter::ModelSorting");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QCompleter_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QCompleter_TypeF(), &::QCompleter::staticMetaObject, sizeof(QCompleterWrapper));
}
