/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebsockets_python.h"

// main header
#include "qwebsocketprotocol_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_QWebSocketProtocol_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebSocketProtocol_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWebSocketProtocol_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebSocketProtocol_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebSocketProtocol_Type = nullptr;
static SbkObjectType *Sbk_QWebSocketProtocol_TypeF(void)
{
    return _Sbk_QWebSocketProtocol_Type;
}

static PyType_Slot Sbk_QWebSocketProtocol_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebSocketProtocol_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebSocketProtocol_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebSocketProtocol_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebSocketProtocol_spec = {
    "2:PySide2.QtWebSockets.QWebSocketProtocol",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebSocketProtocol_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebSocketProtocol_Version_PythonToCpp_QWebSocketProtocol_Version(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebSocketProtocol::Version *>(cppOut) =
        static_cast<::QWebSocketProtocol::Version>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebSocketProtocol_Version_PythonToCpp_QWebSocketProtocol_Version_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX]))
        return QWebSocketProtocol_Version_PythonToCpp_QWebSocketProtocol_Version;
    return {};
}
static PyObject *QWebSocketProtocol_Version_CppToPython_QWebSocketProtocol_Version(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebSocketProtocol::Version *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX], castCppIn);

}

static void QWebSocketProtocol_CloseCode_PythonToCpp_QWebSocketProtocol_CloseCode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebSocketProtocol::CloseCode *>(cppOut) =
        static_cast<::QWebSocketProtocol::CloseCode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebSocketProtocol_CloseCode_PythonToCpp_QWebSocketProtocol_CloseCode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX]))
        return QWebSocketProtocol_CloseCode_PythonToCpp_QWebSocketProtocol_CloseCode;
    return {};
}
static PyObject *QWebSocketProtocol_CloseCode_CppToPython_QWebSocketProtocol_CloseCode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebSocketProtocol::CloseCode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX], castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtWebSocketsQWebSocketProtocol_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_QtWebSocketsQWebSocketProtocol(PyObject *module)
{
    _Sbk_QWebSocketProtocol_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebSocketProtocol",
        "QWebSocketProtocol",
        &Sbk_QWebSocketProtocol_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebSocketProtocol_Type);
    InitSignatureStrings(pyType, QtWebSocketsQWebSocketProtocol_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebSocketProtocol_Type), Sbk_QWebSocketProtocol_PropertyStrings);
    SbkPySide2_QtWebSocketsTypes[SBK_QtWebSocketsQWEBSOCKETPROTOCOL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebSocketProtocol_TypeF());


    // Initialization of enums.

    // Initialization of enum 'Version'.
    SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebSocketProtocol_TypeF(),
        "Version",
        "2:PySide2.QtWebSockets.QWebSocketProtocol.Version",
        "QWebSocketProtocol::Version");
    if (!SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "VersionUnknown", (long) QWebSocketProtocol::Version::VersionUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "Version0", (long) QWebSocketProtocol::Version::Version0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "Version4", (long) QWebSocketProtocol::Version::Version4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "Version5", (long) QWebSocketProtocol::Version::Version5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "Version6", (long) QWebSocketProtocol::Version::Version6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "Version7", (long) QWebSocketProtocol::Version::Version7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "Version8", (long) QWebSocketProtocol::Version::Version8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "Version13", (long) QWebSocketProtocol::Version::Version13))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "VersionLatest", (long) QWebSocketProtocol::Version::VersionLatest))
        return;
    // Register converter for enum 'QWebSocketProtocol::Version'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX],
            QWebSocketProtocol_Version_CppToPython_QWebSocketProtocol_Version);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebSocketProtocol_Version_PythonToCpp_QWebSocketProtocol_Version,
            is_QWebSocketProtocol_Version_PythonToCpp_QWebSocketProtocol_Version_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebSocketProtocol::Version");
        Shiboken::Conversions::registerConverterName(converter, "Version");
    }
    // End of 'Version' enum.

    // Initialization of enum 'CloseCode'.
    SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebSocketProtocol_TypeF(),
        "CloseCode",
        "2:PySide2.QtWebSockets.QWebSocketProtocol.CloseCode",
        "QWebSocketProtocol::CloseCode");
    if (!SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeNormal", (long) QWebSocketProtocol::CloseCode::CloseCodeNormal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeGoingAway", (long) QWebSocketProtocol::CloseCode::CloseCodeGoingAway))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeProtocolError", (long) QWebSocketProtocol::CloseCode::CloseCodeProtocolError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeDatatypeNotSupported", (long) QWebSocketProtocol::CloseCode::CloseCodeDatatypeNotSupported))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeReserved1004", (long) QWebSocketProtocol::CloseCode::CloseCodeReserved1004))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeMissingStatusCode", (long) QWebSocketProtocol::CloseCode::CloseCodeMissingStatusCode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeAbnormalDisconnection", (long) QWebSocketProtocol::CloseCode::CloseCodeAbnormalDisconnection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeWrongDatatype", (long) QWebSocketProtocol::CloseCode::CloseCodeWrongDatatype))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodePolicyViolated", (long) QWebSocketProtocol::CloseCode::CloseCodePolicyViolated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeTooMuchData", (long) QWebSocketProtocol::CloseCode::CloseCodeTooMuchData))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeMissingExtension", (long) QWebSocketProtocol::CloseCode::CloseCodeMissingExtension))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeBadOperation", (long) QWebSocketProtocol::CloseCode::CloseCodeBadOperation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
        Sbk_QWebSocketProtocol_TypeF(), "CloseCodeTlsHandshakeFailed", (long) QWebSocketProtocol::CloseCode::CloseCodeTlsHandshakeFailed))
        return;
    // Register converter for enum 'QWebSocketProtocol::CloseCode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX],
            QWebSocketProtocol_CloseCode_CppToPython_QWebSocketProtocol_CloseCode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebSocketProtocol_CloseCode_PythonToCpp_QWebSocketProtocol_CloseCode,
            is_QWebSocketProtocol_CloseCode_PythonToCpp_QWebSocketProtocol_CloseCode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebSocketProtocol::CloseCode");
        Shiboken::Conversions::registerConverterName(converter, "CloseCode");
    }
    // End of 'CloseCode' enum.

    qRegisterMetaType< ::QWebSocketProtocol::Version >("QWebSocketProtocol::Version");
    qRegisterMetaType< ::QWebSocketProtocol::CloseCode >("QWebSocketProtocol::CloseCode");
}
