/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QWEBENGINEPAGEWRAPPER_H
#define SBK_QWEBENGINEPAGEWRAPPER_H

#define protected public

#include <QtWebEngineWidgets/qwebenginepage.h>


// Extra includes
#include <qobject.h>
#include <QtWebEngineWidgets/qwebengineprofile.h>
#include <QtWebEngineWidgets/qwebenginehistory.h>
#include <QtWidgets/qwidget.h>
#include <QtWidgets/qaction.h>
#include <qcoreevent.h>
#include <QtWidgets/qmenu.h>
#include <qurl.h>
#include <QtWebEngineCore/qwebenginehttprequest.h>
#include <qbytearray.h>
#include <QtGui/qicon.h>
#include <qpoint.h>
#include <qsize.h>
#include <QtWebEngineWidgets/qwebenginescriptcollection.h>
#include <QtWebEngineWidgets/qwebenginesettings.h>
#include <QtWebChannel/qwebchannel.h>
#include <QtGui/qcolor.h>
#include <QtGui/qpagelayout.h>
#include <QtWebEngineWidgets/qwebenginepage.h>
#include <QtWebEngineCore/qwebengineurlrequestinterceptor.h>
#include <QtWebEngineWidgets/qwebenginecontextmenudata.h>
#include <qrect.h>
#include <QtWebEngineWidgets/qwebenginefullscreenrequest.h>
#include <QtNetwork/qauthenticator.h>
#include <QtWebEngineWidgets/qwebenginecertificateerror.h>
#include <QtPrintSupport/qprinter.h>
#include <qobjectdefs.h>
#include <QList>
#include <qmetaobject.h>
#include <qthread.h>
namespace PySide { class DynamicQMetaObject; }

class QWebEnginePageWrapper : public QWebEnginePage
{
public:
    QWebEnginePageWrapper(::QObject * parent = Q_NULLPTR);
    QWebEnginePageWrapper(::QWebEngineProfile * profile, ::QObject * parent = Q_NULLPTR);
    bool acceptNavigationRequest(const ::QUrl & url, ::QWebEnginePage::NavigationType type, bool isMainFrame) override;
    bool certificateError(const ::QWebEngineCertificateError & certificateError) override;
    void childEvent(::QChildEvent * event) override;
    ::QStringList chooseFiles(::QWebEnginePage::FileSelectionMode mode, const ::QStringList & oldFiles, const ::QStringList & acceptedMimeTypes) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QWebEnginePage * createWindow(::QWebEnginePage::WebWindowType type) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void javaScriptAlert(const ::QUrl & securityOrigin, const ::QString & msg) override;
    bool javaScriptConfirm(const ::QUrl & securityOrigin, const ::QString & msg) override;
    void javaScriptConsoleMessage(::QWebEnginePage::JavaScriptConsoleMessageLevel level, const ::QString & message, int lineNumber, const ::QString & sourceID) override;
    bool javaScriptPrompt(const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result) override;
    const ::QMetaObject * metaObject() const override;
    void timerEvent(::QTimerEvent * event) override;
    void triggerAction(::QWebEnginePage::WebAction action, bool checked = false) override;
    ~QWebEnginePageWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[17];
};

#endif // SBK_QWEBENGINEPAGEWRAPPER_H

