/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebenginedownloaditem_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QWebEngineDownloadItemWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QWebEngineDownloadItemWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebEngineDownloadItemWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QWebEngineDownloadItemWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebEngineDownloadItemWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QWebEngineDownloadItemWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEngineDownloadItem.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QWebEngineDownloadItemWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEngineDownloadItem.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QWebEngineDownloadItemWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QWebEngineDownloadItemWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QWebEngineDownloadItem::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QWebEngineDownloadItemWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QWebEngineDownloadItem::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QWebEngineDownloadItemWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QWebEngineDownloadItemWrapper *>(this));
        return QWebEngineDownloadItem::qt_metacast(_clname);
}

QWebEngineDownloadItemWrapper::~QWebEngineDownloadItemWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QWebEngineDownloadItemFunc_accept(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.accept";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // accept()
            cppSelf->accept();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_cancel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.cancel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cancel()
            cppSelf->cancel();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_downloadDirectory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.downloadDirectory";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // downloadDirectory()const
            QString cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->downloadDirectory();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_downloadFileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.downloadFileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // downloadFileName()const
            QString cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->downloadFileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.id";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // id()const
            quint32 cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->id();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_interruptReason(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.interruptReason";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interruptReason()const
            QWebEngineDownloadItem::DownloadInterruptReason cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->interruptReason();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_interruptReasonString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.interruptReasonString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interruptReasonString()const
            QString cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->interruptReasonString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_isPaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.isPaused";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPaused()const
            bool cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->isPaused();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_isSavePageDownload(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.isSavePageDownload";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSavePageDownload()const
            bool cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->isSavePageDownload();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_mimeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.mimeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mimeType()const
            QString cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->mimeType();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_page(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.page";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // page()const
            QWebEnginePage * cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->page();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_path(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.path";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // path()const
            QString cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->path();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_pause(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.pause";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pause()
            cppSelf->pause();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_receivedBytes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.receivedBytes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // receivedBytes()const
            qint64 cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->receivedBytes();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_savePageFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.savePageFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // savePageFormat()const
            QWebEngineDownloadItem::SavePageFormat cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->savePageFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_setDownloadDirectory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.setDownloadDirectory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineDownloadItem::setDownloadDirectory(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDownloadDirectory(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineDownloadItemFunc_setDownloadDirectory_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDownloadDirectory(QString)
            cppSelf->setDownloadDirectory(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineDownloadItemFunc_setDownloadDirectory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_setDownloadFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.setDownloadFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineDownloadItem::setDownloadFileName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDownloadFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineDownloadItemFunc_setDownloadFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDownloadFileName(QString)
            cppSelf->setDownloadFileName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineDownloadItemFunc_setDownloadFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_setPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.setPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineDownloadItem::setPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineDownloadItemFunc_setPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPath(QString)
            cppSelf->setPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineDownloadItemFunc_setPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_setSavePageFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.setSavePageFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineDownloadItem::setSavePageFormat(QWebEngineDownloadItem::SavePageFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSavePageFormat(QWebEngineDownloadItem::SavePageFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineDownloadItemFunc_setSavePageFormat_TypeError;

    // Call function/method
    {
        ::QWebEngineDownloadItem::SavePageFormat cppArg0{QWebEngineDownloadItem::SingleHtmlSaveFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSavePageFormat(QWebEngineDownloadItem::SavePageFormat)
            cppSelf->setSavePageFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineDownloadItemFunc_setSavePageFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QWebEngineDownloadItem::DownloadState cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_suggestedFileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.suggestedFileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // suggestedFileName()const
            QString cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->suggestedFileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_totalBytes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.totalBytes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // totalBytes()const
            qint64 cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->totalBytes();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QWebEngineDownloadItem::DownloadType cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineDownloadItemFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QWebEngineDownloadItem *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineDownloadItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineDownloadItem_methods[] = {
    {"accept", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_accept), METH_NOARGS},
    {"cancel", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_cancel), METH_NOARGS},
    {"downloadDirectory", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_downloadDirectory), METH_NOARGS},
    {"downloadFileName", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_downloadFileName), METH_NOARGS},
    {"id", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_id), METH_NOARGS},
    {"interruptReason", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_interruptReason), METH_NOARGS},
    {"interruptReasonString", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_interruptReasonString), METH_NOARGS},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_isFinished), METH_NOARGS},
    {"isPaused", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_isPaused), METH_NOARGS},
    {"isSavePageDownload", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_isSavePageDownload), METH_NOARGS},
    {"mimeType", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_mimeType), METH_NOARGS},
    {"page", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_page), METH_NOARGS},
    {"path", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_path), METH_NOARGS},
    {"pause", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_pause), METH_NOARGS},
    {"receivedBytes", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_receivedBytes), METH_NOARGS},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_resume), METH_NOARGS},
    {"savePageFormat", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_savePageFormat), METH_NOARGS},
    {"setDownloadDirectory", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_setDownloadDirectory), METH_O},
    {"setDownloadFileName", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_setDownloadFileName), METH_O},
    {"setPath", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_setPath), METH_O},
    {"setSavePageFormat", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_setSavePageFormat), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_state), METH_NOARGS},
    {"suggestedFileName", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_suggestedFileName), METH_NOARGS},
    {"totalBytes", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_totalBytes), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_type), METH_NOARGS},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QWebEngineDownloadItemFunc_url), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QWebEngineDownloadItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QWebEngineDownloadItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QWebEngineDownloadItemWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QWebEngineDownloadItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineDownloadItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineDownloadItem_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineDownloadItem_TypeF(void)
{
    return _Sbk_QWebEngineDownloadItem_Type;
}

static PyType_Slot Sbk_QWebEngineDownloadItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QWebEngineDownloadItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineDownloadItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineDownloadItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineDownloadItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineDownloadItem_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEngineDownloadItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineDownloadItem_slots
};

} //extern "C"

static void *Sbk_QWebEngineDownloadItem_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QWebEngineDownloadItem *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineDownloadItem_DownloadState_PythonToCpp_QWebEngineDownloadItem_DownloadState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineDownloadItem::DownloadState *>(cppOut) =
        static_cast<::QWebEngineDownloadItem::DownloadState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineDownloadItem_DownloadState_PythonToCpp_QWebEngineDownloadItem_DownloadState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX]))
        return QWebEngineDownloadItem_DownloadState_PythonToCpp_QWebEngineDownloadItem_DownloadState;
    return {};
}
static PyObject *QWebEngineDownloadItem_DownloadState_CppToPython_QWebEngineDownloadItem_DownloadState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineDownloadItem::DownloadState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX], castCppIn);

}

static void QWebEngineDownloadItem_SavePageFormat_PythonToCpp_QWebEngineDownloadItem_SavePageFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineDownloadItem::SavePageFormat *>(cppOut) =
        static_cast<::QWebEngineDownloadItem::SavePageFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineDownloadItem_SavePageFormat_PythonToCpp_QWebEngineDownloadItem_SavePageFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX]))
        return QWebEngineDownloadItem_SavePageFormat_PythonToCpp_QWebEngineDownloadItem_SavePageFormat;
    return {};
}
static PyObject *QWebEngineDownloadItem_SavePageFormat_CppToPython_QWebEngineDownloadItem_SavePageFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineDownloadItem::SavePageFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX], castCppIn);

}

static void QWebEngineDownloadItem_DownloadInterruptReason_PythonToCpp_QWebEngineDownloadItem_DownloadInterruptReason(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineDownloadItem::DownloadInterruptReason *>(cppOut) =
        static_cast<::QWebEngineDownloadItem::DownloadInterruptReason>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineDownloadItem_DownloadInterruptReason_PythonToCpp_QWebEngineDownloadItem_DownloadInterruptReason_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX]))
        return QWebEngineDownloadItem_DownloadInterruptReason_PythonToCpp_QWebEngineDownloadItem_DownloadInterruptReason;
    return {};
}
static PyObject *QWebEngineDownloadItem_DownloadInterruptReason_CppToPython_QWebEngineDownloadItem_DownloadInterruptReason(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineDownloadItem::DownloadInterruptReason *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX], castCppIn);

}

static void QWebEngineDownloadItem_DownloadType_PythonToCpp_QWebEngineDownloadItem_DownloadType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineDownloadItem::DownloadType *>(cppOut) =
        static_cast<::QWebEngineDownloadItem::DownloadType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineDownloadItem_DownloadType_PythonToCpp_QWebEngineDownloadItem_DownloadType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX]))
        return QWebEngineDownloadItem_DownloadType_PythonToCpp_QWebEngineDownloadItem_DownloadType;
    return {};
}
static PyObject *QWebEngineDownloadItem_DownloadType_CppToPython_QWebEngineDownloadItem_DownloadType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineDownloadItem::DownloadType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineDownloadItem_PythonToCpp_QWebEngineDownloadItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineDownloadItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineDownloadItem_PythonToCpp_QWebEngineDownloadItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineDownloadItem_TypeF())))
        return QWebEngineDownloadItem_PythonToCpp_QWebEngineDownloadItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineDownloadItem_PTR_CppToPython_QWebEngineDownloadItem(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QWebEngineDownloadItem *>(const_cast<void *>(cppIn)), Sbk_QWebEngineDownloadItem_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineDownloadItem_SignatureStrings[] = {
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.accept(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.cancel(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.downloadDirectory(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.downloadFileName(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.id(self)->quint32",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.interruptReason(self)->PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.DownloadInterruptReason",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.interruptReasonString(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.isFinished(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.isPaused(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.isSavePageDownload(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.mimeType(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.page(self)->PySide2.QtWebEngineWidgets.QWebEnginePage",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.path(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.pause(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.receivedBytes(self)->qint64",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.resume(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.savePageFormat(self)->PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.SavePageFormat",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.setDownloadDirectory(self,directory:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.setDownloadFileName(self,fileName:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.setPath(self,path:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.setSavePageFormat(self,format:PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.SavePageFormat)",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.state(self)->PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.DownloadState",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.suggestedFileName(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.totalBytes(self)->qint64",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.type(self)->PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.DownloadType",
    "PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.url(self)->PySide2.QtCore.QUrl",
    nullptr}; // Sentinel

void init_QWebEngineDownloadItem(PyObject *module)
{
    _Sbk_QWebEngineDownloadItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineDownloadItem",
        "QWebEngineDownloadItem*",
        &Sbk_QWebEngineDownloadItem_spec,
        &Shiboken::callCppDestructor< ::QWebEngineDownloadItem >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineDownloadItem_Type);
    InitSignatureStrings(pyType, QWebEngineDownloadItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineDownloadItem_Type), Sbk_QWebEngineDownloadItem_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineDownloadItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineDownloadItem_TypeF(),
        QWebEngineDownloadItem_PythonToCpp_QWebEngineDownloadItem_PTR,
        is_QWebEngineDownloadItem_PythonToCpp_QWebEngineDownloadItem_PTR_Convertible,
        QWebEngineDownloadItem_PTR_CppToPython_QWebEngineDownloadItem);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineDownloadItem");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineDownloadItem*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineDownloadItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineDownloadItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineDownloadItemWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QWebEngineDownloadItem_TypeF(), &Sbk_QWebEngineDownloadItem_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'DownloadState'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineDownloadItem_TypeF(),
        "DownloadState",
        "2:PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.DownloadState",
        "QWebEngineDownloadItem::DownloadState");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "DownloadRequested", (long) QWebEngineDownloadItem::DownloadState::DownloadRequested))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "DownloadInProgress", (long) QWebEngineDownloadItem::DownloadState::DownloadInProgress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "DownloadCompleted", (long) QWebEngineDownloadItem::DownloadState::DownloadCompleted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "DownloadCancelled", (long) QWebEngineDownloadItem::DownloadState::DownloadCancelled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "DownloadInterrupted", (long) QWebEngineDownloadItem::DownloadState::DownloadInterrupted))
        return;
    // Register converter for enum 'QWebEngineDownloadItem::DownloadState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX],
            QWebEngineDownloadItem_DownloadState_CppToPython_QWebEngineDownloadItem_DownloadState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineDownloadItem_DownloadState_PythonToCpp_QWebEngineDownloadItem_DownloadState,
            is_QWebEngineDownloadItem_DownloadState_PythonToCpp_QWebEngineDownloadItem_DownloadState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineDownloadItem::DownloadState");
        Shiboken::Conversions::registerConverterName(converter, "DownloadState");
    }
    // End of 'DownloadState' enum.

    // Initialization of enum 'SavePageFormat'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineDownloadItem_TypeF(),
        "SavePageFormat",
        "2:PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.SavePageFormat",
        "QWebEngineDownloadItem::SavePageFormat");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "UnknownSaveFormat", (long) QWebEngineDownloadItem::SavePageFormat::UnknownSaveFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "SingleHtmlSaveFormat", (long) QWebEngineDownloadItem::SavePageFormat::SingleHtmlSaveFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "CompleteHtmlSaveFormat", (long) QWebEngineDownloadItem::SavePageFormat::CompleteHtmlSaveFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "MimeHtmlSaveFormat", (long) QWebEngineDownloadItem::SavePageFormat::MimeHtmlSaveFormat))
        return;
    // Register converter for enum 'QWebEngineDownloadItem::SavePageFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX],
            QWebEngineDownloadItem_SavePageFormat_CppToPython_QWebEngineDownloadItem_SavePageFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineDownloadItem_SavePageFormat_PythonToCpp_QWebEngineDownloadItem_SavePageFormat,
            is_QWebEngineDownloadItem_SavePageFormat_PythonToCpp_QWebEngineDownloadItem_SavePageFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineDownloadItem::SavePageFormat");
        Shiboken::Conversions::registerConverterName(converter, "SavePageFormat");
    }
    // End of 'SavePageFormat' enum.

    // Initialization of enum 'DownloadInterruptReason'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineDownloadItem_TypeF(),
        "DownloadInterruptReason",
        "2:PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.DownloadInterruptReason",
        "QWebEngineDownloadItem::DownloadInterruptReason");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "NoReason", (long) QWebEngineDownloadItem::DownloadInterruptReason::NoReason))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileFailed", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileFailed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileAccessDenied", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileAccessDenied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileNoSpace", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileNoSpace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileNameTooLong", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileNameTooLong))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileTooLarge", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileTooLarge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileVirusInfected", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileVirusInfected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileTransientError", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileTransientError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileBlocked", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileBlocked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileSecurityCheckFailed", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileSecurityCheckFailed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileTooShort", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileTooShort))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "FileHashMismatch", (long) QWebEngineDownloadItem::DownloadInterruptReason::FileHashMismatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "NetworkFailed", (long) QWebEngineDownloadItem::DownloadInterruptReason::NetworkFailed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "NetworkTimeout", (long) QWebEngineDownloadItem::DownloadInterruptReason::NetworkTimeout))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "NetworkDisconnected", (long) QWebEngineDownloadItem::DownloadInterruptReason::NetworkDisconnected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "NetworkServerDown", (long) QWebEngineDownloadItem::DownloadInterruptReason::NetworkServerDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "NetworkInvalidRequest", (long) QWebEngineDownloadItem::DownloadInterruptReason::NetworkInvalidRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "ServerFailed", (long) QWebEngineDownloadItem::DownloadInterruptReason::ServerFailed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "ServerBadContent", (long) QWebEngineDownloadItem::DownloadInterruptReason::ServerBadContent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "ServerUnauthorized", (long) QWebEngineDownloadItem::DownloadInterruptReason::ServerUnauthorized))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "ServerCertProblem", (long) QWebEngineDownloadItem::DownloadInterruptReason::ServerCertProblem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "ServerForbidden", (long) QWebEngineDownloadItem::DownloadInterruptReason::ServerForbidden))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "ServerUnreachable", (long) QWebEngineDownloadItem::DownloadInterruptReason::ServerUnreachable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "UserCanceled", (long) QWebEngineDownloadItem::DownloadInterruptReason::UserCanceled))
        return;
    // Register converter for enum 'QWebEngineDownloadItem::DownloadInterruptReason'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX],
            QWebEngineDownloadItem_DownloadInterruptReason_CppToPython_QWebEngineDownloadItem_DownloadInterruptReason);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineDownloadItem_DownloadInterruptReason_PythonToCpp_QWebEngineDownloadItem_DownloadInterruptReason,
            is_QWebEngineDownloadItem_DownloadInterruptReason_PythonToCpp_QWebEngineDownloadItem_DownloadInterruptReason_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADINTERRUPTREASON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineDownloadItem::DownloadInterruptReason");
        Shiboken::Conversions::registerConverterName(converter, "DownloadInterruptReason");
    }
    // End of 'DownloadInterruptReason' enum.

    // Initialization of enum 'DownloadType'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineDownloadItem_TypeF(),
        "DownloadType",
        "2:PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.DownloadType",
        "QWebEngineDownloadItem::DownloadType");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "Attachment", (long) QWebEngineDownloadItem::DownloadType::Attachment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "DownloadAttribute", (long) QWebEngineDownloadItem::DownloadType::DownloadAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "UserRequested", (long) QWebEngineDownloadItem::DownloadType::UserRequested))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX],
        Sbk_QWebEngineDownloadItem_TypeF(), "SavePage", (long) QWebEngineDownloadItem::DownloadType::SavePage))
        return;
    // Register converter for enum 'QWebEngineDownloadItem::DownloadType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX],
            QWebEngineDownloadItem_DownloadType_CppToPython_QWebEngineDownloadItem_DownloadType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineDownloadItem_DownloadType_PythonToCpp_QWebEngineDownloadItem_DownloadType,
            is_QWebEngineDownloadItem_DownloadType_PythonToCpp_QWebEngineDownloadItem_DownloadType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_DOWNLOADTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineDownloadItem::DownloadType");
        Shiboken::Conversions::registerConverterName(converter, "DownloadType");
    }
    // End of 'DownloadType' enum.

    PySide::Signal::registerSignals(Sbk_QWebEngineDownloadItem_TypeF(), &::QWebEngineDownloadItem::staticMetaObject);
    qRegisterMetaType< ::QWebEngineDownloadItem::DownloadState >("QWebEngineDownloadItem::DownloadState");
    qRegisterMetaType< ::QWebEngineDownloadItem::SavePageFormat >("QWebEngineDownloadItem::SavePageFormat");
    qRegisterMetaType< ::QWebEngineDownloadItem::DownloadInterruptReason >("QWebEngineDownloadItem::DownloadInterruptReason");
    qRegisterMetaType< ::QWebEngineDownloadItem::DownloadType >("QWebEngineDownloadItem::DownloadType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QWebEngineDownloadItem_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QWebEngineDownloadItem_TypeF(), &::QWebEngineDownloadItem::staticMetaObject, sizeof(QWebEngineDownloadItemWrapper));
}
