/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginecore_python.h"

// main header
#include "qwebengineurlscheme_wrapper.h"

// inner classes

// Extra includes
#include <QtWebEngineCore/qwebengineurlscheme.h>
#include <qbytearray.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebEngineUrlScheme_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebEngineUrlScheme >()))
        return -1;

    ::QWebEngineUrlScheme *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QWebEngineUrlScheme", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QWebEngineUrlScheme::QWebEngineUrlScheme()
    // 1: QWebEngineUrlScheme::QWebEngineUrlScheme(QByteArray)
    // 2: QWebEngineUrlScheme::QWebEngineUrlScheme(QWebEngineUrlScheme)
    if (numArgs == 0) {
        overloadId = 0; // QWebEngineUrlScheme()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QWebEngineUrlScheme(QWebEngineUrlScheme)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QWebEngineUrlScheme(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlScheme_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWebEngineUrlScheme()
        {

            if (!PyErr_Occurred()) {
                // QWebEngineUrlScheme()
                cptr = new ::QWebEngineUrlScheme();
            }
            break;
        }
        case 1: // QWebEngineUrlScheme(const QByteArray & name)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QWebEngineUrlScheme(QByteArray)
                cptr = new ::QWebEngineUrlScheme(*cppArg0);
            }
            break;
        }
        case 2: // QWebEngineUrlScheme(const QWebEngineUrlScheme & that)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWebEngineUrlScheme cppArg0_local;
            ::QWebEngineUrlScheme *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QWebEngineUrlScheme(QWebEngineUrlScheme)
                cptr = new ::QWebEngineUrlScheme(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebEngineUrlScheme >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebEngineUrlScheme_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QWebEngineUrlScheme_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_defaultPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.defaultPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultPort()const
            int cppResult = const_cast<const ::QWebEngineUrlScheme *>(cppSelf)->defaultPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<QWebEngineUrlScheme::Flag> cppResult = const_cast<const ::QWebEngineUrlScheme *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QByteArray cppResult = const_cast<const ::QWebEngineUrlScheme *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_registerScheme(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.registerScheme";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QWebEngineUrlScheme::registerScheme(QWebEngineUrlScheme)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), (pyArg)))) {
        overloadId = 0; // registerScheme(QWebEngineUrlScheme)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlSchemeFunc_registerScheme_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineUrlScheme cppArg0_local;
        ::QWebEngineUrlScheme *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // registerScheme(QWebEngineUrlScheme)
            ::QWebEngineUrlScheme::registerScheme(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineUrlSchemeFunc_registerScheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_schemeByName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.schemeByName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QWebEngineUrlScheme::schemeByName(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // schemeByName(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlSchemeFunc_schemeByName_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // schemeByName(QByteArray)
            QWebEngineUrlScheme cppResult = ::QWebEngineUrlScheme::schemeByName(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineUrlSchemeFunc_schemeByName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_setDefaultPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.setDefaultPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineUrlScheme::setDefaultPort(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDefaultPort(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlSchemeFunc_setDefaultPort_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultPort(int)
            cppSelf->setDefaultPort(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineUrlSchemeFunc_setDefaultPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_setFlags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.setFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineUrlScheme::setFlags(QFlags<QWebEngineUrlScheme::Flag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFlags(QFlags<QWebEngineUrlScheme::Flag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlSchemeFunc_setFlags_TypeError;

    // Call function/method
    {
        ::QFlags<QWebEngineUrlScheme::Flag> cppArg0 = QFlags<QWebEngineUrlScheme::Flag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFlags(QFlags<QWebEngineUrlScheme::Flag>)
            cppSelf->setFlags(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineUrlSchemeFunc_setFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineUrlScheme::setName(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setName(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlSchemeFunc_setName_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setName(QByteArray)
            cppSelf->setName(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineUrlSchemeFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_setSyntax(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.setSyntax";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineUrlScheme::setSyntax(QWebEngineUrlScheme::Syntax)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSyntax(QWebEngineUrlScheme::Syntax)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineUrlSchemeFunc_setSyntax_TypeError;

    // Call function/method
    {
        ::QWebEngineUrlScheme::Syntax cppArg0{QWebEngineUrlScheme::Syntax::HostPortAndUserInformation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSyntax(QWebEngineUrlScheme::Syntax)
            cppSelf->setSyntax(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineUrlSchemeFunc_setSyntax_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineUrlSchemeFunc_syntax(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineCore.QWebEngineUrlScheme.syntax";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // syntax()const
            QWebEngineUrlScheme::Syntax cppResult = const_cast<const ::QWebEngineUrlScheme *>(cppSelf)->syntax();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineUrlScheme___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineUrlScheme_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineUrlScheme_methods[] = {
    {"defaultPort", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_defaultPort), METH_NOARGS},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_flags), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_name), METH_NOARGS},
    {"registerScheme", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_registerScheme), METH_O|METH_STATIC},
    {"schemeByName", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_schemeByName), METH_O|METH_STATIC},
    {"setDefaultPort", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_setDefaultPort), METH_O},
    {"setFlags", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_setFlags), METH_O},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_setName), METH_O},
    {"setSyntax", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_setSyntax), METH_O},
    {"syntax", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlSchemeFunc_syntax), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QWebEngineUrlScheme___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QWebEngineUrlScheme_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), (pyArg)))) {
                // operator!=(const QWebEngineUrlScheme & that) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QWebEngineUrlScheme cppArg0_local;
                ::QWebEngineUrlScheme *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), (pyArg)))) {
                // operator==(const QWebEngineUrlScheme & that) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QWebEngineUrlScheme cppArg0_local;
                ::QWebEngineUrlScheme *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QWebEngineUrlScheme_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QWebEngineUrlScheme_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QWebEngineUrlScheme_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineUrlScheme_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineUrlScheme_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineUrlScheme_TypeF(void)
{
    return _Sbk_QWebEngineUrlScheme_Type;
}

static PyType_Slot Sbk_QWebEngineUrlScheme_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineUrlScheme_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineUrlScheme_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QWebEngineUrlScheme_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineUrlScheme_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebEngineUrlScheme_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineUrlScheme_spec = {
    "2:PySide2.QtWebEngineCore.QWebEngineUrlScheme",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineUrlScheme_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag___and__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineUrlScheme::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineUrlScheme::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineUrlScheme::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineUrlScheme::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineUrlScheme::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag___or__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineUrlScheme::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineUrlScheme::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineUrlScheme::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineUrlScheme::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineUrlScheme::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineUrlScheme::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineUrlScheme::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineUrlScheme::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineUrlScheme::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineUrlScheme::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineUrlScheme::Flags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, self, &cppSelf);
    ::QWebEngineUrlScheme::Flags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineUrlScheme_Syntax_PythonToCpp_QWebEngineUrlScheme_Syntax(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineUrlScheme::Syntax *>(cppOut) =
        static_cast<::QWebEngineUrlScheme::Syntax>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineUrlScheme_Syntax_PythonToCpp_QWebEngineUrlScheme_Syntax_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX]))
        return QWebEngineUrlScheme_Syntax_PythonToCpp_QWebEngineUrlScheme_Syntax;
    return {};
}
static PyObject *QWebEngineUrlScheme_Syntax_CppToPython_QWebEngineUrlScheme_Syntax(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineUrlScheme::Syntax *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX], castCppIn);

}

static void QWebEngineUrlScheme_SpecialPort_PythonToCpp_QWebEngineUrlScheme_SpecialPort(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineUrlScheme::SpecialPort *>(cppOut) =
        static_cast<::QWebEngineUrlScheme::SpecialPort>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineUrlScheme_SpecialPort_PythonToCpp_QWebEngineUrlScheme_SpecialPort_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SPECIALPORT_IDX]))
        return QWebEngineUrlScheme_SpecialPort_PythonToCpp_QWebEngineUrlScheme_SpecialPort;
    return {};
}
static PyObject *QWebEngineUrlScheme_SpecialPort_CppToPython_QWebEngineUrlScheme_SpecialPort(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineUrlScheme::SpecialPort *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SPECIALPORT_IDX], castCppIn);

}

static void QWebEngineUrlScheme_Flag_PythonToCpp_QWebEngineUrlScheme_Flag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineUrlScheme::Flag *>(cppOut) =
        static_cast<::QWebEngineUrlScheme::Flag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineUrlScheme_Flag_PythonToCpp_QWebEngineUrlScheme_Flag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX]))
        return QWebEngineUrlScheme_Flag_PythonToCpp_QWebEngineUrlScheme_Flag;
    return {};
}
static PyObject *QWebEngineUrlScheme_Flag_CppToPython_QWebEngineUrlScheme_Flag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineUrlScheme::Flag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX], castCppIn);

}

static void QFlags_QWebEngineUrlScheme_Flag__PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QWebEngineUrlScheme::Flag> *>(cppOut) =
        ::QFlags<QWebEngineUrlScheme::Flag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QWebEngineUrlScheme_Flag__PythonToCpp_QFlags_QWebEngineUrlScheme_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX]))
        return QFlags_QWebEngineUrlScheme_Flag__PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_;
    return {};
}
static PyObject *QFlags_QWebEngineUrlScheme_Flag__CppToPython_QFlags_QWebEngineUrlScheme_Flag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QWebEngineUrlScheme::Flag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX]));

}

static void QWebEngineUrlScheme_Flag_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QWebEngineUrlScheme::Flag> *>(cppOut) =
        ::QFlags<QWebEngineUrlScheme::Flag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QWebEngineUrlScheme_Flag_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX]))
        return QWebEngineUrlScheme_Flag_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_;
    return {};
}
static void number_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QWebEngineUrlScheme::Flag> *>(cppOut) =
        ::QFlags<QWebEngineUrlScheme::Flag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX]))
        return number_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineUrlScheme_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineUrlScheme_TypeF())))
        return QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineUrlScheme_PTR_CppToPython_QWebEngineUrlScheme(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineUrlScheme *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineUrlScheme_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QWebEngineUrlScheme_COPY_CppToPython_QWebEngineUrlScheme(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QWebEngineUrlScheme_TypeF(), new ::QWebEngineUrlScheme(*reinterpret_cast<const ::QWebEngineUrlScheme *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineUrlScheme *>(cppOut) = *reinterpret_cast< ::QWebEngineUrlScheme *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineUrlScheme_TypeF())))
        return QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineUrlScheme_SignatureStrings[] = {
    "2:PySide2.QtWebEngineCore.QWebEngineUrlScheme(self)",
    "1:PySide2.QtWebEngineCore.QWebEngineUrlScheme(self,name:PySide2.QtCore.QByteArray)",
    "0:PySide2.QtWebEngineCore.QWebEngineUrlScheme(self,that:PySide2.QtWebEngineCore.QWebEngineUrlScheme)",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.defaultPort(self)->int",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.flags(self)->PySide2.QtWebEngineCore.QWebEngineUrlScheme.Flags",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.name(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.registerScheme(scheme:PySide2.QtWebEngineCore.QWebEngineUrlScheme)",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.schemeByName(name:PySide2.QtCore.QByteArray)->PySide2.QtWebEngineCore.QWebEngineUrlScheme",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.setDefaultPort(self,newValue:int)",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.setFlags(self,newValue:PySide2.QtWebEngineCore.QWebEngineUrlScheme.Flags)",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.setName(self,newValue:PySide2.QtCore.QByteArray)",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.setSyntax(self,newValue:PySide2.QtWebEngineCore.QWebEngineUrlScheme.Syntax)",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.syntax(self)->PySide2.QtWebEngineCore.QWebEngineUrlScheme.Syntax",
    "PySide2.QtWebEngineCore.QWebEngineUrlScheme.__copy__()",
    nullptr}; // Sentinel

void init_QWebEngineUrlScheme(PyObject *module)
{
    _Sbk_QWebEngineUrlScheme_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineUrlScheme",
        "QWebEngineUrlScheme",
        &Sbk_QWebEngineUrlScheme_spec,
        &Shiboken::callCppDestructor< ::QWebEngineUrlScheme >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineUrlScheme_Type);
    InitSignatureStrings(pyType, QWebEngineUrlScheme_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineUrlScheme_Type), Sbk_QWebEngineUrlScheme_PropertyStrings);
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineUrlScheme_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineUrlScheme_TypeF(),
        QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_PTR,
        is_QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_PTR_Convertible,
        QWebEngineUrlScheme_PTR_CppToPython_QWebEngineUrlScheme,
        QWebEngineUrlScheme_COPY_CppToPython_QWebEngineUrlScheme);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlScheme");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlScheme*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlScheme&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineUrlScheme).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_COPY,
        is_QWebEngineUrlScheme_PythonToCpp_QWebEngineUrlScheme_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Syntax'.
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineUrlScheme_TypeF(),
        "Syntax",
        "2:PySide2.QtWebEngineCore.QWebEngineUrlScheme.Syntax",
        "QWebEngineUrlScheme::Syntax");
    if (!SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX],
        SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX], "HostPortAndUserInformation", (long) QWebEngineUrlScheme::Syntax::HostPortAndUserInformation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX],
        SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX], "HostAndPort", (long) QWebEngineUrlScheme::Syntax::HostAndPort))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX],
        SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX], "Host", (long) QWebEngineUrlScheme::Syntax::Host))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX],
        SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX], "Path", (long) QWebEngineUrlScheme::Syntax::Path))
        return;
    // Register converter for enum 'QWebEngineUrlScheme::Syntax'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX],
            QWebEngineUrlScheme_Syntax_CppToPython_QWebEngineUrlScheme_Syntax);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineUrlScheme_Syntax_PythonToCpp_QWebEngineUrlScheme_Syntax,
            is_QWebEngineUrlScheme_Syntax_PythonToCpp_QWebEngineUrlScheme_Syntax_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SYNTAX_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlScheme::Syntax");
        Shiboken::Conversions::registerConverterName(converter, "Syntax");
    }
    // End of 'Syntax' enum.

    // Initialization of enum 'SpecialPort'.
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SPECIALPORT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineUrlScheme_TypeF(),
        "SpecialPort",
        "2:PySide2.QtWebEngineCore.QWebEngineUrlScheme.SpecialPort",
        "QWebEngineUrlScheme::SpecialPort");
    if (!SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SPECIALPORT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SPECIALPORT_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "PortUnspecified", (long) QWebEngineUrlScheme::SpecialPort::PortUnspecified))
        return;
    // Register converter for enum 'QWebEngineUrlScheme::SpecialPort'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SPECIALPORT_IDX],
            QWebEngineUrlScheme_SpecialPort_CppToPython_QWebEngineUrlScheme_SpecialPort);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineUrlScheme_SpecialPort_PythonToCpp_QWebEngineUrlScheme_SpecialPort,
            is_QWebEngineUrlScheme_SpecialPort_PythonToCpp_QWebEngineUrlScheme_SpecialPort_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_SPECIALPORT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlScheme::SpecialPort");
        Shiboken::Conversions::registerConverterName(converter, "SpecialPort");
    }
    // End of 'SpecialPort' enum.

    // Initialization of enum 'Flag'.
    SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWebEngineCore.QWebEngineUrlScheme.Flags", SbkPySide2_QtWebEngineCore_QWebEngineUrlScheme_Flag_number_slots);
    SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineUrlScheme_TypeF(),
        "Flag",
        "2:PySide2.QtWebEngineCore.QWebEngineUrlScheme.Flag",
        "QWebEngineUrlScheme::Flag",
        SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX]);
    if (!SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "SecureScheme", (long) QWebEngineUrlScheme::Flag::SecureScheme))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "LocalScheme", (long) QWebEngineUrlScheme::Flag::LocalScheme))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "LocalAccessAllowed", (long) QWebEngineUrlScheme::Flag::LocalAccessAllowed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "NoAccessAllowed", (long) QWebEngineUrlScheme::Flag::NoAccessAllowed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "ServiceWorkersAllowed", (long) QWebEngineUrlScheme::Flag::ServiceWorkersAllowed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "ViewSourceAllowed", (long) QWebEngineUrlScheme::Flag::ViewSourceAllowed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "ContentSecurityPolicyIgnored", (long) QWebEngineUrlScheme::Flag::ContentSecurityPolicyIgnored))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
        Sbk_QWebEngineUrlScheme_TypeF(), "CorsEnabled", (long) QWebEngineUrlScheme::Flag::CorsEnabled))
        return;
    // Register converter for enum 'QWebEngineUrlScheme::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX],
            QWebEngineUrlScheme_Flag_CppToPython_QWebEngineUrlScheme_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineUrlScheme_Flag_PythonToCpp_QWebEngineUrlScheme_Flag,
            is_QWebEngineUrlScheme_Flag_PythonToCpp_QWebEngineUrlScheme_Flag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLSCHEME_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlScheme::Flag");
        Shiboken::Conversions::registerConverterName(converter, "Flag");
    }
    // Register converter for flag 'QFlags<QWebEngineUrlScheme::Flag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX],
            QFlags_QWebEngineUrlScheme_Flag__CppToPython_QFlags_QWebEngineUrlScheme_Flag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineUrlScheme_Flag_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_,
            is_QWebEngineUrlScheme_Flag_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QWebEngineUrlScheme_Flag__PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_,
            is_QFlags_QWebEngineUrlScheme_Flag__PythonToCpp_QFlags_QWebEngineUrlScheme_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag_,
            is_number_PythonToCpp_QFlags_QWebEngineUrlScheme_Flag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineCoreTypes[SBK_QFLAGS_QWEBENGINEURLSCHEME_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineUrlScheme::Flags");
        Shiboken::Conversions::registerConverterName(converter, "Flags");
    }
    // End of 'Flag' enum/flags.

    qRegisterMetaType< ::QWebEngineUrlScheme >("QWebEngineUrlScheme");
    qRegisterMetaType< ::QWebEngineUrlScheme::Syntax >("QWebEngineUrlScheme::Syntax");
    qRegisterMetaType< ::QWebEngineUrlScheme::SpecialPort >("QWebEngineUrlScheme::SpecialPort");
    qRegisterMetaType< ::QWebEngineUrlScheme::Flag >("QWebEngineUrlScheme::Flag");
    qRegisterMetaType< ::QWebEngineUrlScheme::Flags >("QWebEngineUrlScheme::Flags");
}
