/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qttexttospeech_python.h"

// main header
#include "qtexttospeech_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTextToSpeechWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTextToSpeechWrapper::QTextToSpeechWrapper(::QObject * parent) : QTextToSpeech(parent)
{
    resetPyMethodCache();
    // ... middle
}

QTextToSpeechWrapper::QTextToSpeechWrapper(const ::QString & engine, ::QObject * parent) : QTextToSpeech(engine, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QTextToSpeechWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTextToSpeechWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QTextToSpeechWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTextToSpeechWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QTextToSpeechWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextToSpeech.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QTextToSpeechWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextToSpeech.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QTextToSpeechWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QTextToSpeechWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QTextToSpeech::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QTextToSpeechWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QTextToSpeech::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QTextToSpeechWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QTextToSpeechWrapper *>(this));
        return QTextToSpeech::qt_metacast(_clname);
}

QTextToSpeechWrapper::~QTextToSpeechWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextToSpeech_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextToSpeech >()))
        return -1;

    ::QTextToSpeechWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QTextToSpeech", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QTextToSpeech::QTextToSpeech(QObject*)
    // 1: QTextToSpeech::QTextToSpeech(QString,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QTextToSpeech(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QTextToSpeech(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QTextToSpeech(QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QTextToSpeech(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextToSpeech_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextToSpeech(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextToSpeech_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QTextToSpeech_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTextToSpeech(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QTextToSpeechWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QTextToSpeechWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QTextToSpeech(const QString & engine, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextToSpeech_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QTextToSpeech_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QTextToSpeech(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QTextToSpeechWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QTextToSpeechWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextToSpeech >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextToSpeech_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QTextToSpeech_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QTextToSpeech_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextToSpeechFunc_availableEngines(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.availableEngines";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableEngines()
            QStringList cppResult = ::QTextToSpeech::availableEngines();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextToSpeechFunc_availableLocales(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.availableLocales";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableLocales()const
            QVector<QLocale > cppResult = const_cast<const ::QTextToSpeech *>(cppSelf)->availableLocales();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtTextToSpeechTypeConverters[SBK_QTTEXTTOSPEECH_QVECTOR_QLOCALE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextToSpeechFunc_availableVoices(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.availableVoices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableVoices()const
            QVector<QVoice > cppResult = const_cast<const ::QTextToSpeech *>(cppSelf)->availableVoices();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtTextToSpeechTypeConverters[SBK_QTTEXTTOSPEECH_QVECTOR_QVOICE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextToSpeechFunc_locale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.locale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // locale()const
            QLocale cppResult = const_cast<const ::QTextToSpeech *>(cppSelf)->locale();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextToSpeechFunc_pause(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.pause";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pause()
            cppSelf->pause();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextToSpeechFunc_pitch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.pitch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pitch()const
            double cppResult = const_cast<const ::QTextToSpeech *>(cppSelf)->pitch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextToSpeechFunc_rate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.rate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rate()const
            double cppResult = const_cast<const ::QTextToSpeech *>(cppSelf)->rate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextToSpeechFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextToSpeechFunc_say(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.say";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextToSpeech::say(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // say(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextToSpeechFunc_say_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // say(QString)
            cppSelf->say(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextToSpeechFunc_say_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextToSpeechFunc_setLocale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.setLocale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextToSpeech::setLocale(QLocale)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
        overloadId = 0; // setLocale(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextToSpeechFunc_setLocale_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLocale(QLocale)
            cppSelf->setLocale(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextToSpeechFunc_setLocale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextToSpeechFunc_setPitch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.setPitch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextToSpeech::setPitch(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setPitch(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextToSpeechFunc_setPitch_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPitch(double)
            cppSelf->setPitch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextToSpeechFunc_setPitch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextToSpeechFunc_setRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.setRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextToSpeech::setRate(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setRate(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextToSpeechFunc_setRate_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRate(double)
            cppSelf->setRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextToSpeechFunc_setRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextToSpeechFunc_setVoice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.setVoice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextToSpeech::setVoice(QVoice)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), (pyArg)))) {
        overloadId = 0; // setVoice(QVoice)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextToSpeechFunc_setVoice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVoice cppArg0_local;
        ::QVoice *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setVoice(QVoice)
            cppSelf->setVoice(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextToSpeechFunc_setVoice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextToSpeechFunc_setVolume(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.setVolume";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextToSpeech::setVolume(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setVolume(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextToSpeechFunc_setVolume_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVolume(double)
            cppSelf->setVolume(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextToSpeechFunc_setVolume_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextToSpeechFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QTextToSpeech::State cppResult = const_cast<const ::QTextToSpeech *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextToSpeechFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextToSpeechFunc_voice(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.voice";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // voice()const
            QVoice cppResult = const_cast<const ::QTextToSpeech *>(cppSelf)->voice();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextToSpeechFunc_volume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QTextToSpeech.volume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // volume()const
            double cppResult = const_cast<const ::QTextToSpeech *>(cppSelf)->volume();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextToSpeech_PropertyStrings[] = {
    "locale::",
    "pitch::",
    "rate::",
    "state:",
    "voice::",
    "volume::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextToSpeech_methods[] = {
    {"availableEngines", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_availableEngines), METH_NOARGS|METH_STATIC},
    {"availableLocales", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_availableLocales), METH_NOARGS},
    {"availableVoices", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_availableVoices), METH_NOARGS},
    {"locale", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_locale), METH_NOARGS},
    {"pause", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_pause), METH_NOARGS},
    {"pitch", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_pitch), METH_NOARGS},
    {"rate", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_rate), METH_NOARGS},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_resume), METH_NOARGS},
    {"say", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_say), METH_O},
    {"setLocale", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_setLocale), METH_O},
    {"setPitch", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_setPitch), METH_O},
    {"setRate", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_setRate), METH_O},
    {"setVoice", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_setVoice), METH_O},
    {"setVolume", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_setVolume), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_state), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_stop), METH_NOARGS},
    {"voice", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_voice), METH_NOARGS},
    {"volume", reinterpret_cast<PyCFunction>(Sbk_QTextToSpeechFunc_volume), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTextToSpeech_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTextToSpeech *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTextToSpeechWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QTextToSpeech_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextToSpeech_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextToSpeech_Type = nullptr;
static SbkObjectType *Sbk_QTextToSpeech_TypeF(void)
{
    return _Sbk_QTextToSpeech_Type;
}

static PyType_Slot Sbk_QTextToSpeech_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTextToSpeech_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextToSpeech_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextToSpeech_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextToSpeech_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextToSpeech_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextToSpeech_spec = {
    "2:PySide2.QtTextToSpeech.QTextToSpeech",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextToSpeech_slots
};

} //extern "C"

static void *Sbk_QTextToSpeech_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QTextToSpeech *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QTextToSpeech_State_PythonToCpp_QTextToSpeech_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextToSpeech::State *>(cppOut) =
        static_cast<::QTextToSpeech::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextToSpeech_State_PythonToCpp_QTextToSpeech_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX]))
        return QTextToSpeech_State_PythonToCpp_QTextToSpeech_State;
    return {};
}
static PyObject *QTextToSpeech_State_CppToPython_QTextToSpeech_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextToSpeech::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextToSpeech_PythonToCpp_QTextToSpeech_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextToSpeech_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextToSpeech_PythonToCpp_QTextToSpeech_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextToSpeech_TypeF())))
        return QTextToSpeech_PythonToCpp_QTextToSpeech_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextToSpeech_PTR_CppToPython_QTextToSpeech(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QTextToSpeech *>(const_cast<void *>(cppIn)), Sbk_QTextToSpeech_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextToSpeech_SignatureStrings[] = {
    "1:PySide2.QtTextToSpeech.QTextToSpeech(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtTextToSpeech.QTextToSpeech(self,engine:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtTextToSpeech.QTextToSpeech.availableEngines()->QStringList",
    "PySide2.QtTextToSpeech.QTextToSpeech.availableLocales(self)->QVector[PySide2.QtCore.QLocale]",
    "PySide2.QtTextToSpeech.QTextToSpeech.availableVoices(self)->QVector[PySide2.QtTextToSpeech.QVoice]",
    "PySide2.QtTextToSpeech.QTextToSpeech.locale(self)->PySide2.QtCore.QLocale",
    "PySide2.QtTextToSpeech.QTextToSpeech.pause(self)",
    "PySide2.QtTextToSpeech.QTextToSpeech.pitch(self)->double",
    "PySide2.QtTextToSpeech.QTextToSpeech.rate(self)->double",
    "PySide2.QtTextToSpeech.QTextToSpeech.resume(self)",
    "PySide2.QtTextToSpeech.QTextToSpeech.say(self,text:QString)",
    "PySide2.QtTextToSpeech.QTextToSpeech.setLocale(self,locale:PySide2.QtCore.QLocale)",
    "PySide2.QtTextToSpeech.QTextToSpeech.setPitch(self,pitch:double)",
    "PySide2.QtTextToSpeech.QTextToSpeech.setRate(self,rate:double)",
    "PySide2.QtTextToSpeech.QTextToSpeech.setVoice(self,voice:PySide2.QtTextToSpeech.QVoice)",
    "PySide2.QtTextToSpeech.QTextToSpeech.setVolume(self,volume:double)",
    "PySide2.QtTextToSpeech.QTextToSpeech.state(self)->PySide2.QtTextToSpeech.QTextToSpeech.State",
    "PySide2.QtTextToSpeech.QTextToSpeech.stop(self)",
    "PySide2.QtTextToSpeech.QTextToSpeech.voice(self)->PySide2.QtTextToSpeech.QVoice",
    "PySide2.QtTextToSpeech.QTextToSpeech.volume(self)->double",
    nullptr}; // Sentinel

void init_QTextToSpeech(PyObject *module)
{
    _Sbk_QTextToSpeech_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextToSpeech",
        "QTextToSpeech*",
        &Sbk_QTextToSpeech_spec,
        &Shiboken::callCppDestructor< ::QTextToSpeech >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextToSpeech_Type);
    InitSignatureStrings(pyType, QTextToSpeech_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextToSpeech_Type), Sbk_QTextToSpeech_PropertyStrings);
    SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextToSpeech_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextToSpeech_TypeF(),
        QTextToSpeech_PythonToCpp_QTextToSpeech_PTR,
        is_QTextToSpeech_PythonToCpp_QTextToSpeech_PTR_Convertible,
        QTextToSpeech_PTR_CppToPython_QTextToSpeech);

    Shiboken::Conversions::registerConverterName(converter, "QTextToSpeech");
    Shiboken::Conversions::registerConverterName(converter, "QTextToSpeech*");
    Shiboken::Conversions::registerConverterName(converter, "QTextToSpeech&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextToSpeech).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextToSpeechWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QTextToSpeech_TypeF(), &Sbk_QTextToSpeech_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextToSpeech_TypeF(),
        "State",
        "2:PySide2.QtTextToSpeech.QTextToSpeech.State",
        "QTextToSpeech::State");
    if (!SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX],
        Sbk_QTextToSpeech_TypeF(), "Ready", (long) QTextToSpeech::State::Ready))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX],
        Sbk_QTextToSpeech_TypeF(), "Speaking", (long) QTextToSpeech::State::Speaking))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX],
        Sbk_QTextToSpeech_TypeF(), "Paused", (long) QTextToSpeech::State::Paused))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX],
        Sbk_QTextToSpeech_TypeF(), "BackendError", (long) QTextToSpeech::State::BackendError))
        return;
    // Register converter for enum 'QTextToSpeech::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX],
            QTextToSpeech_State_CppToPython_QTextToSpeech_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextToSpeech_State_PythonToCpp_QTextToSpeech_State,
            is_QTextToSpeech_State_PythonToCpp_QTextToSpeech_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtTextToSpeechTypes[SBK_QTEXTTOSPEECH_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextToSpeech::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    PySide::Signal::registerSignals(Sbk_QTextToSpeech_TypeF(), &::QTextToSpeech::staticMetaObject);
    qRegisterMetaType< ::QTextToSpeech::State >("QTextToSpeech::State");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QTextToSpeech_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QTextToSpeech_TypeF(), &::QTextToSpeech::staticMetaObject, sizeof(QTextToSpeechWrapper));
}
