/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtsql_python.h"

// main header
#include "qsqlerror_wrapper.h"

// inner classes

// Extra includes
#include <QtSql/qsqlerror.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSqlError_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSqlError >()))
        return -1;

    ::QSqlError *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlError_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QSqlError", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QSqlError::QSqlError(QSqlError)
    // 1: QSqlError::QSqlError(QString,QString,QSqlError::ErrorType,QString)
    // 2: QSqlError::QSqlError(QString,QString,QSqlError::ErrorType,int)
    if (numArgs == 0) {
        overloadId = 1; // QSqlError(QString,QString,QSqlError::ErrorType,QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QSqlError(QString,QString,QSqlError::ErrorType,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // QSqlError(QString,QString,QSqlError::ErrorType,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // QSqlError(QString,QString,QSqlError::ErrorType,QString)
                } else if (numArgs == 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 2; // QSqlError(QString,QString,QSqlError::ErrorType,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    overloadId = 1; // QSqlError(QString,QString,QSqlError::ErrorType,QString)
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSqlError(QSqlError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlError_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSqlError(const QSqlError & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QSqlError_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSqlError cppArg0_local;
            ::QSqlError *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSqlError(QSqlError)
                cptr = new ::QSqlError(*cppArg0);
            }
            break;
        }
        case 1: // QSqlError(const QString & driverText, const QString & databaseText, QSqlError::ErrorType type, const QString & errorCode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_driverText = Shiboken::String::createStaticString("driverText");
                if (PyDict_Contains(kwds, key_driverText)) {
                    value = PyDict_GetItem(kwds, key_driverText);
                    if (value && pyArgs[0]) {
                        errInfo = key_driverText;
                        Py_INCREF(errInfo);
                        goto Sbk_QSqlError_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                            goto Sbk_QSqlError_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_driverText);
                }
                static PyObject *const key_databaseText = Shiboken::String::createStaticString("databaseText");
                if (PyDict_Contains(kwds, key_databaseText)) {
                    value = PyDict_GetItem(kwds, key_databaseText);
                    if (value && pyArgs[1]) {
                        errInfo = key_databaseText;
                        Py_INCREF(errInfo);
                        goto Sbk_QSqlError_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QSqlError_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_databaseText);
                }
                static PyObject *const key_type = Shiboken::String::createStaticString("type");
                if (PyDict_Contains(kwds, key_type)) {
                    value = PyDict_GetItem(kwds, key_type);
                    if (value && pyArgs[2]) {
                        errInfo = key_type;
                        Py_INCREF(errInfo);
                        goto Sbk_QSqlError_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QSqlError_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_type);
                }
                static PyObject *const key_errorCode = Shiboken::String::createStaticString("errorCode");
                if (PyDict_Contains(kwds, key_errorCode)) {
                    value = PyDict_GetItem(kwds, key_errorCode);
                    if (value && pyArgs[3]) {
                        errInfo = key_errorCode;
                        Py_INCREF(errInfo);
                        goto Sbk_QSqlError_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_QSqlError_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_errorCode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSqlError_Init_TypeError;
                }
            }
            ::QString cppArg0 = QString();
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QSqlError::ErrorType cppArg2 = QSqlError::ErrorType::NoError;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QSqlError(QString,QString,QSqlError::ErrorType,QString)
                cptr = new ::QSqlError(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // QSqlError(const QString & driverText, const QString & databaseText, QSqlError::ErrorType type, int number)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QSqlError_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QSqlError::ErrorType cppArg2{QSqlError::NoError};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QSqlError(QString,QString,QSqlError::ErrorType,int)
                cptr = new ::QSqlError(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QSqlError.QSqlError(const QString & driverText, const QString & databaseText, QSqlError::ErrorType type, int number) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSqlError >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSqlError_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSqlError_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSqlErrorFunc_databaseText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.databaseText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // databaseText()const
            QString cppResult = const_cast<const ::QSqlError *>(cppSelf)->databaseText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlErrorFunc_driverText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.driverText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // driverText()const
            QString cppResult = const_cast<const ::QSqlError *>(cppSelf)->driverText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlErrorFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QSqlError *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlErrorFunc_nativeErrorCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.nativeErrorCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeErrorCode()const
            QString cppResult = const_cast<const ::QSqlError *>(cppSelf)->nativeErrorCode();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlErrorFunc_number(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.number";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // number()const
            int cppResult = const_cast<const ::QSqlError *>(cppSelf)->number();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlErrorFunc_setDatabaseText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.setDatabaseText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlError::setDatabaseText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDatabaseText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlErrorFunc_setDatabaseText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDatabaseText(QString)
            cppSelf->setDatabaseText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlErrorFunc_setDatabaseText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlErrorFunc_setDriverText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.setDriverText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlError::setDriverText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDriverText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlErrorFunc_setDriverText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDriverText(QString)
            cppSelf->setDriverText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlErrorFunc_setDriverText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlErrorFunc_setNumber(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.setNumber";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlError::setNumber(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setNumber(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlErrorFunc_setNumber_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumber(int)
            cppSelf->setNumber(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlErrorFunc_setNumber_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlErrorFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.setType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlError::setType(QSqlError::ErrorType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setType(QSqlError::ErrorType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlErrorFunc_setType_TypeError;

    // Call function/method
    {
        ::QSqlError::ErrorType cppArg0{QSqlError::NoError};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setType(QSqlError::ErrorType)
            cppSelf->setType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlErrorFunc_setType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlErrorFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlError::swap(QSqlError&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QSqlError&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlErrorFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSqlError cppArg0_local;
        ::QSqlError *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QSqlError&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlErrorFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlErrorFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QSqlError *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlErrorFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlError.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QSqlError::ErrorType cppResult = const_cast<const ::QSqlError *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlError___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSqlError_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSqlError_methods[] = {
    {"databaseText", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_databaseText), METH_NOARGS},
    {"driverText", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_driverText), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_isValid), METH_NOARGS},
    {"nativeErrorCode", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_nativeErrorCode), METH_NOARGS},
    {"number", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_number), METH_NOARGS},
    {"setDatabaseText", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_setDatabaseText), METH_O},
    {"setDriverText", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_setDriverText), METH_O},
    {"setNumber", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_setNumber), METH_O},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_setType), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_swap), METH_O},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_text), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QSqlErrorFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSqlError___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QSqlError_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), (pyArg)))) {
                // operator!=(const QSqlError & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSqlError cppArg0_local;
                ::QSqlError *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), (pyArg)))) {
                // operator==(const QSqlError & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSqlError cppArg0_local;
                ::QSqlError *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSqlError_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSqlError_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSqlError_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSqlError_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSqlError__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSqlError_Type = nullptr;
static SbkObjectType *Sbk_QSqlError_TypeF(void)
{
    return _Sbk_QSqlError_Type;
}

static PyType_Slot Sbk_QSqlError_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSqlError__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSqlError_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSqlError_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSqlError_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSqlError_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSqlError_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSqlError_spec = {
    "2:PySide2.QtSql.QSqlError",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSqlError_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSqlError_ErrorType_PythonToCpp_QSqlError_ErrorType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlError::ErrorType *>(cppOut) =
        static_cast<::QSqlError::ErrorType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSqlError_ErrorType_PythonToCpp_QSqlError_ErrorType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX]))
        return QSqlError_ErrorType_PythonToCpp_QSqlError_ErrorType;
    return {};
}
static PyObject *QSqlError_ErrorType_CppToPython_QSqlError_ErrorType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSqlError::ErrorType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSqlError_PythonToCpp_QSqlError_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSqlError_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSqlError_PythonToCpp_QSqlError_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSqlError_TypeF())))
        return QSqlError_PythonToCpp_QSqlError_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSqlError_PTR_CppToPython_QSqlError(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSqlError *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSqlError_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSqlError_COPY_CppToPython_QSqlError(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSqlError_TypeF(), new ::QSqlError(*reinterpret_cast<const ::QSqlError *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSqlError_PythonToCpp_QSqlError_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlError *>(cppOut) = *reinterpret_cast< ::QSqlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSqlError_PythonToCpp_QSqlError_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSqlError_TypeF())))
        return QSqlError_PythonToCpp_QSqlError_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSqlError_SignatureStrings[] = {
    "2:PySide2.QtSql.QSqlError(self,other:PySide2.QtSql.QSqlError)",
    "1:PySide2.QtSql.QSqlError(self,driverText:QString=QString(),databaseText:QString=QString(),type:PySide2.QtSql.QSqlError.ErrorType=NoError,errorCode:QString=QString())",
    "0:PySide2.QtSql.QSqlError(self,driverText:QString,databaseText:QString,type:PySide2.QtSql.QSqlError.ErrorType,number:int)",
    "PySide2.QtSql.QSqlError.databaseText(self)->QString",
    "PySide2.QtSql.QSqlError.driverText(self)->QString",
    "PySide2.QtSql.QSqlError.isValid(self)->bool",
    "PySide2.QtSql.QSqlError.nativeErrorCode(self)->QString",
    "PySide2.QtSql.QSqlError.number(self)->int",
    "PySide2.QtSql.QSqlError.setDatabaseText(self,databaseText:QString)",
    "PySide2.QtSql.QSqlError.setDriverText(self,driverText:QString)",
    "PySide2.QtSql.QSqlError.setNumber(self,number:int)",
    "PySide2.QtSql.QSqlError.setType(self,type:PySide2.QtSql.QSqlError.ErrorType)",
    "PySide2.QtSql.QSqlError.swap(self,other:PySide2.QtSql.QSqlError)",
    "PySide2.QtSql.QSqlError.text(self)->QString",
    "PySide2.QtSql.QSqlError.type(self)->PySide2.QtSql.QSqlError.ErrorType",
    "PySide2.QtSql.QSqlError.__copy__()",
    nullptr}; // Sentinel

void init_QSqlError(PyObject *module)
{
    _Sbk_QSqlError_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSqlError",
        "QSqlError",
        &Sbk_QSqlError_spec,
        &Shiboken::callCppDestructor< ::QSqlError >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSqlError_Type);
    InitSignatureStrings(pyType, QSqlError_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSqlError_Type), Sbk_QSqlError_PropertyStrings);
    SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSqlError_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSqlError_TypeF(),
        QSqlError_PythonToCpp_QSqlError_PTR,
        is_QSqlError_PythonToCpp_QSqlError_PTR_Convertible,
        QSqlError_PTR_CppToPython_QSqlError,
        QSqlError_COPY_CppToPython_QSqlError);

    Shiboken::Conversions::registerConverterName(converter, "QSqlError");
    Shiboken::Conversions::registerConverterName(converter, "QSqlError*");
    Shiboken::Conversions::registerConverterName(converter, "QSqlError&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSqlError).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSqlError_PythonToCpp_QSqlError_COPY,
        is_QSqlError_PythonToCpp_QSqlError_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ErrorType'.
    SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSqlError_TypeF(),
        "ErrorType",
        "2:PySide2.QtSql.QSqlError.ErrorType",
        "QSqlError::ErrorType");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX],
        Sbk_QSqlError_TypeF(), "NoError", (long) QSqlError::ErrorType::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX],
        Sbk_QSqlError_TypeF(), "ConnectionError", (long) QSqlError::ErrorType::ConnectionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX],
        Sbk_QSqlError_TypeF(), "StatementError", (long) QSqlError::ErrorType::StatementError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX],
        Sbk_QSqlError_TypeF(), "TransactionError", (long) QSqlError::ErrorType::TransactionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX],
        Sbk_QSqlError_TypeF(), "UnknownError", (long) QSqlError::ErrorType::UnknownError))
        return;
    // Register converter for enum 'QSqlError::ErrorType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX],
            QSqlError_ErrorType_CppToPython_QSqlError_ErrorType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSqlError_ErrorType_PythonToCpp_QSqlError_ErrorType,
            is_QSqlError_ErrorType_PythonToCpp_QSqlError_ErrorType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_ERRORTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSqlError::ErrorType");
        Shiboken::Conversions::registerConverterName(converter, "ErrorType");
    }
    // End of 'ErrorType' enum.

    qRegisterMetaType< ::QSqlError::ErrorType >("QSqlError::ErrorType");
}
