/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtsql_python.h"

// main header
#include "qsqldriver_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSqlDriverWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSqlDriverWrapper::QSqlDriverWrapper(::QObject * parent) : QSqlDriver(parent)
{
    resetPyMethodCache();
    // ... middle
}

bool QSqlDriverWrapper::beginTransaction()
{
    if (m_PyMethodCache[0])
        return this->::QSqlDriver::beginTransaction();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "beginTransaction";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QSqlDriver::beginTransaction();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.beginTransaction", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSqlDriverWrapper::cancelQuery()
{
    if (m_PyMethodCache[1])
        return this->::QSqlDriver::cancelQuery();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "cancelQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSqlDriver::cancelQuery();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.cancelQuery", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSqlDriverWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSqlDriverWrapper::close()
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.close()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "close";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.close()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSqlDriverWrapper::commitTransaction()
{
    if (m_PyMethodCache[4])
        return this->::QSqlDriver::commitTransaction();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "commitTransaction";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QSqlDriver::commitTransaction();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.commitTransaction", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSqlDriverWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSqlResult * QSqlDriverWrapper::createResult() const
{
    if (m_PyMethodCache[6]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.createResult()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createResult";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.createResult()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRESULT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.createResult", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSqlResult >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSqlResult *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSqlDriverWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSqlDriverWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QString QSqlDriverWrapper::escapeIdentifier(const ::QString & identifier, ::QSqlDriver::IdentifierType type) const
{
    if (m_PyMethodCache[9])
        return this->::QSqlDriver::escapeIdentifier(identifier, type);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "escapeIdentifier";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QSqlDriver::escapeIdentifier(identifier, type);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &identifier),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])->converter, &type)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.escapeIdentifier", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSqlDriverWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSqlDriverWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[11])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QString QSqlDriverWrapper::formatValue(const ::QSqlField & field, bool trimStrings) const
{
    if (m_PyMethodCache[12])
        return this->::QSqlDriver::formatValue(field, trimStrings);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "formatValue";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QSqlDriver::formatValue(field, trimStrings);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), &field),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &trimStrings)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.formatValue", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSqlDriverWrapper::hasFeature(::QSqlDriver::DriverFeature f) const
{
    if (m_PyMethodCache[13]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.hasFeature()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasFeature";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.hasFeature()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX])->converter, &f)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.hasFeature", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSqlDriverWrapper::isIdentifierEscaped(const ::QString & identifier, ::QSqlDriver::IdentifierType type) const
{
    if (m_PyMethodCache[14])
        return this->::QSqlDriver::isIdentifierEscaped(identifier, type);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isIdentifierEscaped";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QSqlDriver::isIdentifierEscaped(identifier, type);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &identifier),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])->converter, &type)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.isIdentifierEscaped", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSqlDriverWrapper::isOpen() const
{
    if (m_PyMethodCache[15])
        return this->::QSqlDriver::isOpen();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isOpen";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QSqlDriver::isOpen();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.isOpen", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSqlDriverWrapper::open(const ::QString & db, const ::QString & user, const ::QString & password, const ::QString & host, int port, const ::QString & connOpts)
{
    if (m_PyMethodCache[17]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "open";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNNiN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &db),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &user),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &password),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &host),
    port,
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &connOpts)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.open", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSqlIndex QSqlDriverWrapper::primaryIndex(const ::QString & tableName) const
{
    if (m_PyMethodCache[18])
        return this->::QSqlDriver::primaryIndex(tableName);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QSqlIndex();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "primaryIndex";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QSqlDriver::primaryIndex(tableName);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &tableName)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QSqlIndex();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.primaryIndex", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSqlIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return ::QSqlIndex();
    }
    ::QSqlIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSqlRecord QSqlDriverWrapper::record(const ::QString & tableName) const
{
    if (m_PyMethodCache[19])
        return this->::QSqlDriver::record(tableName);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "record";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QSqlDriver::record(tableName);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &tableName)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.record", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSqlRecord >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSqlRecord cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSqlDriverWrapper::rollbackTransaction()
{
    if (m_PyMethodCache[20])
        return this->::QSqlDriver::rollbackTransaction();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "rollbackTransaction";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QSqlDriver::rollbackTransaction();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.rollbackTransaction", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSqlDriverWrapper::setLastError(const ::QSqlError & e)
{
    if (m_PyMethodCache[21]) {
        return this->::QSqlDriver::setLastError(e);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setLastError";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QSqlDriver::setLastError(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), &e)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSqlDriverWrapper::setOpen(bool o)
{
    if (m_PyMethodCache[22]) {
        return this->::QSqlDriver::setOpen(o);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setOpen";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QSqlDriver::setOpen(o);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &o)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSqlDriverWrapper::setOpenError(bool e)
{
    if (m_PyMethodCache[23]) {
        return this->::QSqlDriver::setOpenError(e);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setOpenError";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QSqlDriver::setOpenError(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &e)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QString QSqlDriverWrapper::sqlStatement(::QSqlDriver::StatementType type, const ::QString & tableName, const ::QSqlRecord & rec, bool preparedStatement) const
{
    if (m_PyMethodCache[24])
        return this->::QSqlDriver::sqlStatement(type, tableName, rec, preparedStatement);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sqlStatement";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QSqlDriver::sqlStatement(type, tableName, rec, preparedStatement);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX])->converter, &type),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &tableName),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), &rec),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &preparedStatement)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.sqlStatement", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString QSqlDriverWrapper::stripDelimiters(const ::QString & identifier, ::QSqlDriver::IdentifierType type) const
{
    if (m_PyMethodCache[25])
        return this->::QSqlDriver::stripDelimiters(identifier, type);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stripDelimiters";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QSqlDriver::stripDelimiters(identifier, type);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &identifier),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])->converter, &type)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.stripDelimiters", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSqlDriverWrapper::subscribeToNotification(const ::QString & name)
{
    if (m_PyMethodCache[26])
        return this->::QSqlDriver::subscribeToNotification(name);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "subscribeToNotification";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QSqlDriver::subscribeToNotification(name);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &name)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.subscribeToNotification", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QStringList QSqlDriverWrapper::subscribedToNotifications() const
{
    if (m_PyMethodCache[27])
        return this->::QSqlDriver::subscribedToNotifications();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QStringList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "subscribedToNotifications";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QSqlDriver::subscribedToNotifications();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QStringList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.subscribedToNotifications", "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QStringList QSqlDriverWrapper::tables(::QSql::TableType tableType) const
{
    if (m_PyMethodCache[28])
        return this->::QSqlDriver::tables(tableType);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QStringList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "tables";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QSqlDriver::tables(tableType);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX])->converter, &tableType)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QStringList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.tables", "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSqlDriverWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[29]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QSqlDriverWrapper::unsubscribeFromNotification(const ::QString & name)
{
    if (m_PyMethodCache[30])
        return this->::QSqlDriver::unsubscribeFromNotification(name);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "unsubscribeFromNotification";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QSqlDriver::unsubscribeFromNotification(name);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &name)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriver.unsubscribeFromNotification", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QSqlDriverWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSqlDriver::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSqlDriverWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSqlDriver::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSqlDriverWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSqlDriverWrapper *>(this));
        return QSqlDriver::qt_metacast(_clname);
}

QSqlDriverWrapper::~QSqlDriverWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSqlDriver_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSqlDriver' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSqlDriver >()))
        return -1;

    ::QSqlDriverWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QSqlDriver", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSqlDriver::QSqlDriver(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSqlDriver(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSqlDriver(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriver_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDriver_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QSqlDriver_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QSqlDriver(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QSqlDriverWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QSqlDriverWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSqlDriver >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSqlDriver_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSqlDriver_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSqlDriver_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSqlDriverFunc_beginTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.beginTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // beginTransaction()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::beginTransaction()
                : cppSelf->beginTransaction();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_cancelQuery(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.cancelQuery";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cancelQuery()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::cancelQuery()
                : cppSelf->cancelQuery();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.close()' not implemented.");
                return {};
            }
            cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSqlDriverFunc_commitTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.commitTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // commitTransaction()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::commitTransaction()
                : cppSelf->commitTransaction();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_createResult(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.createResult";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createResult()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.createResult()' not implemented.");
                return {};
            }
            QSqlResult * cppResult = const_cast<const ::QSqlDriver *>(cppSelf)->createResult();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRESULT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_dbmsType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.dbmsType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dbmsType()const
            QSqlDriver::DbmsType cppResult = const_cast<const ::QSqlDriver *>(cppSelf)->dbmsType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_escapeIdentifier(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.escapeIdentifier";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "escapeIdentifier", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDriver::escapeIdentifier(QString,QSqlDriver::IdentifierType)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // escapeIdentifier(QString,QSqlDriver::IdentifierType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_escapeIdentifier_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QSqlDriver::IdentifierType cppArg1{QSqlDriver::FieldName};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // escapeIdentifier(QString,QSqlDriver::IdentifierType)const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::escapeIdentifier(cppArg0, cppArg1)
                : const_cast<const ::QSqlDriver *>(cppSelf)->escapeIdentifier(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_escapeIdentifier_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_formatValue(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.formatValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDriverFunc_formatValue_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDriverFunc_formatValue_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:formatValue", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDriver::formatValue(QSqlField,bool)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // formatValue(QSqlField,bool)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // formatValue(QSqlField,bool)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_formatValue_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_trimStrings = Shiboken::String::createStaticString("trimStrings");
            if (PyDict_Contains(kwds, key_trimStrings)) {
                value = PyDict_GetItem(kwds, key_trimStrings);
                if (value && pyArgs[1]) {
                    errInfo = key_trimStrings;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDriverFunc_formatValue_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QSqlDriverFunc_formatValue_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_trimStrings);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSqlDriverFunc_formatValue_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSqlField cppArg0_local;
        ::QSqlField *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // formatValue(QSqlField,bool)const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::formatValue(*cppArg0, cppArg1)
                : const_cast<const ::QSqlDriver *>(cppSelf)->formatValue(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_formatValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_hasFeature(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.hasFeature";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::hasFeature(QSqlDriver::DriverFeature)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // hasFeature(QSqlDriver::DriverFeature)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_hasFeature_TypeError;

    // Call function/method
    {
        ::QSqlDriver::DriverFeature cppArg0{QSqlDriver::Transactions};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasFeature(QSqlDriver::DriverFeature)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.hasFeature()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QSqlDriver *>(cppSelf)->hasFeature(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_hasFeature_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_isIdentifierEscaped(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.isIdentifierEscaped";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isIdentifierEscaped", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDriver::isIdentifierEscaped(QString,QSqlDriver::IdentifierType)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // isIdentifierEscaped(QString,QSqlDriver::IdentifierType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_isIdentifierEscaped_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QSqlDriver::IdentifierType cppArg1{QSqlDriver::FieldName};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isIdentifierEscaped(QString,QSqlDriver::IdentifierType)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::isIdentifierEscaped(cppArg0, cppArg1)
                : const_cast<const ::QSqlDriver *>(cppSelf)->isIdentifierEscaped(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_isIdentifierEscaped_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_isOpen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.isOpen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOpen()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::isOpen()
                : const_cast<const ::QSqlDriver *>(cppSelf)->isOpen();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_isOpenError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.isOpenError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOpenError()const
            bool cppResult = const_cast<const ::QSqlDriver *>(cppSelf)->isOpenError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_lastError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.lastError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastError()const
            QSqlError cppResult = const_cast<const ::QSqlDriver *>(cppSelf)->lastError();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_numericalPrecisionPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.numericalPrecisionPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numericalPrecisionPolicy()const
            QSql::NumericalPrecisionPolicy cppResult = const_cast<const ::QSqlDriver *>(cppSelf)->numericalPrecisionPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_open(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.open";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDriverFunc_open_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSqlDriverFunc_open_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:open", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDriver::open(QString,QString,QString,QString,int,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // open(QString,QString,QString,QString,int,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // open(QString,QString,QString,QString,int,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // open(QString,QString,QString,QString,int,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // open(QString,QString,QString,QString,int,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // open(QString,QString,QString,QString,int,QString)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
                            overloadId = 0; // open(QString,QString,QString,QString,int,QString)
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_open_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_user = Shiboken::String::createStaticString("user");
            if (PyDict_Contains(kwds, key_user)) {
                value = PyDict_GetItem(kwds, key_user);
                if (value && pyArgs[1]) {
                    errInfo = key_user;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_user);
            }
            static PyObject *const key_password = Shiboken::String::createStaticString("password");
            if (PyDict_Contains(kwds, key_password)) {
                value = PyDict_GetItem(kwds, key_password);
                if (value && pyArgs[2]) {
                    errInfo = key_password;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_password);
            }
            static PyObject *const key_host = Shiboken::String::createStaticString("host");
            if (PyDict_Contains(kwds, key_host)) {
                value = PyDict_GetItem(kwds, key_host);
                if (value && pyArgs[3]) {
                    errInfo = key_host;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_host);
            }
            static PyObject *const key_port = Shiboken::String::createStaticString("port");
            if (PyDict_Contains(kwds, key_port)) {
                value = PyDict_GetItem(kwds, key_port);
                if (value && pyArgs[4]) {
                    errInfo = key_port;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                        goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_port);
            }
            static PyObject *const key_connOpts = Shiboken::String::createStaticString("connOpts");
            if (PyDict_Contains(kwds, key_connOpts)) {
                value = PyDict_GetItem(kwds, key_connOpts);
                if (value && pyArgs[5]) {
                    errInfo = key_connOpts;
                    Py_INCREF(errInfo);
                    goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5]))))
                        goto Sbk_QSqlDriverFunc_open_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_connOpts);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSqlDriverFunc_open_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = -1;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // open(QString,QString,QString,QString,int,QString)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
                return {};
            }
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = cppSelf->open(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_open_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_primaryIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.primaryIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::primaryIndex(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // primaryIndex(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_primaryIndex_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // primaryIndex(QString)const
            QSqlIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::primaryIndex(cppArg0)
                : const_cast<const ::QSqlDriver *>(cppSelf)->primaryIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_primaryIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_record(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.record";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::record(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // record(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_record_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // record(QString)const
            QSqlRecord cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::record(cppArg0)
                : const_cast<const ::QSqlDriver *>(cppSelf)->record(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_record_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_rollbackTransaction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.rollbackTransaction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rollbackTransaction()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::rollbackTransaction()
                : cppSelf->rollbackTransaction();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_setLastError(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.setLastError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::setLastError(QSqlError)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), (pyArg)))) {
        overloadId = 0; // setLastError(QSqlError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_setLastError_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSqlError cppArg0_local;
        ::QSqlError *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLERROR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLastError(QSqlError)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::setLastError(*cppArg0)
                : cppSelf->setLastError(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDriverFunc_setLastError_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_setNumericalPrecisionPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.setNumericalPrecisionPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQL_NUMERICALPRECISIONPOLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_setNumericalPrecisionPolicy_TypeError;

    // Call function/method
    {
        ::QSql::NumericalPrecisionPolicy cppArg0{QSql::HighPrecision};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
            cppSelf->setNumericalPrecisionPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDriverFunc_setNumericalPrecisionPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_setOpen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.setOpen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::setOpen(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOpen(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_setOpen_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOpen(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::setOpen(cppArg0)
                : cppSelf->setOpen(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDriverFunc_setOpen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_setOpenError(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.setOpenError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::setOpenError(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOpenError(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_setOpenError_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOpenError(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::setOpenError(cppArg0)
                : cppSelf->setOpenError(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlDriverFunc_setOpenError_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_sqlStatement(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.sqlStatement";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sqlStatement", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDriver::sqlStatement(QSqlDriver::StatementType,QString,QSqlRecord,bool)const
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
        overloadId = 0; // sqlStatement(QSqlDriver::StatementType,QString,QSqlRecord,bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_sqlStatement_TypeError;

    // Call function/method
    {
        ::QSqlDriver::StatementType cppArg0{QSqlDriver::WhereStatement};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QSqlRecord cppArg2_local;
        ::QSqlRecord *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        bool cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // sqlStatement(QSqlDriver::StatementType,QString,QSqlRecord,bool)const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::sqlStatement(cppArg0, cppArg1, *cppArg2, cppArg3)
                : const_cast<const ::QSqlDriver *>(cppSelf)->sqlStatement(cppArg0, cppArg1, *cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_sqlStatement_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_stripDelimiters(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.stripDelimiters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "stripDelimiters", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlDriver::stripDelimiters(QString,QSqlDriver::IdentifierType)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // stripDelimiters(QString,QSqlDriver::IdentifierType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_stripDelimiters_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QSqlDriver::IdentifierType cppArg1{QSqlDriver::FieldName};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // stripDelimiters(QString,QSqlDriver::IdentifierType)const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::stripDelimiters(cppArg0, cppArg1)
                : const_cast<const ::QSqlDriver *>(cppSelf)->stripDelimiters(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_stripDelimiters_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_subscribeToNotification(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.subscribeToNotification";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::subscribeToNotification(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // subscribeToNotification(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_subscribeToNotification_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // subscribeToNotification(QString)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::subscribeToNotification(cppArg0)
                : cppSelf->subscribeToNotification(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_subscribeToNotification_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_subscribedToNotifications(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.subscribedToNotifications";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subscribedToNotifications()const
            QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::subscribedToNotifications()
                : const_cast<const ::QSqlDriver *>(cppSelf)->subscribedToNotifications();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlDriverFunc_tables(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.tables";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::tables(QSql::TableType)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSqlTypes[SBK_QSQL_TABLETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // tables(QSql::TableType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_tables_TypeError;

    // Call function/method
    {
        ::QSql::TableType cppArg0 = static_cast< ::QSql::TableType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // tables(QSql::TableType)const
            QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSqlDriver *>(cppSelf)->::QSqlDriver::tables(cppArg0)
                : const_cast<const ::QSqlDriver *>(cppSelf)->tables(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_tables_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlDriverFunc_unsubscribeFromNotification(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriver.unsubscribeFromNotification";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlDriver::unsubscribeFromNotification(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // unsubscribeFromNotification(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlDriverFunc_unsubscribeFromNotification_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // unsubscribeFromNotification(QString)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSqlDriver::unsubscribeFromNotification(cppArg0)
                : cppSelf->unsubscribeFromNotification(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlDriverFunc_unsubscribeFromNotification_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSqlDriver_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSqlDriver_methods[] = {
    {"beginTransaction", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_beginTransaction), METH_NOARGS},
    {"cancelQuery", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_cancelQuery), METH_NOARGS},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_close), METH_NOARGS},
    {"commitTransaction", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_commitTransaction), METH_NOARGS},
    {"createResult", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_createResult), METH_NOARGS},
    {"dbmsType", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_dbmsType), METH_NOARGS},
    {"escapeIdentifier", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_escapeIdentifier), METH_VARARGS},
    {"formatValue", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_formatValue), METH_VARARGS|METH_KEYWORDS},
    {"hasFeature", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_hasFeature), METH_O},
    {"isIdentifierEscaped", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_isIdentifierEscaped), METH_VARARGS},
    {"isOpen", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_isOpen), METH_NOARGS},
    {"isOpenError", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_isOpenError), METH_NOARGS},
    {"lastError", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_lastError), METH_NOARGS},
    {"numericalPrecisionPolicy", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_numericalPrecisionPolicy), METH_NOARGS},
    {"open", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_open), METH_VARARGS|METH_KEYWORDS},
    {"primaryIndex", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_primaryIndex), METH_O},
    {"record", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_record), METH_O},
    {"rollbackTransaction", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_rollbackTransaction), METH_NOARGS},
    {"setLastError", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_setLastError), METH_O},
    {"setNumericalPrecisionPolicy", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_setNumericalPrecisionPolicy), METH_O},
    {"setOpen", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_setOpen), METH_O},
    {"setOpenError", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_setOpenError), METH_O},
    {"sqlStatement", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_sqlStatement), METH_VARARGS},
    {"stripDelimiters", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_stripDelimiters), METH_VARARGS},
    {"subscribeToNotification", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_subscribeToNotification), METH_O},
    {"subscribedToNotifications", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_subscribedToNotifications), METH_NOARGS},
    {"tables", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_tables), METH_O},
    {"unsubscribeFromNotification", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverFunc_unsubscribeFromNotification), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSqlDriver_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSqlDriver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSqlDriverWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSqlDriver_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSqlDriver_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSqlDriver_Type = nullptr;
static SbkObjectType *Sbk_QSqlDriver_TypeF(void)
{
    return _Sbk_QSqlDriver_Type;
}

static PyType_Slot Sbk_QSqlDriver_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSqlDriver_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSqlDriver_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSqlDriver_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSqlDriver_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSqlDriver_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSqlDriver_spec = {
    "2:PySide2.QtSql.QSqlDriver",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSqlDriver_slots
};

} //extern "C"

static void *Sbk_QSqlDriver_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSqlDriver *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QSqlDriver_DriverFeature_PythonToCpp_QSqlDriver_DriverFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlDriver::DriverFeature *>(cppOut) =
        static_cast<::QSqlDriver::DriverFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSqlDriver_DriverFeature_PythonToCpp_QSqlDriver_DriverFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX]))
        return QSqlDriver_DriverFeature_PythonToCpp_QSqlDriver_DriverFeature;
    return {};
}
static PyObject *QSqlDriver_DriverFeature_CppToPython_QSqlDriver_DriverFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSqlDriver::DriverFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX], castCppIn);

}

static void QSqlDriver_StatementType_PythonToCpp_QSqlDriver_StatementType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlDriver::StatementType *>(cppOut) =
        static_cast<::QSqlDriver::StatementType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSqlDriver_StatementType_PythonToCpp_QSqlDriver_StatementType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX]))
        return QSqlDriver_StatementType_PythonToCpp_QSqlDriver_StatementType;
    return {};
}
static PyObject *QSqlDriver_StatementType_CppToPython_QSqlDriver_StatementType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSqlDriver::StatementType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX], castCppIn);

}

static void QSqlDriver_IdentifierType_PythonToCpp_QSqlDriver_IdentifierType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlDriver::IdentifierType *>(cppOut) =
        static_cast<::QSqlDriver::IdentifierType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSqlDriver_IdentifierType_PythonToCpp_QSqlDriver_IdentifierType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX]))
        return QSqlDriver_IdentifierType_PythonToCpp_QSqlDriver_IdentifierType;
    return {};
}
static PyObject *QSqlDriver_IdentifierType_CppToPython_QSqlDriver_IdentifierType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSqlDriver::IdentifierType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX], castCppIn);

}

static void QSqlDriver_NotificationSource_PythonToCpp_QSqlDriver_NotificationSource(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlDriver::NotificationSource *>(cppOut) =
        static_cast<::QSqlDriver::NotificationSource>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSqlDriver_NotificationSource_PythonToCpp_QSqlDriver_NotificationSource_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX]))
        return QSqlDriver_NotificationSource_PythonToCpp_QSqlDriver_NotificationSource;
    return {};
}
static PyObject *QSqlDriver_NotificationSource_CppToPython_QSqlDriver_NotificationSource(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSqlDriver::NotificationSource *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX], castCppIn);

}

static void QSqlDriver_DbmsType_PythonToCpp_QSqlDriver_DbmsType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlDriver::DbmsType *>(cppOut) =
        static_cast<::QSqlDriver::DbmsType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSqlDriver_DbmsType_PythonToCpp_QSqlDriver_DbmsType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX]))
        return QSqlDriver_DbmsType_PythonToCpp_QSqlDriver_DbmsType;
    return {};
}
static PyObject *QSqlDriver_DbmsType_CppToPython_QSqlDriver_DbmsType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSqlDriver::DbmsType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSqlDriver_PythonToCpp_QSqlDriver_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSqlDriver_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSqlDriver_PythonToCpp_QSqlDriver_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSqlDriver_TypeF())))
        return QSqlDriver_PythonToCpp_QSqlDriver_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSqlDriver_PTR_CppToPython_QSqlDriver(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSqlDriver *>(const_cast<void *>(cppIn)), Sbk_QSqlDriver_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSqlDriver_SignatureStrings[] = {
    "PySide2.QtSql.QSqlDriver(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtSql.QSqlDriver.beginTransaction(self)->bool",
    "PySide2.QtSql.QSqlDriver.cancelQuery(self)->bool",
    "PySide2.QtSql.QSqlDriver.close(self)",
    "PySide2.QtSql.QSqlDriver.commitTransaction(self)->bool",
    "PySide2.QtSql.QSqlDriver.createResult(self)->PySide2.QtSql.QSqlResult",
    "PySide2.QtSql.QSqlDriver.dbmsType(self)->PySide2.QtSql.QSqlDriver.DbmsType",
    "PySide2.QtSql.QSqlDriver.escapeIdentifier(self,identifier:QString,type:PySide2.QtSql.QSqlDriver.IdentifierType)->QString",
    "PySide2.QtSql.QSqlDriver.formatValue(self,field:PySide2.QtSql.QSqlField,trimStrings:bool=false)->QString",
    "PySide2.QtSql.QSqlDriver.hasFeature(self,f:PySide2.QtSql.QSqlDriver.DriverFeature)->bool",
    "PySide2.QtSql.QSqlDriver.isIdentifierEscaped(self,identifier:QString,type:PySide2.QtSql.QSqlDriver.IdentifierType)->bool",
    "PySide2.QtSql.QSqlDriver.isOpen(self)->bool",
    "PySide2.QtSql.QSqlDriver.isOpenError(self)->bool",
    "PySide2.QtSql.QSqlDriver.lastError(self)->PySide2.QtSql.QSqlError",
    "PySide2.QtSql.QSqlDriver.numericalPrecisionPolicy(self)->PySide2.QtSql.QSql.NumericalPrecisionPolicy",
    "PySide2.QtSql.QSqlDriver.open(self,db:QString,user:QString=QString(),password:QString=QString(),host:QString=QString(),port:int=-1,connOpts:QString=QString())->bool",
    "PySide2.QtSql.QSqlDriver.primaryIndex(self,tableName:QString)->PySide2.QtSql.QSqlIndex",
    "PySide2.QtSql.QSqlDriver.record(self,tableName:QString)->PySide2.QtSql.QSqlRecord",
    "PySide2.QtSql.QSqlDriver.rollbackTransaction(self)->bool",
    "PySide2.QtSql.QSqlDriver.setLastError(self,e:PySide2.QtSql.QSqlError)",
    "PySide2.QtSql.QSqlDriver.setNumericalPrecisionPolicy(self,precisionPolicy:PySide2.QtSql.QSql.NumericalPrecisionPolicy)",
    "PySide2.QtSql.QSqlDriver.setOpen(self,o:bool)",
    "PySide2.QtSql.QSqlDriver.setOpenError(self,e:bool)",
    "PySide2.QtSql.QSqlDriver.sqlStatement(self,type:PySide2.QtSql.QSqlDriver.StatementType,tableName:QString,rec:PySide2.QtSql.QSqlRecord,preparedStatement:bool)->QString",
    "PySide2.QtSql.QSqlDriver.stripDelimiters(self,identifier:QString,type:PySide2.QtSql.QSqlDriver.IdentifierType)->QString",
    "PySide2.QtSql.QSqlDriver.subscribeToNotification(self,name:QString)->bool",
    "PySide2.QtSql.QSqlDriver.subscribedToNotifications(self)->QStringList",
    "PySide2.QtSql.QSqlDriver.tables(self,tableType:PySide2.QtSql.QSql.TableType)->QStringList",
    "PySide2.QtSql.QSqlDriver.unsubscribeFromNotification(self,name:QString)->bool",
    nullptr}; // Sentinel

void init_QSqlDriver(PyObject *module)
{
    _Sbk_QSqlDriver_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSqlDriver",
        "QSqlDriver*",
        &Sbk_QSqlDriver_spec,
        &Shiboken::callCppDestructor< ::QSqlDriver >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSqlDriver_Type);
    InitSignatureStrings(pyType, QSqlDriver_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSqlDriver_Type), Sbk_QSqlDriver_PropertyStrings);
    SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSqlDriver_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSqlDriver_TypeF(),
        QSqlDriver_PythonToCpp_QSqlDriver_PTR,
        is_QSqlDriver_PythonToCpp_QSqlDriver_PTR_Convertible,
        QSqlDriver_PTR_CppToPython_QSqlDriver);

    Shiboken::Conversions::registerConverterName(converter, "QSqlDriver");
    Shiboken::Conversions::registerConverterName(converter, "QSqlDriver*");
    Shiboken::Conversions::registerConverterName(converter, "QSqlDriver&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSqlDriver).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSqlDriverWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSqlDriver_TypeF(), &Sbk_QSqlDriver_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'DriverFeature'.
    SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSqlDriver_TypeF(),
        "DriverFeature",
        "2:PySide2.QtSql.QSqlDriver.DriverFeature",
        "QSqlDriver::DriverFeature");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "Transactions", (long) QSqlDriver::DriverFeature::Transactions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "QuerySize", (long) QSqlDriver::DriverFeature::QuerySize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "BLOB", (long) QSqlDriver::DriverFeature::BLOB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "Unicode", (long) QSqlDriver::DriverFeature::Unicode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "PreparedQueries", (long) QSqlDriver::DriverFeature::PreparedQueries))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "NamedPlaceholders", (long) QSqlDriver::DriverFeature::NamedPlaceholders))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "PositionalPlaceholders", (long) QSqlDriver::DriverFeature::PositionalPlaceholders))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "LastInsertId", (long) QSqlDriver::DriverFeature::LastInsertId))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "BatchOperations", (long) QSqlDriver::DriverFeature::BatchOperations))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "SimpleLocking", (long) QSqlDriver::DriverFeature::SimpleLocking))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "LowPrecisionNumbers", (long) QSqlDriver::DriverFeature::LowPrecisionNumbers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "EventNotifications", (long) QSqlDriver::DriverFeature::EventNotifications))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "FinishQuery", (long) QSqlDriver::DriverFeature::FinishQuery))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "MultipleResultSets", (long) QSqlDriver::DriverFeature::MultipleResultSets))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
        Sbk_QSqlDriver_TypeF(), "CancelQuery", (long) QSqlDriver::DriverFeature::CancelQuery))
        return;
    // Register converter for enum 'QSqlDriver::DriverFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX],
            QSqlDriver_DriverFeature_CppToPython_QSqlDriver_DriverFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSqlDriver_DriverFeature_PythonToCpp_QSqlDriver_DriverFeature,
            is_QSqlDriver_DriverFeature_PythonToCpp_QSqlDriver_DriverFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSqlDriver::DriverFeature");
        Shiboken::Conversions::registerConverterName(converter, "DriverFeature");
    }
    // End of 'DriverFeature' enum.

    // Initialization of enum 'StatementType'.
    SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSqlDriver_TypeF(),
        "StatementType",
        "2:PySide2.QtSql.QSqlDriver.StatementType",
        "QSqlDriver::StatementType");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "WhereStatement", (long) QSqlDriver::StatementType::WhereStatement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "SelectStatement", (long) QSqlDriver::StatementType::SelectStatement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "UpdateStatement", (long) QSqlDriver::StatementType::UpdateStatement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "InsertStatement", (long) QSqlDriver::StatementType::InsertStatement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "DeleteStatement", (long) QSqlDriver::StatementType::DeleteStatement))
        return;
    // Register converter for enum 'QSqlDriver::StatementType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX],
            QSqlDriver_StatementType_CppToPython_QSqlDriver_StatementType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSqlDriver_StatementType_PythonToCpp_QSqlDriver_StatementType,
            is_QSqlDriver_StatementType_PythonToCpp_QSqlDriver_StatementType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSqlDriver::StatementType");
        Shiboken::Conversions::registerConverterName(converter, "StatementType");
    }
    // End of 'StatementType' enum.

    // Initialization of enum 'IdentifierType'.
    SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSqlDriver_TypeF(),
        "IdentifierType",
        "2:PySide2.QtSql.QSqlDriver.IdentifierType",
        "QSqlDriver::IdentifierType");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "FieldName", (long) QSqlDriver::IdentifierType::FieldName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "TableName", (long) QSqlDriver::IdentifierType::TableName))
        return;
    // Register converter for enum 'QSqlDriver::IdentifierType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX],
            QSqlDriver_IdentifierType_CppToPython_QSqlDriver_IdentifierType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSqlDriver_IdentifierType_PythonToCpp_QSqlDriver_IdentifierType,
            is_QSqlDriver_IdentifierType_PythonToCpp_QSqlDriver_IdentifierType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSqlDriver::IdentifierType");
        Shiboken::Conversions::registerConverterName(converter, "IdentifierType");
    }
    // End of 'IdentifierType' enum.

    // Initialization of enum 'NotificationSource'.
    SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSqlDriver_TypeF(),
        "NotificationSource",
        "2:PySide2.QtSql.QSqlDriver.NotificationSource",
        "QSqlDriver::NotificationSource");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX],
        Sbk_QSqlDriver_TypeF(), "UnknownSource", (long) QSqlDriver::NotificationSource::UnknownSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX],
        Sbk_QSqlDriver_TypeF(), "SelfSource", (long) QSqlDriver::NotificationSource::SelfSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX],
        Sbk_QSqlDriver_TypeF(), "OtherSource", (long) QSqlDriver::NotificationSource::OtherSource))
        return;
    // Register converter for enum 'QSqlDriver::NotificationSource'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX],
            QSqlDriver_NotificationSource_CppToPython_QSqlDriver_NotificationSource);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSqlDriver_NotificationSource_PythonToCpp_QSqlDriver_NotificationSource,
            is_QSqlDriver_NotificationSource_PythonToCpp_QSqlDriver_NotificationSource_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_NOTIFICATIONSOURCE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSqlDriver::NotificationSource");
        Shiboken::Conversions::registerConverterName(converter, "NotificationSource");
    }
    // End of 'NotificationSource' enum.

    // Initialization of enum 'DbmsType'.
    SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSqlDriver_TypeF(),
        "DbmsType",
        "2:PySide2.QtSql.QSqlDriver.DbmsType",
        "QSqlDriver::DbmsType");
    if (!SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "UnknownDbms", (long) QSqlDriver::DbmsType::UnknownDbms))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "MSSqlServer", (long) QSqlDriver::DbmsType::MSSqlServer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "MySqlServer", (long) QSqlDriver::DbmsType::MySqlServer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "PostgreSQL", (long) QSqlDriver::DbmsType::PostgreSQL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "Oracle", (long) QSqlDriver::DbmsType::Oracle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "Sybase", (long) QSqlDriver::DbmsType::Sybase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "SQLite", (long) QSqlDriver::DbmsType::SQLite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "Interbase", (long) QSqlDriver::DbmsType::Interbase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
        Sbk_QSqlDriver_TypeF(), "DB2", (long) QSqlDriver::DbmsType::DB2))
        return;
    // Register converter for enum 'QSqlDriver::DbmsType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX],
            QSqlDriver_DbmsType_CppToPython_QSqlDriver_DbmsType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSqlDriver_DbmsType_PythonToCpp_QSqlDriver_DbmsType,
            is_QSqlDriver_DbmsType_PythonToCpp_QSqlDriver_DbmsType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_DBMSTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSqlDriver::DbmsType");
        Shiboken::Conversions::registerConverterName(converter, "DbmsType");
    }
    // End of 'DbmsType' enum.

    PySide::Signal::registerSignals(Sbk_QSqlDriver_TypeF(), &::QSqlDriver::staticMetaObject);
    qRegisterMetaType< ::QSqlDriver::DriverFeature >("QSqlDriver::DriverFeature");
    qRegisterMetaType< ::QSqlDriver::StatementType >("QSqlDriver::StatementType");
    qRegisterMetaType< ::QSqlDriver::IdentifierType >("QSqlDriver::IdentifierType");
    qRegisterMetaType< ::QSqlDriver::NotificationSource >("QSqlDriver::NotificationSource");
    qRegisterMetaType< ::QSqlDriver::DbmsType >("QSqlDriver::DbmsType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSqlDriver_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSqlDriver_TypeF(), &::QSqlDriver::staticMetaObject, sizeof(QSqlDriverWrapper));
}
