/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtscxml_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtScxmlTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtScxmlModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtScxmlTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtScxml_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtScxmlTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtScxml_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QScxmlTableData(PyObject *module);
void init_QtScxmlQScxmlExecutableContent(PyObject *module);
void init_QScxmlExecutableContent_ParameterInfo(PyObject *enclosingClass);
void init_QScxmlExecutableContent_InvokeInfo(PyObject *enclosingClass);
void init_QScxmlExecutableContent_ForeachInfo(PyObject *enclosingClass);
void init_QScxmlExecutableContent_EvaluatorInfo(PyObject *enclosingClass);
void init_QScxmlExecutableContent_AssignmentInfo(PyObject *enclosingClass);
void init_QScxmlEvent(PyObject *module);
void init_QScxmlError(PyObject *module);
void init_QScxmlCompiler(PyObject *module);
void init_QScxmlCompiler_Loader(PyObject *enclosingClass);
void init_QScxmlDataModel(PyObject *module);
void init_QScxmlEcmaScriptDataModel(PyObject *module);
void init_QScxmlDataModel_ForeachLoopBody(PyObject *enclosingClass);
void init_QScxmlCppDataModel(PyObject *module);
void init_QScxmlNullDataModel(PyObject *module);
void init_QScxmlStateMachine(PyObject *module);
void init_QScxmlInvokableServiceFactory(PyObject *module);
void init_QScxmlDynamicScxmlServiceFactory(PyObject *module);
void init_QScxmlStaticScxmlServiceFactory(PyObject *module);
void init_QScxmlInvokableService(PyObject *module);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'QVector<QScxmlError >'.
static PyObject *_QVector_QScxmlError__CppToPython__QVector_QScxmlError_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QScxmlError > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QScxmlError >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QScxmlError >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QScxmlError cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QScxmlError__PythonToCpp__QVector_QScxmlError_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QScxmlError > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QScxmlError cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QScxmlError__PythonToCpp__QVector_QScxmlError__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX]), pyIn))
        return _QVector_QScxmlError__PythonToCpp__QVector_QScxmlError_;
    return {};
}

// C++ to Python conversion for type 'const QMap<QString,QVariant > &'.
static PyObject *_constQMap_QString_QVariant_REF_CppToPython__constQMap_QString_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'const QVector<int > &'.
static PyObject *_constQVector_int_REF_CppToPython__constQVector_int_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<int >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<int >::size_type idx = 0; idx < vectorSize; ++idx) {
        int cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_int_REF_PythonToCpp__constQVector_int_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_int_REF_PythonToCpp__constQVector_int_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _constQVector_int_REF_PythonToCpp__constQVector_int_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QScxmlExecutableContent::ParameterInfo > &'.
static PyObject *_constQVector_QScxmlExecutableContent_ParameterInfo_REF_CppToPython__constQVector_QScxmlExecutableContent_ParameterInfo_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QScxmlExecutableContent::ParameterInfo > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QScxmlExecutableContent::ParameterInfo >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QScxmlExecutableContent::ParameterInfo >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QScxmlExecutableContent::ParameterInfo cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_PARAMETERINFO_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QScxmlExecutableContent_ParameterInfo_REF_PythonToCpp__constQVector_QScxmlExecutableContent_ParameterInfo_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QScxmlExecutableContent::ParameterInfo > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QScxmlExecutableContent::ParameterInfo cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_PARAMETERINFO_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QScxmlExecutableContent_ParameterInfo_REF_PythonToCpp__constQVector_QScxmlExecutableContent_ParameterInfo_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_PARAMETERINFO_IDX]), pyIn))
        return _constQVector_QScxmlExecutableContent_ParameterInfo_REF_PythonToCpp__constQVector_QScxmlExecutableContent_ParameterInfo_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<QScxmlInvokableService* >'.
static PyObject *_QVector_QScxmlInvokableServicePTR__CppToPython__QVector_QScxmlInvokableServicePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QScxmlInvokableService* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QScxmlInvokableService* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QScxmlInvokableService* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QScxmlInvokableService* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLINVOKABLESERVICE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QScxmlInvokableServicePTR__PythonToCpp__QVector_QScxmlInvokableServicePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QScxmlInvokableService* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QScxmlInvokableService* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLINVOKABLESERVICE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QScxmlInvokableServicePTR__PythonToCpp__QVector_QScxmlInvokableServicePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtScxmlTypes[SBK_QSCXMLINVOKABLESERVICE_IDX], pyIn))
        return _QVector_QScxmlInvokableServicePTR__PythonToCpp__QVector_QScxmlInvokableServicePTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtScxml",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtScxml_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtScxml_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtScxml)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtScxml_IDX_COUNT];
    SbkPySide2_QtScxmlTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtScxml_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtScxmlTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtScxml", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtScxml", QtScxml_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtScxmlModuleObject = module;

    // Initialize classes in the type system
    init_QScxmlTableData(module);
    init_QtScxmlQScxmlExecutableContent(module);
    init_QScxmlExecutableContent_ParameterInfo(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtScxmlTypes[SBK_QtScxmlQSCXMLEXECUTABLECONTENT_IDX])->tp_dict);
    init_QScxmlExecutableContent_InvokeInfo(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtScxmlTypes[SBK_QtScxmlQSCXMLEXECUTABLECONTENT_IDX])->tp_dict);
    init_QScxmlExecutableContent_ForeachInfo(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtScxmlTypes[SBK_QtScxmlQSCXMLEXECUTABLECONTENT_IDX])->tp_dict);
    init_QScxmlExecutableContent_EvaluatorInfo(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtScxmlTypes[SBK_QtScxmlQSCXMLEXECUTABLECONTENT_IDX])->tp_dict);
    init_QScxmlExecutableContent_AssignmentInfo(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtScxmlTypes[SBK_QtScxmlQSCXMLEXECUTABLECONTENT_IDX])->tp_dict);
    init_QScxmlEvent(module);
    init_QScxmlError(module);
    init_QScxmlCompiler(module);
    init_QScxmlCompiler_Loader(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLCOMPILER_IDX])->tp_dict);
    init_QScxmlDataModel(module);
    init_QScxmlEcmaScriptDataModel(module);
    init_QScxmlDataModel_ForeachLoopBody(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLDATAMODEL_IDX])->tp_dict);
    init_QScxmlCppDataModel(module);
    init_QScxmlNullDataModel(module);
    init_QScxmlStateMachine(module);
    init_QScxmlInvokableServiceFactory(module);
    init_QScxmlDynamicScxmlServiceFactory(module);
    init_QScxmlStaticScxmlServiceFactory(module);
    init_QScxmlInvokableService(module);

    // Register converter for type 'QVector<QScxmlError>'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLERROR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QScxmlError__CppToPython__QVector_QScxmlError_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLERROR_IDX], "QVector<QScxmlError>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLERROR_IDX],
        _QVector_QScxmlError__PythonToCpp__QVector_QScxmlError_,
        is__QVector_QScxmlError__PythonToCpp__QVector_QScxmlError__Convertible);

    // Register converter for type 'const QMap<QString,QVariant>&'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQMap_QString_QVariant_REF_CppToPython__constQMap_QString_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QMAP_QSTRING_QVARIANT_IDX], "const QMap<QString,QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QMAP_QSTRING_QVARIANT_IDX],
        _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF,
        is__constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF_Convertible);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'const QVector<int>&'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_int_REF_CppToPython__constQVector_int_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_INT_IDX], "const QVector<int>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_INT_IDX], "QVector<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_INT_IDX],
        _constQVector_int_REF_PythonToCpp__constQVector_int_REF,
        is__constQVector_int_REF_PythonToCpp__constQVector_int_REF_Convertible);

    // Register converter for type 'const QVector<QScxmlExecutableContent::ParameterInfo>&'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLEXECUTABLECONTENT_PARAMETERINFO_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QScxmlExecutableContent_ParameterInfo_REF_CppToPython__constQVector_QScxmlExecutableContent_ParameterInfo_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLEXECUTABLECONTENT_PARAMETERINFO_IDX], "const QVector<QScxmlExecutableContent::ParameterInfo>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLEXECUTABLECONTENT_PARAMETERINFO_IDX], "QVector<QScxmlExecutableContent::ParameterInfo>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLEXECUTABLECONTENT_PARAMETERINFO_IDX],
        _constQVector_QScxmlExecutableContent_ParameterInfo_REF_PythonToCpp__constQVector_QScxmlExecutableContent_ParameterInfo_REF,
        is__constQVector_QScxmlExecutableContent_ParameterInfo_REF_PythonToCpp__constQVector_QScxmlExecutableContent_ParameterInfo_REF_Convertible);

    // Register converter for type 'QVector<QScxmlInvokableService*>'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLINVOKABLESERVICEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QScxmlInvokableServicePTR__CppToPython__QVector_QScxmlInvokableServicePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLINVOKABLESERVICEPTR_IDX], "QVector<QScxmlInvokableService*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLINVOKABLESERVICEPTR_IDX],
        _QVector_QScxmlInvokableServicePTR__PythonToCpp__QVector_QScxmlInvokableServicePTR_,
        is__QVector_QScxmlInvokableServicePTR__PythonToCpp__QVector_QScxmlInvokableServicePTR__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtScxmlTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtScxmlTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtScxml");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtScxml_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
