/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscxml_python.h"

// main header
#include "qscxmlerror_wrapper.h"

// inner classes

// Extra includes
#include <QtScxml/qscxmlerror.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScxmlError_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScxmlError >()))
        return -1;

    ::QScxmlError *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlError.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QScxmlError_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QScxmlError", 0, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QScxmlError::QScxmlError()
    // 1: QScxmlError::QScxmlError(QScxmlError)
    // 2: QScxmlError::QScxmlError(QString,int,int,QString)
    if (numArgs == 0) {
        overloadId = 0; // QScxmlError()
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
        overloadId = 2; // QScxmlError(QString,int,int,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QScxmlError(QScxmlError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlError_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QScxmlError()
        {

            if (!PyErr_Occurred()) {
                // QScxmlError()
                cptr = new ::QScxmlError();
            }
            break;
        }
        case 1: // QScxmlError(const QScxmlError & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScxmlError cppArg0_local;
            ::QScxmlError *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QScxmlError(QScxmlError)
                cptr = new ::QScxmlError(*cppArg0);
            }
            break;
        }
        case 2: // QScxmlError(const QString & fileName, int line, int column, const QString & description)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QScxmlError(QString,int,int,QString)
                cptr = new ::QScxmlError(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScxmlError >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScxmlError_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScxmlError_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScxmlErrorFunc_column(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlError.column";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // column()const
            int cppResult = const_cast<const ::QScxmlError *>(cppSelf)->column();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlErrorFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlError.description";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // description()const
            QString cppResult = const_cast<const ::QScxmlError *>(cppSelf)->description();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlErrorFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlError.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::QScxmlError *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlErrorFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlError.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QScxmlError *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlErrorFunc_line(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlError.line";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // line()const
            int cppResult = const_cast<const ::QScxmlError *>(cppSelf)->line();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlErrorFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlError.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QScxmlError *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlError___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QScxmlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScxmlError_PropertyStrings[] = {
    "column:",
    "description:",
    "fileName:",
    "line:",
    "valid:isValid",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScxmlError_methods[] = {
    {"column", reinterpret_cast<PyCFunction>(Sbk_QScxmlErrorFunc_column), METH_NOARGS},
    {"description", reinterpret_cast<PyCFunction>(Sbk_QScxmlErrorFunc_description), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QScxmlErrorFunc_fileName), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QScxmlErrorFunc_isValid), METH_NOARGS},
    {"line", reinterpret_cast<PyCFunction>(Sbk_QScxmlErrorFunc_line), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QScxmlErrorFunc_toString), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QScxmlError___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QScxmlError_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScxmlError_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScxmlError_Type = nullptr;
static SbkObjectType *Sbk_QScxmlError_TypeF(void)
{
    return _Sbk_QScxmlError_Type;
}

static PyType_Slot Sbk_QScxmlError_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScxmlError_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScxmlError_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScxmlError_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScxmlError_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScxmlError_spec = {
    "2:PySide2.QtScxml.QScxmlError",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScxmlError_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScxmlError_PythonToCpp_QScxmlError_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScxmlError_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScxmlError_PythonToCpp_QScxmlError_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScxmlError_TypeF())))
        return QScxmlError_PythonToCpp_QScxmlError_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScxmlError_PTR_CppToPython_QScxmlError(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScxmlError *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScxmlError_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QScxmlError_COPY_CppToPython_QScxmlError(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QScxmlError_TypeF(), new ::QScxmlError(*reinterpret_cast<const ::QScxmlError *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QScxmlError_PythonToCpp_QScxmlError_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScxmlError *>(cppOut) = *reinterpret_cast< ::QScxmlError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QScxmlError_PythonToCpp_QScxmlError_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScxmlError_TypeF())))
        return QScxmlError_PythonToCpp_QScxmlError_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScxmlError_SignatureStrings[] = {
    "2:PySide2.QtScxml.QScxmlError(self)",
    "1:PySide2.QtScxml.QScxmlError(self,arg__1:PySide2.QtScxml.QScxmlError)",
    "0:PySide2.QtScxml.QScxmlError(self,fileName:QString,line:int,column:int,description:QString)",
    "PySide2.QtScxml.QScxmlError.column(self)->int",
    "PySide2.QtScxml.QScxmlError.description(self)->QString",
    "PySide2.QtScxml.QScxmlError.fileName(self)->QString",
    "PySide2.QtScxml.QScxmlError.isValid(self)->bool",
    "PySide2.QtScxml.QScxmlError.line(self)->int",
    "PySide2.QtScxml.QScxmlError.toString(self)->QString",
    "PySide2.QtScxml.QScxmlError.__copy__()",
    nullptr}; // Sentinel

void init_QScxmlError(PyObject *module)
{
    _Sbk_QScxmlError_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScxmlError",
        "QScxmlError",
        &Sbk_QScxmlError_spec,
        &Shiboken::callCppDestructor< ::QScxmlError >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlError_Type);
    InitSignatureStrings(pyType, QScxmlError_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlError_Type), Sbk_QScxmlError_PropertyStrings);
    SbkPySide2_QtScxmlTypes[SBK_QSCXMLERROR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScxmlError_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScxmlError_TypeF(),
        QScxmlError_PythonToCpp_QScxmlError_PTR,
        is_QScxmlError_PythonToCpp_QScxmlError_PTR_Convertible,
        QScxmlError_PTR_CppToPython_QScxmlError,
        QScxmlError_COPY_CppToPython_QScxmlError);

    Shiboken::Conversions::registerConverterName(converter, "QScxmlError");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlError*");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlError&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScxmlError).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QScxmlError_PythonToCpp_QScxmlError_COPY,
        is_QScxmlError_PythonToCpp_QScxmlError_COPY_Convertible);

    qRegisterMetaType< ::QScxmlError >("QScxmlError");
}
