/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscript_python.h"

// main header
#include "qscriptvalueiterator_wrapper.h"

// inner classes

// Extra includes
#include <QtScript/qscriptstring.h>
#include <QtScript/qscriptvalue.h>
#include <QtScript/qscriptvalueiterator.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScriptValueIterator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScriptValueIterator >()))
        return -1;

    ::QScriptValueIterator *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScriptValueIterator", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QScriptValueIterator::QScriptValueIterator(QScriptValue)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QScriptValueIterator(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueIterator_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);


        if (!PyErr_Occurred()) {
            // QScriptValueIterator(QScriptValue)
            cptr = new ::QScriptValueIterator(*cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScriptValueIterator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScriptValueIterator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScriptValueIterator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScriptValueIteratorFunc___iter__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.__iter__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __iter__()
            // Begin code injection
            // TEMPLATE - __iter__ - START
            Py_INCREF(self);
            pyResult = self;
            // TEMPLATE - __iter__ - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueIteratorFunc___next__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.__next__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __next__()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtscript.cpp (qscriptvalueiterator-next)]
            if (cppSelf->hasNext()) {
                cppSelf->next();
                QString name = cppSelf->name();
                QVariant value = cppSelf->value().toVariant();
                pyResult = PyTuple_New(2);
                PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &name));
                PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value));
            } else {
                PyErr_SetNone(PyExc_StopIteration);
            }
            // END of custom code block [file: ../glue/qtscript.cpp (qscriptvalueiterator-next)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueIteratorFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<QScriptValue::PropertyFlag> cppResult = const_cast<const ::QScriptValueIterator *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueIteratorFunc_hasNext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.hasNext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasNext()const
            bool cppResult = const_cast<const ::QScriptValueIterator *>(cppSelf)->hasNext();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueIteratorFunc_hasPrevious(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.hasPrevious";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasPrevious()const
            bool cppResult = const_cast<const ::QScriptValueIterator *>(cppSelf)->hasPrevious();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueIteratorFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QScriptValueIterator *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueIteratorFunc_next(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.next";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // next()
            cppSelf->next();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptValueIteratorFunc_previous(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.previous";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // previous()
            cppSelf->previous();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptValueIteratorFunc_remove(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.remove";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // remove()
            cppSelf->remove();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptValueIteratorFunc_scriptName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.scriptName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scriptName()const
            QScriptString cppResult = const_cast<const ::QScriptValueIterator *>(cppSelf)->scriptName();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueIteratorFunc_setValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.setValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValueIterator::setValue(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setValue(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueIteratorFunc_setValue_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setValue(QScriptValue)
            cppSelf->setValue(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptValueIteratorFunc_setValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueIteratorFunc_toBack(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.toBack";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toBack()
            cppSelf->toBack();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptValueIteratorFunc_toFront(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.toFront";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toFront()
            cppSelf->toFront();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptValueIteratorFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValueIterator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValueIterator.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            QScriptValue cppResult = const_cast<const ::QScriptValueIterator *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScriptValueIterator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScriptValueIterator_methods[] = {
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_flags), METH_NOARGS},
    {"hasNext", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_hasNext), METH_NOARGS},
    {"hasPrevious", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_hasPrevious), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_name), METH_NOARGS},
    {"next", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_next), METH_NOARGS},
    {"previous", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_previous), METH_NOARGS},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_remove), METH_NOARGS},
    {"scriptName", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_scriptName), METH_NOARGS},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_setValue), METH_O},
    {"toBack", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_toBack), METH_NOARGS},
    {"toFront", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_toFront), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QScriptValueIteratorFunc_value), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QScriptValueIterator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScriptValueIterator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScriptValueIterator_Type = nullptr;
static SbkObjectType *Sbk_QScriptValueIterator_TypeF(void)
{
    return _Sbk_QScriptValueIterator_Type;
}

static PyType_Slot Sbk_QScriptValueIterator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScriptValueIterator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScriptValueIterator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        reinterpret_cast<void *>(Sbk_QScriptValueIteratorFunc___iter__)},
    {Py_tp_iternext,    reinterpret_cast<void *>(Sbk_QScriptValueIteratorFunc___next__)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScriptValueIterator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScriptValueIterator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScriptValueIterator_spec = {
    "2:PySide2.QtScript.QScriptValueIterator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScriptValueIterator_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScriptValueIterator_PythonToCpp_QScriptValueIterator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScriptValueIterator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScriptValueIterator_PythonToCpp_QScriptValueIterator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptValueIterator_TypeF())))
        return QScriptValueIterator_PythonToCpp_QScriptValueIterator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScriptValueIterator_PTR_CppToPython_QScriptValueIterator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScriptValueIterator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScriptValueIterator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScriptValueIterator_SignatureStrings[] = {
    "PySide2.QtScript.QScriptValueIterator(self,value:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptValueIterator.__iter__(self)->PyObject",
    "PySide2.QtScript.QScriptValueIterator.__next__(self)->PyObject",
    "PySide2.QtScript.QScriptValueIterator.flags(self)->PySide2.QtScript.QScriptValue.PropertyFlags",
    "PySide2.QtScript.QScriptValueIterator.hasNext(self)->bool",
    "PySide2.QtScript.QScriptValueIterator.hasPrevious(self)->bool",
    "PySide2.QtScript.QScriptValueIterator.name(self)->QString",
    "PySide2.QtScript.QScriptValueIterator.next(self)",
    "PySide2.QtScript.QScriptValueIterator.previous(self)",
    "PySide2.QtScript.QScriptValueIterator.remove(self)",
    "PySide2.QtScript.QScriptValueIterator.scriptName(self)->PySide2.QtScript.QScriptString",
    "PySide2.QtScript.QScriptValueIterator.setValue(self,value:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptValueIterator.toBack(self)",
    "PySide2.QtScript.QScriptValueIterator.toFront(self)",
    "PySide2.QtScript.QScriptValueIterator.value(self)->PySide2.QtScript.QScriptValue",
    nullptr}; // Sentinel

void init_QScriptValueIterator(PyObject *module)
{
    _Sbk_QScriptValueIterator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScriptValueIterator",
        "QScriptValueIterator*",
        &Sbk_QScriptValueIterator_spec,
        &Shiboken::callCppDestructor< ::QScriptValueIterator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScriptValueIterator_Type);
    InitSignatureStrings(pyType, QScriptValueIterator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScriptValueIterator_Type), Sbk_QScriptValueIterator_PropertyStrings);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScriptValueIterator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScriptValueIterator_TypeF(),
        QScriptValueIterator_PythonToCpp_QScriptValueIterator_PTR,
        is_QScriptValueIterator_PythonToCpp_QScriptValueIterator_PTR_Convertible,
        QScriptValueIterator_PTR_CppToPython_QScriptValueIterator);

    Shiboken::Conversions::registerConverterName(converter, "QScriptValueIterator");
    Shiboken::Conversions::registerConverterName(converter, "QScriptValueIterator*");
    Shiboken::Conversions::registerConverterName(converter, "QScriptValueIterator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptValueIterator).name());


}
