/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscript_python.h"

// main header
#include "qscriptvalue_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtScript/qscriptclass.h>
#include <QtScript/qscriptengine.h>
#include <QtScript/qscriptstring.h>
#include <QtScript/qscriptvalue.h>
#include <qdatetime.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qregexp.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScriptValue_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScriptValue >()))
        return -1;

    ::QScriptValue *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScriptValue", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QScriptValue::QScriptValue()
    // 1: QScriptValue::QScriptValue(QScriptEngine*,QScriptValue::SpecialValue)
    // 2: QScriptValue::QScriptValue(QScriptEngine*,bool)
    // 3: QScriptValue::QScriptValue(QScriptEngine*,QString)
    // 4: QScriptValue::QScriptValue(QScriptEngine*,const char*)
    // 5: QScriptValue::QScriptValue(QScriptEngine*,double)
    // 6: QScriptValue::QScriptValue(QScriptEngine*,int)
    // 7: QScriptValue::QScriptValue(QScriptEngine*,uint)
    // 8: QScriptValue::QScriptValue(QScriptValue::SpecialValue)
    // 9: QScriptValue::QScriptValue(bool)
    // 10: QScriptValue::QScriptValue(QScriptValue)
    // 11: QScriptValue::QScriptValue(QString)
    // 12: QScriptValue::QScriptValue(const char*)
    // 13: QScriptValue::QScriptValue(double)
    // 14: QScriptValue::QScriptValue(int)
    // 15: QScriptValue::QScriptValue(uint)
    if (numArgs == 0) {
        overloadId = 0; // QScriptValue()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 8; // QScriptValue(QScriptValue::SpecialValue)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 15; // QScriptValue(uint)
    } else if (numArgs == 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        overloadId = 13; // QScriptValue(double)
    } else if (numArgs == 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 12; // QScriptValue(const char*)
    } else if (numArgs == 1
        && PyBool_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 9; // QScriptValue(bool)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 14; // QScriptValue(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QScriptValue(QScriptEngine*,QScriptValue::SpecialValue)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[1])))) {
            overloadId = 7; // QScriptValue(QScriptEngine*,uint)
        } else if (numArgs == 2
            && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
            overloadId = 5; // QScriptValue(QScriptEngine*,double)
        } else if (numArgs == 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 4; // QScriptValue(QScriptEngine*,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 3; // QScriptValue(QScriptEngine*,QString)
        } else if (numArgs == 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 2; // QScriptValue(QScriptEngine*,bool)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 6; // QScriptValue(QScriptEngine*,int)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 11; // QScriptValue(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 10; // QScriptValue(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValue_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QScriptValue()
        {

            if (!PyErr_Occurred()) {
                // QScriptValue()
                cptr = new ::QScriptValue();
            }
            break;
        }
        case 1: // QScriptValue(QScriptEngine * engine, QScriptValue::SpecialValue val)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QScriptValue::SpecialValue cppArg1{QScriptValue::NullValue};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptEngine*,QScriptValue::SpecialValue)
                cptr = new ::QScriptValue(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QScriptValue(QScriptEngine * engine, bool val)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptEngine*,bool)
                cptr = new ::QScriptValue(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QScriptValue(QScriptEngine * engine, const QString & val)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptEngine*,QString)
                cptr = new ::QScriptValue(cppArg0, cppArg1);
            }
            break;
        }
        case 4: // QScriptValue(QScriptEngine * engine, const char * val)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptEngine*,const char*)
                cptr = new ::QScriptValue(cppArg0, cppArg1);
            }
            break;
        }
        case 5: // QScriptValue(QScriptEngine * engine, double val)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            double cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptEngine*,double)
                cptr = new ::QScriptValue(cppArg0, cppArg1);
            }
            break;
        }
        case 6: // QScriptValue(QScriptEngine * engine, int val)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptEngine*,int)
                cptr = new ::QScriptValue(cppArg0, cppArg1);
            }
            break;
        }
        case 7: // QScriptValue(QScriptEngine * engine, uint val)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            uint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptEngine*,uint)
                cptr = new ::QScriptValue(cppArg0, cppArg1);
            }
            break;
        }
        case 8: // QScriptValue(QScriptValue::SpecialValue value)
        {
            ::QScriptValue::SpecialValue cppArg0{QScriptValue::NullValue};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptValue::SpecialValue)
                cptr = new ::QScriptValue(cppArg0);
            }
            break;
        }
        case 9: // QScriptValue(bool value)
        {
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptValue(bool)
                cptr = new ::QScriptValue(cppArg0);
            }
            break;
        }
        case 10: // QScriptValue(const QScriptValue & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptValue cppArg0_local;
            ::QScriptValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QScriptValue(QScriptValue)
                cptr = new ::QScriptValue(*cppArg0);
            }
            break;
        }
        case 11: // QScriptValue(const QString & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptValue(QString)
                cptr = new ::QScriptValue(cppArg0);
            }
            break;
        }
        case 12: // QScriptValue(const char * value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptValue(const char*)
                cptr = new ::QScriptValue(cppArg0);
            }
            break;
        }
        case 13: // QScriptValue(double value)
        {
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptValue(double)
                cptr = new ::QScriptValue(cppArg0);
            }
            break;
        }
        case 14: // QScriptValue(int value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptValue(int)
                cptr = new ::QScriptValue(cppArg0);
            }
            break;
        }
        case 15: // QScriptValue(uint value)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptValue(uint)
                cptr = new ::QScriptValue(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScriptValue >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScriptValue_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScriptValue_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScriptValueFunc___iter__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.__iter__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __iter__()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: qscript_value_iterator_glue.cpp]
            pyResult = Shiboken::Object::newObject(
                         reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QScriptValueIterator >()),
                         new QScriptValueIterator(*cppSelf), true, true);
            // END of custom code block [file: qscript_value_iterator_glue.cpp]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtscript.cpp (qscriptvalue-repr)]
            if (cppSelf->isVariant() || cppSelf->isString()) {
                QString format = QString::asprintf("%s(\"%s\")",
                        Py_TYPE(self)->tp_name,
                        qPrintable(cppSelf->toString()));
                pyResult = Shiboken::String::fromCString(qPrintable(format));
             } else {
                pyResult = Shiboken::String::fromCString(Py_TYPE(self)->tp_name);
            }
            // END of custom code block [file: ../glue/qtscript.cpp (qscriptvalue-repr)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_call(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.call";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptValueFunc_call_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:call", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptValue::call(QScriptValue,QList<QScriptValue>)
    // 1: QScriptValue::call(QScriptValue,QScriptValue)
    if (numArgs == 0) {
        overloadId = 0; // call(QScriptValue,QList<QScriptValue>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // call(QScriptValue,QList<QScriptValue>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // call(QScriptValue,QScriptValue)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtScriptTypeConverters[SBK_QTSCRIPT_QLIST_QSCRIPTVALUE_IDX], (pyArgs[1])))) {
            overloadId = 0; // call(QScriptValue,QList<QScriptValue>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_call_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // call(const QScriptValue & thisObject, const QList<QScriptValue > & args)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_thisObject = Shiboken::String::createStaticString("thisObject");
                if (PyDict_Contains(kwds, key_thisObject)) {
                    value = PyDict_GetItem(kwds, key_thisObject);
                    if (value && pyArgs[0]) {
                        errInfo = key_thisObject;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_call_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0]))))
                            goto Sbk_QScriptValueFunc_call_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_thisObject);
                }
                static PyObject *const key_args = Shiboken::String::createStaticString("args");
                if (PyDict_Contains(kwds, key_args)) {
                    value = PyDict_GetItem(kwds, key_args);
                    if (value && pyArgs[1]) {
                        errInfo = key_args;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_call_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtScriptTypeConverters[SBK_QTSCRIPT_QLIST_QSCRIPTVALUE_IDX], (pyArgs[1]))))
                            goto Sbk_QScriptValueFunc_call_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_args);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_call_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptValue cppArg0_local = QScriptValue();
            ::QScriptValue *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }
            ::QList<QScriptValue > cppArg1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // call(QScriptValue,QList<QScriptValue>)
                QScriptValue cppResult = cppSelf->call(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // call(const QScriptValue & thisObject, const QScriptValue & arguments)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QScriptValueFunc_call_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptValue cppArg0_local;
            ::QScriptValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QScriptValue cppArg1_local;
            ::QScriptValue *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // call(QScriptValue,QScriptValue)
                QScriptValue cppResult = cppSelf->call(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptValueFunc_call_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_construct(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.construct";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptValueFunc_construct_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:construct", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QScriptValue::construct(QList<QScriptValue>)
    // 1: QScriptValue::construct(QScriptValue)
    if (numArgs == 0) {
        overloadId = 0; // construct(QList<QScriptValue>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // construct(QScriptValue)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtScriptTypeConverters[SBK_QTSCRIPT_QLIST_QSCRIPTVALUE_IDX], (pyArgs[0])))) {
        overloadId = 0; // construct(QList<QScriptValue>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_construct_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // construct(const QList<QScriptValue > & args)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_args = Shiboken::String::createStaticString("args");
                if (PyDict_Contains(kwds, key_args)) {
                    value = PyDict_GetItem(kwds, key_args);
                    if (value && pyArgs[0]) {
                        errInfo = key_args;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_construct_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtScriptTypeConverters[SBK_QTSCRIPT_QLIST_QSCRIPTVALUE_IDX], (pyArgs[0]))))
                            goto Sbk_QScriptValueFunc_construct_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_args);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_construct_TypeError;
                }
            }
            ::QList<QScriptValue > cppArg0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // construct(QList<QScriptValue>)
                QScriptValue cppResult = cppSelf->construct(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // construct(const QScriptValue & arguments)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QScriptValueFunc_construct_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptValue cppArg0_local;
            ::QScriptValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // construct(QScriptValue)
                QScriptValue cppResult = cppSelf->construct(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptValueFunc_construct_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            QScriptValue cppResult = const_cast<const ::QScriptValue *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_engine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.engine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // engine()const
            QScriptEngine * cppResult = const_cast<const ::QScriptValue *>(cppSelf)->engine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_equals(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.equals";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValue::equals(QScriptValue)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // equals(QScriptValue)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_equals_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // equals(QScriptValue)const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->equals(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptValueFunc_equals_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_instanceOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.instanceOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValue::instanceOf(QScriptValue)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // instanceOf(QScriptValue)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_instanceOf_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // instanceOf(QScriptValue)const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->instanceOf(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptValueFunc_instanceOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_isArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isArray()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBool()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isBool();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isBoolean(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isBoolean";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBoolean()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isBoolean();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isDate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDate()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isDate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isError()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isFunction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isFunction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFunction()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isFunction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNumber()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isObject()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isQMetaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isQMetaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isQMetaObject()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isQMetaObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isQObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isQObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isQObject()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isQObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isRegExp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isRegExp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRegExp()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isRegExp();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isString()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isString();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isUndefined(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isUndefined";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUndefined()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isUndefined();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_isVariant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.isVariant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVariant()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->isVariant();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_lessThan(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.lessThan";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValue::lessThan(QScriptValue)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // lessThan(QScriptValue)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_lessThan_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // lessThan(QScriptValue)const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->lessThan(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptValueFunc_lessThan_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_objectId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.objectId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // objectId()const
            qint64 cppResult = const_cast<const ::QScriptValue *>(cppSelf)->objectId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_property(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.property";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptValueFunc_property_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScriptValueFunc_property_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:property", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptValue::property(QScriptString,QFlags<QScriptValue::ResolveFlag>)const
    // 1: QScriptValue::property(QString,QFlags<QScriptValue::ResolveFlag>)const
    // 2: QScriptValue::property(quint32,QFlags<QScriptValue::ResolveFlag>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // property(quint32,QFlags<QScriptValue::ResolveFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 2; // property(quint32,QFlags<QScriptValue::ResolveFlag>)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // property(QString,QFlags<QScriptValue::ResolveFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // property(QString,QFlags<QScriptValue::ResolveFlag>)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // property(QScriptString,QFlags<QScriptValue::ResolveFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // property(QScriptString,QFlags<QScriptValue::ResolveFlag>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_property_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // property(const QScriptString & name, const QFlags<QScriptValue::ResolveFlag> & mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_property_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QScriptValueFunc_property_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_property_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptString cppArg0_local;
            ::QScriptString *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<QScriptValue::ResolveFlag> cppArg1 = QScriptValue::ResolvePrototype;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // property(QScriptString,QFlags<QScriptValue::ResolveFlag>)const
                QScriptValue cppResult = const_cast<const ::QScriptValue *>(cppSelf)->property(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // property(const QString & name, const QFlags<QScriptValue::ResolveFlag> & mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_property_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QScriptValueFunc_property_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_property_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QScriptValue::ResolveFlag> cppArg1 = QScriptValue::ResolvePrototype;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // property(QString,QFlags<QScriptValue::ResolveFlag>)const
                QScriptValue cppResult = const_cast<const ::QScriptValue *>(cppSelf)->property(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 2: // property(quint32 arrayIndex, const QFlags<QScriptValue::ResolveFlag> & mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_property_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QScriptValueFunc_property_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_property_TypeError;
                }
            }
            quint32 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QScriptValue::ResolveFlag> cppArg1 = QScriptValue::ResolvePrototype;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // property(quint32,QFlags<QScriptValue::ResolveFlag>)const
                QScriptValue cppResult = const_cast<const ::QScriptValue *>(cppSelf)->property(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptValueFunc_property_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_propertyFlags(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.propertyFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptValueFunc_propertyFlags_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScriptValueFunc_propertyFlags_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:propertyFlags", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptValue::propertyFlags(QScriptString,QFlags<QScriptValue::ResolveFlag>)const
    // 1: QScriptValue::propertyFlags(QString,QFlags<QScriptValue::ResolveFlag>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // propertyFlags(QString,QFlags<QScriptValue::ResolveFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // propertyFlags(QString,QFlags<QScriptValue::ResolveFlag>)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // propertyFlags(QScriptString,QFlags<QScriptValue::ResolveFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // propertyFlags(QScriptString,QFlags<QScriptValue::ResolveFlag>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_propertyFlags_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // propertyFlags(const QScriptString & name, const QFlags<QScriptValue::ResolveFlag> & mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_propertyFlags_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QScriptValueFunc_propertyFlags_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_propertyFlags_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptString cppArg0_local;
            ::QScriptString *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<QScriptValue::ResolveFlag> cppArg1 = QScriptValue::ResolvePrototype;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // propertyFlags(QScriptString,QFlags<QScriptValue::ResolveFlag>)const
                QFlags<QScriptValue::PropertyFlag> cppResult = const_cast<const ::QScriptValue *>(cppSelf)->propertyFlags(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, &cppResult);
            }
            break;
        }
        case 1: // propertyFlags(const QString & name, const QFlags<QScriptValue::ResolveFlag> & mode) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_propertyFlags_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QScriptValueFunc_propertyFlags_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_propertyFlags_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QScriptValue::ResolveFlag> cppArg1 = QScriptValue::ResolvePrototype;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // propertyFlags(QString,QFlags<QScriptValue::ResolveFlag>)const
                QFlags<QScriptValue::PropertyFlag> cppResult = const_cast<const ::QScriptValue *>(cppSelf)->propertyFlags(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptValueFunc_propertyFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_prototype(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.prototype";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // prototype()const
            QScriptValue cppResult = const_cast<const ::QScriptValue *>(cppSelf)->prototype();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_scope(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.scope";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scope()const
            QScriptValue cppResult = const_cast<const ::QScriptValue *>(cppSelf)->scope();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_scriptClass(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.scriptClass";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scriptClass()const
            QScriptClass * cppResult = const_cast<const ::QScriptValue *>(cppSelf)->scriptClass();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_setData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValue::setData(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setData(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_setData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setData(QScriptValue)
            cppSelf->setData(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptValueFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_setProperty(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.setProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptValueFunc_setProperty_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScriptValueFunc_setProperty_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setProperty", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScriptValue::setProperty(QScriptString,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
    // 1: QScriptValue::setProperty(QString,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
    // 2: QScriptValue::setProperty(quint32,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // setProperty(quint32,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, (pyArgs[2])))) {
            overloadId = 2; // setProperty(quint32,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // setProperty(QString,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, (pyArgs[2])))) {
            overloadId = 1; // setProperty(QString,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setProperty(QScriptString,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // setProperty(QScriptString,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_setProperty_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setProperty(const QScriptString & name, const QScriptValue & value, const QFlags<QScriptValue::PropertyFlag> & flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[2]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_setProperty_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QScriptValueFunc_setProperty_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_setProperty_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptString cppArg0_local;
            ::QScriptString *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QScriptValue cppArg1_local;
            ::QScriptValue *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QFlags<QScriptValue::PropertyFlag> cppArg2 = QScriptValue::KeepExistingFlags;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setProperty(QScriptString,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
                cppSelf->setProperty(*cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 1: // setProperty(const QString & name, const QScriptValue & value, const QFlags<QScriptValue::PropertyFlag> & flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[2]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_setProperty_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QScriptValueFunc_setProperty_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_setProperty_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QScriptValue cppArg1_local;
            ::QScriptValue *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QFlags<QScriptValue::PropertyFlag> cppArg2 = QScriptValue::KeepExistingFlags;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setProperty(QString,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
                cppSelf->setProperty(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 2: // setProperty(quint32 arrayIndex, const QScriptValue & value, const QFlags<QScriptValue::PropertyFlag> & flags)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
                if (PyDict_Contains(kwds, key_flags)) {
                    value = PyDict_GetItem(kwds, key_flags);
                    if (value && pyArgs[2]) {
                        errInfo = key_flags;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptValueFunc_setProperty_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QScriptValueFunc_setProperty_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_flags);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptValueFunc_setProperty_TypeError;
                }
            }
            quint32 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QScriptValue cppArg1_local;
            ::QScriptValue *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QFlags<QScriptValue::PropertyFlag> cppArg2 = QScriptValue::KeepExistingFlags;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setProperty(quint32,QScriptValue,QFlags<QScriptValue::PropertyFlag>)
                cppSelf->setProperty(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptValueFunc_setProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_setPrototype(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.setPrototype";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValue::setPrototype(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setPrototype(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_setPrototype_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPrototype(QScriptValue)
            cppSelf->setPrototype(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptValueFunc_setPrototype_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_setScope(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.setScope";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValue::setScope(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setScope(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_setScope_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScope(QScriptValue)
            cppSelf->setScope(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptValueFunc_setScope_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_setScriptClass(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.setScriptClass";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValue::setScriptClass(QScriptClass*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX]), (pyArg)))) {
        overloadId = 0; // setScriptClass(QScriptClass*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_setScriptClass_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptClass *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setScriptClass(QScriptClass*)
            cppSelf->setScriptClass(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptValueFunc_setScriptClass_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_strictlyEquals(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.strictlyEquals";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptValue::strictlyEquals(QScriptValue)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // strictlyEquals(QScriptValue)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptValueFunc_strictlyEquals_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // strictlyEquals(QScriptValue)const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->strictlyEquals(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptValueFunc_strictlyEquals_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptValueFunc_toBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toBool()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toBool();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toBoolean(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toBoolean";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toBoolean()const
            bool cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toBoolean();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toDateTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toDateTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toDateTime()const
            QDateTime cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toDateTime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toInt32(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toInt32";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toInt32()const
            qint32 cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toInt32();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toInteger(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toInteger";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toInteger()const
            double cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toInteger();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toNumber()const
            double cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toObject()const
            QScriptValue cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toObject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toQMetaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toQMetaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toQMetaObject()const
            const QMetaObject * cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toQMetaObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toQObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toQObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toQObject()const
            QObject * cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toQObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toRegExp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toRegExp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toRegExp()const
            QRegExp cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toRegExp();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toUInt16(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toUInt16";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toUInt16()const
            quint16 cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toUInt16();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toUInt32(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toUInt32";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toUInt32()const
            quint32 cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toUInt32();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValueFunc_toVariant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptValue.toVariant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toVariant()const
            QVariant cppResult = const_cast<const ::QScriptValue *>(cppSelf)->toVariant();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptValue___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScriptValue_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScriptValue_methods[] = {
    {"call", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_call), METH_VARARGS|METH_KEYWORDS},
    {"construct", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_construct), METH_VARARGS|METH_KEYWORDS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_data), METH_NOARGS},
    {"engine", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_engine), METH_NOARGS},
    {"equals", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_equals), METH_O},
    {"instanceOf", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_instanceOf), METH_O},
    {"isArray", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isArray), METH_NOARGS},
    {"isBool", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isBool), METH_NOARGS},
    {"isBoolean", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isBoolean), METH_NOARGS},
    {"isDate", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isDate), METH_NOARGS},
    {"isError", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isError), METH_NOARGS},
    {"isFunction", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isFunction), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isNull), METH_NOARGS},
    {"isNumber", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isNumber), METH_NOARGS},
    {"isObject", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isObject), METH_NOARGS},
    {"isQMetaObject", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isQMetaObject), METH_NOARGS},
    {"isQObject", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isQObject), METH_NOARGS},
    {"isRegExp", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isRegExp), METH_NOARGS},
    {"isString", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isString), METH_NOARGS},
    {"isUndefined", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isUndefined), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isValid), METH_NOARGS},
    {"isVariant", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_isVariant), METH_NOARGS},
    {"lessThan", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_lessThan), METH_O},
    {"objectId", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_objectId), METH_NOARGS},
    {"property", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_property), METH_VARARGS|METH_KEYWORDS},
    {"propertyFlags", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_propertyFlags), METH_VARARGS|METH_KEYWORDS},
    {"prototype", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_prototype), METH_NOARGS},
    {"scope", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_scope), METH_NOARGS},
    {"scriptClass", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_scriptClass), METH_NOARGS},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_setData), METH_O},
    {"setProperty", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_setProperty), METH_VARARGS|METH_KEYWORDS},
    {"setPrototype", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_setPrototype), METH_O},
    {"setScope", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_setScope), METH_O},
    {"setScriptClass", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_setScriptClass), METH_O},
    {"strictlyEquals", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_strictlyEquals), METH_O},
    {"toBool", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toBool), METH_NOARGS},
    {"toBoolean", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toBoolean), METH_NOARGS},
    {"toDateTime", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toDateTime), METH_NOARGS},
    {"toInt32", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toInt32), METH_NOARGS},
    {"toInteger", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toInteger), METH_NOARGS},
    {"toNumber", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toNumber), METH_NOARGS},
    {"toObject", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toObject), METH_NOARGS},
    {"toQMetaObject", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toQMetaObject), METH_NOARGS},
    {"toQObject", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toQObject), METH_NOARGS},
    {"toRegExp", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toRegExp), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toString), METH_NOARGS},
    {"toUInt16", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toUInt16), METH_NOARGS},
    {"toUInt32", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toUInt32), METH_NOARGS},
    {"toVariant", reinterpret_cast<PyCFunction>(Sbk_QScriptValueFunc_toVariant), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QScriptValue___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScriptValue___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

PyObject* Sbk_QScriptValueFunc___mgetitem__(PyObject *self, PyObject *_key)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtscript.cpp (qscriptvalue-mgetitem)]
    Shiboken::AutoDecRef key(PyObject_Str(_key));
    QVariant res = cppSelf->property(Shiboken::String::toCString(key.object())).toVariant();
    if (res.isValid()) {
        return Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &res);
    } else {
        PyObject *errorType = PyInt_Check(_key) ? PyExc_IndexError : PyExc_KeyError;
        PyErr_SetString(errorType, "Key not found.");
        return 0;
    }
    // END of custom code block [file: ../glue/qtscript.cpp (qscriptvalue-mgetitem)]
    // ========================================================================

    // End of code injection

}

} // extern "C"

static int Sbk_QScriptValue_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScriptValue_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScriptValue_Type = nullptr;
static SbkObjectType *Sbk_QScriptValue_TypeF(void)
{
    return _Sbk_QScriptValue_Type;
}

static PyType_Slot Sbk_QScriptValue_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QScriptValueFunc___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScriptValue_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScriptValue_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        reinterpret_cast<void *>(Sbk_QScriptValueFunc___iter__)},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScriptValue_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScriptValue_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports mapping protocol
    {Py_mp_subscript, (void *)&Sbk_QScriptValueFunc___mgetitem__},
    {Py_mp_ass_subscript, (void *)0},
    {Py_mp_length, (void *)0},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QScriptValue___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QScriptValue___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QScriptValue_spec = {
    "2:PySide2.QtScript.QScriptValue",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScriptValue_slots
};

} //extern "C"

PyObject *SbkPySide2_QtScript_QScriptValue_ResolveFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QScriptValue::ResolveFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptValue::ResolveFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptValue::ResolveFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptValue::ResolveFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptValue::ResolveFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptValue_ResolveFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QScriptValue::ResolveFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptValue::ResolveFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptValue::ResolveFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptValue::ResolveFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptValue::ResolveFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptValue_ResolveFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QScriptValue::ResolveFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptValue::ResolveFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptValue::ResolveFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptValue::ResolveFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptValue::ResolveFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptValue_ResolveFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QScriptValue::ResolveFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, self, &cppSelf);
    ::QScriptValue::ResolveFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtScript_QScriptValue_ResolveFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtScript_QScriptValue_ResolveFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtScript_QScriptValue_ResolveFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_ResolveFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtScript_QScriptValue_PropertyFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QScriptValue::PropertyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptValue::PropertyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptValue::PropertyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptValue::PropertyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptValue::PropertyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptValue_PropertyFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QScriptValue::PropertyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptValue::PropertyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptValue::PropertyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptValue::PropertyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptValue::PropertyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptValue_PropertyFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QScriptValue::PropertyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptValue::PropertyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptValue::PropertyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptValue::PropertyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptValue::PropertyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptValue_PropertyFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QScriptValue::PropertyFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, self, &cppSelf);
    ::QScriptValue::PropertyFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtScript_QScriptValue_PropertyFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtScript_QScriptValue_PropertyFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtScript_QScriptValue_PropertyFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptValue_PropertyFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QScriptValue_ResolveFlag_PythonToCpp_QScriptValue_ResolveFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptValue::ResolveFlag *>(cppOut) =
        static_cast<::QScriptValue::ResolveFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptValue_ResolveFlag_PythonToCpp_QScriptValue_ResolveFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX]))
        return QScriptValue_ResolveFlag_PythonToCpp_QScriptValue_ResolveFlag;
    return {};
}
static PyObject *QScriptValue_ResolveFlag_CppToPython_QScriptValue_ResolveFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptValue::ResolveFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX], castCppIn);

}

static void QFlags_QScriptValue_ResolveFlag__PythonToCpp_QFlags_QScriptValue_ResolveFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QScriptValue::ResolveFlag> *>(cppOut) =
        ::QFlags<QScriptValue::ResolveFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QScriptValue_ResolveFlag__PythonToCpp_QFlags_QScriptValue_ResolveFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX]))
        return QFlags_QScriptValue_ResolveFlag__PythonToCpp_QFlags_QScriptValue_ResolveFlag_;
    return {};
}
static PyObject *QFlags_QScriptValue_ResolveFlag__CppToPython_QFlags_QScriptValue_ResolveFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QScriptValue::ResolveFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX]));

}

static void QScriptValue_ResolveFlag_PythonToCpp_QFlags_QScriptValue_ResolveFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QScriptValue::ResolveFlag> *>(cppOut) =
        ::QFlags<QScriptValue::ResolveFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QScriptValue_ResolveFlag_PythonToCpp_QFlags_QScriptValue_ResolveFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX]))
        return QScriptValue_ResolveFlag_PythonToCpp_QFlags_QScriptValue_ResolveFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QScriptValue_ResolveFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QScriptValue::ResolveFlag> *>(cppOut) =
        ::QFlags<QScriptValue::ResolveFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QScriptValue_ResolveFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QScriptValue_ResolveFlag_;
    return {};
}
static void QScriptValue_PropertyFlag_PythonToCpp_QScriptValue_PropertyFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptValue::PropertyFlag *>(cppOut) =
        static_cast<::QScriptValue::PropertyFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptValue_PropertyFlag_PythonToCpp_QScriptValue_PropertyFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX]))
        return QScriptValue_PropertyFlag_PythonToCpp_QScriptValue_PropertyFlag;
    return {};
}
static PyObject *QScriptValue_PropertyFlag_CppToPython_QScriptValue_PropertyFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptValue::PropertyFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX], castCppIn);

}

static void QFlags_QScriptValue_PropertyFlag__PythonToCpp_QFlags_QScriptValue_PropertyFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QScriptValue::PropertyFlag> *>(cppOut) =
        ::QFlags<QScriptValue::PropertyFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QScriptValue_PropertyFlag__PythonToCpp_QFlags_QScriptValue_PropertyFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX]))
        return QFlags_QScriptValue_PropertyFlag__PythonToCpp_QFlags_QScriptValue_PropertyFlag_;
    return {};
}
static PyObject *QFlags_QScriptValue_PropertyFlag__CppToPython_QFlags_QScriptValue_PropertyFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QScriptValue::PropertyFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX]));

}

static void QScriptValue_PropertyFlag_PythonToCpp_QFlags_QScriptValue_PropertyFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QScriptValue::PropertyFlag> *>(cppOut) =
        ::QFlags<QScriptValue::PropertyFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QScriptValue_PropertyFlag_PythonToCpp_QFlags_QScriptValue_PropertyFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX]))
        return QScriptValue_PropertyFlag_PythonToCpp_QFlags_QScriptValue_PropertyFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QScriptValue_PropertyFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QScriptValue::PropertyFlag> *>(cppOut) =
        ::QFlags<QScriptValue::PropertyFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QScriptValue_PropertyFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX]))
        return number_PythonToCpp_QFlags_QScriptValue_PropertyFlag_;
    return {};
}
static void QScriptValue_SpecialValue_PythonToCpp_QScriptValue_SpecialValue(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptValue::SpecialValue *>(cppOut) =
        static_cast<::QScriptValue::SpecialValue>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptValue_SpecialValue_PythonToCpp_QScriptValue_SpecialValue_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX]))
        return QScriptValue_SpecialValue_PythonToCpp_QScriptValue_SpecialValue;
    return {};
}
static PyObject *QScriptValue_SpecialValue_CppToPython_QScriptValue_SpecialValue(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptValue::SpecialValue *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScriptValue_PythonToCpp_QScriptValue_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScriptValue_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScriptValue_PythonToCpp_QScriptValue_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptValue_TypeF())))
        return QScriptValue_PythonToCpp_QScriptValue_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScriptValue_PTR_CppToPython_QScriptValue(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScriptValue *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScriptValue_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QScriptValue_COPY_CppToPython_QScriptValue(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QScriptValue_TypeF(), new ::QScriptValue(*reinterpret_cast<const ::QScriptValue *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QScriptValue_PythonToCpp_QScriptValue_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptValue *>(cppOut) = *reinterpret_cast< ::QScriptValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QScriptValue_PythonToCpp_QScriptValue_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptValue_TypeF())))
        return QScriptValue_PythonToCpp_QScriptValue_COPY;
    return {};
}

// Implicit conversions.
static void QScriptValue_SpecialValue_PythonToCpp_QScriptValue(PyObject *pyIn, void *cppOut) {
    ::QScriptValue::SpecialValue cppIn{QScriptValue::NullValue};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QScriptValue *>(cppOut) = ::QScriptValue(cppIn);
}
static PythonToCppFunc is_QScriptValue_SpecialValue_PythonToCpp_QScriptValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX], pyIn))
        return QScriptValue_SpecialValue_PythonToCpp_QScriptValue;
    return {};
}

static void PySide2_QtCore_bool_PythonToCpp_QScriptValue(PyObject *pyIn, void *cppOut) {
    bool cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyIn, &cppIn);
    *reinterpret_cast<::QScriptValue *>(cppOut) = ::QScriptValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_bool_PythonToCpp_QScriptValue_Convertible(PyObject *pyIn) {
    if (PyBool_Check(pyIn))
        return PySide2_QtCore_bool_PythonToCpp_QScriptValue;
    return {};
}

static void PySide2_QtCore_constQStringREF_PythonToCpp_QScriptValue(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QScriptValue *>(cppOut) = ::QScriptValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQStringREF_PythonToCpp_QScriptValue_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constQStringREF_PythonToCpp_QScriptValue;
    return {};
}

static void PySide2_QtCore_constcharPTR_PythonToCpp_QScriptValue(PyObject *pyIn, void *cppOut) {
    const char* cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), pyIn, &cppIn);
    *reinterpret_cast<::QScriptValue *>(cppOut) = ::QScriptValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constcharPTR_PythonToCpp_QScriptValue_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constcharPTR_PythonToCpp_QScriptValue;
    return {};
}

static void PySide2_QtCore_double_PythonToCpp_QScriptValue(PyObject *pyIn, void *cppOut) {
    double cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<double>(), pyIn, &cppIn);
    *reinterpret_cast<::QScriptValue *>(cppOut) = ::QScriptValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_double_PythonToCpp_QScriptValue_Convertible(PyObject *pyIn) {
    if (PyFloat_Check(pyIn))
        return PySide2_QtCore_double_PythonToCpp_QScriptValue;
    return {};
}

static void PySide2_QtCore_int_PythonToCpp_QScriptValue(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QScriptValue *>(cppOut) = ::QScriptValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_int_PythonToCpp_QScriptValue_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_int_PythonToCpp_QScriptValue;
    return {};
}

static void PySide2_QtCore_uint_PythonToCpp_QScriptValue(PyObject *pyIn, void *cppOut) {
    uint cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), pyIn, &cppIn);
    *reinterpret_cast<::QScriptValue *>(cppOut) = ::QScriptValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_uint_PythonToCpp_QScriptValue_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_uint_PythonToCpp_QScriptValue;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScriptValue_SignatureStrings[] = {
    "15:PySide2.QtScript.QScriptValue(self)",
    "14:PySide2.QtScript.QScriptValue(self,engine:PySide2.QtScript.QScriptEngine,val:PySide2.QtScript.QScriptValue.SpecialValue)",
    "13:PySide2.QtScript.QScriptValue(self,engine:PySide2.QtScript.QScriptEngine,val:bool)",
    "12:PySide2.QtScript.QScriptValue(self,engine:PySide2.QtScript.QScriptEngine,val:QString)",
    "11:PySide2.QtScript.QScriptValue(self,engine:PySide2.QtScript.QScriptEngine,val:char*)",
    "10:PySide2.QtScript.QScriptValue(self,engine:PySide2.QtScript.QScriptEngine,val:double)",
    "9:PySide2.QtScript.QScriptValue(self,engine:PySide2.QtScript.QScriptEngine,val:int)",
    "8:PySide2.QtScript.QScriptValue(self,engine:PySide2.QtScript.QScriptEngine,val:uint)",
    "7:PySide2.QtScript.QScriptValue(self,value:PySide2.QtScript.QScriptValue.SpecialValue)",
    "6:PySide2.QtScript.QScriptValue(self,value:bool)",
    "5:PySide2.QtScript.QScriptValue(self,other:PySide2.QtScript.QScriptValue)",
    "4:PySide2.QtScript.QScriptValue(self,value:QString)",
    "3:PySide2.QtScript.QScriptValue(self,value:char*)",
    "2:PySide2.QtScript.QScriptValue(self,value:double)",
    "1:PySide2.QtScript.QScriptValue(self,value:int)",
    "0:PySide2.QtScript.QScriptValue(self,value:uint)",
    "PySide2.QtScript.QScriptValue.__iter__(self)->PyObject",
    "PySide2.QtScript.QScriptValue.__repr__(self)->PyObject",
    "1:PySide2.QtScript.QScriptValue.call(self,thisObject:PySide2.QtScript.QScriptValue=QScriptValue(),args:QList[PySide2.QtScript.QScriptValue]=QScriptValueList())->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptValue.call(self,thisObject:PySide2.QtScript.QScriptValue,arguments:PySide2.QtScript.QScriptValue)->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptValue.construct(self,args:QList[PySide2.QtScript.QScriptValue]=QScriptValueList())->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptValue.construct(self,arguments:PySide2.QtScript.QScriptValue)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptValue.data(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptValue.engine(self)->PySide2.QtScript.QScriptEngine",
    "PySide2.QtScript.QScriptValue.equals(self,other:PySide2.QtScript.QScriptValue)->bool",
    "PySide2.QtScript.QScriptValue.instanceOf(self,other:PySide2.QtScript.QScriptValue)->bool",
    "PySide2.QtScript.QScriptValue.isArray(self)->bool",
    "PySide2.QtScript.QScriptValue.isBool(self)->bool",
    "PySide2.QtScript.QScriptValue.isBoolean(self)->bool",
    "PySide2.QtScript.QScriptValue.isDate(self)->bool",
    "PySide2.QtScript.QScriptValue.isError(self)->bool",
    "PySide2.QtScript.QScriptValue.isFunction(self)->bool",
    "PySide2.QtScript.QScriptValue.isNull(self)->bool",
    "PySide2.QtScript.QScriptValue.isNumber(self)->bool",
    "PySide2.QtScript.QScriptValue.isObject(self)->bool",
    "PySide2.QtScript.QScriptValue.isQMetaObject(self)->bool",
    "PySide2.QtScript.QScriptValue.isQObject(self)->bool",
    "PySide2.QtScript.QScriptValue.isRegExp(self)->bool",
    "PySide2.QtScript.QScriptValue.isString(self)->bool",
    "PySide2.QtScript.QScriptValue.isUndefined(self)->bool",
    "PySide2.QtScript.QScriptValue.isValid(self)->bool",
    "PySide2.QtScript.QScriptValue.isVariant(self)->bool",
    "PySide2.QtScript.QScriptValue.lessThan(self,other:PySide2.QtScript.QScriptValue)->bool",
    "PySide2.QtScript.QScriptValue.objectId(self)->qint64",
    "2:PySide2.QtScript.QScriptValue.property(self,name:PySide2.QtScript.QScriptString,mode:PySide2.QtScript.QScriptValue.ResolveFlags=QScriptValue.ResolvePrototype)->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptValue.property(self,name:QString,mode:PySide2.QtScript.QScriptValue.ResolveFlags=QScriptValue.ResolvePrototype)->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptValue.property(self,arrayIndex:quint32,mode:PySide2.QtScript.QScriptValue.ResolveFlags=QScriptValue.ResolvePrototype)->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptValue.propertyFlags(self,name:PySide2.QtScript.QScriptString,mode:PySide2.QtScript.QScriptValue.ResolveFlags=QScriptValue.ResolvePrototype)->PySide2.QtScript.QScriptValue.PropertyFlags",
    "0:PySide2.QtScript.QScriptValue.propertyFlags(self,name:QString,mode:PySide2.QtScript.QScriptValue.ResolveFlags=QScriptValue.ResolvePrototype)->PySide2.QtScript.QScriptValue.PropertyFlags",
    "PySide2.QtScript.QScriptValue.prototype(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptValue.scope(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptValue.scriptClass(self)->PySide2.QtScript.QScriptClass",
    "PySide2.QtScript.QScriptValue.setData(self,data:PySide2.QtScript.QScriptValue)",
    "2:PySide2.QtScript.QScriptValue.setProperty(self,name:PySide2.QtScript.QScriptString,value:PySide2.QtScript.QScriptValue,flags:PySide2.QtScript.QScriptValue.PropertyFlags=QScriptValue.KeepExistingFlags)",
    "1:PySide2.QtScript.QScriptValue.setProperty(self,name:QString,value:PySide2.QtScript.QScriptValue,flags:PySide2.QtScript.QScriptValue.PropertyFlags=QScriptValue.KeepExistingFlags)",
    "0:PySide2.QtScript.QScriptValue.setProperty(self,arrayIndex:quint32,value:PySide2.QtScript.QScriptValue,flags:PySide2.QtScript.QScriptValue.PropertyFlags=QScriptValue.KeepExistingFlags)",
    "PySide2.QtScript.QScriptValue.setPrototype(self,prototype:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptValue.setScope(self,scope:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptValue.setScriptClass(self,scriptClass:PySide2.QtScript.QScriptClass)",
    "PySide2.QtScript.QScriptValue.strictlyEquals(self,other:PySide2.QtScript.QScriptValue)->bool",
    "PySide2.QtScript.QScriptValue.toBool(self)->bool",
    "PySide2.QtScript.QScriptValue.toBoolean(self)->bool",
    "PySide2.QtScript.QScriptValue.toDateTime(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtScript.QScriptValue.toInt32(self)->qint32",
    "PySide2.QtScript.QScriptValue.toInteger(self)->double",
    "PySide2.QtScript.QScriptValue.toNumber(self)->double",
    "PySide2.QtScript.QScriptValue.toObject(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptValue.toQMetaObject(self)->PySide2.QtCore.QMetaObject",
    "PySide2.QtScript.QScriptValue.toQObject(self)->PySide2.QtCore.QObject",
    "PySide2.QtScript.QScriptValue.toRegExp(self)->PySide2.QtCore.QRegExp",
    "PySide2.QtScript.QScriptValue.toString(self)->QString",
    "PySide2.QtScript.QScriptValue.toUInt16(self)->quint16",
    "PySide2.QtScript.QScriptValue.toUInt32(self)->quint32",
    "PySide2.QtScript.QScriptValue.toVariant(self)->QVariant",
    "PySide2.QtScript.QScriptValue.__copy__()",
    nullptr}; // Sentinel

void init_QScriptValue(PyObject *module)
{
    _Sbk_QScriptValue_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScriptValue",
        "QScriptValue",
        &Sbk_QScriptValue_spec,
        &Shiboken::callCppDestructor< ::QScriptValue >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScriptValue_Type);
    InitSignatureStrings(pyType, QScriptValue_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScriptValue_Type), Sbk_QScriptValue_PropertyStrings);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScriptValue_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScriptValue_TypeF(),
        QScriptValue_PythonToCpp_QScriptValue_PTR,
        is_QScriptValue_PythonToCpp_QScriptValue_PTR_Convertible,
        QScriptValue_PTR_CppToPython_QScriptValue,
        QScriptValue_COPY_CppToPython_QScriptValue);

    Shiboken::Conversions::registerConverterName(converter, "QScriptValue");
    Shiboken::Conversions::registerConverterName(converter, "QScriptValue*");
    Shiboken::Conversions::registerConverterName(converter, "QScriptValue&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptValue).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QScriptValue_PythonToCpp_QScriptValue_COPY,
        is_QScriptValue_PythonToCpp_QScriptValue_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QScriptValue_SpecialValue_PythonToCpp_QScriptValue,
        is_QScriptValue_SpecialValue_PythonToCpp_QScriptValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_bool_PythonToCpp_QScriptValue,
        is_PySide2_QtCore_bool_PythonToCpp_QScriptValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQStringREF_PythonToCpp_QScriptValue,
        is_PySide2_QtCore_constQStringREF_PythonToCpp_QScriptValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constcharPTR_PythonToCpp_QScriptValue,
        is_PySide2_QtCore_constcharPTR_PythonToCpp_QScriptValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_double_PythonToCpp_QScriptValue,
        is_PySide2_QtCore_double_PythonToCpp_QScriptValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_int_PythonToCpp_QScriptValue,
        is_PySide2_QtCore_int_PythonToCpp_QScriptValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_uint_PythonToCpp_QScriptValue,
        is_PySide2_QtCore_uint_PythonToCpp_QScriptValue_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ResolveFlag'.
    SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtScript.QScriptValue.ResolveFlags", SbkPySide2_QtScript_QScriptValue_ResolveFlag_number_slots);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptValue_TypeF(),
        "ResolveFlag",
        "2:PySide2.QtScript.QScriptValue.ResolveFlag",
        "QScriptValue::ResolveFlag",
        SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX]);
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "ResolveLocal", (long) QScriptValue::ResolveFlag::ResolveLocal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "ResolvePrototype", (long) QScriptValue::ResolveFlag::ResolvePrototype))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "ResolveScope", (long) QScriptValue::ResolveFlag::ResolveScope))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "ResolveFull", (long) QScriptValue::ResolveFlag::ResolveFull))
        return;
    // Register converter for enum 'QScriptValue::ResolveFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX],
            QScriptValue_ResolveFlag_CppToPython_QScriptValue_ResolveFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptValue_ResolveFlag_PythonToCpp_QScriptValue_ResolveFlag,
            is_QScriptValue_ResolveFlag_PythonToCpp_QScriptValue_ResolveFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptValue::ResolveFlag");
        Shiboken::Conversions::registerConverterName(converter, "ResolveFlag");
    }
    // Register converter for flag 'QFlags<QScriptValue::ResolveFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX],
            QFlags_QScriptValue_ResolveFlag__CppToPython_QFlags_QScriptValue_ResolveFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptValue_ResolveFlag_PythonToCpp_QFlags_QScriptValue_ResolveFlag_,
            is_QScriptValue_ResolveFlag_PythonToCpp_QFlags_QScriptValue_ResolveFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QScriptValue_ResolveFlag__PythonToCpp_QFlags_QScriptValue_ResolveFlag_,
            is_QFlags_QScriptValue_ResolveFlag__PythonToCpp_QFlags_QScriptValue_ResolveFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QScriptValue_ResolveFlag_,
            is_number_PythonToCpp_QFlags_QScriptValue_ResolveFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_RESOLVEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptValue::ResolveFlags");
        Shiboken::Conversions::registerConverterName(converter, "ResolveFlags");
    }
    // End of 'ResolveFlag' enum/flags.

    // Initialization of enum 'PropertyFlag'.
    SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtScript.QScriptValue.PropertyFlags", SbkPySide2_QtScript_QScriptValue_PropertyFlag_number_slots);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptValue_TypeF(),
        "PropertyFlag",
        "2:PySide2.QtScript.QScriptValue.PropertyFlag",
        "QScriptValue::PropertyFlag",
        SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX]);
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "ReadOnly", (long) QScriptValue::PropertyFlag::ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "Undeletable", (long) QScriptValue::PropertyFlag::Undeletable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "SkipInEnumeration", (long) QScriptValue::PropertyFlag::SkipInEnumeration))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "PropertyGetter", (long) QScriptValue::PropertyFlag::PropertyGetter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "PropertySetter", (long) QScriptValue::PropertyFlag::PropertySetter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "QObjectMember", (long) QScriptValue::PropertyFlag::QObjectMember))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "KeepExistingFlags", (long) QScriptValue::PropertyFlag::KeepExistingFlags))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
        Sbk_QScriptValue_TypeF(), "UserRange", (long) QScriptValue::PropertyFlag::UserRange))
        return;
    // Register converter for enum 'QScriptValue::PropertyFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX],
            QScriptValue_PropertyFlag_CppToPython_QScriptValue_PropertyFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptValue_PropertyFlag_PythonToCpp_QScriptValue_PropertyFlag,
            is_QScriptValue_PropertyFlag_PythonToCpp_QScriptValue_PropertyFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptValue::PropertyFlag");
        Shiboken::Conversions::registerConverterName(converter, "PropertyFlag");
    }
    // Register converter for flag 'QFlags<QScriptValue::PropertyFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX],
            QFlags_QScriptValue_PropertyFlag__CppToPython_QFlags_QScriptValue_PropertyFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptValue_PropertyFlag_PythonToCpp_QFlags_QScriptValue_PropertyFlag_,
            is_QScriptValue_PropertyFlag_PythonToCpp_QFlags_QScriptValue_PropertyFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QScriptValue_PropertyFlag__PythonToCpp_QFlags_QScriptValue_PropertyFlag_,
            is_QFlags_QScriptValue_PropertyFlag__PythonToCpp_QFlags_QScriptValue_PropertyFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QScriptValue_PropertyFlag_,
            is_number_PythonToCpp_QFlags_QScriptValue_PropertyFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptValue::PropertyFlags");
        Shiboken::Conversions::registerConverterName(converter, "PropertyFlags");
    }
    // End of 'PropertyFlag' enum/flags.

    // Initialization of enum 'SpecialValue'.
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptValue_TypeF(),
        "SpecialValue",
        "2:PySide2.QtScript.QScriptValue.SpecialValue",
        "QScriptValue::SpecialValue");
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX],
        Sbk_QScriptValue_TypeF(), "NullValue", (long) QScriptValue::SpecialValue::NullValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX],
        Sbk_QScriptValue_TypeF(), "UndefinedValue", (long) QScriptValue::SpecialValue::UndefinedValue))
        return;
    // Register converter for enum 'QScriptValue::SpecialValue'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX],
            QScriptValue_SpecialValue_CppToPython_QScriptValue_SpecialValue);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptValue_SpecialValue_PythonToCpp_QScriptValue_SpecialValue,
            is_QScriptValue_SpecialValue_PythonToCpp_QScriptValue_SpecialValue_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptValue::SpecialValue");
        Shiboken::Conversions::registerConverterName(converter, "SpecialValue");
    }
    // End of 'SpecialValue' enum.

    qRegisterMetaType< ::QScriptValue >("QScriptValue");
    qRegisterMetaType< ::QScriptValue::ResolveFlag >("QScriptValue::ResolveFlag");
    qRegisterMetaType< ::QScriptValue::ResolveFlags >("QScriptValue::ResolveFlags");
    qRegisterMetaType< ::QScriptValue::PropertyFlag >("QScriptValue::PropertyFlag");
    qRegisterMetaType< ::QScriptValue::PropertyFlags >("QScriptValue::PropertyFlags");
    qRegisterMetaType< ::QScriptValue::SpecialValue >("QScriptValue::SpecialValue");
}
