/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscript_python.h"

// main header
#include "qscriptengineagent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScriptEngineAgentWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QScriptEngineAgentWrapper::QScriptEngineAgentWrapper(::QScriptEngine * engine) : QScriptEngineAgent(engine)
{
    resetPyMethodCache();
    // ... middle
}

void QScriptEngineAgentWrapper::contextPop()
{
    if (m_PyMethodCache[0]) {
        return this->::QScriptEngineAgent::contextPop();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contextPop";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QScriptEngineAgent::contextPop();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScriptEngineAgentWrapper::contextPush()
{
    if (m_PyMethodCache[1]) {
        return this->::QScriptEngineAgent::contextPush();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contextPush";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QScriptEngineAgent::contextPush();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScriptEngineAgentWrapper::exceptionCatch(qint64 scriptId, const ::QScriptValue & exception)
{
    if (m_PyMethodCache[2]) {
        return this->::QScriptEngineAgent::exceptionCatch(scriptId, exception);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "exceptionCatch";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QScriptEngineAgent::exceptionCatch(scriptId, exception);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(LN)",
    scriptId,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &exception)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScriptEngineAgentWrapper::exceptionThrow(qint64 scriptId, const ::QScriptValue & exception, bool hasHandler)
{
    if (m_PyMethodCache[3]) {
        return this->::QScriptEngineAgent::exceptionThrow(scriptId, exception, hasHandler);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "exceptionThrow";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QScriptEngineAgent::exceptionThrow(scriptId, exception, hasHandler);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(LNN)",
    scriptId,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &exception),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &hasHandler)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QVariant QScriptEngineAgentWrapper::extension(::QScriptEngineAgent::Extension extension, const ::QVariant & argument)
{
    if (m_PyMethodCache[4])
        return this->::QScriptEngineAgent::extension(extension, argument);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "extension";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QScriptEngineAgent::extension(extension, argument);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX])->converter, &extension),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &argument)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptEngineAgent.extension", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QScriptEngineAgentWrapper::functionEntry(qint64 scriptId)
{
    if (m_PyMethodCache[5]) {
        return this->::QScriptEngineAgent::functionEntry(scriptId);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "functionEntry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QScriptEngineAgent::functionEntry(scriptId);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    scriptId
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScriptEngineAgentWrapper::functionExit(qint64 scriptId, const ::QScriptValue & returnValue)
{
    if (m_PyMethodCache[6]) {
        return this->::QScriptEngineAgent::functionExit(scriptId, returnValue);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "functionExit";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QScriptEngineAgent::functionExit(scriptId, returnValue);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(LN)",
    scriptId,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &returnValue)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScriptEngineAgentWrapper::positionChange(qint64 scriptId, int lineNumber, int columnNumber)
{
    if (m_PyMethodCache[7]) {
        return this->::QScriptEngineAgent::positionChange(scriptId, lineNumber, columnNumber);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "positionChange";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QScriptEngineAgent::positionChange(scriptId, lineNumber, columnNumber);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Lii)",
    scriptId,
    lineNumber,
    columnNumber
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScriptEngineAgentWrapper::scriptLoad(qint64 id, const ::QString & program, const ::QString & fileName, int baseLineNumber)
{
    if (m_PyMethodCache[8]) {
        return this->::QScriptEngineAgent::scriptLoad(id, program, fileName, baseLineNumber);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "scriptLoad";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QScriptEngineAgent::scriptLoad(id, program, fileName, baseLineNumber);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(LNNi)",
    id,
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &program),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &fileName),
    baseLineNumber
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScriptEngineAgentWrapper::scriptUnload(qint64 id)
{
    if (m_PyMethodCache[9]) {
        return this->::QScriptEngineAgent::scriptUnload(id);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "scriptUnload";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QScriptEngineAgent::scriptUnload(id);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    id
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QScriptEngineAgentWrapper::supportsExtension(::QScriptEngineAgent::Extension extension) const
{
    if (m_PyMethodCache[10])
        return this->::QScriptEngineAgent::supportsExtension(extension);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportsExtension";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QScriptEngineAgent::supportsExtension(extension);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX])->converter, &extension)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptEngineAgent.supportsExtension", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QScriptEngineAgentWrapper::~QScriptEngineAgentWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScriptEngineAgent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScriptEngineAgent >()))
        return -1;

    ::QScriptEngineAgentWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScriptEngineAgent", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QScriptEngineAgent::QScriptEngineAgent(QScriptEngine*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QScriptEngineAgent(QScriptEngine*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgent_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QScriptEngine *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QScriptEngineAgent(QScriptEngine*)
            cptr = new ::QScriptEngineAgentWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScriptEngineAgent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScriptEngineAgent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScriptEngineAgent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScriptEngineAgentFunc_contextPop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.contextPop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contextPop()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::contextPop()
                : cppSelf->contextPop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptEngineAgentFunc_contextPush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.contextPush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contextPush()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::contextPush()
                : cppSelf->contextPush();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptEngineAgentFunc_engine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.engine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // engine()const
            QScriptEngine * cppResult = const_cast<const ::QScriptEngineAgent *>(cppSelf)->engine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineAgentFunc_exceptionCatch(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.exceptionCatch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "exceptionCatch", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngineAgent::exceptionCatch(qint64,QScriptValue)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // exceptionCatch(qint64,QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_exceptionCatch_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QScriptValue cppArg1_local;
        ::QScriptValue *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // exceptionCatch(qint64,QScriptValue)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::exceptionCatch(cppArg0, *cppArg1)
                : cppSelf->exceptionCatch(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineAgentFunc_exceptionCatch_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineAgentFunc_exceptionThrow(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.exceptionThrow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "exceptionThrow", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngineAgent::exceptionThrow(qint64,QScriptValue,bool)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
        overloadId = 0; // exceptionThrow(qint64,QScriptValue,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_exceptionThrow_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QScriptValue cppArg1_local;
        ::QScriptValue *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        bool cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // exceptionThrow(qint64,QScriptValue,bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::exceptionThrow(cppArg0, *cppArg1, cppArg2)
                : cppSelf->exceptionThrow(cppArg0, *cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineAgentFunc_exceptionThrow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineAgentFunc_extension(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.extension";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineAgentFunc_extension_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineAgentFunc_extension_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:extension", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngineAgent::extension(QScriptEngineAgent::Extension,QVariant)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // extension(QScriptEngineAgent::Extension,QVariant)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
            overloadId = 0; // extension(QScriptEngineAgent::Extension,QVariant)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_extension_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_argument = Shiboken::String::createStaticString("argument");
            if (PyDict_Contains(kwds, key_argument)) {
                value = PyDict_GetItem(kwds, key_argument);
                if (value && pyArgs[1]) {
                    errInfo = key_argument;
                    Py_INCREF(errInfo);
                    goto Sbk_QScriptEngineAgentFunc_extension_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1]))))
                        goto Sbk_QScriptEngineAgentFunc_extension_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_argument);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScriptEngineAgentFunc_extension_TypeError;
            }
        }
        ::QScriptEngineAgent::Extension cppArg0{QScriptEngineAgent::DebuggerInvocationRequest};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1 = QVariant();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // extension(QScriptEngineAgent::Extension,QVariant)
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::extension(cppArg0, cppArg1)
                : cppSelf->extension(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineAgentFunc_extension_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineAgentFunc_functionEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.functionEntry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngineAgent::functionEntry(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // functionEntry(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_functionEntry_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // functionEntry(qint64)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::functionEntry(cppArg0)
                : cppSelf->functionEntry(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineAgentFunc_functionEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineAgentFunc_functionExit(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.functionExit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "functionExit", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngineAgent::functionExit(qint64,QScriptValue)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // functionExit(qint64,QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_functionExit_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QScriptValue cppArg1_local;
        ::QScriptValue *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // functionExit(qint64,QScriptValue)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::functionExit(cppArg0, *cppArg1)
                : cppSelf->functionExit(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineAgentFunc_functionExit_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineAgentFunc_positionChange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.positionChange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "positionChange", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngineAgent::positionChange(qint64,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // positionChange(qint64,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_positionChange_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // positionChange(qint64,int,int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::positionChange(cppArg0, cppArg1, cppArg2)
                : cppSelf->positionChange(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineAgentFunc_positionChange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineAgentFunc_scriptLoad(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.scriptLoad";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "scriptLoad", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngineAgent::scriptLoad(qint64,QString,QString,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // scriptLoad(qint64,QString,QString,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_scriptLoad_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // scriptLoad(qint64,QString,QString,int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::scriptLoad(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->scriptLoad(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineAgentFunc_scriptLoad_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineAgentFunc_scriptUnload(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.scriptUnload";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngineAgent::scriptUnload(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // scriptUnload(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_scriptUnload_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // scriptUnload(qint64)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptEngineAgent::scriptUnload(cppArg0)
                : cppSelf->scriptUnload(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineAgentFunc_scriptUnload_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineAgentFunc_supportsExtension(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngineAgent.supportsExtension";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngineAgent::supportsExtension(QScriptEngineAgent::Extension)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // supportsExtension(QScriptEngineAgent::Extension)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineAgentFunc_supportsExtension_TypeError;

    // Call function/method
    {
        ::QScriptEngineAgent::Extension cppArg0{QScriptEngineAgent::DebuggerInvocationRequest};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // supportsExtension(QScriptEngineAgent::Extension)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QScriptEngineAgent *>(cppSelf)->::QScriptEngineAgent::supportsExtension(cppArg0)
                : const_cast<const ::QScriptEngineAgent *>(cppSelf)->supportsExtension(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineAgentFunc_supportsExtension_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QScriptEngineAgent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScriptEngineAgent_methods[] = {
    {"contextPop", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_contextPop), METH_NOARGS},
    {"contextPush", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_contextPush), METH_NOARGS},
    {"engine", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_engine), METH_NOARGS},
    {"exceptionCatch", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_exceptionCatch), METH_VARARGS},
    {"exceptionThrow", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_exceptionThrow), METH_VARARGS},
    {"extension", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_extension), METH_VARARGS|METH_KEYWORDS},
    {"functionEntry", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_functionEntry), METH_O},
    {"functionExit", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_functionExit), METH_VARARGS},
    {"positionChange", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_positionChange), METH_VARARGS},
    {"scriptLoad", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_scriptLoad), METH_VARARGS},
    {"scriptUnload", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_scriptUnload), METH_O},
    {"supportsExtension", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineAgentFunc_supportsExtension), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScriptEngineAgent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScriptEngineAgent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScriptEngineAgentWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScriptEngineAgent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScriptEngineAgent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScriptEngineAgent_Type = nullptr;
static SbkObjectType *Sbk_QScriptEngineAgent_TypeF(void)
{
    return _Sbk_QScriptEngineAgent_Type;
}

static PyType_Slot Sbk_QScriptEngineAgent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScriptEngineAgent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScriptEngineAgent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScriptEngineAgent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScriptEngineAgent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScriptEngineAgent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScriptEngineAgent_spec = {
    "2:PySide2.QtScript.QScriptEngineAgent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScriptEngineAgent_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QScriptEngineAgent_Extension_PythonToCpp_QScriptEngineAgent_Extension(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptEngineAgent::Extension *>(cppOut) =
        static_cast<::QScriptEngineAgent::Extension>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptEngineAgent_Extension_PythonToCpp_QScriptEngineAgent_Extension_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX]))
        return QScriptEngineAgent_Extension_PythonToCpp_QScriptEngineAgent_Extension;
    return {};
}
static PyObject *QScriptEngineAgent_Extension_CppToPython_QScriptEngineAgent_Extension(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptEngineAgent::Extension *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScriptEngineAgent_PythonToCpp_QScriptEngineAgent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScriptEngineAgent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScriptEngineAgent_PythonToCpp_QScriptEngineAgent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptEngineAgent_TypeF())))
        return QScriptEngineAgent_PythonToCpp_QScriptEngineAgent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScriptEngineAgent_PTR_CppToPython_QScriptEngineAgent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScriptEngineAgent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScriptEngineAgent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScriptEngineAgent_SignatureStrings[] = {
    "PySide2.QtScript.QScriptEngineAgent(self,engine:PySide2.QtScript.QScriptEngine)",
    "PySide2.QtScript.QScriptEngineAgent.contextPop(self)",
    "PySide2.QtScript.QScriptEngineAgent.contextPush(self)",
    "PySide2.QtScript.QScriptEngineAgent.engine(self)->PySide2.QtScript.QScriptEngine",
    "PySide2.QtScript.QScriptEngineAgent.exceptionCatch(self,scriptId:qint64,exception:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptEngineAgent.exceptionThrow(self,scriptId:qint64,exception:PySide2.QtScript.QScriptValue,hasHandler:bool)",
    "PySide2.QtScript.QScriptEngineAgent.extension(self,extension:PySide2.QtScript.QScriptEngineAgent.Extension,argument:QVariant=QVariant())->QVariant",
    "PySide2.QtScript.QScriptEngineAgent.functionEntry(self,scriptId:qint64)",
    "PySide2.QtScript.QScriptEngineAgent.functionExit(self,scriptId:qint64,returnValue:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptEngineAgent.positionChange(self,scriptId:qint64,lineNumber:int,columnNumber:int)",
    "PySide2.QtScript.QScriptEngineAgent.scriptLoad(self,id:qint64,program:QString,fileName:QString,baseLineNumber:int)",
    "PySide2.QtScript.QScriptEngineAgent.scriptUnload(self,id:qint64)",
    "PySide2.QtScript.QScriptEngineAgent.supportsExtension(self,extension:PySide2.QtScript.QScriptEngineAgent.Extension)->bool",
    nullptr}; // Sentinel

void init_QScriptEngineAgent(PyObject *module)
{
    _Sbk_QScriptEngineAgent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScriptEngineAgent",
        "QScriptEngineAgent*",
        &Sbk_QScriptEngineAgent_spec,
        &Shiboken::callCppDestructor< ::QScriptEngineAgent >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScriptEngineAgent_Type);
    InitSignatureStrings(pyType, QScriptEngineAgent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScriptEngineAgent_Type), Sbk_QScriptEngineAgent_PropertyStrings);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScriptEngineAgent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScriptEngineAgent_TypeF(),
        QScriptEngineAgent_PythonToCpp_QScriptEngineAgent_PTR,
        is_QScriptEngineAgent_PythonToCpp_QScriptEngineAgent_PTR_Convertible,
        QScriptEngineAgent_PTR_CppToPython_QScriptEngineAgent);

    Shiboken::Conversions::registerConverterName(converter, "QScriptEngineAgent");
    Shiboken::Conversions::registerConverterName(converter, "QScriptEngineAgent*");
    Shiboken::Conversions::registerConverterName(converter, "QScriptEngineAgent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptEngineAgent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptEngineAgentWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'Extension'.
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptEngineAgent_TypeF(),
        "Extension",
        "2:PySide2.QtScript.QScriptEngineAgent.Extension",
        "QScriptEngineAgent::Extension");
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX],
        Sbk_QScriptEngineAgent_TypeF(), "DebuggerInvocationRequest", (long) QScriptEngineAgent::Extension::DebuggerInvocationRequest))
        return;
    // Register converter for enum 'QScriptEngineAgent::Extension'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX],
            QScriptEngineAgent_Extension_CppToPython_QScriptEngineAgent_Extension);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptEngineAgent_Extension_PythonToCpp_QScriptEngineAgent_Extension,
            is_QScriptEngineAgent_Extension_PythonToCpp_QScriptEngineAgent_Extension_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptEngineAgent::Extension");
        Shiboken::Conversions::registerConverterName(converter, "Extension");
    }
    // End of 'Extension' enum.

    qRegisterMetaType< ::QScriptEngineAgent::Extension >("QScriptEngineAgent::Extension");
}
