/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QQUICKWIDGETWRAPPER_H
#define SBK_QQUICKWIDGETWRAPPER_H

#define protected public

#include <QtQuickWidgets/qquickwidget.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qwidget.h>
#include <QtQml/qqmlengine.h>
#include <qurl.h>
#include <QtQml/qqmlcontext.h>
#include <QtQuick/qquickitem.h>
#include <QList>
#include <QtQml/qqmlerror.h>
#include <qsize.h>
#include <QtGui/qsurfaceformat.h>
#include <QtGui/qimage.h>
#include <QtGui/qcolor.h>
#include <QtQuick/qquickwindow.h>
#include <QtQml/qqmlcomponent.h>
#include <QtGui/qevent.h>
#include <qcoreevent.h>
#include <QtGui/qpaintdevice.h>
#include <qpoint.h>
#include <QtGui/qregion.h>
#include <qlocale.h>
#include <qbytearray.h>
#include <QtGui/qpainter.h>
#include <QtWidgets/qlayout.h>
#include <qmetaobject.h>
#include <QtGui/qcursor.h>
#include <QtWidgets/qgraphicseffect.h>
#include <QtGui/qicon.h>
#include <qrect.h>
#include <QtGui/qpalette.h>
#include <QtGui/qfontmetrics.h>
#include <QtWidgets/qaction.h>
#include <QtWidgets/qsizepolicy.h>
#include <QtGui/qpixmap.h>
#include <QtGui/qwindow.h>
#include <QtGui/qbitmap.h>
#include <QtGui/qbackingstore.h>
#include <QtGui/qpaintengine.h>
#include <QtWidgets/qgraphicsproxywidget.h>
#include <QtGui/qfontinfo.h>
#include <QtWidgets/qstyle.h>
#include <qmargins.h>
#include <QtGui/qkeysequence.h>
#include <QtGui/qfont.h>
#include <QtGui/qscreen.h>
#include <qobjectdefs.h>
namespace PySide { class DynamicQMetaObject; }

class QQuickWidgetWrapper : public QQuickWidget
{
public:
    QQuickWidgetWrapper(::QQmlEngine * engine, ::QWidget * parent);
    QQuickWidgetWrapper(::QWidget * parent = nullptr);
    QQuickWidgetWrapper(const ::QUrl & source, ::QWidget * parent = nullptr);
    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * event) override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * event) override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * arg__1) override;
    void dragLeaveEvent(::QDragLeaveEvent * arg__1) override;
    void dragMoveEvent(::QDragMoveEvent * arg__1) override;
    void dropEvent(::QDropEvent * arg__1) override;
    void enterEvent(::QEvent * event) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * event) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * arg__1) override;
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent(::QKeyEvent * arg__1) override;
    void keyReleaseEvent(::QKeyEvent * arg__1) override;
    void leaveEvent(::QEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * arg__1) override;
    void mouseMoveEvent(::QMouseEvent * arg__1) override;
    void mousePressEvent(::QMouseEvent * arg__1) override;
    void mouseReleaseEvent(::QMouseEvent * arg__1) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, long * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * event) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * arg__1) override;
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * arg__1) override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * arg__1) override;
    void wheelEvent(::QWheelEvent * arg__1) override;
    ~QQuickWidgetWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[48];
};

#endif // SBK_QQUICKWIDGETWRAPPER_H

