/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsharedpointer_qquickitemgrabresult_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

static const char * kSmartPointerGetter = "data";
// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QSharedPointerFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSharedPointer<QQuickItemGrabResult > *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSHAREDPOINTER_QQUICKITEMGRABRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSharedPointer.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            QQuickItemGrabResult * cppResult = const_cast<const ::QSharedPointer<QQuickItemGrabResult > *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEMGRABRESULT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSharedPointer___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSharedPointer<QQuickItemGrabResult > *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSHAREDPOINTER_QQUICKITEMGRABRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSHAREDPOINTER_QQUICKITEMGRABRESULT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSharedPointer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSharedPointer_methods[] = {
    {"data", reinterpret_cast<PyCFunction>(Sbk_QSharedPointerFunc_data), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSharedPointer___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QSharedPointer_getattro(PyObject *self, PyObject *name)
{
    PyObject *tmp = PyObject_GenericGetAttr(self, name);
    if (tmp)
        return tmp;
    if (!PyErr_ExceptionMatches(PyExc_AttributeError))
        return nullptr;
    PyErr_Clear();
    // Try to find the 'name' attribute, by retrieving the PyObject for the corresponding C++ object held by the smart pointer.
    if (auto rawObj = PyObject_CallMethod(self, const_cast<char *>(kSmartPointerGetter), 0)) {
        if (auto attribute = PyObject_GetAttr(rawObj, name))
            tmp = attribute;
        Py_DECREF(rawObj);
    }
    if (!tmp) {
        PyTypeObject *tp = Py_TYPE(self);
        PyErr_Format(PyExc_AttributeError,
                     "'%.50s' object has no attribute '%.400s'",
                     tp->tp_name, Shiboken::String::toCString(name));
    }
    return tmp;
}

static int Sbk_QSharedPointer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    // Try to find the 'name' attribute, by retrieving the PyObject for the corresponding C++ object held by the smart pointer.
    PyObject *rawObj = PyObject_CallMethod(self, const_cast<char *>(kSmartPointerGetter), 0);
    if (rawObj) {
        int hasAttribute = PyObject_HasAttr(rawObj, name);
        if (hasAttribute) {
            return PyObject_GenericSetAttr(rawObj, name, value);
        }
        Py_DECREF(rawObj);
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static int Sbk_QSharedPointer___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QSharedPointer<QQuickItemGrabResult > *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSHAREDPOINTER_QQUICKITEMGRABRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QSharedPointer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSharedPointer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSharedPointer_Type = nullptr;
static SbkObjectType *Sbk_QSharedPointer_TypeF(void)
{
    return _Sbk_QSharedPointer_Type;
}

static PyType_Slot Sbk_QSharedPointer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QSharedPointer_getattro)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSharedPointer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSharedPointer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSharedPointer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSharedPointer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QSharedPointer___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QSharedPointer___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QSharedPointer_spec = {
    "2:PySide2.QtQuick.QSharedPointer_QQuickItemGrabResult",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSharedPointer_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSharedPointer_PythonToCpp_QSharedPointer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSharedPointer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSharedPointer_PythonToCpp_QSharedPointer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSharedPointer_TypeF())))
        return QSharedPointer_PythonToCpp_QSharedPointer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSharedPointer_PTR_CppToPython_QSharedPointer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSharedPointer<QQuickItemGrabResult > *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSharedPointer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSharedPointer_COPY_CppToPython_QSharedPointer(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSharedPointer_TypeF(), new ::QSharedPointer<QQuickItemGrabResult >(*reinterpret_cast<const ::QSharedPointer<QQuickItemGrabResult > *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSharedPointer_PythonToCpp_QSharedPointer_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSharedPointer<QQuickItemGrabResult > *>(cppOut) = *reinterpret_cast< ::QSharedPointer<QQuickItemGrabResult > *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSHAREDPOINTER_QQUICKITEMGRABRESULT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSharedPointer_PythonToCpp_QSharedPointer_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSharedPointer_TypeF())))
        return QSharedPointer_PythonToCpp_QSharedPointer_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSharedPointer_QQuickItemGrabResult___SignatureStrings[] = {
    "PySide2.QtQuick.QSharedPointer.data(self)->PySide2.QtQuick.QQuickItemGrabResult",
    "PySide2.QtQuick.QSharedPointer.__copy__()",
    nullptr}; // Sentinel

void init_QSharedPointer_QQuickItemGrabResult__(PyObject *module)
{
    _Sbk_QSharedPointer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSharedPointer<QQuickItemGrabResult >",
        "QSharedPointer<QQuickItemGrabResult >",
        &Sbk_QSharedPointer_spec,
        &Shiboken::callCppDestructor< ::QSharedPointer<QQuickItemGrabResult > >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSharedPointer_Type);
    InitSignatureStrings(pyType, QSharedPointer_QQuickItemGrabResult___SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSharedPointer_Type), Sbk_QSharedPointer_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSHAREDPOINTER_QQUICKITEMGRABRESULT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSharedPointer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSharedPointer_TypeF(),
        QSharedPointer_PythonToCpp_QSharedPointer_PTR,
        is_QSharedPointer_PythonToCpp_QSharedPointer_PTR_Convertible,
        QSharedPointer_PTR_CppToPython_QSharedPointer,
        QSharedPointer_COPY_CppToPython_QSharedPointer);

    Shiboken::Conversions::registerConverterName(converter, "QSharedPointer<QQuickItemGrabResult >");
    Shiboken::Conversions::registerConverterName(converter, "QSharedPointer<QQuickItemGrabResult >*");
    Shiboken::Conversions::registerConverterName(converter, "QSharedPointer<QQuickItemGrabResult >&");
    Shiboken::Conversions::registerConverterName(converter, "QQuickItemGrabResult");
    Shiboken::Conversions::registerConverterName(converter, "QQuickItemGrabResult*");
    Shiboken::Conversions::registerConverterName(converter, "QQuickItemGrabResult&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSharedPointer<QQuickItemGrabResult >).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSharedPointer_PythonToCpp_QSharedPointer_COPY,
        is_QSharedPointer_PythonToCpp_QSharedPointer_COPY_Convertible);

    qRegisterMetaType< ::QSharedPointer<QQuickItemGrabResult > >("QSharedPointer<QQuickItemGrabResult >");
}
