/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsgnode_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGNodeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGNodeWrapper::QSGNodeWrapper() : QSGNode()
{
    resetPyMethodCache();
    // ... middle
}

QSGNodeWrapper::QSGNodeWrapper(::QSGNode::NodeType type) : QSGNode(type)
{
    resetPyMethodCache();
    // ... middle
}

bool QSGNodeWrapper::isSubtreeBlocked() const
{
    if (m_PyMethodCache[0])
        return this->::QSGNode::isSubtreeBlocked();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSubtreeBlocked";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QSGNode::isSubtreeBlocked();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGNode.isSubtreeBlocked", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSGNodeWrapper::preprocess()
{
    if (m_PyMethodCache[1]) {
        return this->::QSGNode::preprocess();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "preprocess";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSGNode::preprocess();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QSGNodeWrapper::~QSGNodeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGNode_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGNode >()))
        return -1;

    ::QSGNodeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSGNode", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSGNode::QSGNode()
    // 1: QSGNode::QSGNode(QSGNode::NodeType)
    if (numArgs == 0) {
        overloadId = 0; // QSGNode()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QSGNode(QSGNode::NodeType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNode_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSGNode()
        {

            if (!PyErr_Occurred()) {
                // QSGNode()
                cptr = new ::QSGNodeWrapper();
            }
            break;
        }
        case 1: // QSGNode(QSGNode::NodeType type)
        {
            ::QSGNode::NodeType cppArg0{QSGNode::BasicNodeType};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSGNode(QSGNode::NodeType)
                cptr = new ::QSGNodeWrapper(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGNode >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSGNode_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSGNode_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGNodeFunc_appendChildNode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.appendChildNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGNode::appendChildNode(QSGNode*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArg)))) {
        overloadId = 0; // appendChildNode(QSGNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_appendChildNode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // appendChildNode(QSGNode*)
            cppSelf->appendChildNode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_appendChildNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_childAtIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.childAtIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGNode::childAtIndex(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // childAtIndex(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_childAtIndex_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // childAtIndex(int)const
            QSGNode * cppResult = const_cast<const ::QSGNode *>(cppSelf)->childAtIndex(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSGNodeFunc_childAtIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_childCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.childCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childCount()const
            int cppResult = const_cast<const ::QSGNode *>(cppSelf)->childCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_clearDirty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.clearDirty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearDirty()
            cppSelf->clearDirty();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSGNodeFunc_dirtyState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.dirtyState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dirtyState()const
            QFlags<QSGNode::DirtyStateBit> cppResult = const_cast<const ::QSGNode *>(cppSelf)->dirtyState();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_firstChild(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.firstChild";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstChild()const
            QSGNode * cppResult = const_cast<const ::QSGNode *>(cppSelf)->firstChild();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<QSGNode::Flag> cppResult = const_cast<const ::QSGNode *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_insertChildNodeAfter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.insertChildNodeAfter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertChildNodeAfter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGNode::insertChildNodeAfter(QSGNode*,QSGNode*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertChildNodeAfter(QSGNode*,QSGNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_insertChildNodeAfter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSGNode *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertChildNodeAfter(QSGNode*,QSGNode*)
            cppSelf->insertChildNodeAfter(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_insertChildNodeAfter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_insertChildNodeBefore(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.insertChildNodeBefore";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertChildNodeBefore", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGNode::insertChildNodeBefore(QSGNode*,QSGNode*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertChildNodeBefore(QSGNode*,QSGNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_insertChildNodeBefore_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSGNode *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertChildNodeBefore(QSGNode*,QSGNode*)
            cppSelf->insertChildNodeBefore(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_insertChildNodeBefore_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_isSubtreeBlocked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.isSubtreeBlocked";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSubtreeBlocked()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSGNode *>(cppSelf)->::QSGNode::isSubtreeBlocked()
                : const_cast<const ::QSGNode *>(cppSelf)->isSubtreeBlocked();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_lastChild(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.lastChild";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastChild()const
            QSGNode * cppResult = const_cast<const ::QSGNode *>(cppSelf)->lastChild();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_markDirty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.markDirty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGNode::markDirty(QFlags<QSGNode::DirtyStateBit>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // markDirty(QFlags<QSGNode::DirtyStateBit>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_markDirty_TypeError;

    // Call function/method
    {
        ::QFlags<QSGNode::DirtyStateBit> cppArg0 = QFlags<QSGNode::DirtyStateBit>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // markDirty(QFlags<QSGNode::DirtyStateBit>)
            cppSelf->markDirty(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_markDirty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_nextSibling(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.nextSibling";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextSibling()const
            QSGNode * cppResult = const_cast<const ::QSGNode *>(cppSelf)->nextSibling();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_parent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.parent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parent()const
            QSGNode * cppResult = const_cast<const ::QSGNode *>(cppSelf)->parent();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_prependChildNode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.prependChildNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGNode::prependChildNode(QSGNode*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArg)))) {
        overloadId = 0; // prependChildNode(QSGNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_prependChildNode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // prependChildNode(QSGNode*)
            cppSelf->prependChildNode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_prependChildNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_preprocess(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.preprocess";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preprocess()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSGNode::preprocess()
                : cppSelf->preprocess();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSGNodeFunc_previousSibling(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.previousSibling";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // previousSibling()const
            QSGNode * cppResult = const_cast<const ::QSGNode *>(cppSelf)->previousSibling();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGNodeFunc_removeAllChildNodes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.removeAllChildNodes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeAllChildNodes()
            cppSelf->removeAllChildNodes();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSGNodeFunc_removeChildNode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.removeChildNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGNode::removeChildNode(QSGNode*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArg)))) {
        overloadId = 0; // removeChildNode(QSGNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_removeChildNode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeChildNode(QSGNode*)
            cppSelf->removeChildNode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_removeChildNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_reparentChildNodesTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.reparentChildNodesTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGNode::reparentChildNodesTo(QSGNode*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArg)))) {
        overloadId = 0; // reparentChildNodesTo(QSGNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_reparentChildNodesTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reparentChildNodesTo(QSGNode*)
            cppSelf->reparentChildNodesTo(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_reparentChildNodesTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_setFlag(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.setFlag";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGNodeFunc_setFlag_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSGNodeFunc_setFlag_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setFlag", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGNode::setFlag(QSGNode::Flag,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFlag(QSGNode::Flag,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setFlag(QSGNode::Flag,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_setFlag_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__2 = Shiboken::String::createStaticString("arg__2");
            if (PyDict_Contains(kwds, key_arg__2)) {
                value = PyDict_GetItem(kwds, key_arg__2);
                if (value && pyArgs[1]) {
                    errInfo = key_arg__2;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGNodeFunc_setFlag_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QSGNodeFunc_setFlag_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__2);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGNodeFunc_setFlag_TypeError;
            }
        }
        ::QSGNode::Flag cppArg0 = static_cast< ::QSGNode::Flag>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFlag(QSGNode::Flag,bool)
            cppSelf->setFlag(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_setFlag_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_setFlags(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.setFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGNodeFunc_setFlags_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSGNodeFunc_setFlags_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setFlags", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGNode::setFlags(QFlags<QSGNode::Flag>,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFlags(QFlags<QSGNode::Flag>,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setFlags(QFlags<QSGNode::Flag>,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGNodeFunc_setFlags_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__2 = Shiboken::String::createStaticString("arg__2");
            if (PyDict_Contains(kwds, key_arg__2)) {
                value = PyDict_GetItem(kwds, key_arg__2);
                if (value && pyArgs[1]) {
                    errInfo = key_arg__2;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGNodeFunc_setFlags_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QSGNodeFunc_setFlags_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__2);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGNodeFunc_setFlags_TypeError;
            }
        }
        ::QFlags<QSGNode::Flag> cppArg0 = QFlags<QSGNode::Flag>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFlags(QFlags<QSGNode::Flag>,bool)
            cppSelf->setFlags(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGNodeFunc_setFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGNodeFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGNode.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QSGNode::NodeType cppResult = const_cast<const ::QSGNode *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGNode_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGNode_methods[] = {
    {"appendChildNode", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_appendChildNode), METH_O},
    {"childAtIndex", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_childAtIndex), METH_O},
    {"childCount", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_childCount), METH_NOARGS},
    {"clearDirty", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_clearDirty), METH_NOARGS},
    {"dirtyState", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_dirtyState), METH_NOARGS},
    {"firstChild", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_firstChild), METH_NOARGS},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_flags), METH_NOARGS},
    {"insertChildNodeAfter", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_insertChildNodeAfter), METH_VARARGS},
    {"insertChildNodeBefore", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_insertChildNodeBefore), METH_VARARGS},
    {"isSubtreeBlocked", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_isSubtreeBlocked), METH_NOARGS},
    {"lastChild", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_lastChild), METH_NOARGS},
    {"markDirty", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_markDirty), METH_O},
    {"nextSibling", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_nextSibling), METH_NOARGS},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_parent), METH_NOARGS},
    {"prependChildNode", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_prependChildNode), METH_O},
    {"preprocess", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_preprocess), METH_NOARGS},
    {"previousSibling", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_previousSibling), METH_NOARGS},
    {"removeAllChildNodes", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_removeAllChildNodes), METH_NOARGS},
    {"removeChildNode", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_removeChildNode), METH_O},
    {"reparentChildNodesTo", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_reparentChildNodesTo), METH_O},
    {"setFlag", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_setFlag), METH_VARARGS|METH_KEYWORDS},
    {"setFlags", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_setFlags), METH_VARARGS|METH_KEYWORDS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QSGNodeFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGNode_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGNodeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGNode_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGNode_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSGNode__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGNode_Type = nullptr;
static SbkObjectType *Sbk_QSGNode_TypeF(void)
{
    return _Sbk_QSGNode_Type;
}

static PyType_Slot Sbk_QSGNode_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSGNode__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGNode_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGNode_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGNode_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGNode_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGNode_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGNode_spec = {
    "2:PySide2.QtQuick.QSGNode",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGNode_slots
};

} //extern "C"

PyObject *SbkPySide2_QtQuick_QSGNode_Flag___and__(PyObject *self, PyObject *pyArg)
{
    ::QSGNode::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGNode::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGNode::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGNode::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGNode::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGNode_Flag___or__(PyObject *self, PyObject *pyArg)
{
    ::QSGNode::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGNode::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGNode::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGNode::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGNode::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGNode_Flag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSGNode::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGNode::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGNode::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGNode::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGNode::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGNode_Flag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSGNode::Flags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, self, &cppSelf);
    ::QSGNode::Flags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QSGNode_Flag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QSGNode_Flag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QSGNode_Flag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_Flag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtQuick_QSGNode_DirtyStateBit___and__(PyObject *self, PyObject *pyArg)
{
    ::QSGNode::DirtyState cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGNode::DirtyState>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGNode::DirtyState>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGNode::DirtyState>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGNode::DirtyState>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGNode_DirtyStateBit___or__(PyObject *self, PyObject *pyArg)
{
    ::QSGNode::DirtyState cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGNode::DirtyState>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGNode::DirtyState>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGNode::DirtyState>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGNode::DirtyState>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGNode_DirtyStateBit___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSGNode::DirtyState cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGNode::DirtyState>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGNode::DirtyState>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGNode::DirtyState>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGNode::DirtyState>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGNode_DirtyStateBit___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSGNode::DirtyState cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, self, &cppSelf);
    ::QSGNode::DirtyState cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QSGNode_DirtyStateBit_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QSGNode_DirtyStateBit__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QSGNode_DirtyStateBit_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGNode_DirtyStateBit_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSGNode_NodeType_PythonToCpp_QSGNode_NodeType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGNode::NodeType *>(cppOut) =
        static_cast<::QSGNode::NodeType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGNode_NodeType_PythonToCpp_QSGNode_NodeType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX]))
        return QSGNode_NodeType_PythonToCpp_QSGNode_NodeType;
    return {};
}
static PyObject *QSGNode_NodeType_CppToPython_QSGNode_NodeType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGNode::NodeType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX], castCppIn);

}

static void QSGNode_Flag_PythonToCpp_QSGNode_Flag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGNode::Flag *>(cppOut) =
        static_cast<::QSGNode::Flag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGNode_Flag_PythonToCpp_QSGNode_Flag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX]))
        return QSGNode_Flag_PythonToCpp_QSGNode_Flag;
    return {};
}
static PyObject *QSGNode_Flag_CppToPython_QSGNode_Flag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGNode::Flag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX], castCppIn);

}

static void QFlags_QSGNode_Flag__PythonToCpp_QFlags_QSGNode_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGNode::Flag> *>(cppOut) =
        ::QFlags<QSGNode::Flag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSGNode_Flag__PythonToCpp_QFlags_QSGNode_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX]))
        return QFlags_QSGNode_Flag__PythonToCpp_QFlags_QSGNode_Flag_;
    return {};
}
static PyObject *QFlags_QSGNode_Flag__CppToPython_QFlags_QSGNode_Flag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSGNode::Flag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX]));

}

static void QSGNode_Flag_PythonToCpp_QFlags_QSGNode_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGNode::Flag> *>(cppOut) =
        ::QFlags<QSGNode::Flag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSGNode_Flag_PythonToCpp_QFlags_QSGNode_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX]))
        return QSGNode_Flag_PythonToCpp_QFlags_QSGNode_Flag_;
    return {};
}
static void number_PythonToCpp_QFlags_QSGNode_Flag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSGNode::Flag> *>(cppOut) =
        ::QFlags<QSGNode::Flag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSGNode_Flag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX]))
        return number_PythonToCpp_QFlags_QSGNode_Flag_;
    return {};
}
static void QSGNode_DirtyStateBit_PythonToCpp_QSGNode_DirtyStateBit(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGNode::DirtyStateBit *>(cppOut) =
        static_cast<::QSGNode::DirtyStateBit>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGNode_DirtyStateBit_PythonToCpp_QSGNode_DirtyStateBit_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX]))
        return QSGNode_DirtyStateBit_PythonToCpp_QSGNode_DirtyStateBit;
    return {};
}
static PyObject *QSGNode_DirtyStateBit_CppToPython_QSGNode_DirtyStateBit(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGNode::DirtyStateBit *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX], castCppIn);

}

static void QFlags_QSGNode_DirtyStateBit__PythonToCpp_QFlags_QSGNode_DirtyStateBit_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGNode::DirtyStateBit> *>(cppOut) =
        ::QFlags<QSGNode::DirtyStateBit>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSGNode_DirtyStateBit__PythonToCpp_QFlags_QSGNode_DirtyStateBit__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX]))
        return QFlags_QSGNode_DirtyStateBit__PythonToCpp_QFlags_QSGNode_DirtyStateBit_;
    return {};
}
static PyObject *QFlags_QSGNode_DirtyStateBit__CppToPython_QFlags_QSGNode_DirtyStateBit_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSGNode::DirtyStateBit> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX]));

}

static void QSGNode_DirtyStateBit_PythonToCpp_QFlags_QSGNode_DirtyStateBit_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGNode::DirtyStateBit> *>(cppOut) =
        ::QFlags<QSGNode::DirtyStateBit>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSGNode_DirtyStateBit_PythonToCpp_QFlags_QSGNode_DirtyStateBit__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX]))
        return QSGNode_DirtyStateBit_PythonToCpp_QFlags_QSGNode_DirtyStateBit_;
    return {};
}
static void number_PythonToCpp_QFlags_QSGNode_DirtyStateBit_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSGNode::DirtyStateBit> *>(cppOut) =
        ::QFlags<QSGNode::DirtyStateBit>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSGNode_DirtyStateBit__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX]))
        return number_PythonToCpp_QFlags_QSGNode_DirtyStateBit_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGNode_PythonToCpp_QSGNode_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGNode_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGNode_PythonToCpp_QSGNode_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGNode_TypeF())))
        return QSGNode_PythonToCpp_QSGNode_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGNode_PTR_CppToPython_QSGNode(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGNode *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGNode_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGNode_SignatureStrings[] = {
    "1:PySide2.QtQuick.QSGNode(self)",
    "0:PySide2.QtQuick.QSGNode(self,type:PySide2.QtQuick.QSGNode.NodeType)",
    "PySide2.QtQuick.QSGNode.appendChildNode(self,node:PySide2.QtQuick.QSGNode)",
    "PySide2.QtQuick.QSGNode.childAtIndex(self,i:int)->PySide2.QtQuick.QSGNode",
    "PySide2.QtQuick.QSGNode.childCount(self)->int",
    "PySide2.QtQuick.QSGNode.clearDirty(self)",
    "PySide2.QtQuick.QSGNode.dirtyState(self)->PySide2.QtQuick.QSGNode.DirtyState",
    "PySide2.QtQuick.QSGNode.firstChild(self)->PySide2.QtQuick.QSGNode",
    "PySide2.QtQuick.QSGNode.flags(self)->PySide2.QtQuick.QSGNode.Flags",
    "PySide2.QtQuick.QSGNode.insertChildNodeAfter(self,node:PySide2.QtQuick.QSGNode,after:PySide2.QtQuick.QSGNode)",
    "PySide2.QtQuick.QSGNode.insertChildNodeBefore(self,node:PySide2.QtQuick.QSGNode,before:PySide2.QtQuick.QSGNode)",
    "PySide2.QtQuick.QSGNode.isSubtreeBlocked(self)->bool",
    "PySide2.QtQuick.QSGNode.lastChild(self)->PySide2.QtQuick.QSGNode",
    "PySide2.QtQuick.QSGNode.markDirty(self,bits:PySide2.QtQuick.QSGNode.DirtyState)",
    "PySide2.QtQuick.QSGNode.nextSibling(self)->PySide2.QtQuick.QSGNode",
    "PySide2.QtQuick.QSGNode.parent(self)->PySide2.QtQuick.QSGNode",
    "PySide2.QtQuick.QSGNode.prependChildNode(self,node:PySide2.QtQuick.QSGNode)",
    "PySide2.QtQuick.QSGNode.preprocess(self)",
    "PySide2.QtQuick.QSGNode.previousSibling(self)->PySide2.QtQuick.QSGNode",
    "PySide2.QtQuick.QSGNode.removeAllChildNodes(self)",
    "PySide2.QtQuick.QSGNode.removeChildNode(self,node:PySide2.QtQuick.QSGNode)",
    "PySide2.QtQuick.QSGNode.reparentChildNodesTo(self,newParent:PySide2.QtQuick.QSGNode)",
    "PySide2.QtQuick.QSGNode.setFlag(self,arg__1:PySide2.QtQuick.QSGNode.Flag,arg__2:bool=true)",
    "PySide2.QtQuick.QSGNode.setFlags(self,arg__1:PySide2.QtQuick.QSGNode.Flags,arg__2:bool=true)",
    "PySide2.QtQuick.QSGNode.type(self)->PySide2.QtQuick.QSGNode.NodeType",
    nullptr}; // Sentinel

void init_QSGNode(PyObject *module)
{
    _Sbk_QSGNode_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGNode",
        "QSGNode*",
        &Sbk_QSGNode_spec,
        &Shiboken::callCppDestructor< ::QSGNode >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGNode_Type);
    InitSignatureStrings(pyType, QSGNode_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGNode_Type), Sbk_QSGNode_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGNode_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGNode_TypeF(),
        QSGNode_PythonToCpp_QSGNode_PTR,
        is_QSGNode_PythonToCpp_QSGNode_PTR_Convertible,
        QSGNode_PTR_CppToPython_QSGNode);

    Shiboken::Conversions::registerConverterName(converter, "QSGNode");
    Shiboken::Conversions::registerConverterName(converter, "QSGNode*");
    Shiboken::Conversions::registerConverterName(converter, "QSGNode&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGNode).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGNodeWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'NodeType'.
    SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGNode_TypeF(),
        "NodeType",
        "2:PySide2.QtQuick.QSGNode.NodeType",
        "QSGNode::NodeType");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX],
        Sbk_QSGNode_TypeF(), "BasicNodeType", (long) QSGNode::NodeType::BasicNodeType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX],
        Sbk_QSGNode_TypeF(), "GeometryNodeType", (long) QSGNode::NodeType::GeometryNodeType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX],
        Sbk_QSGNode_TypeF(), "TransformNodeType", (long) QSGNode::NodeType::TransformNodeType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX],
        Sbk_QSGNode_TypeF(), "ClipNodeType", (long) QSGNode::NodeType::ClipNodeType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX],
        Sbk_QSGNode_TypeF(), "OpacityNodeType", (long) QSGNode::NodeType::OpacityNodeType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX],
        Sbk_QSGNode_TypeF(), "RootNodeType", (long) QSGNode::NodeType::RootNodeType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX],
        Sbk_QSGNode_TypeF(), "RenderNodeType", (long) QSGNode::NodeType::RenderNodeType))
        return;
    // Register converter for enum 'QSGNode::NodeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX],
            QSGNode_NodeType_CppToPython_QSGNode_NodeType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGNode_NodeType_PythonToCpp_QSGNode_NodeType,
            is_QSGNode_NodeType_PythonToCpp_QSGNode_NodeType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGNode::NodeType");
        Shiboken::Conversions::registerConverterName(converter, "NodeType");
    }
    // End of 'NodeType' enum.

    // Initialization of enum 'Flag'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QSGNode.Flags", SbkPySide2_QtQuick_QSGNode_Flag_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGNode_TypeF(),
        "Flag",
        "2:PySide2.QtQuick.QSGNode.Flag",
        "QSGNode::Flag",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX],
        Sbk_QSGNode_TypeF(), "OwnedByParent", (long) QSGNode::Flag::OwnedByParent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX],
        Sbk_QSGNode_TypeF(), "UsePreprocess", (long) QSGNode::Flag::UsePreprocess))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX],
        Sbk_QSGNode_TypeF(), "OwnsGeometry", (long) QSGNode::Flag::OwnsGeometry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX],
        Sbk_QSGNode_TypeF(), "OwnsMaterial", (long) QSGNode::Flag::OwnsMaterial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX],
        Sbk_QSGNode_TypeF(), "OwnsOpaqueMaterial", (long) QSGNode::Flag::OwnsOpaqueMaterial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX],
        Sbk_QSGNode_TypeF(), "IsVisitableNode", (long) QSGNode::Flag::IsVisitableNode))
        return;
    // Register converter for enum 'QSGNode::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX],
            QSGNode_Flag_CppToPython_QSGNode_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGNode_Flag_PythonToCpp_QSGNode_Flag,
            is_QSGNode_Flag_PythonToCpp_QSGNode_Flag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGNODE_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGNode::Flag");
        Shiboken::Conversions::registerConverterName(converter, "Flag");
    }
    // Register converter for flag 'QFlags<QSGNode::Flag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX],
            QFlags_QSGNode_Flag__CppToPython_QFlags_QSGNode_Flag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGNode_Flag_PythonToCpp_QFlags_QSGNode_Flag_,
            is_QSGNode_Flag_PythonToCpp_QFlags_QSGNode_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSGNode_Flag__PythonToCpp_QFlags_QSGNode_Flag_,
            is_QFlags_QSGNode_Flag__PythonToCpp_QFlags_QSGNode_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSGNode_Flag_,
            is_number_PythonToCpp_QFlags_QSGNode_Flag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGNode::Flags");
        Shiboken::Conversions::registerConverterName(converter, "Flags");
    }
    // End of 'Flag' enum/flags.

    // Initialization of enum 'DirtyStateBit'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QSGNode.DirtyState", SbkPySide2_QtQuick_QSGNode_DirtyStateBit_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGNode_TypeF(),
        "DirtyStateBit",
        "2:PySide2.QtQuick.QSGNode.DirtyStateBit",
        "QSGNode::DirtyStateBit",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtySubtreeBlocked", (long) QSGNode::DirtyStateBit::DirtySubtreeBlocked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyMatrix", (long) QSGNode::DirtyStateBit::DirtyMatrix))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyNodeAdded", (long) QSGNode::DirtyStateBit::DirtyNodeAdded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyNodeRemoved", (long) QSGNode::DirtyStateBit::DirtyNodeRemoved))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyGeometry", (long) QSGNode::DirtyStateBit::DirtyGeometry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyMaterial", (long) QSGNode::DirtyStateBit::DirtyMaterial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyOpacity", (long) QSGNode::DirtyStateBit::DirtyOpacity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyForceUpdate", (long) QSGNode::DirtyStateBit::DirtyForceUpdate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyUsePreprocess", (long) QSGNode::DirtyStateBit::DirtyUsePreprocess))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
        Sbk_QSGNode_TypeF(), "DirtyPropagationMask", (long) QSGNode::DirtyStateBit::DirtyPropagationMask))
        return;
    // Register converter for enum 'QSGNode::DirtyStateBit'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX],
            QSGNode_DirtyStateBit_CppToPython_QSGNode_DirtyStateBit);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGNode_DirtyStateBit_PythonToCpp_QSGNode_DirtyStateBit,
            is_QSGNode_DirtyStateBit_PythonToCpp_QSGNode_DirtyStateBit_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGNODE_DIRTYSTATEBIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGNode::DirtyStateBit");
        Shiboken::Conversions::registerConverterName(converter, "DirtyStateBit");
    }
    // Register converter for flag 'QFlags<QSGNode::DirtyStateBit>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX],
            QFlags_QSGNode_DirtyStateBit__CppToPython_QFlags_QSGNode_DirtyStateBit_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGNode_DirtyStateBit_PythonToCpp_QFlags_QSGNode_DirtyStateBit_,
            is_QSGNode_DirtyStateBit_PythonToCpp_QFlags_QSGNode_DirtyStateBit__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSGNode_DirtyStateBit__PythonToCpp_QFlags_QSGNode_DirtyStateBit_,
            is_QFlags_QSGNode_DirtyStateBit__PythonToCpp_QFlags_QSGNode_DirtyStateBit__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSGNode_DirtyStateBit_,
            is_number_PythonToCpp_QFlags_QSGNode_DirtyStateBit__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGNode::DirtyState");
        Shiboken::Conversions::registerConverterName(converter, "DirtyState");
    }
    // End of 'DirtyStateBit' enum/flags.

    qRegisterMetaType< ::QSGNode::NodeType >("QSGNode::NodeType");
    qRegisterMetaType< ::QSGNode::Flag >("QSGNode::Flag");
    qRegisterMetaType< ::QSGNode::Flags >("QSGNode::Flags");
    qRegisterMetaType< ::QSGNode::DirtyStateBit >("QSGNode::DirtyStateBit");
    qRegisterMetaType< ::QSGNode::DirtyState >("QSGNode::DirtyState");
}
