/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsgbasicgeometrynode_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGBasicGeometryNodeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGBasicGeometryNodeWrapper::QSGBasicGeometryNodeWrapper(::QSGNode::NodeType type) : QSGBasicGeometryNode(type)
{
    resetPyMethodCache();
    // ... middle
}

bool QSGBasicGeometryNodeWrapper::isSubtreeBlocked() const
{
    if (m_PyMethodCache[0])
        return this->::QSGNode::isSubtreeBlocked();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSubtreeBlocked";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QSGNode::isSubtreeBlocked();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGBasicGeometryNode.isSubtreeBlocked", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSGBasicGeometryNodeWrapper::preprocess()
{
    if (m_PyMethodCache[1]) {
        return this->::QSGNode::preprocess();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "preprocess";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSGNode::preprocess();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QSGBasicGeometryNodeWrapper::~QSGBasicGeometryNodeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGBasicGeometryNode_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGBasicGeometryNode >()))
        return -1;

    ::QSGBasicGeometryNodeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGBasicGeometryNode.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSGBasicGeometryNode", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSGBasicGeometryNode::QSGBasicGeometryNode(QSGNode::NodeType)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGNODE_NODETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QSGBasicGeometryNode(QSGNode::NodeType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGBasicGeometryNode_Init_TypeError;

    // Call function/method
    {
        ::QSGNode::NodeType cppArg0{QSGNode::BasicNodeType};
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QSGBasicGeometryNode(QSGNode::NodeType)
            cptr = new ::QSGBasicGeometryNodeWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGBasicGeometryNode >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSGBasicGeometryNode_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSGBasicGeometryNode_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGBasicGeometryNodeFunc_clipList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGBasicGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGBasicGeometryNode.clipList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipList()const
            const QSGClipNode * cppResult = const_cast<const ::QSGBasicGeometryNode *>(cppSelf)->clipList();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGCLIPNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGBasicGeometryNodeFunc_geometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGBasicGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGBasicGeometryNode.geometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometry()
            QSGGeometry * cppResult = cppSelf->geometry();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGBasicGeometryNodeFunc_matrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGBasicGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGBasicGeometryNode.matrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matrix()const
            const QMatrix4x4 * cppResult = const_cast<const ::QSGBasicGeometryNode *>(cppSelf)->matrix();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGBasicGeometryNodeFunc_setGeometry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGBasicGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGBasicGeometryNode.setGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGBasicGeometryNode::setGeometry(QSGGeometry*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX]), (pyArg)))) {
        overloadId = 0; // setGeometry(QSGGeometry*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGBasicGeometryNodeFunc_setGeometry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSGGeometry *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGeometry(QSGGeometry*)
            cppSelf->setGeometry(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGBasicGeometryNodeFunc_setGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGBasicGeometryNodeFunc_setRendererClipList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGBasicGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGBasicGeometryNode.setRendererClipList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGBasicGeometryNode::setRendererClipList(const QSGClipNode*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGCLIPNODE_IDX]), (pyArg)))) {
        overloadId = 0; // setRendererClipList(const QSGClipNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGBasicGeometryNodeFunc_setRendererClipList_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSGClipNode *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRendererClipList(const QSGClipNode*)
            cppSelf->setRendererClipList(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGBasicGeometryNodeFunc_setRendererClipList_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGBasicGeometryNodeFunc_setRendererMatrix(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGBasicGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGBasicGeometryNode.setRendererMatrix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGBasicGeometryNode::setRendererMatrix(const QMatrix4x4*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // setRendererMatrix(const QMatrix4x4*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGBasicGeometryNodeFunc_setRendererMatrix_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMatrix4x4 *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRendererMatrix(const QMatrix4x4*)
            cppSelf->setRendererMatrix(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGBasicGeometryNodeFunc_setRendererMatrix_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSGBasicGeometryNode_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGBasicGeometryNode_methods[] = {
    {"clipList", reinterpret_cast<PyCFunction>(Sbk_QSGBasicGeometryNodeFunc_clipList), METH_NOARGS},
    {"geometry", reinterpret_cast<PyCFunction>(Sbk_QSGBasicGeometryNodeFunc_geometry), METH_NOARGS},
    {"matrix", reinterpret_cast<PyCFunction>(Sbk_QSGBasicGeometryNodeFunc_matrix), METH_NOARGS},
    {"setGeometry", reinterpret_cast<PyCFunction>(Sbk_QSGBasicGeometryNodeFunc_setGeometry), METH_O},
    {"setRendererClipList", reinterpret_cast<PyCFunction>(Sbk_QSGBasicGeometryNodeFunc_setRendererClipList), METH_O},
    {"setRendererMatrix", reinterpret_cast<PyCFunction>(Sbk_QSGBasicGeometryNodeFunc_setRendererMatrix), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGBasicGeometryNode_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGBasicGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGBasicGeometryNodeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGBasicGeometryNode_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGBasicGeometryNode_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGBasicGeometryNode_Type = nullptr;
static SbkObjectType *Sbk_QSGBasicGeometryNode_TypeF(void)
{
    return _Sbk_QSGBasicGeometryNode_Type;
}

static PyType_Slot Sbk_QSGBasicGeometryNode_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGBasicGeometryNode_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGBasicGeometryNode_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGBasicGeometryNode_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGBasicGeometryNode_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGBasicGeometryNode_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGBasicGeometryNode_spec = {
    "2:PySide2.QtQuick.QSGBasicGeometryNode",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGBasicGeometryNode_slots
};

} //extern "C"

static void *Sbk_QSGBasicGeometryNode_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSGNode >()))
        return dynamic_cast< ::QSGBasicGeometryNode *>(reinterpret_cast< ::QSGNode *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGBasicGeometryNode_PythonToCpp_QSGBasicGeometryNode_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGBasicGeometryNode_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGBasicGeometryNode_PythonToCpp_QSGBasicGeometryNode_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGBasicGeometryNode_TypeF())))
        return QSGBasicGeometryNode_PythonToCpp_QSGBasicGeometryNode_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGBasicGeometryNode_PTR_CppToPython_QSGBasicGeometryNode(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGBasicGeometryNode *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGBasicGeometryNode_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGBasicGeometryNode_SignatureStrings[] = {
    "PySide2.QtQuick.QSGBasicGeometryNode(self,type:PySide2.QtQuick.QSGNode.NodeType)",
    "PySide2.QtQuick.QSGBasicGeometryNode.clipList(self)->PySide2.QtQuick.QSGClipNode",
    "1:PySide2.QtQuick.QSGBasicGeometryNode.geometry(self)->PySide2.QtQuick.QSGGeometry",
    "0:PySide2.QtQuick.QSGBasicGeometryNode.geometry(self)->PySide2.QtQuick.QSGGeometry",
    "PySide2.QtQuick.QSGBasicGeometryNode.matrix(self)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtQuick.QSGBasicGeometryNode.setGeometry(self,geometry:PySide2.QtQuick.QSGGeometry)",
    "PySide2.QtQuick.QSGBasicGeometryNode.setRendererClipList(self,c:PySide2.QtQuick.QSGClipNode)",
    "PySide2.QtQuick.QSGBasicGeometryNode.setRendererMatrix(self,m:PySide2.QtGui.QMatrix4x4)",
    nullptr}; // Sentinel

void init_QSGBasicGeometryNode(PyObject *module)
{
    _Sbk_QSGBasicGeometryNode_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGBasicGeometryNode",
        "QSGBasicGeometryNode*",
        &Sbk_QSGBasicGeometryNode_spec,
        &Shiboken::callCppDestructor< ::QSGBasicGeometryNode >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGBasicGeometryNode_Type);
    InitSignatureStrings(pyType, QSGBasicGeometryNode_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGBasicGeometryNode_Type), Sbk_QSGBasicGeometryNode_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGBasicGeometryNode_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGBasicGeometryNode_TypeF(),
        QSGBasicGeometryNode_PythonToCpp_QSGBasicGeometryNode_PTR,
        is_QSGBasicGeometryNode_PythonToCpp_QSGBasicGeometryNode_PTR_Convertible,
        QSGBasicGeometryNode_PTR_CppToPython_QSGBasicGeometryNode);

    Shiboken::Conversions::registerConverterName(converter, "QSGBasicGeometryNode");
    Shiboken::Conversions::registerConverterName(converter, "QSGBasicGeometryNode*");
    Shiboken::Conversions::registerConverterName(converter, "QSGBasicGeometryNode&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGBasicGeometryNode).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGBasicGeometryNodeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSGBasicGeometryNode_TypeF(), &Sbk_QSGBasicGeometryNode_typeDiscovery);

}
