/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qquickasyncimageprovider_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQuickAsyncImageProviderWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQuickAsyncImageProviderWrapper::QQuickAsyncImageProviderWrapper() : QQuickAsyncImageProvider()
{
    resetPyMethodCache();
    // ... middle
}

::QFlags<QQmlImageProviderBase::Flag> QQuickAsyncImageProviderWrapper::flags() const
{
    if (m_PyMethodCache[0])
        return this->::QQuickImageProvider::flags();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QQmlImageProviderBase::Flag>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "flags";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QQuickImageProvider::flags();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QQmlImageProviderBase::Flag>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickAsyncImageProvider.flags", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QQmlImageProviderBase::Flag> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QQmlImageProviderBase::Flag>(0);
    }
    ::QFlags<QQmlImageProviderBase::Flag> cppResult = QFlags<QQmlImageProviderBase::Flag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QQmlImageProviderBase::ImageType QQuickAsyncImageProviderWrapper::imageType() const
{
    if (m_PyMethodCache[1])
        return this->::QQuickImageProvider::imageType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QQmlImageProviderBase::Image;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "imageType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QQuickImageProvider::imageType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QQmlImageProviderBase::Image;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickAsyncImageProvider.imageType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QQmlImageProviderBase::ImageType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QQmlImageProviderBase::Image;
    }
    ::QQmlImageProviderBase::ImageType cppResult{QQmlImageProviderBase::Image};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QImage QQuickAsyncImageProviderWrapper::requestImage(const ::QString & id, ::QSize * size, const ::QSize & requestedSize)
{
    if (m_PyMethodCache[2])
        return this->::QQuickImageProvider::requestImage(id, size, requestedSize);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "requestImage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QQuickImageProvider::requestImage(id, size, requestedSize);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &id),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), size),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &requestedSize)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickAsyncImageProvider.requestImage", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QImage >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QImage cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QQuickImageResponse * QQuickAsyncImageProviderWrapper::requestImageResponse(const ::QString & id, const ::QSize & requestedSize)
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQuickAsyncImageProvider.requestImageResponse()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "requestImageResponse";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQuickAsyncImageProvider.requestImageResponse()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &id),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &requestedSize)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKIMAGERESPONSE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickAsyncImageProvider.requestImageResponse", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QQuickImageResponse >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QQuickImageResponse *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPixmap QQuickAsyncImageProviderWrapper::requestPixmap(const ::QString & id, ::QSize * size, const ::QSize & requestedSize)
{
    if (m_PyMethodCache[4])
        return this->::QQuickImageProvider::requestPixmap(id, size, requestedSize);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "requestPixmap";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QQuickImageProvider::requestPixmap(id, size, requestedSize);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &id),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), size),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &requestedSize)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickAsyncImageProvider.requestPixmap", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPixmap >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPixmap cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QQuickTextureFactory * QQuickAsyncImageProviderWrapper::requestTexture(const ::QString & id, ::QSize * size, const ::QSize & requestedSize)
{
    if (m_PyMethodCache[5])
        return this->::QQuickImageProvider::requestTexture(id, size, requestedSize);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "requestTexture";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QQuickImageProvider::requestTexture(id, size, requestedSize);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &id),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), size),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &requestedSize)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKTEXTUREFACTORY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickAsyncImageProvider.requestTexture", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QQuickTextureFactory >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QQuickTextureFactory *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QQuickAsyncImageProviderWrapper::~QQuickAsyncImageProviderWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQuickAsyncImageProvider_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKASYNCIMAGEPROVIDER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QQuickAsyncImageProvider' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQuickAsyncImageProvider >()))
        return -1;

    ::QQuickAsyncImageProviderWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickAsyncImageProvider.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QQuickAsyncImageProvider()
            cptr = new ::QQuickAsyncImageProviderWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQuickAsyncImageProvider >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QQuickAsyncImageProviderFunc_requestImageResponse(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickAsyncImageProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKASYNCIMAGEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickAsyncImageProvider.requestImageResponse";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "requestImageResponse", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickAsyncImageProvider::requestImageResponse(QString,QSize)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // requestImageResponse(QString,QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickAsyncImageProviderFunc_requestImageResponse_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSize cppArg1_local;
        ::QSize *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // requestImageResponse(QString,QSize)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQuickAsyncImageProvider.requestImageResponse()' not implemented.");
                return {};
            }
            QQuickImageResponse * cppResult = cppSelf->requestImageResponse(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKIMAGERESPONSE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickAsyncImageProviderFunc_requestImageResponse_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQuickAsyncImageProvider_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQuickAsyncImageProvider_methods[] = {
    {"requestImageResponse", reinterpret_cast<PyCFunction>(Sbk_QQuickAsyncImageProviderFunc_requestImageResponse), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQuickAsyncImageProvider_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQuickAsyncImageProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKASYNCIMAGEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQuickAsyncImageProviderWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQuickAsyncImageProvider_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQuickAsyncImageProvider_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQuickAsyncImageProvider_Type = nullptr;
static SbkObjectType *Sbk_QQuickAsyncImageProvider_TypeF(void)
{
    return _Sbk_QQuickAsyncImageProvider_Type;
}

static PyType_Slot Sbk_QQuickAsyncImageProvider_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQuickAsyncImageProvider_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQuickAsyncImageProvider_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQuickAsyncImageProvider_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQuickAsyncImageProvider_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQuickAsyncImageProvider_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQuickAsyncImageProvider_spec = {
    "2:PySide2.QtQuick.QQuickAsyncImageProvider",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQuickAsyncImageProvider_slots
};

} //extern "C"

static void *Sbk_QQuickAsyncImageProvider_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QQmlImageProviderBase >()))
        return dynamic_cast< ::QQuickAsyncImageProvider *>(reinterpret_cast< ::QQmlImageProviderBase *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQuickAsyncImageProvider_PythonToCpp_QQuickAsyncImageProvider_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQuickAsyncImageProvider_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQuickAsyncImageProvider_PythonToCpp_QQuickAsyncImageProvider_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQuickAsyncImageProvider_TypeF())))
        return QQuickAsyncImageProvider_PythonToCpp_QQuickAsyncImageProvider_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQuickAsyncImageProvider_PTR_CppToPython_QQuickAsyncImageProvider(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQuickAsyncImageProvider *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQuickAsyncImageProvider_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQuickAsyncImageProvider_SignatureStrings[] = {
    "PySide2.QtQuick.QQuickAsyncImageProvider(self)",
    "PySide2.QtQuick.QQuickAsyncImageProvider.requestImageResponse(self,id:QString,requestedSize:PySide2.QtCore.QSize)->PySide2.QtQuick.QQuickImageResponse",
    nullptr}; // Sentinel

void init_QQuickAsyncImageProvider(PyObject *module)
{
    _Sbk_QQuickAsyncImageProvider_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQuickAsyncImageProvider",
        "QQuickAsyncImageProvider*",
        &Sbk_QQuickAsyncImageProvider_spec,
        &Shiboken::callCppDestructor< ::QQuickAsyncImageProvider >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKIMAGEPROVIDER_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQuickAsyncImageProvider_Type);
    InitSignatureStrings(pyType, QQuickAsyncImageProvider_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQuickAsyncImageProvider_Type), Sbk_QQuickAsyncImageProvider_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QQUICKASYNCIMAGEPROVIDER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQuickAsyncImageProvider_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQuickAsyncImageProvider_TypeF(),
        QQuickAsyncImageProvider_PythonToCpp_QQuickAsyncImageProvider_PTR,
        is_QQuickAsyncImageProvider_PythonToCpp_QQuickAsyncImageProvider_PTR_Convertible,
        QQuickAsyncImageProvider_PTR_CppToPython_QQuickAsyncImageProvider);

    Shiboken::Conversions::registerConverterName(converter, "QQuickAsyncImageProvider");
    Shiboken::Conversions::registerConverterName(converter, "QQuickAsyncImageProvider*");
    Shiboken::Conversions::registerConverterName(converter, "QQuickAsyncImageProvider&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickAsyncImageProvider).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickAsyncImageProviderWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QQuickAsyncImageProvider_TypeF(), &Sbk_QQuickAsyncImageProvider_typeDiscovery);

}
