/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtqml_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtQmlTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtQmlModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtQmlTypeConverters = nullptr;
    // Begin code injection
#include "pysideqmlregistertype.h"

    // End of code injection

void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtQml_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtQmlTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------
static PyObject *SbkQtQmlModule_qmlRegisterType(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.qmlRegisterType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qmlRegisterType", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: qmlRegisterType(PyTypeObject,const char*,int,int,const char*)
    if (numArgs == 5
        && PyType_Check(pyArgs[0])
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && Shiboken::String::check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[4])))) {
        overloadId = 0; // qmlRegisterType(PyTypeObject,const char*,int,int,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtQmlModule_qmlRegisterType_TypeError;

    // Call function/method
    {
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        SBK_UNUSED(cppArg1)
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        SBK_UNUSED(cppArg2)
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        SBK_UNUSED(cppArg3)
        const char* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        SBK_UNUSED(cppArg4)

        if (!PyErr_Occurred()) {
            // qmlRegisterType(PyTypeObject,const char*,int,int,const char*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtqml.cpp (qmlregistertype)]
            int cppResult = PySide::qmlRegisterType(pyArgs[0], cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            // END of custom code block [file: ../glue/qtqml.cpp (qmlregistertype)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtQmlModule_qmlRegisterType_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static PyMethodDef QtQml_methods[] = {
    {"qmlRegisterType", reinterpret_cast<PyCFunction>(SbkQtQmlModule_qmlRegisterType), METH_VARARGS},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtQmlQtQml(PyObject *module);
void init_QQmlTypesExtensionInterface(PyObject *module);
void init_QQmlScriptString(PyObject *module);
void init_QQmlPropertyValueSource(PyObject *module);
void init_QQmlProperty(PyObject *module);
void init_QQmlParserStatus(PyObject *module);
void init_QQmlNetworkAccessManagerFactory(PyObject *module);
void init_QQmlListReference(PyObject *module);
void init_QQmlIncubator(PyObject *module);
void init_QQmlIncubationController(PyObject *module);
void init_QQmlImageProviderBase(PyObject *module);
void init_QQmlFile(PyObject *module);
void init_QQmlExtensionInterface(PyObject *module);
void init_QQmlError(PyObject *module);
void init_QQmlDebuggingEnabler(PyObject *module);
void init_QQmlAbstractUrlInterceptor(PyObject *module);
void init_QJSValueIterator(PyObject *module);
void init_QJSValue(PyObject *module);
void init_QQmlPropertyMap(PyObject *module);
void init_QQmlFileSelector(PyObject *module);
void init_QQmlExtensionPlugin(PyObject *module);
void init_QQmlExpression(PyObject *module);
void init_QQmlContext(PyObject *module);
void init_QQmlComponent(PyObject *module);
void init_QJSEngine(PyObject *module);
void init_QQmlEngine(PyObject *module);
void init_QQmlApplicationEngine(PyObject *module);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;
PyTypeObject **SbkPySide2_QtNetworkTypes;
SbkConverter **SbkPySide2_QtNetworkTypeConverters;
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'const QList<QJSValue > &'.
static PyObject *_constQList_QJSValue_REF_CppToPython__constQList_QJSValue_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QJSValue > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QJSValue >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QJSValue cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QJSValue_REF_PythonToCpp__constQList_QJSValue_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QJSValue > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QJSValue cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QJSValue_REF_PythonToCpp__constQList_QJSValue_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pyIn))
        return _constQList_QJSValue_REF_PythonToCpp__constQList_QJSValue_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QQmlError > *'.
static PyObject *_QList_QQmlError_PTR_CppToPython__QList_QQmlError_PTR(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QQmlError > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QQmlError >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QQmlError cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLERROR_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QQmlError_PTR_PythonToCpp__QList_QQmlError_PTR(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QQmlError > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QQmlError cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLERROR_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QQmlError_PTR_PythonToCpp__QList_QQmlError_PTR_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLERROR_IDX]), pyIn))
        return _QList_QQmlError_PTR_PythonToCpp__QList_QQmlError_PTR;
    return {};
}

// C++ to Python conversion for type 'const QMap<QString,QVariant > &'.
static PyObject *_constQMap_QString_QVariant_REF_CppToPython__constQMap_QString_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'const QHash<QString,QVariant > &'.
static PyObject *_constQHash_QString_QVariant_REF_CppToPython__constQHash_QString_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtQml",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtQml_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtQml_SignatureStrings[] = {
    "PySide2.QtQml.qmlRegisterType(arg__1:PyTypeObject,arg__2:char*,arg__3:int,arg__4:int,arg__5:char*)->int",
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtQml)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtNetwork"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtNetworkTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtNetworkTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtQml_IDX_COUNT];
    SbkPySide2_QtQmlTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtQml_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtQmlTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtQml", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtQml", QtQml_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtQmlModuleObject = module;

    // Initialize classes in the type system
    init_QtQmlQtQml(module);
    init_QQmlTypesExtensionInterface(module);
    init_QQmlScriptString(module);
    init_QQmlPropertyValueSource(module);
    init_QQmlProperty(module);
    init_QQmlParserStatus(module);
    init_QQmlNetworkAccessManagerFactory(module);
    init_QQmlListReference(module);
    init_QQmlIncubator(module);
    init_QQmlIncubationController(module);
    init_QQmlImageProviderBase(module);
    init_QQmlFile(module);
    init_QQmlExtensionInterface(module);
    init_QQmlError(module);
    init_QQmlDebuggingEnabler(module);
    init_QQmlAbstractUrlInterceptor(module);
    init_QJSValueIterator(module);
    init_QJSValue(module);
    init_QQmlPropertyMap(module);
    init_QQmlFileSelector(module);
    init_QQmlExtensionPlugin(module);
    init_QQmlExpression(module);
    init_QQmlContext(module);
    init_QQmlComponent(module);
    init_QJSEngine(module);
    init_QQmlEngine(module);
    init_QQmlApplicationEngine(module);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'const QList<QJSValue>&'.
    SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QJSValue_REF_CppToPython__constQList_QJSValue_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX], "const QList<QJSValue>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX], "QList<QJSValue>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX],
        _constQList_QJSValue_REF_PythonToCpp__constQList_QJSValue_REF,
        is__constQList_QJSValue_REF_PythonToCpp__constQList_QJSValue_REF_Convertible);

    // Register converter for type 'QList<QQmlError>*'.
    SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QQMLERROR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QQmlError_PTR_CppToPython__QList_QQmlError_PTR);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QQMLERROR_IDX], "QList<QQmlError>*");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QQMLERROR_IDX],
        _QList_QQmlError_PTR_PythonToCpp__QList_QQmlError_PTR,
        is__QList_QQmlError_PTR_PythonToCpp__QList_QQmlError_PTR_Convertible);

    // Register converter for type 'const QMap<QString,QVariant>&'.
    SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQMap_QString_QVariant_REF_CppToPython__constQMap_QString_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QMAP_QSTRING_QVARIANT_IDX], "const QMap<QString,QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QMAP_QSTRING_QVARIANT_IDX],
        _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF,
        is__constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF_Convertible);

    // Register converter for type 'const QHash<QString,QVariant>&'.
    SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QHASH_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQHash_QString_QVariant_REF_CppToPython__constQHash_QString_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QHASH_QSTRING_QVARIANT_IDX], "const QHash<QString,QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QHASH_QSTRING_QVARIANT_IDX], "QHash<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QHASH_QSTRING_QVARIANT_IDX],
        _constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF,
        is__constQHash_QString_QVariant_REF_PythonToCpp__constQHash_QString_QVariant_REF_Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtQmlTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtQmlTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtQml");
    }
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtqml.cpp (init)]
    PySide::initQmlSupport(module);
    // END of custom code block [file: ../glue/qtqml.cpp (init)]
    // ========================================================================

    // End of code injection

    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtQml_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
