/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmlproperty_wrapper.h"

// inner classes

// Extra includes
#include <QtQml/qqmlcontext.h>
#include <QtQml/qqmlengine.h>
#include <QtQml/qqmlproperty.h>
#include <qmetaobject.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlProperty_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlProperty >()))
        return -1;

    ::QQmlProperty *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QQmlProperty", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QQmlProperty::QQmlProperty()
    // 1: QQmlProperty::QQmlProperty(QObject*)
    // 2: QQmlProperty::QQmlProperty(QObject*,QQmlContext*)
    // 3: QQmlProperty::QQmlProperty(QObject*,QQmlEngine*)
    // 4: QQmlProperty::QQmlProperty(QObject*,QString)
    // 5: QQmlProperty::QQmlProperty(QObject*,QString,QQmlContext*)
    // 6: QQmlProperty::QQmlProperty(QObject*,QString,QQmlEngine*)
    // 7: QQmlProperty::QQmlProperty(QQmlProperty)
    if (numArgs == 0) {
        overloadId = 0; // QQmlProperty()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QQmlProperty(QObject*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[1])))) {
            overloadId = 3; // QQmlProperty(QObject*,QQmlEngine*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLCONTEXT_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QQmlProperty(QObject*,QQmlContext*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // QQmlProperty(QObject*,QString)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[2])))) {
                overloadId = 6; // QQmlProperty(QObject*,QString,QQmlEngine*)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLCONTEXT_IDX]), (pyArgs[2])))) {
                overloadId = 5; // QQmlProperty(QObject*,QString,QQmlContext*)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]), (pyArgs[0])))) {
        overloadId = 7; // QQmlProperty(QQmlProperty)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlProperty_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QQmlProperty()
        {

            if (!PyErr_Occurred()) {
                // QQmlProperty()
                cptr = new ::QQmlProperty();
            }
            break;
        }
        case 1: // QQmlProperty(QObject * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QQmlProperty(QObject*)
                cptr = new ::QQmlProperty(cppArg0);
            }
            break;
        }
        case 2: // QQmlProperty(QObject * arg__1, QQmlContext * arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QQmlContext *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QQmlProperty(QObject*,QQmlContext*)
                cptr = new ::QQmlProperty(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QQmlProperty(QObject * arg__1, QQmlEngine * arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QQmlEngine *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QQmlProperty(QObject*,QQmlEngine*)
                cptr = new ::QQmlProperty(cppArg0, cppArg1);
            }
            break;
        }
        case 4: // QQmlProperty(QObject * arg__1, const QString & arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QQmlProperty(QObject*,QString)
                cptr = new ::QQmlProperty(cppArg0, cppArg1);
            }
            break;
        }
        case 5: // QQmlProperty(QObject * arg__1, const QString & arg__2, QQmlContext * arg__3)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QQmlContext *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QQmlProperty(QObject*,QString,QQmlContext*)
                cptr = new ::QQmlProperty(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 6: // QQmlProperty(QObject * arg__1, const QString & arg__2, QQmlEngine * arg__3)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QQmlEngine *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QQmlProperty(QObject*,QString,QQmlEngine*)
                cptr = new ::QQmlProperty(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 7: // QQmlProperty(const QQmlProperty & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QQmlProperty cppArg0_local;
            ::QQmlProperty *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QQmlProperty(QQmlProperty)
                cptr = new ::QQmlProperty(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlProperty >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QQmlProperty_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QQmlProperty_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QQmlPropertyFunc_connectNotifySignal(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.connectNotifySignal";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "connectNotifySignal", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQmlProperty::connectNotifySignal(QObject*,const char*)const
    // 1: QQmlProperty::connectNotifySignal(QObject*,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // connectNotifySignal(QObject*,int)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // connectNotifySignal(QObject*,const char*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlPropertyFunc_connectNotifySignal_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // connectNotifySignal(QObject * dest, const char * slot) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // connectNotifySignal(QObject*,const char*)const
                bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->connectNotifySignal(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // connectNotifySignal(QObject * dest, int method) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // connectNotifySignal(QObject*,int)const
                bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->connectNotifySignal(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlPropertyFunc_connectNotifySignal_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlPropertyFunc_hasNotifySignal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.hasNotifySignal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasNotifySignal()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->hasNotifySignal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_index(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.index";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // index()const
            int cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->index();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_isDesignable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.isDesignable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDesignable()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->isDesignable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_isProperty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.isProperty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isProperty()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->isProperty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_isResettable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.isResettable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isResettable()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->isResettable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_isSignalProperty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.isSignalProperty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSignalProperty()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->isSignalProperty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_isWritable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.isWritable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isWritable()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->isWritable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_method(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.method";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // method()const
            QMetaMethod cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->method();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_needsNotifySignal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.needsNotifySignal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // needsNotifySignal()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->needsNotifySignal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_object(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.object";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // object()const
            QObject * cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->object();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_property(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.property";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // property()const
            QMetaProperty cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->property();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAPROPERTY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_propertyType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.propertyType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyType()const
            int cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->propertyType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_propertyTypeCategory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.propertyTypeCategory";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyTypeCategory()const
            QQmlProperty::PropertyTypeCategory cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->propertyTypeCategory();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_propertyTypeName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.propertyTypeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyTypeName()const
            const char * cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->propertyTypeName();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_read(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QQmlProperty *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.read";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto Sbk_QQmlPropertyFunc_read_TypeError;

    if (!PyArg_UnpackTuple(args, "read", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QQmlProperty::read()const
    // 1: static QQmlProperty::read(const QObject*,QString)
    // 2: static QQmlProperty::read(const QObject*,QString,QQmlContext*)
    // 3: static QQmlProperty::read(const QObject*,QString,QQmlEngine*)
    if (numArgs == 0) {
        overloadId = 0; // read()const
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // read(const QObject*,QString)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[2])))) {
            overloadId = 3; // read(const QObject*,QString,QQmlEngine*)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLCONTEXT_IDX]), (pyArgs[2])))) {
            overloadId = 2; // read(const QObject*,QString,QQmlContext*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlPropertyFunc_read_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // read() const
        {

            if (!PyErr_Occurred()) {
                // read()const
                QVariant cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->read();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
            }
            break;
        }
        case 1: // read(const QObject * arg__1, const QString & arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // read(const QObject*,QString)
                QVariant cppResult = ::QQmlProperty::read(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
            }
            break;
        }
        case 2: // read(const QObject * arg__1, const QString & arg__2, QQmlContext * arg__3)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QQmlContext *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // read(const QObject*,QString,QQmlContext*)
                QVariant cppResult = ::QQmlProperty::read(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
            }
            break;
        }
        case 3: // read(const QObject * arg__1, const QString & arg__2, QQmlEngine * arg__3)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QQmlEngine *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // read(const QObject*,QString,QQmlEngine*)
                QVariant cppResult = ::QQmlProperty::read(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlPropertyFunc_read_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlPropertyFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()const
            bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->reset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QQmlProperty::Type cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlPropertyFunc_write(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QQmlProperty *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlProperty.write";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QQmlPropertyFunc_write_TypeError;

    if (!PyArg_UnpackTuple(args, "write", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QQmlProperty::write(QObject*,QString,QVariant)
    // 1: static QQmlProperty::write(QObject*,QString,QVariant,QQmlContext*)
    // 2: static QQmlProperty::write(QObject*,QString,QVariant,QQmlEngine*)
    // 3: QQmlProperty::write(QVariant)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // write(QObject*,QString,QVariant)
        } else if (numArgs == 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[3])))) {
            overloadId = 2; // write(QObject*,QString,QVariant,QQmlEngine*)
        } else if (numArgs == 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLCONTEXT_IDX]), (pyArgs[3])))) {
            overloadId = 1; // write(QObject*,QString,QVariant,QQmlContext*)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[0])))) {
        overloadId = 3; // write(QVariant)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlPropertyFunc_write_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // write(QObject * arg__1, const QString & arg__2, const QVariant & arg__3)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QVariant cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // write(QObject*,QString,QVariant)
                bool cppResult = ::QQmlProperty::write(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // write(QObject * arg__1, const QString & arg__2, const QVariant & arg__3, QQmlContext * arg__4)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QVariant cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QQmlContext *cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // write(QObject*,QString,QVariant,QQmlContext*)
                bool cppResult = ::QQmlProperty::write(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // write(QObject * arg__1, const QString & arg__2, const QVariant & arg__3, QQmlEngine * arg__4)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QVariant cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QQmlEngine *cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // write(QObject*,QString,QVariant,QQmlEngine*)
                bool cppResult = ::QQmlProperty::write(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 3: // write(const QVariant & arg__1) const
        {
            ::QVariant cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // write(QVariant)const
                bool cppResult = const_cast<const ::QQmlProperty *>(cppSelf)->write(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlPropertyFunc_write_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlProperty___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyMethodDef Sbk_QQmlPropertyMethod_read = {
    "read", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_read), METH_VARARGS|METH_STATIC
};

static PyMethodDef Sbk_QQmlPropertyMethod_write = {
    "write", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_write), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QQmlProperty_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlProperty_methods[] = {
    {"connectNotifySignal", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_connectNotifySignal), METH_VARARGS},
    {"hasNotifySignal", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_hasNotifySignal), METH_NOARGS},
    {"index", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_index), METH_NOARGS},
    {"isDesignable", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_isDesignable), METH_NOARGS},
    {"isProperty", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_isProperty), METH_NOARGS},
    {"isResettable", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_isResettable), METH_NOARGS},
    {"isSignalProperty", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_isSignalProperty), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_isValid), METH_NOARGS},
    {"isWritable", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_isWritable), METH_NOARGS},
    {"method", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_method), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_name), METH_NOARGS},
    {"needsNotifySignal", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_needsNotifySignal), METH_NOARGS},
    {"object", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_object), METH_NOARGS},
    {"property", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_property), METH_NOARGS},
    {"propertyType", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_propertyType), METH_NOARGS},
    {"propertyTypeCategory", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_propertyTypeCategory), METH_NOARGS},
    {"propertyTypeName", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_propertyTypeName), METH_NOARGS},
    Sbk_QQmlPropertyMethod_read,
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_reset), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyFunc_type), METH_NOARGS},
    Sbk_QQmlPropertyMethod_write,

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QQmlProperty___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QQmlProperty_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QQmlPropertyMethod_read = {
        Sbk_QQmlPropertyMethod_read.ml_name,
        Sbk_QQmlPropertyMethod_read.ml_meth,
        Sbk_QQmlPropertyMethod_read.ml_flags & (~METH_STATIC),
        Sbk_QQmlPropertyMethod_read.ml_doc,
    };
    if (Shiboken::String::compare(name, "read") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QQmlPropertyMethod_read, self, 0);
    static PyMethodDef non_static_Sbk_QQmlPropertyMethod_write = {
        Sbk_QQmlPropertyMethod_write.ml_name,
        Sbk_QQmlPropertyMethod_write.ml_meth,
        Sbk_QQmlPropertyMethod_write.ml_flags & (~METH_STATIC),
        Sbk_QQmlPropertyMethod_write.ml_doc,
    };
    if (Shiboken::String::compare(name, "write") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QQmlPropertyMethod_write, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

// Rich comparison
static PyObject * Sbk_QQmlProperty_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]), (pyArg)))) {
                // operator==(const QQmlProperty & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QQmlProperty cppArg0_local;
                ::QQmlProperty *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QQmlProperty_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QQmlProperty_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QQmlProperty_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlProperty_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlProperty_Type = nullptr;
static SbkObjectType *Sbk_QQmlProperty_TypeF(void)
{
    return _Sbk_QQmlProperty_Type;
}

static PyType_Slot Sbk_QQmlProperty_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QQmlProperty_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlProperty_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlProperty_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QQmlProperty_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlProperty_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlProperty_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlProperty_spec = {
    "2:PySide2.QtQml.QQmlProperty",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlProperty_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QQmlProperty_PropertyTypeCategory_PythonToCpp_QQmlProperty_PropertyTypeCategory(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlProperty::PropertyTypeCategory *>(cppOut) =
        static_cast<::QQmlProperty::PropertyTypeCategory>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlProperty_PropertyTypeCategory_PythonToCpp_QQmlProperty_PropertyTypeCategory_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX]))
        return QQmlProperty_PropertyTypeCategory_PythonToCpp_QQmlProperty_PropertyTypeCategory;
    return {};
}
static PyObject *QQmlProperty_PropertyTypeCategory_CppToPython_QQmlProperty_PropertyTypeCategory(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlProperty::PropertyTypeCategory *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX], castCppIn);

}

static void QQmlProperty_Type_PythonToCpp_QQmlProperty_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlProperty::Type *>(cppOut) =
        static_cast<::QQmlProperty::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlProperty_Type_PythonToCpp_QQmlProperty_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX]))
        return QQmlProperty_Type_PythonToCpp_QQmlProperty_Type;
    return {};
}
static PyObject *QQmlProperty_Type_CppToPython_QQmlProperty_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlProperty::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlProperty_PythonToCpp_QQmlProperty_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlProperty_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlProperty_PythonToCpp_QQmlProperty_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlProperty_TypeF())))
        return QQmlProperty_PythonToCpp_QQmlProperty_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlProperty_PTR_CppToPython_QQmlProperty(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlProperty *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlProperty_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QQmlProperty_COPY_CppToPython_QQmlProperty(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QQmlProperty_TypeF(), new ::QQmlProperty(*reinterpret_cast<const ::QQmlProperty *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QQmlProperty_PythonToCpp_QQmlProperty_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlProperty *>(cppOut) = *reinterpret_cast< ::QQmlProperty *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QQmlProperty_PythonToCpp_QQmlProperty_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlProperty_TypeF())))
        return QQmlProperty_PythonToCpp_QQmlProperty_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_QObjectPTR_PythonToCpp_QQmlProperty(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlProperty *>(cppOut) = ::QQmlProperty(reinterpret_cast< ::QObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_QObjectPTR_PythonToCpp_QQmlProperty_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return PySide2_QtCore_QObjectPTR_PythonToCpp_QQmlProperty;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlProperty_SignatureStrings[] = {
    "7:PySide2.QtQml.QQmlProperty(self)",
    "6:PySide2.QtQml.QQmlProperty(self,arg__1:PySide2.QtCore.QObject)",
    "5:PySide2.QtQml.QQmlProperty(self,arg__1:PySide2.QtCore.QObject,arg__2:PySide2.QtQml.QQmlContext)",
    "4:PySide2.QtQml.QQmlProperty(self,arg__1:PySide2.QtCore.QObject,arg__2:PySide2.QtQml.QQmlEngine)",
    "3:PySide2.QtQml.QQmlProperty(self,arg__1:PySide2.QtCore.QObject,arg__2:QString)",
    "2:PySide2.QtQml.QQmlProperty(self,arg__1:PySide2.QtCore.QObject,arg__2:QString,arg__3:PySide2.QtQml.QQmlContext)",
    "1:PySide2.QtQml.QQmlProperty(self,arg__1:PySide2.QtCore.QObject,arg__2:QString,arg__3:PySide2.QtQml.QQmlEngine)",
    "0:PySide2.QtQml.QQmlProperty(self,arg__1:PySide2.QtQml.QQmlProperty)",
    "1:PySide2.QtQml.QQmlProperty.connectNotifySignal(self,dest:PySide2.QtCore.QObject,slot:char*)->bool",
    "0:PySide2.QtQml.QQmlProperty.connectNotifySignal(self,dest:PySide2.QtCore.QObject,method:int)->bool",
    "PySide2.QtQml.QQmlProperty.hasNotifySignal(self)->bool",
    "PySide2.QtQml.QQmlProperty.index(self)->int",
    "PySide2.QtQml.QQmlProperty.isDesignable(self)->bool",
    "PySide2.QtQml.QQmlProperty.isProperty(self)->bool",
    "PySide2.QtQml.QQmlProperty.isResettable(self)->bool",
    "PySide2.QtQml.QQmlProperty.isSignalProperty(self)->bool",
    "PySide2.QtQml.QQmlProperty.isValid(self)->bool",
    "PySide2.QtQml.QQmlProperty.isWritable(self)->bool",
    "PySide2.QtQml.QQmlProperty.method(self)->PySide2.QtCore.QMetaMethod",
    "PySide2.QtQml.QQmlProperty.name(self)->QString",
    "PySide2.QtQml.QQmlProperty.needsNotifySignal(self)->bool",
    "PySide2.QtQml.QQmlProperty.object(self)->PySide2.QtCore.QObject",
    "PySide2.QtQml.QQmlProperty.property(self)->PySide2.QtCore.QMetaProperty",
    "PySide2.QtQml.QQmlProperty.propertyType(self)->int",
    "PySide2.QtQml.QQmlProperty.propertyTypeCategory(self)->PySide2.QtQml.QQmlProperty.PropertyTypeCategory",
    "PySide2.QtQml.QQmlProperty.propertyTypeName(self)->char*",
    "3:PySide2.QtQml.QQmlProperty.read(self)->QVariant",
    "2:PySide2.QtQml.QQmlProperty.read(arg__1:PySide2.QtCore.QObject,arg__2:QString)->QVariant",
    "1:PySide2.QtQml.QQmlProperty.read(arg__1:PySide2.QtCore.QObject,arg__2:QString,arg__3:PySide2.QtQml.QQmlContext)->QVariant",
    "0:PySide2.QtQml.QQmlProperty.read(arg__1:PySide2.QtCore.QObject,arg__2:QString,arg__3:PySide2.QtQml.QQmlEngine)->QVariant",
    "PySide2.QtQml.QQmlProperty.reset(self)->bool",
    "PySide2.QtQml.QQmlProperty.type(self)->PySide2.QtQml.QQmlProperty.Type",
    "3:PySide2.QtQml.QQmlProperty.write(arg__1:PySide2.QtCore.QObject,arg__2:QString,arg__3:QVariant)->bool",
    "2:PySide2.QtQml.QQmlProperty.write(arg__1:PySide2.QtCore.QObject,arg__2:QString,arg__3:QVariant,arg__4:PySide2.QtQml.QQmlContext)->bool",
    "1:PySide2.QtQml.QQmlProperty.write(arg__1:PySide2.QtCore.QObject,arg__2:QString,arg__3:QVariant,arg__4:PySide2.QtQml.QQmlEngine)->bool",
    "0:PySide2.QtQml.QQmlProperty.write(self,arg__1:QVariant)->bool",
    "PySide2.QtQml.QQmlProperty.__copy__()",
    nullptr}; // Sentinel

void init_QQmlProperty(PyObject *module)
{
    _Sbk_QQmlProperty_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlProperty",
        "QQmlProperty",
        &Sbk_QQmlProperty_spec,
        &Shiboken::callCppDestructor< ::QQmlProperty >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlProperty_Type);
    InitSignatureStrings(pyType, QQmlProperty_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlProperty_Type), Sbk_QQmlProperty_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlProperty_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlProperty_TypeF(),
        QQmlProperty_PythonToCpp_QQmlProperty_PTR,
        is_QQmlProperty_PythonToCpp_QQmlProperty_PTR_Convertible,
        QQmlProperty_PTR_CppToPython_QQmlProperty,
        QQmlProperty_COPY_CppToPython_QQmlProperty);

    Shiboken::Conversions::registerConverterName(converter, "QQmlProperty");
    Shiboken::Conversions::registerConverterName(converter, "QQmlProperty*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlProperty&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlProperty).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QQmlProperty_PythonToCpp_QQmlProperty_COPY,
        is_QQmlProperty_PythonToCpp_QQmlProperty_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_QObjectPTR_PythonToCpp_QQmlProperty,
        is_PySide2_QtCore_QObjectPTR_PythonToCpp_QQmlProperty_Convertible);

    // Initialization of enums.

    // Initialization of enum 'PropertyTypeCategory'.
    SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlProperty_TypeF(),
        "PropertyTypeCategory",
        "2:PySide2.QtQml.QQmlProperty.PropertyTypeCategory",
        "QQmlProperty::PropertyTypeCategory");
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX],
        Sbk_QQmlProperty_TypeF(), "InvalidCategory", (long) QQmlProperty::PropertyTypeCategory::InvalidCategory))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX],
        Sbk_QQmlProperty_TypeF(), "List", (long) QQmlProperty::PropertyTypeCategory::List))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX],
        Sbk_QQmlProperty_TypeF(), "Object", (long) QQmlProperty::PropertyTypeCategory::Object))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX],
        Sbk_QQmlProperty_TypeF(), "Normal", (long) QQmlProperty::PropertyTypeCategory::Normal))
        return;
    // Register converter for enum 'QQmlProperty::PropertyTypeCategory'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX],
            QQmlProperty_PropertyTypeCategory_CppToPython_QQmlProperty_PropertyTypeCategory);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlProperty_PropertyTypeCategory_PythonToCpp_QQmlProperty_PropertyTypeCategory,
            is_QQmlProperty_PropertyTypeCategory_PythonToCpp_QQmlProperty_PropertyTypeCategory_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_PROPERTYTYPECATEGORY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlProperty::PropertyTypeCategory");
        Shiboken::Conversions::registerConverterName(converter, "PropertyTypeCategory");
    }
    // End of 'PropertyTypeCategory' enum.

    // Initialization of enum 'Type'.
    SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlProperty_TypeF(),
        "Type",
        "2:PySide2.QtQml.QQmlProperty.Type",
        "QQmlProperty::Type");
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX],
        Sbk_QQmlProperty_TypeF(), "Invalid", (long) QQmlProperty::Type::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX],
        Sbk_QQmlProperty_TypeF(), "Property", (long) QQmlProperty::Type::Property))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX],
        Sbk_QQmlProperty_TypeF(), "SignalProperty", (long) QQmlProperty::Type::SignalProperty))
        return;
    // Register converter for enum 'QQmlProperty::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX],
            QQmlProperty_Type_CppToPython_QQmlProperty_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlProperty_Type_PythonToCpp_QQmlProperty_Type,
            is_QQmlProperty_Type_PythonToCpp_QQmlProperty_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlProperty::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::QQmlProperty >("QQmlProperty");
    qRegisterMetaType< ::QQmlProperty::PropertyTypeCategory >("QQmlProperty::PropertyTypeCategory");
    qRegisterMetaType< ::QQmlProperty::Type >("QQmlProperty::Type");
}
