/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmllistreference_wrapper.h"

// inner classes

// Extra includes
#include <QtQml/qqmlengine.h>
#include <QtQml/qqmllist.h>
#include <qobject.h>
#include <qobjectdefs.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlListReference_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlListReference >()))
        return -1;

    ::QQmlListReference *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQmlListReference_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QQmlListReference", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QQmlListReference::QQmlListReference()
    // 1: QQmlListReference::QQmlListReference(QObject*,const char*,QQmlEngine*)
    // 2: QQmlListReference::QQmlListReference(QQmlListReference)
    if (numArgs == 0) {
        overloadId = 0; // QQmlListReference()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QQmlListReference(QQmlListReference)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // QQmlListReference(QObject*,const char*,QQmlEngine*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[2])))) {
            overloadId = 1; // QQmlListReference(QObject*,const char*,QQmlEngine*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlListReference_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QQmlListReference()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QQmlListReference_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QQmlListReference()
                cptr = new ::QQmlListReference();
            }
            break;
        }
        case 1: // QQmlListReference(QObject * arg__1, const char * property, QQmlEngine * arg__3)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_arg__3 = Shiboken::String::createStaticString("arg__3");
                if (PyDict_Contains(kwds, key_arg__3)) {
                    value = PyDict_GetItem(kwds, key_arg__3);
                    if (value && pyArgs[2]) {
                        errInfo = key_arg__3;
                        Py_INCREF(errInfo);
                        goto Sbk_QQmlListReference_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[2]))))
                            goto Sbk_QQmlListReference_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_arg__3);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QQmlListReference_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QQmlEngine *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QQmlListReference(QObject*,const char*,QQmlEngine*)
                cptr = new ::QQmlListReference(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // QQmlListReference(const QQmlListReference & arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QQmlListReference_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QQmlListReference cppArg0_local;
            ::QQmlListReference *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QQmlListReference(QQmlListReference)
                cptr = new ::QQmlListReference(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlListReference >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QQmlListReference_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QQmlListReference_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QQmlListReferenceFunc_append(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQmlListReference::append(QObject*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // append(QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlListReferenceFunc_append_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // append(QObject*)const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->append(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlListReferenceFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlListReferenceFunc_at(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.at";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQmlListReference::at(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // at(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlListReferenceFunc_at_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // at(int)const
            QObject * cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->at(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlListReferenceFunc_at_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlListReferenceFunc_canAppend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.canAppend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canAppend()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->canAppend();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_canAt(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.canAt";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canAt()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->canAt();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_canClear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.canClear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canClear()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->canClear();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_canCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.canCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canCount()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->canCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_canRemoveLast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.canRemoveLast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canRemoveLast()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->canRemoveLast();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_canReplace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.canReplace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canReplace()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->canReplace();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->clear();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_isManipulable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.isManipulable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isManipulable()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->isManipulable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_isReadable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.isReadable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadable()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->isReadable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_listElementType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.listElementType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // listElementType()const
            const QMetaObject * cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->listElementType();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_object(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.object";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // object()const
            QObject * cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->object();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_removeLast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.removeLast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeLast()const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->removeLast();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlListReferenceFunc_replace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlListReference.replace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQmlListReference::replace(int,QObject*)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // replace(int,QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlListReferenceFunc_replace_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // replace(int,QObject*)const
            bool cppResult = const_cast<const ::QQmlListReference *>(cppSelf)->replace(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlListReferenceFunc_replace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlListReference___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QQmlListReference_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlListReference_methods[] = {
    {"append", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_append), METH_O},
    {"at", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_at), METH_O},
    {"canAppend", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_canAppend), METH_NOARGS},
    {"canAt", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_canAt), METH_NOARGS},
    {"canClear", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_canClear), METH_NOARGS},
    {"canCount", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_canCount), METH_NOARGS},
    {"canRemoveLast", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_canRemoveLast), METH_NOARGS},
    {"canReplace", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_canReplace), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_clear), METH_NOARGS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_count), METH_NOARGS},
    {"isManipulable", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_isManipulable), METH_NOARGS},
    {"isReadable", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_isReadable), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_isValid), METH_NOARGS},
    {"listElementType", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_listElementType), METH_NOARGS},
    {"object", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_object), METH_NOARGS},
    {"removeLast", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_removeLast), METH_NOARGS},
    {"replace", reinterpret_cast<PyCFunction>(Sbk_QQmlListReferenceFunc_replace), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QQmlListReference___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QQmlListReference_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlListReference_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlListReference_Type = nullptr;
static SbkObjectType *Sbk_QQmlListReference_TypeF(void)
{
    return _Sbk_QQmlListReference_Type;
}

static PyType_Slot Sbk_QQmlListReference_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlListReference_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlListReference_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlListReference_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlListReference_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlListReference_spec = {
    "2:PySide2.QtQml.QQmlListReference",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlListReference_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlListReference_PythonToCpp_QQmlListReference_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlListReference_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlListReference_PythonToCpp_QQmlListReference_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlListReference_TypeF())))
        return QQmlListReference_PythonToCpp_QQmlListReference_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlListReference_PTR_CppToPython_QQmlListReference(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlListReference *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlListReference_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QQmlListReference_COPY_CppToPython_QQmlListReference(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QQmlListReference_TypeF(), new ::QQmlListReference(*reinterpret_cast<const ::QQmlListReference *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QQmlListReference_PythonToCpp_QQmlListReference_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlListReference *>(cppOut) = *reinterpret_cast< ::QQmlListReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QQmlListReference_PythonToCpp_QQmlListReference_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlListReference_TypeF())))
        return QQmlListReference_PythonToCpp_QQmlListReference_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlListReference_SignatureStrings[] = {
    "2:PySide2.QtQml.QQmlListReference(self)",
    "1:PySide2.QtQml.QQmlListReference(self,arg__1:PySide2.QtCore.QObject,property:char*,arg__3:PySide2.QtQml.QQmlEngine=nullptr)",
    "0:PySide2.QtQml.QQmlListReference(self,arg__1:PySide2.QtQml.QQmlListReference)",
    "PySide2.QtQml.QQmlListReference.append(self,arg__1:PySide2.QtCore.QObject)->bool",
    "PySide2.QtQml.QQmlListReference.at(self,arg__1:int)->PySide2.QtCore.QObject",
    "PySide2.QtQml.QQmlListReference.canAppend(self)->bool",
    "PySide2.QtQml.QQmlListReference.canAt(self)->bool",
    "PySide2.QtQml.QQmlListReference.canClear(self)->bool",
    "PySide2.QtQml.QQmlListReference.canCount(self)->bool",
    "PySide2.QtQml.QQmlListReference.canRemoveLast(self)->bool",
    "PySide2.QtQml.QQmlListReference.canReplace(self)->bool",
    "PySide2.QtQml.QQmlListReference.clear(self)->bool",
    "PySide2.QtQml.QQmlListReference.count(self)->int",
    "PySide2.QtQml.QQmlListReference.isManipulable(self)->bool",
    "PySide2.QtQml.QQmlListReference.isReadable(self)->bool",
    "PySide2.QtQml.QQmlListReference.isValid(self)->bool",
    "PySide2.QtQml.QQmlListReference.listElementType(self)->PySide2.QtCore.QMetaObject",
    "PySide2.QtQml.QQmlListReference.object(self)->PySide2.QtCore.QObject",
    "PySide2.QtQml.QQmlListReference.removeLast(self)->bool",
    "PySide2.QtQml.QQmlListReference.replace(self,arg__1:int,arg__2:PySide2.QtCore.QObject)->bool",
    "PySide2.QtQml.QQmlListReference.__copy__()",
    nullptr}; // Sentinel

void init_QQmlListReference(PyObject *module)
{
    _Sbk_QQmlListReference_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlListReference",
        "QQmlListReference",
        &Sbk_QQmlListReference_spec,
        &Shiboken::callCppDestructor< ::QQmlListReference >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlListReference_Type);
    InitSignatureStrings(pyType, QQmlListReference_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlListReference_Type), Sbk_QQmlListReference_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLLISTREFERENCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlListReference_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlListReference_TypeF(),
        QQmlListReference_PythonToCpp_QQmlListReference_PTR,
        is_QQmlListReference_PythonToCpp_QQmlListReference_PTR_Convertible,
        QQmlListReference_PTR_CppToPython_QQmlListReference,
        QQmlListReference_COPY_CppToPython_QQmlListReference);

    Shiboken::Conversions::registerConverterName(converter, "QQmlListReference");
    Shiboken::Conversions::registerConverterName(converter, "QQmlListReference*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlListReference&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlListReference).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QQmlListReference_PythonToCpp_QQmlListReference_COPY,
        is_QQmlListReference_PythonToCpp_QQmlListReference_COPY_Convertible);

    qRegisterMetaType< ::QQmlListReference >("QQmlListReference");
}
